'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: c_104b_.inc,v $
'*
'*  $Revision: 1.4 $
'*
'*  last change: $Author: tbo $ $Date: 2005/09/27 14:55:49 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : peter.junge@Sun.COM
'*
'* short description : Detailed test of the functions in the Insert menu - Part 2
'*
'************************************************************************
'*
' #1 c_104b_     ' Initial routine
' #1 tImportDrawingObjects
' #1 tFunctionCheck
' #1 tCellreferences
' #1 tInsertDataRange
' #1 tInsertExternalData
'*
'\***********************************************************************

sub c_104b_
Printlog Chr(13) + "--------- C_104b_ ---------"

   call tImportDrawingObjects
   call tFunctionCheck
   call tCellreferences
   call tInsertDataRange
   call tInsertExternalData

end sub

'
'---------------------------------------------------------------------------
'
   Global file$

testcase tImportDrawingObjects
'/// This test checks several properties of an exceldocument with painting objects.///
'/// For this test the document <gTesttoolPath>+input/calc/stufe1/c_104b/paintingobjects.xls ///
'/// is loaded. The following properties are checked:///
'/// FROM LINE: Linestyle(4), Lineends(10) ///
'/// FROM SQUARE: Linestyle(2), Color(2), WallColor(4), Transparency(no) ///
'/// FROM ELLIPSOID: Linestyle(1), Wallproperty(Bitmap), Shadow(no), Transparency(no), ShadowColor(4)
'/// FROM SMALL SQUARE: Linestyle(2), Color(13), ColorGradient(yes), Shadow(yes), ShadowColor(6),
'/// Transparency(no), ColorGradients(10, 4) ///
'/// FROM TEXT: Font(Arial), FontStyle(3), FontColor(10), FontEffects(normal), Spacing(1)

   file$ = convertpath(gtesttoolpath & "input\calc\stufe1\c_104b\paintingobjects.xls")

   printlog "* Open Excel document *"
   call hDateiOeffnen file$
   Kontext "DocumentCalc"
   printlog "* Checking the line *"
   DocumentCalc.MouseDoubleClick 1,1   'Select line to edit
   FormatLinie
   Kontext
   Active.SetPage TabLinie
   Kontext "TabLinie"

   if Stil.GetSelIndex = 4 and Farbe.GetSelIndex = 10 then
      printlog "OK, line style was correct imported!"
   else
      warnlog "Line style wasn't correct imported!"
   end if
   Kontext
    Active.SetPage TabLinienenden
    Kontext "TabLinienenden"

    if Liste.GetSelIndex = 10 Then
         printlog "OK, the line ends were correct imported!"
    else
         warnlog "The line ends weren't correct imported"
    end if
    TabLinienenden.OK

    printlog "* Checking square *"
    call gMouseClick (20,30)        'Select quadrat to edit
    FormatLine
    Kontext
    Active.SetPage TabLinie
    Kontext "TabLinie"

    if Stil.GetSelIndex = 2 and Farbe.GetSelIndex = 2 then
      printlog "OK, line style from was correct imported!"
    else
      warnlog "Line style wasn't correct imported!"
    end if
    TabLinie.Cancel
    FormatArea
    Kontext
    Active.SetPage TabFlaeche
    Kontext "TabFlaeche"
    if Farbe.IsChecked and FarbeAuswahl.GetSelIndex = 4 then
         printlog "OK, surface was correct imported!"
      else
         warnlog "Surface wasn't correct imported!"
      end if
      Kontext
      Active.SetPage TabTransparenz
      Kontext "TabTransparenz"
      if KeineTransparenz.IsChecked then
         printlog "OK, transparency characteristic was correct imported!"
      else
         warnlog "Transparency characteristic wasn't correct imported!"
      end if
      Kontext
      Active.SetPage TabFarben
      Kontext "TabFarben"
      if Farbe.GetSelIndex = 4 then
         printlog "OK, Colour was correct imported!"
      else
         warnlog "Colour wasn't correct imported!"
      end if
      TabFarben.Cancel

      printlog "* Checking ellipsoid *"
      call gMouseClick (20,65)
      FormatLinie
      Kontext
      Active.SetPage TabLinie
      Kontext "TabLinie"
      if Stil.GetSelIndex = 1 then
         printlog "OK, line style was correct imported!"
      else
         warnlog "The line style wasn't correct imported!"
      end if
      TabLinie.Cancel
      FormatFlaeche
      Kontext
      Active.SetPage TabFlaeche
      Kontext "TabFlaeche"
      if Bitmap.IsChecked then
         printlog "OK, the surface was correct imported!"
      else
         warnlog "The surface wasn't correct imported!"
      end if
      Kontext
      Active.SetPage TabSchatten
      Kontext "TabSchatten"
    if NOT Anzeigen.IsChecked then
      printlog "OK, shadow wasn't active!"
    else
      warnlog "Shadow was active!"
    end if
    Kontext
    Active.SetPage TabTransparenz
    Kontext "TabTransparenz"
    if KeineTransparenz.IsChecked then
      printlog "OK, transparency wasn't enabled!"
    else
      warnlog "Transparency was enabled!"
    end if
    Kontext
    Active.SetPage TabFarben
    Kontext "TabFarben"
    if Farbe.GetSelIndex = 4 then
      printlog "OK, Colour was corrct imported!"
    else
      warnlog "Colour wasn't correct imported!"
    end if
    TabFarben.Cancel

    printlog "* Checking the small square *"
    call gMouseClick (5,84)
    FormatLine
    Kontext
    Active.SetPage TabLinie
    Kontext "Tablinie"
    if Stil.GetSelIndex = 2 and Farbe.GetSelIndex = 13 then
      printlog "Ok, the line style was correct imported!"
    else
      warnlog "The line style wasn't correct imported!"
    end if

    TabLinie.Cancel

    FormatArea
    Kontext
    Active.SetPage TabFlaeche
    Kontext "TabFlaeche"
    if Farbverlauf.IsChecked then
      printlog "OK, colour gradient was correct imported!"
    else
      warnlog "Colour gradient wasn't correct imported!"
    end if
    Kontext
    Active.SetPage TabSchatten
    Kontext "TabSchatten"
    if Anzeigen.IsChecked and Farbe.GetSelIndex = 6 then
      printlog "OK, Shadow was imported with the right colour!"
    else
      warnlog "Shadow wasn't correct imported!"
    end if

    Kontext
    Active.SetPage TabTransparenz
    Kontext "TabTransparenz"
    if KeineTransparenz.IsChecked then
      printlog "OK, there was no transparency!"
    else
      warnlog "Transparency was active!"
    end if

    Kontext
    Active.SetPage TabFarbverlaeufe
    Kontext "TabFarbverlaeufe"
    if Von.GetSelIndex = 10 and Bis.GetSelIndex = 4 then
      printlog "OK, the Colours are the right ones!"
    else
      warnlog "There weren't the right colours imported!"
    end if

    TabFarbverlaeufe.Cancel

    printlog "* Checking the first text *"
    Kontext "DocumentCalc"
    DocumentCalc.MouseDoubleClick 40,8
    FormatCharacter
    Kontext
    Active.SetPage TabSchrift
    Kontext "TabSchrift"
    if Schriftart.GetSelText = "Arial" and Schriftstil.GetSelIndex = 3 and Farbe.GetSelIndex = 10 then
      printlog "OK, the characteristic of the writing was correct importet!"
    else
      warnlog "The characteristic wasn't correct importet!"
    end if

    Kontext
    Active.SetPage TabSchrifteffekt
    Kontext "TabSchrifteffekt"
    if Normal.IsChecked and Laufweite.GetSelIndex = 1 then
      printlog "OK, the writing effects were correct imported!"
    else
      warnlog "The writing effects weren't correct imported!"
    end if

    TabSchrifteffekt.Cancel


    call hCloseDocument

endcase

'
'---------------------------------------------------------------------------
'
testcase tInsertDataRange
'/// This test checks, if the formula, which calculate the contents of a relative
'/// adressed cellrange, recalculate it, when the location of this range was changed
'/// by inserting a new cell in the document.

   dim file$
   file$ = convertpath(gtesttoolpath & "input\calc\stufe1\c_104\teinfuegenzellen" & Ext)

   call hDateiOeffnen file$



   call hCloseDocument

endcase

'
'---------------------------------------------------------------------------
'
testcase tInsertExternalData
'/// This test checks, if the inserting of an external datasource is available.
'/// First it is checked by using the appropriate dialog.
'/// Then it is checked by using the navigator.
'/// Here the following URL's are used
'/// http://de.finance.yahoo.com/q?s=@NE50_XE.DE&d=v1 as an URL from the internet and
'/// file:///V:/testtool/input/calc/stufe1/c_104/tinsertexternaldata.sxc as an URL from the LAN

   dim httpText as String, fileText as String
   httpText = "http://de.finance.yahoo.com/q?s=@NE50_XE.DE&d=v1"
   fileText = "file:///" & replaceCharacter(gTesttoolPath, "\", "/") & "calc/level1/input/c_104/tinsertexternaldata.sxc"
   printlog "fileText: " & fileText
   'fileText = "file:///V:/testtool/calc/level1/input/c_104/tinsertexternaldata.sxc"
'/// Load a new calc document
'/// First this functionality is checked by using the appropriate dialog
'/// Check this feature by inserting a file from the LAN with the FileOpenDlg
   call hNewDocument

   printlog "*** First this functionality is checked by using the appropriate dialog"
   printlog "Check this feature by inserting a file from the LAN with the FileOpenDlg"
   Kontext "DocumentCalc"
   DocumentCalc.TypeKeys "<MOD1 HOME>"
   checkexternaldata("A1", "This is the first range with 4 rows", 1, fileText, true)
   sleep 3
   printlog "Then check this feature by inserting a file from the LAN with using the URL Bar"
   call cgotoCell ("A10")
   checkexternaldata("A10", "The second range contains 10 rows", 2, fileText, false)
   sleep 3

   call hCloseDocument
'/// Then check this feature by inserting a html document from the internet with using the URL Bar
   sleep 3
   printlog "Now check this feature by inserting a html document from the internet with using the URL Bar"
   call hNewDocument
   DocumentCalc.TypeKeys "<MOD1 HOME>"
   checkexternaldata("B14", "WKN", 2, httpText, false)

   call hCloseDocument
goto endtest
' The following test doesn't work with the testtool, because it is not possible to move the mouse outside of
' the navigator window without Kontext/Focus Change.
   sleep 3
   printlog "*** Now it is checked by using the navigator"

   call hDateiOeffnen "V:/testtool/calc/level1/input/c_104/tinsertexternaldata.sxc"
   sleep 3
    call hNewDocument
   Kontext "DocumentCalc"
   'Open the navigator
   Kontext "NavigatorCalc"
   if NOT NavigatorCalc.exists then
      Kontext "DocumentCalc"
      DocumentCalc.TypeKeys "<F5>"
   end if
   sleep 3
   Kontext "NavigatorCalc"
   dim i as integer
   for i = 1 to Dokumente.getItemCount
      Dokumente.select i
      if left(Dokumente.getSelText, 7) = "tinsert" then exit for
   next i
   printlog "Document " & Dokumente.getSelText & " is selected"
   NavigatorCalc.MouseDown 80, 15
   NavigatorCalc.MouseMove 80, 30
   NavigatorCalc.MouseUp 80, 30
   sleep 3
   Liste.TypeKeys "<PAGEUP><DOWN><DOWN>"
   Liste.Typekeys "+"
   call Navigatorclick("Range1", true, false)

   sleep 3
   Liste.MouseDown gcMousePosX, gcMousePosY
   sleep 3
   Liste.MouseMove 1, 1
   Kontext "DocumentCalc"
   DocumentCalc.MouseMove 1, 1
   sleep 5

   Kontext "DocumentCalc"
   dim Cellcontent as String
   Cellcontent = cZellwert("A1")
   if Cellcontent = "This is the first range with 4 rows" then
      printlog "OK, the source was inserted into the cell"
   else
      warnlog "There was " & Cellcontent & " instead of 'This is the first range with 4 rows' in the cell A1"
   end if
   call hCloseDocument
   sleep 3
   call hCloseDocument
endtest:
endcase

'
'---------------------------------------------------------------------------
'
testcase tCellreferences
'/// In this test there are inserted sum formula in cell B10. Then with the shortcut ///
'/// SHIFT+F4 it is checked if the cellreferences are modified. ///
'/// It is also checked, if the cell references are modified after cut and paste ///
'/// into the same column or the row from which they were cut. ///

   Dim i as integer
   Dim IstInhalt, SollInhalt1, SollInhalt2, SollInhalt3
   Dim file$
   file$ = convertpath(gtesttoolpath & "calc\level1\input\c_102\tbearbeitenausschneiden" & Ext)
   select case iSprache
      case 49  : SollInhalt1 = "=SUMME($B$2:$B$6)" : SollInhalt2 = "=SUMME(B$2:B$6)" : SollInhalt3 = "=SUMME($B2:$B6)"     ' german
      case 46  : SollInhalt1 = "=SUMMA($B$2:$B$6)" : SollInhalt2 = "=SUMMA(B$2:B$6)" : SollInhalt3 = "=SUMMA($B2:$B6)"     ' swedish
      case 01  : SollInhalt1 = "=SUM($B$2:$B$6)" : SollInhalt2 = "=SUM(B$2:B$6)" : SollInhalt3 = "=SUM($B2:$B6)"        ' english
      case 03  : SollInhalt1 = "=SOMA($B$2:$B$6)" : SollInhalt2 = "=SOMA(B$2:B$6)" : SollInhalt3 = "=SOMA($B2:$B6)"        ' Portugiesisch
      case 31  : SollInhalt1 = "=SOM($B$2:$B$6)" : SollInhalt2 = "=SOM(B$2:B$6)" : SollInhalt3 = "=SOM($B2:$B6)"        ' Niederlaendisch
      case 33  : SollInhalt1 = "=SOMME($B$2:$B$6)" : SollInhalt2 = "=SOMME(B$2:B$6)" : SollInhalt3 = "=SOMME($B2:$B6)"        ' french
      case 34  : SollInhalt1 = "=SUMA($B$2:$B$6)" : SollInhalt2 = "=SUMA(B$2:B$6)" : SollInhalt3 = "=SUMA($B2:$B6)"        ' spanish
      case 39  : SollInhalt1 = "=SOMMA($B$2:$B$6)" : SollInhalt2 = "=SOMMA(B$2:B$6)" : SollInhalt3 = "=SOMMA($B2:$B6)"        ' italian
      case 45  : SollInhalt1 = "=SUM($B$2:$B$6)" : SollInhalt2 = "=SUM(B$2:B$6)" : SollInhalt3 = "=SUM($B2:$B6)"        ' danish
      case 81  : SollInhalt1 = "=SUM($B$2:$B$6)" : SollInhalt2 = "=SUM(B$2:B$6)" : SollInhalt3 = "=SUM($B2:$B6)"
      case 82  : SollInhalt1 = "=SUM($B$2:$B$6)" : SollInhalt2 = "=SUM(B$2:B$6)" : SollInhalt3 = "=SUM($B2:$B6)"
      case 86  : SollInhalt1 = "=SUM($B$2:$B$6)" : SollInhalt2 = "=SUM(B$2:B$6)" : SollInhalt3 = "=SUM($B2:$B6)"
      case 88  : SollInhalt1 = "=SUM($B$2:$B$6)" : SollInhalt2 = "=SUM(B$2:B$6)" : SollInhalt3 = "=SUM($B2:$B6)"
      case 48  :  SollInhalt1 = "=SUMA($B$2:$B$6)" : SollInhalt2 = "=SUMA(B$2:B$6)" : SollInhalt3 = "=SUMA($B2:$B6)"       ' polish
      case else : warnlog "Current value: language adjustment is still missing!"
   end select

   Printlog "Insert sum formula and modify cell references with Shift F4"
   call hNewDocument
'/// Open a new calc document and insert a sum formula in cell 'B10' (=SUM(B":B6))
   cgotocell ("B10")
   Select case iSprache
      case 01 : DocumentCalc.Typekeys "=SUM(B2:B6)<RETURN><UP>"
      case 03  : DocumentCalc.Typekeys "=SOMA(B2:B6)<RETURN><UP>"
      case 31  : DocumentCalc.Typekeys "=SOM(B2:B6)<RETURN><UP>"
      case 49 : DocumentCalc.Typekeys "=SUMME(B2:B6)<RETURN><UP>"
      case 46 : DocumentCalc.Typekeys "=SUMMA(B2:B6)<RETURN><UP>"
      case 33 : DocumentCalc.Typekeys "=SOMME(B2:B6)<RETURN><UP>"
      case 34 : DocumentCalc.Typekeys "=SUMA(B2:B6)<RETURN><UP>"
      case 39 : DocumentCalc.Typekeys "=SOMMA(B2:B6)<RETURN><UP>"
      case 45 : DocumentCalc.Typekeys "=SUM(B2:B6)<RETURN><UP>"
      case 48 : DocumentCalc.Typekeys "=SUMA(B2:B6)<RETURN><UP>"
      case 81 : DocumentCalc.Typekeys "=SUM(B2:B6)<RETURN><UP>"
      case 82 : DocumentCalc.Typekeys "=SUM(B2:B6)<RETURN><UP>"
      case 86 : DocumentCalc.Typekeys "=SUM(B2:B6)<RETURN><UP>"
      case 88 : DocumentCalc.Typekeys "=SUM(B2:B6)<RETURN><UP>"
      case else : warnlog "Formula insert: language adjustment is still missing!"
   end select
'/// Then press Keys <SHIFT+F4> to make the refrence row and column absolut
   DocumentCalc.Typekeys "<SHIFT F4>"
   IstInhalt = cZellInhalt("B10")
   Printlog "First time : " + IstInhalt
   If IstInhalt <>  SollInhalt1 then
      warnlog " The cell reference wasn't correct modify! Current: " + SollInhalt1
   end if
'/// Press the Keys <SHIFT+F4> a second time to make the rows absolut
   DocumentCalc.Typekeys "<SHIFT F4>"
   IstInhalt = cZellInhalt("B10")
   Printlog "At the second time : " + IstInhalt
   If IstInhalt <>  SollInhalt2 then
      warnlog " The cell reference wasn't correct modify! Current: " + SollInhalt2
   end if
'/// Press the Keys <SHIFT+F4> a second time to make the column absolut
   DocumentCalc.Typekeys "<SHIFT F4>"
   IstInhalt = cZellInhalt("B10")
   Printlog "At the third time : " + IstInhalt
   If IstInhalt <>  SollInhalt3 then
      warnlog " The cell reference wasn't correct modify! Current: " + SollInhalt3
   end if
   call hCloseDocument

   ' Check, if the cell referneces are modified after cut and paste
   ' This procedure was modified, because it's now impossible to shift cells into the same column or the
   ' row from which they were cut. This new procedure considers this.
'/// Open the file gtesttoolpath & "calc\level1\input\c_102\tbearbeitenausschneiden"
   call hDateiOeffnen file$
   Kontext "DocumentCalc"
   DocumentCalc.TypeKeys "<Mod1 Home>"
'/// Cut the cellcontent of cell 'A1'  and call the menuitem 'EditPasteSpecialCalc'
'/// uncheck All, check numbers and attempt to check shift cells downwards and right
'/// (a warnlog should be appear). Then paste it with the option numbers into cell 'B1'
   EditCut
   DocumentCalc.TypeKeys "<down>"
   EditPasteSpecialCalc
   Kontext "InhalteEinfuegenCalc"
   AllesEinfuegen.UnCheck
   Zahlen.Check
   try
      NachUnten.Check
      Warnlog "warning cells shift downward were possible"
   catch
      printlog "OK it wasn't possible to shift cells downward"
   endcatch
   InhalteEinfuegenCalc.Cancel
   Kontext "DocumentCalc"
   DocumentCalc.TypeKeys "<up><right>"
   EditPasteSpecialCalc
   Kontext "InhalteEinfuegenCalc"
   AllesEinfuegen.UnCheck
   Zahlen.Check
   try
      NachRechts.Check
      warnlog "warning cells shift right were possible"
   catch
      printlog "OK it wasn't possible to shift cells to the right"
   endcatch
   try
      NachUnten.Check
   catch
      printlog "warning, it wasn't possible to shift cells downward"
   endcatch
   InhalteEinfuegenCalc.OK
'/// Check if the cellcontent of cell 'A1' was cut abd if the cellcontent of cell 'B1' was '1'
   Kontext "DocumentCalc"
   if cZellinhalt("A1") = "" then
      printlog "OK, cellcontain was cut"
   else
      warnlog "Cellcontain of A1 wasn't cut"
   end if
   if cZellinhalt("B1") = "1" then
      printlog "OK, the cellcotent was inserted"
   else
      warnlog "The Cellcontent wasn't inserted"
   end if
'/// Check if the cellreference of cell 'B2' was '=B1'
   if cZellinhalt("B2") = "=B1" then
      printlog "OK the cellreference from B1 was adapted"
   else
      warnlog "warning, the cellreference from B1 wasn't adapted"
   end if
'/// Check , if the cellreferences from the cells 'B3:B6' are '=A2...5'
   for i = 3 to 6
      if cZellinhalt("B" & i) = "=A" & (i-1) then
         printlog "Ok the cellreference from B" & i & " was adapted"
      else
         warnlog "the cellrefence from B" & i & " wasn't adapted"
      end if
   next i
   call hCloseDocument
'/// Close the document and open it again
   call hDateiOeffnen file$
   Kontext "DocumentCalc"
   DocumentCalc.TypeKeys "<Mod1 Home>"
   DocumentCalc.TypeKeys "<Mod1 Shift down>"
'/// Cut the cellcontents from 'A1:A5' and paste it with the special options
'/// numbers and not move, uncheck all other options and confirm with OK.
   EditCut
   call cGotoCell("A6")
   EditPasteSpecialCalc
   Kontext "InhalteEinfuegenCalc"
   AllesEinfuegen.UnCheck
   Zahlen.Check
   Transponieren.UnCheck
   Verknuepfen.UnCheck
   LeerzellenUeberspringen.UnCheck
   NichtVerschieben.Check
   InhalteEinfuegenCalc.OK
   sleep 5
'/// Check if the cellcontents from 'B1..3' are updated to '=A6...8'
   if cZellinhalt("B1") = "=A6" and cZellinhalt("B2") = "=A7" and cZellinhalt("B3") = "=A8" then
      printlog "OK, formulars in the cells were adapted"
   else
      warnlog "Formulars in the cells weren't adapted"
   end if
   sleep 30
   call hCloseDocument

endcase
'
'---------------------------------------------------------------------------
'
testcase tFunctionCheck
'/// This test read the function list and check on blanks in the function names. ///

    Dim Eintrag1, Eintrag2, Kategorietext
    Dim wh, gf, fl, x, z, ct
    dim entryNr as integer
'/// Open a new calc document, call the function autopilot and check if any formula has a blank in it
    call hNewDocument

    sleep 3
    Kontext
    InsertFunction
    Kontext "Funktionsautopilot"
    select case iSprache
      case 01     : Eintrag1 = "All"
      case 03     : Eintrag1 = "Tudo"        ' Portugiesisch
      case 31     : Eintrag1 = "Alle"        ' Niederlaendisch
      case 39     : Eintrag1 = "Tutte"    ' Italienisch
      case 45     : Eintrag1 = "Alle"        ' Dänisch
      case 49     : Eintrag1 = "Alle"
      case 46     : Eintrag1 = "Alla"        ' Schwedisch
      case 48     : Eintrag1 = "Wszystkie"   ' Polnisch
      case 33     : Eintrag1 = "Toutes"      ' Französisch
      case 34     : Eintrag1 = "Todas"    ' Spanisch
      case 81     : entryNr = 2
      case 82     : entryNr = 2
      case 86     : entryNr = 2
      case 88     : entryNr = 2
        case else : warnlog "The language adjustment is still missing!"
    end select

    wh = 0
    gf = 0
    fl = 0

    For wh = 1 to Kategorie.getItemCount
      Kontext "FunktionsAutoPilot"
      Kategorie.select wh
      Kategorietext = Kategorie.getSelText
      If Kategorietext = Eintrag1 then gf = wh
    next
    If gf <> 0 then
      printlog "The entry " + Eintrag1 + " has the number " + gf
    else
      if iSprache < 80 then
            warnlog "The entry " + Eintrag1 + " isn't available in the list !"
         else
            printlog "It is an asian office, so the entry for the Category isn't detected as string, but as entryNr"
         end if
    end if
    printlog "Altogether are " + Kategorie.getItemCount + " entries in the list."

    '*** Funktionsnamen auf Leerzeichen pruefen

    ct = 0
    Kontext "FunktionsAutoPilot"
    Sleep 2
    if iSprache > 80 then
      Kategorie.select entryNr
    else
        Kategorie.select gf
    end if

    for fl = 1 to Funktion.getItemCount
        Funktion.select fl
        Eintrag2 = Funktion.getSelText
        'Printlog Eintrag2
        For x = 1 to len(Eintrag2)
            z = mid(Eintrag2,x,1)
            'Leerzeichen ist 32
            if z = CHR(32) then warnlog "In the function name [" + Eintrag2 + "] is a blank! "
        next
        ct = ct + 1
    next
    Printlog " There were checked " + ct + " entries"
    Funktionsautopilot.Cancel
    sleep 1
    call hCloseDocument
endcase

