'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: coption7.inc,v $
'*
'*  $Revision: 1.5 $
'*
'*  last change: $Author: tbo $ $Date: 2005/09/07 19:07:16 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : peter.junge@Sun.COM
'*
'* short description : Check Tools->Options->Spreadsheet->Print
'*
'************************************************************************
'*
' #1 cOption7                     ' Initial Routine
' #1 tOptionsPrint_save            ' Check all Print Options and change them
' #1 tOptionsPrint_reload          ' Check if changes persist after exit and restart the office
' #1 tOptionsPrintRestore_settings ' Restore default settings
' #1 tOptionsPrint_functionality   ' Test correct functionality of changes
'*
'\************************************************************************

Global curr_Suppress as integer, flag_Suppress as integer
Global curr_Select as integer, flag_Select as integer

sub cOption7

        printLog Chr(13) + "--------- cOption7 ---------"
        printlog "Tools|Options|Spreadsheet|Print"

        call tOptionsPrint_save
        call tOptionsPrint_reload
        call tOptionsPrint_functionality
        call tOptionsPrintRestore_settings

end sub

'*********************************************************************************************************

testcase tOptionsPrint_save
'/// This test invokes the "Tools|Options|Spreadsheet|Print" dialog
'/// First the default settings are verified ///'
'/// For any item with an unexpected value a warning is thrown ///'
'/// Then each control is modified and the dialog is saved & closed using OK. ///'
'/// After a restart of the office the persistence of the changes is verified ///'
'/// Further correct functionality is tested ///'
'/// Finally the original settings are restored ///'

        ' Initialize the variables
        curr_Suppress = 0
        curr_Select = 0

        Call hNewDocument

        ' Modify all parameters in this tabpage
        ToolsOptions
        hToolsOptions("SPREADSHEET", "PRINT")

    ' Suppress output of empty pages
    if SuppressOutput.ischecked then
        warnlog "<Suppress output ...> is enabled by default"
        curr_Suppress = 1
        SuppressOutput.uncheck
        flag_Suppress = SuppressOutput.GetState
    else
        curr_Suppress = 0
        SuppressOutput.check
        flag_Suppress = SuppressOutput.GetState
    end if

    ' Print only selected sheets
    if PrintOnly.ischecked then
        warnlog "<Print only...> is enabled by default"
        curr_Select = 1
        PrintOnly.uncheck
        flag_Select = PrintOnly.GetState
    else
        curr_Select = 0
        PrintOnly.check
        flag_Select = PrintOnly.GetState
    end if

    ' Close the Options dialog with modified settings

        Kontext "OptionenDlg"
        OptionenDlg.OK
    sleep 5
        Call hCloseDocument

endcase

'*********************************************************************************************************

testcase tOptionsPrint_reload
'/// Documentation is summarized in tOptionsPrint_save

    sleep 5
    'Restart the complete office
    ExitRestartTheOffice
    Call hNewDocument

    ' Check the changed settings
    ToolsOptions
    hToolsOptions("SPREADSHEET", "PRINT")

    ' Suppress output of empty pages
    if SuppressOutput.GetState = flag_Suppress then
        printlog "OK, change of <Suppress output of empty pages> is persistent"
        else
                warnlog "The new value of <Suppress output of empty pages> wasn't stored"
        end if

        ' Print only selected sheets
        if PrintOnly.GetState = flag_Select then
        printlog "OK, the change of <Print only selected sheets> is persistent"
        else
                warnlog "The new value of <Print only selected sheets> wasn't stored"
        end if

        ' Close the Options dialog with the new settings

        Kontext "OptionenDlg"
        OptionenDlg.Cancel

        Call hCloseDocument

endcase

'*********************************************************************************************************

testcase tOptionsPrintRestore_settings
'/// Documentation is summarized in tOptionsPrint_save

        call hNewDocument

        ' Restore the default settings
        ToolsOptions
        hToolsOptions("SPREADSHEET", "PRINT")

    ' Suppress output of empty pages
    if curr_Suppress = 1 then
        SuppressOutput.check
    else
        SuppressOutput.uncheck
    end if

        ' Print only selected sheets
        if curr_Select = 1 then
                PrintOnly.check
        else
                PrintOnly.uncheck
        end if

        Kontext "OptionenDlg"
        OptionenDlg.OK

        Call hCloseDocument

endcase

'*********************************************************************************************************

testcase tOptionsPrint_functionality
'/// Documentation is summarized in tOptionsPrint_save

        dim sheetname1 as string
        dim sheetname2 as string
        dim sheetentry1 as string

        sheetentry1 = "#Suppress output of empty pages# is activated -> sheet1 and sheet3 should be printed"

        Call hNewDocument

        ' Check the new settings for correct functionality

        ' Suppress output of empty pages
        printlog "Check the option <Suppress output of empty pages>"

        Kontext "DocumentCalc"
        DocumentCalc.TypeKeys "<MOD1 HOME>"
        DocumentCalc.TypeKeys "#Suppress output of empty pages# is activated -> sheet1 and sheet3 should be printed<RETURN>"
        'determine the first sheetname
        FormatSheetRename
        Kontext "TabelleUmbenennen"
        sheetname1 = TabellenName.GetText
        TabelleUmbenennen.Cancel
        Kontext "DocumentCalc"
        'Goto the third sheet
        DocumentCalc.TypeKeys "<MOD1 PAGEDOWN PAGEDOWN>"
        DocumentCalc.TypeKeys "<MOD1 HOME>"
        DocumentCalc.TypeKeys "This is the second page<RETURN>"
        'determine the third sheetname
        FormatSheetRename
        Kontext "TabelleUmbenennen"
        sheetname2 = TabellenName.GetText
        TabelleUmbenennen.Cancel
        Kontext "DocumentCalc"
        'Go to the first page
    FilePageView
    Kontext "Previewbar"
    ErsteSeite.Click
    'Check the entry in the center area of the dialog Header
    EditHeadersAndFooters
    Kontext
    active.setpage TabKopfzeileCalc
    Kontext "TabKopfzeileCalc"
    Kontext "MittlererBereich"
    MittlererBereich.TypeKeys "<END>"
    MittlererBereich.TypeKeys "<MOD1 SHIFT LEFT>"
    MittlererBereich.TypeKeys "<MOD1 C>"
    Kontext "TabKopfzeileCalc"
    TabKopfzeileCalc.Cancel
    if GetClipboardText = sheetname1 then
        printlog "OK, the sheet name is correct"
    else
        qaErrorLog "The sheet name is '" & GetClipboardText & "' instead of " &  "'" & sheetname1 & "'"
    end if
    'Leave the pagepreview and check the entry in cell A1
    Kontext "Previewbar"
    Seitenansicht.Click
    'After closing the page preview the focus should be on the second page again
    Kontext "DocumentCalc"
        DocumentCalc.TypeKeys "<MOD1 HOME>"
        DocumentCalc.TypeKeys "<F2>"
        DocumentCalc.TypeKeys "<MOD1 SHIFT HOME>"
        DocumentCalc.TypeKeys "<MOD1 C>"
        if GetClipboardText = "This is the second page" then
                printlog "OK, the sheet name and cell content are correct"
        else
                warnlog "The cell content is '" & GetClipboardText & "' instead of 'This is the second page'"
        end if

    'Check the sheet name of the third sheet
        FilePageView
    Kontext "Previewbar"
    EditHeadersAndFooters
    Kontext
    active.setpage TabKopfzeileCalc
    Kontext "TabKopfzeileCalc"
    Kontext "MittlererBereich"
    MittlererBereich.TypeKeys "<END>"
    MittlererBereich.TypeKeys "<MOD1 SHIFT LEFT>"
    MittlererBereich.TypeKeys "<MOD1 C>"
    Kontext "TabKopfzeileCalc"
    TabKopfzeileCalc.Cancel
    if GetClipboardText = sheetname2 then
        printlog "OK, the sheet name is correct"
    else
        warnlog "The sheet name is '" & GetClipboardText & "' instead of " &  "'" & sheetname2 & "'"
    end if
    'Leave the page preview and check the entry in cell A1
    Kontext "Previewbar"
    Seitenansicht.Click
    Kontext "DocumentCalc"
    ' Go to the first page
    Kontext "DocumentCalc"
    DocumentCalc.TypeKeys "<MOD1 PAGEUP PAGEUP>"
        DocumentCalc.TypeKeys "<MOD1 HOME>"
        DocumentCalc.TypeKeys "<MOD1 HOME>"
        DocumentCalc.TypeKeys "<F2>"
        DocumentCalc.TypeKeys "<MOD1 SHIFT HOME>"
        DocumentCalc.TypeKeys "<MOD1 C>"
        if GetClipboardText = sheetentry1 then
                printlog "OK, the shee tname and cell content are correct"
        else
                warnlog "The cellcontent is '" & GetClipboardText & "' instead of " & sheetentry1
        end if

        ' Now check the option by printing the document
        ' At first disable the printoption 'selected sheet'
        ToolsOptions
        hToolsOptions("SPREADSHEET", "PRINT")
        ' Print only selected sheets
        if PrintOnly.ischecked then
                PrintOnly.uncheck
        end if
        Kontext "OptionenDlg"
        OptionenDlg.OK
        printlog "Printing the first and the third page"
        FilePrint
        'if there is no printer in the system you will get an error
        Kontext
          if Active.Exists(2) then
            if Active.GetRT = 304 then
             QAErrorLog "You seem to have no printer configured!"
             printlog Active.GetText
             Active.OK
            end if
          else
            Kontext "DruckenDlg"
            DruckenDlg.OK
            Kontext
            if Active.Exists(2) then
               QAErrorLog "Yes, you have a printer configured. But, the settings doesn't seem to be proper!"
               if Active.GetRT = 304 then
                  printlog Active.GetText
                  Active.OK
               else
                  warnlog "Unexpected objekt: " & Active.GetText & " found!"
                  try
                     Active.OK
                  catch
                     Active.Yes
                  endcatch
               end if 
            end if
          end if
        ' Now it is time to check the next option on their functionality
        ' Print only selected sheets
        sleep 2
        printlog "Check the option 'Print only selected sheets'"

        Kontext "DocumentCalc"
        DocumentCalc.TypeKeys "<MOD1 HOME>"
        DocumentCalc.TypeKeys "This is the first page<RETURN>"

        ' Go to the third sheet
        DocumentCalc.TypeKeys "<MOD1 PAGEDOWN PAGEDOWN>"
        DocumentCalc.TypeKeys "<MOD1 HOME>"
        DocumentCalc.TypeKeys "<Print only selected sheets> is activated -> only this page should be printed<RETURN>"

        ' Enable the print option
        ToolsOptions
        hToolsOptions("SPREADSHEET", "PRINT")
        ' Print only selected sheets
        if NOT PrintOnly.ischecked then
                PrintOnly.check
        end if
        Kontext "OptionenDlg"
        OptionenDlg.OK
    printlog "Printing the selected page"
        FilePrint
        'if there is no printer in the system you will get an error
        Kontext
        if Active.Exists(2) then
          if Active.GetRT = 304 then
           QAErrorLog "You seem to have no printer configured!"
           printlog Active.GetText
           Active.OK
          end if
        else
          Kontext "DruckenDlg"
          DruckenDlg.OK
          Kontext
            if Active.Exists(2) then
               QAErrorLog "Yes, you have a printer configured. But, the settings doesn't seem to be proper!"
               if Active.GetRT = 304 then
                  printlog Active.GetText
                  Active.OK
               else
                  warnlog "Unexpected objekt: " & Active.GetText & " found!"
                  try
                     Active.OK
                  catch
                     Active.Yes
                  endcatch
               end if 
            end if
        end if
        sleep (2)
        call hCloseDocument
endcase

