'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: un_redo4.inc,v $
'*
'*  $Revision: 1.2 $
'*
'*  last change: $Author: tbo $ $Date: 2005/09/07 19:07:25 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : peter.junge@Sun.COM
'*
'* short description    :       Complete Test for the undo/redo function which test
'*
'************************************************************************
'*
' #1 un_redo4      ' Initial routine
' #1 tFormat_Table ' Format Table - Undo/Redo - Check correct settings
'*
'\***********************************************************************

sub un_redo4

Printlog Chr(13) + "--------- FormatPage ---------"

        call tFormat_Table

end sub

'**************************************************************************************************

testcase tFormat_Table

'/// Open a new calc document, call menuitem 'FormatPage', goto tabpage 'Sheet' and toggle
'/// ColumnRowHeader
        dim ColandRow_current, ColandRow_bool as boolean
        call hNewDocument
        Printlog ""
        Printlog "* TabPage Table"
        FormatPageCalc
        Kontext
        active.setpage TabTabelleCalc
        Kontext
          if Active.Exists(2) then
             if Active.GetRT = 304 then
                printlog Active.GetText
                Active.YES
             end if
          end if
        Kontext "TabTabelleCalc"
        ColandRow_current = false
        ColandRow_current = false
        if ZeilenSpaltenKoepfe.IsChecked then
                ZeilenSpaltenKoepfe.UnCheck
                ColandRow_bool = false
        else
                ZeilenSpaltenKoepfe.Check
                ColandRow_bool = true
        end if
   ColandRow_current = ColandRow_bool
   TabTabelleCalc.OK

'/// check if the modify has been taken over
   FormatPageCalc
   Kontext
        active.setpage TabTabelleCalc
        Kontext "TabTabelleCalc"
        if ZeilenSpaltenKoepfe.IsChecked then
                ColandRow_bool = true
        else
                ColandRow_bool = false
        end if
        if ColandRow_current = ColandRow_bool then
                printlog "OK, the ColandRow state has been modified"
        else
                warnlog "The ColandRow state hasn't been modified"
        end if
        Kontext
        TabTabelleCalc.Cancel

'/// check if the undo-function works
        EditUndo
        if ColandRow_current = true then
                ColandRow_current = false
        else
                ColandRow_current = true
        end if
        FormatPageCalc
   Kontext
        active.setpage TabTabelleCalc
        Kontext "TabTabelleCalc"
        if ZeilenSpaltenKoepfe.IsChecked then
                ColandRow_bool = true
        else
                ColandRow_bool = false
        end if
        if ColandRow_current = ColandRow_bool then
                printlog "OK, the ColandRow state has been reset to current"
        else
                warnlog "The ColandRow state hasn't been reset to current"
        end if
        Kontext
        TabTabelleCalc.Cancel

'/// check if the redo-function works
        EditRedo
        if ColandRow_current = true then
                ColandRow_current = false
        else
                ColandRow_current = true
        end if
        FormatPageCalc
   Kontext
        active.setpage TabTabelleCalc
        Kontext "TabTabelleCalc"
        if ZeilenSpaltenKoepfe.IsChecked then
                ColandRow_bool = true
        else
                ColandRow_bool = false
        end if
        if ColandRow_current = ColandRow_bool then
                printlog "OK, redo works"
        else
                warnlog "The redo-function doesn't work"
        end if
        Kontext
        TabTabelleCalc.Cancel
        EditUndo
        '_________________________________________________________________________________________________

'/// Call menuitem 'FormatPage', goto tabpage 'Sheet' and toggle table grid
        dim Grid_current, Grid_bool as boolean
        FormatPageCalc
        Kontext
        active.setpage TabTabelleCalc
        Kontext "TabTabelleCalc"
        Grid_current = false
        Grid_current = false
        if Tabellengitter.IsChecked then
                Tabellengitter.UnCheck
                Grid_bool = false
        else
                Tabellengitter.Check
                Grid_bool = true
        end if
   Grid_current = Grid_bool
   TabTabelleCalc.OK

'/// check if the modify has been taken over
   FormatPageCalc
   Kontext
        active.setpage TabTabelleCalc
        Kontext "TabTabelleCalc"
        if Tabellengitter.IsChecked then
                Grid_bool = true
        else
                Grid_bool = false
        end if
        if Grid_current = Grid_bool then
                printlog "OK, the Grid state has been modified"
        else
                warnlog "The Grid state hasn't been modified"
        end if
        Kontext
        TabTabelleCalc.Cancel

'/// check if the undo-function works
        EditUndo
        if Grid_current = true then
                Grid_current = false
        else
                Grid_current = true
        end if
        FormatPageCalc
        Kontext
        active.setpage TabTabelleCalc
        Kontext "TabTabelleCalc"
        if Tabellengitter.IsChecked then
                Grid_bool = true
        else
                Grid_bool = false
        end if
        if Grid_current = Grid_bool then
                printlog "OK, the Grid state has been reset to current"
        else
                warnlog "The Grid state hasn't been reset to current"
        end if
        Kontext
        TabTabelleCalc.Cancel

'/// check if the redo-function works
        EditRedo
        if Grid_current = true then
                Grid_current = false
        else
                Grid_current = true
        end if
        FormatPageCalc
        Kontext
        active.setpage TabTabelleCalc
        Kontext "TabTabelleCalc"
        if Tabellengitter.IsChecked then
                Grid_bool = true
        else
                Grid_bool = false
        end if
        if Grid_current = Grid_bool then
                printlog "OK, redo works"
        else
                warnlog "The redo-function doesn't work"
        end if
        Kontext
        TabTabelleCalc.Cancel
        EditUndo
        '_________________________________________________________________________________________________

'/// Call menuitem 'FormatPage', goto tabpage 'Sheet' and toggle notes
        dim Notes_current, Notes_bool as boolean
        FormatPageCalc
        Kontext
        active.setpage TabTabelleCalc
        Kontext "TabTabelleCalc"
        Notes_current = false
        Notes_current = false
        if Notizen.IsChecked then
                Notizen.UnCheck
                Notes_bool = false
        else
                Notizen.Check
                Notes_bool = true
        end if
   Notes_current = Notes_bool
   TabTabelleCalc.OK

'/// check if the modify has been taken over
   FormatPageCalc
   Kontext
        active.setpage TabTabelleCalc
        Kontext "TabTabelleCalc"
        if Notizen.IsChecked then
                Notes_bool = true
        else
                Notes_bool = false
        end if
        if Notes_current = Notes_bool then
                printlog "OK, the Notes state has been modified"
        else
                warnlog "The Notes state hasn't been modified"
        end if
        Kontext
        TabTabelleCalc.Cancel

'/// check if the undo-function works
        EditUndo
        if Notes_current = true then
                Notes_current = false
        else
                Notes_current = true
        end if
        FormatPageCalc
   Kontext
        active.setpage TabTabelleCalc
        Kontext "TabTabelleCalc"
        if Notizen.IsChecked then
                Notes_bool = true
        else
                Notes_bool = false
        end if
        if Notes_current = Notes_bool then
                printlog "OK, the Notes state has been reset to current"
        else
                warnlog "The Notes state hasn't been reset to current"
        end if
        Kontext
        TabTabelleCalc.Cancel

'/// check if the redo-function works
        EditRedo
        if Notes_current = true then
                Notes_current = false
        else
                Notes_current = true
        end if
        FormatPageCalc
        Kontext
        active.setpage TabTabelleCalc
        Kontext "TabTabelleCalc"
        if Notizen.IsChecked then
                Notes_bool = true
        else
                Notes_bool = false
        end if
        if Notes_current = Notes_bool then
                printlog "OK, redo works"
        else
                warnlog "The redo-function doesn't work"
        end if
        Kontext
        TabTabelleCalc.Cancel
        EditUndo
        '_________________________________________________________________________________________________

'/// Call menuitem 'FormatPage', goto tabpage 'Sheet' and toggle graphics
        dim Objects_current, Objects_bool as boolean
        FormatPageCalc
        Kontext
        active.setpage TabTabelleCalc
        Kontext "TabTabelleCalc"
        Objects_current = false
        Objects_current = false
        if GrafikenObjekte.IsChecked then
                GrafikenObjekte.UnCheck
                Objects_bool = false
        else
                GrafikenObjekte.Check
                Objects_bool = true
        end if
   Objects_current = Objects_bool
   TabTabelleCalc.OK

'/// check if the modify has been taken over
   FormatPageCalc
   Kontext
        active.setpage TabTabelleCalc
        Kontext "TabTabelleCalc"
        if GrafikenObjekte.IsChecked then
                Objects_bool = true
        else
                Objects_bool = false
        end if
        if Objects_current = Objects_bool then
                printlog "OK, the Objects state has been modified"
        else
                warnlog "The Objects state hasn't been modified"
        end if
        Kontext
        TabTabelleCalc.Cancel

'/// check if the undo-function works
        EditUndo
        if Objects_current = true then
                Objects_current = false
        else
                Objects_current = true
        end if
        FormatPageCalc
        Kontext
        active.setpage TabTabelleCalc
        Kontext "TabTabelleCalc"
        if GrafikenObjekte.IsChecked then
                Objects_bool = true
        else
                Objects_bool = false
        end if
        if Objects_current = Objects_bool then
                printlog "OK, the Objects state has been reset to current"
        else
                warnlog "The Objects state hasn't been reset to current"
        end if
        Kontext
        TabTabelleCalc.Cancel

'/// check if the redo-function works
        EditRedo
        if Objects_current = true then
                Objects_current = false
        else
                Objects_current = true
        end if
        FormatPageCalc
   Kontext
        active.setpage TabTabelleCalc
        Kontext "TabTabelleCalc"
        if GrafikenObjekte.IsChecked then
                Objects_bool = true
        else
                Objects_bool = false
        end if
        if Objects_current = Objects_bool then
                printlog "OK, redo works"
        else
                warnlog "The redo-function doesn't work"
        end if
        Kontext
        TabTabelleCalc.Cancel
        EditUndo
        '_________________________________________________________________________________________________

'/// Call menuitem 'FormatPage', goto tabpage 'Table and toggle charts
        dim Charts_current, Charts_bool as boolean
        FormatPageCalc
        Kontext
        active.setpage TabTabelleCalc
        Kontext "TabTabelleCalc"
        Charts_current = false
        Charts_current = false
        if Diagramme.IsChecked then
                Diagramme.UnCheck
                Charts_bool = false
        else
                Diagramme.Check
                Charts_bool = true
        end if
   Charts_current = Charts_bool
   TabTabelleCalc.OK

'/// check if the modify has been taken over
   FormatPageCalc
   Kontext
        active.setpage TabTabelleCalc
        Kontext "TabTabelleCalc"
        if Diagramme.IsChecked then
                Charts_bool = true
        else
                Charts_bool = false
        end if
        if Charts_current = Charts_bool then
                printlog "OK, the Charts state has been modified"
        else
                warnlog "The Charts state hasn't been modified"
        end if
        Kontext
        TabTabelleCalc.Cancel

'/// check if the undo-function works
        EditUndo
        if Charts_current = true then
                Charts_current = false
        else
                Charts_current = true
        end if
        FormatPageCalc
        Kontext
        active.setpage TabTabelleCalc
        Kontext "TabTabelleCalc"
        if Diagramme.IsChecked then
                Charts_bool = true
        else
                Charts_bool = false
        end if
        if Charts_current = Charts_bool then
                printlog "OK, the Charts state has been reset to current"
        else
                warnlog "The Charts state hasn't been reset to current"
        end if
        Kontext
        TabTabelleCalc.Cancel

'/// check if the redo-function works
        EditRedo
        if Charts_current = true then
                Charts_current = false
        else
                Charts_current = true
        end if
        FormatPageCalc
   Kontext
        active.setpage TabTabelleCalc
        Kontext "TabTabelleCalc"
        if Diagramme.IsChecked then
                Charts_bool = true
        else
                Charts_bool = false
        end if
        if Charts_current = Charts_bool then
                printlog "OK, redo works"
        else
                warnlog "The redo-function doesn't work"
        end if
        Kontext
        TabTabelleCalc.Cancel
        EditUndo
        '_________________________________________________________________________________________________

'/// Call menuitem 'FormatPage', goto tabpage 'Sheet' and toggle drawing objects
        dim DrawingObjects_current, DrawingObjects_bool as boolean
        FormatPageCalc
        Kontext
        active.setpage TabTabelleCalc
        Kontext "TabTabelleCalc"
        DrawingObjects_current = false
        DrawingObjects_current = false
        if Zeichenobjekte.IsChecked then
                Zeichenobjekte.UnCheck
                DrawingObjects_bool = false
        else
                Zeichenobjekte.Check
                DrawingObjects_bool = true
        end if
   DrawingObjects_current = DrawingObjects_bool
   TabTabelleCalc.OK

'/// check if the modify has been taken over
   FormatPageCalc
   Kontext
        active.setpage TabTabelleCalc
        Kontext "TabTabelleCalc"
        if Zeichenobjekte.IsChecked then
                DrawingObjects_bool = true
        else
                DrawingObjects_bool = false
        end if
        if DrawingObjects_current = DrawingObjects_bool then
                printlog "OK, the DrawingObjects state has been modified"
        else
                warnlog "The DrawingObjects state hasn't been modified"
        end if
        Kontext
        TabTabelleCalc.Cancel

'/// check if the undo-function works
        EditUndo
        if DrawingObjects_current = true then
                DrawingObjects_current = false
        else
                DrawingObjects_current = true
        end if
        FormatPageCalc
   Kontext
        active.setpage TabTabelleCalc
        Kontext "TabTabelleCalc"
        if Zeichenobjekte.IsChecked then
                DrawingObjects_bool = true
        else
                DrawingObjects_bool = false
        end if
        if DrawingObjects_current = DrawingObjects_bool then
                printlog "OK, the DrawingObjects state has been reset to current"
        else
                warnlog "The DrawingObjects state hasn't been reset to current"
        end if
        Kontext
        TabTabelleCalc.Cancel

'/// check if the redo-function works
        EditRedo
        if DrawingObjects_current = true then
                DrawingObjects_current = false
        else
                DrawingObjects_current = true
        end if
        FormatPageCalc
        Kontext
        active.setpage TabTabelleCalc
        Kontext "TabTabelleCalc"
        if Zeichenobjekte.IsChecked then
                DrawingObjects_bool = true
        else
                DrawingObjects_bool = false
        end if
        if DrawingObjects_current = DrawingObjects_bool then
                printlog "OK, redo works"
        else
                warnlog "The redo-function doesn't work"
        end if
        Kontext
        TabTabelleCalc.Cancel
        EditUndo
        '_________________________________________________________________________________________________

'/// Call menuitem 'FormatPage', goto tabpage 'Sheet' and toggle formulas
        dim Formulas_current, Formulas_bool as boolean
        FormatPageCalc
        Kontext
        active.setpage TabTabelleCalc
        Kontext "TabTabelleCalc"
        Formulas_current = false
        Formulas_current = false
        if Formeln.IsChecked then
                Formeln.UnCheck
                Formulas_bool = false
        else
                Formeln.Check
                Formulas_bool = true
        end if
   Formulas_current = Formulas_bool
   TabTabelleCalc.OK

'/// check if the modify has been taken over
   FormatPageCalc
   Kontext
        active.setpage TabTabelleCalc
        Kontext "TabTabelleCalc"
        if Formeln.IsChecked then
                Formulas_bool = true
        else
                Formulas_bool = false
        end if
        if Formulas_current = Formulas_bool then
                printlog "OK, the Formulas state has been modified"
        else
                warnlog "The Formulas state hasn't been modified"
        end if
        Kontext
        TabTabelleCalc.Cancel

'/// check if the undo-function works
        EditUndo
        if Formulas_current = true then
                Formulas_current = false
        else
                Formulas_current = true
        end if
        FormatPageCalc
        Kontext
        active.setpage TabTabelleCalc
        Kontext "TabTabelleCalc"
        if Formeln.IsChecked then
                Formulas_bool = true
        else
                Formulas_bool = false
        end if
        if Formulas_current = Formulas_bool then
                printlog "OK, the Formulas state has been reset to current"
        else
                warnlog "The Formulas state hasn't been reset to current"
        end if
        Kontext
        TabTabelleCalc.Cancel

'/// check if the redo-function works
        EditRedo
        if Formulas_current = true then
                Formulas_current = false
        else
                Formulas_current = true
        end if
        FormatPageCalc
   Kontext
        active.setpage TabTabelleCalc
        Kontext "TabTabelleCalc"
        if Formeln.IsChecked then
                Formulas_bool = true
        else
                Formulas_bool = false
        end if
        if Formulas_current = Formulas_bool then
                printlog "OK, redo works"
        else
                warnlog "The redo-function doesn't work"
        end if
        Kontext
        TabTabelleCalc.Cancel
        EditUndo
        '_________________________________________________________________________________________________

'/// Call menuitem 'FormatPage', goto tabpage 'Sheet' and toggle zerovalues
        dim ZeroValues_current, ZeroValues_bool as boolean
        FormatPageCalc
        Kontext
        active.setpage TabTabelleCalc
        Kontext "TabTabelleCalc"
        ZeroValues_current = false
        ZeroValues_current = false
        if Nullwerte.IsChecked then
                Nullwerte.UnCheck
                ZeroValues_bool = false
        else
                Nullwerte.Check
                ZeroValues_bool = true
        end if
   ZeroValues_current = ZeroValues_bool
   TabTabelleCalc.OK

'/// check if the modify has been taken over
   FormatPageCalc
   Kontext
        active.setpage TabTabelleCalc
        Kontext "TabTabelleCalc"
        if Nullwerte.IsChecked then
                ZeroValues_bool = true
        else
                ZeroValues_bool = false
        end if
        if ZeroValues_current = ZeroValues_bool then
                printlog "OK, the ZeroValues state has been modified"
        else
                warnlog "The ZeroValues state hasn't been modified"
        end if
        Kontext
        TabTabelleCalc.Cancel

'/// check if the undo-function works
        EditUndo
        if ZeroValues_current = true then
                ZeroValues_current = false
        else
                ZeroValues_current = true
        end if
        FormatPageCalc
   Kontext
        active.setpage TabTabelleCalc
        Kontext "TabTabelleCalc"
        if Nullwerte.IsChecked then
                ZeroValues_bool = true
        else
                ZeroValues_bool = false
        end if
        if ZeroValues_current = ZeroValues_bool then
                printlog "OK, the ZeroValues state has been reset to current"
        else
                warnlog "The ZeroValues state hasn't been reset to current"
        end if
        Kontext
        TabTabelleCalc.Cancel

'/// check if the redo-function works
        EditRedo
        if ZeroValues_current = true then
                ZeroValues_current = false
        else
                ZeroValues_current = true
        end if
        FormatPageCalc
        Kontext
        active.setpage TabTabelleCalc
        Kontext "TabTabelleCalc"
        if Nullwerte.IsChecked then
                ZeroValues_bool = true
        else
                ZeroValues_bool = false
        end if
        if ZeroValues_current = ZeroValues_bool then
                printlog "OK, redo works"
        else
                warnlog "The redo-function doesn't work"
        end if
        Kontext
        TabTabelleCalc.Cancel
        EditUndo
        '_________________________________________________________________________________________________

'/// Call menuitem 'FormatPage', goto tabpage 'Sheet' and toggle toptobottom
        dim PageOrderVertical_current, PageOrderVertical_bool as boolean
        FormatPageCalc
        Kontext
        active.setpage TabTabelleCalc
        Kontext "TabTabelleCalc"
        PageOrderVertical_current = false
        PageOrderVertical_current = false
        if SeitenreihenfolgeObenUnten.IsChecked then
                SeitenreihenfolgeLinksRechts.Check
                printlog "The PageOrderHoricontal is checked as default"
                PageOrderVertical_bool = false
        else
                SeitenreihenfolgeObenUnten.Check
                printlog "The PageOrderVertical is checked as default"
                PageOrderVertical_bool = true
        end if
   PageOrderVertical_current = PageOrderVertical_bool
   TabTabelleCalc.OK

'/// check if the modify has been taken over
   FormatPageCalc
   Kontext
        active.setpage TabTabelleCalc
        Kontext "TabTabelleCalc"
        if SeitenreihenfolgeObenUnten.IsChecked then
                PageOrderVertical_bool = true
        else
                PageOrderVertical_bool = false
        end if
        if PageOrderVertical_current = PageOrderVertical_bool then
                printlog "OK, the PageOrderVertical state has been modified"
        else
                warnlog "The PageOrderVertical state hasn't been modified"
        end if
        Kontext
        TabTabelleCalc.Cancel

'/// check if the undo-function works
        EditUndo
        if PageOrderVertical_current = true then
                PageOrderVertical_current = false
        else
                PageOrderVertical_current = true
        end if
        FormatPageCalc
        Kontext
        active.setpage TabTabelleCalc
        Kontext "TabTabelleCalc"
        if SeitenreihenfolgeObenUnten.IsChecked then
                PageOrderVertical_bool = true
        else
                PageOrderVertical_bool = false
        end if
        if PageOrderVertical_current = PageOrderVertical_bool then
                printlog "OK, the PageOrderVertical state has been reset to current"
        else
                warnlog "The PageOrderVertical state hasn't been reset to current"
        end if
        Kontext
        TabTabelleCalc.Cancel

'/// check if the redo-function works
        EditRedo
        if PageOrderVertical_current = true then
                PageOrderVertical_current = false
        else
                PageOrderVertical_current = true
        end if
        FormatPageCalc
        Kontext
        active.setpage TabTabelleCalc
        Kontext "TabTabelleCalc"
        if SeitenreihenfolgeObenUnten.IsChecked then
                PageOrderVertical_bool = true
        else
                PageOrderVertical_bool = false
        end if
        if PageOrderVertical_current = PageOrderVertical_bool then
                printlog "OK, redo works"
        else
                warnlog "The redo-function doesn't work"
        end if
        Kontext
        TabTabelleCalc.Cancel
        EditUndo
        '_________________________________________________________________________________________________

'/// Call menuitem 'FormatPage', goto tabpage 'Sheet' and toggle first page number
        dim FirstPageNumbers_current, FirstPageNumbers_bool as boolean
        FormatPageCalc
        Kontext
        active.setpage TabTabelleCalc
        Kontext "TabTabelleCalc"
        FirstPageNumbers_current = false
        FirstPageNumbers_current = false
        if ErsteSeitenzahl.IsChecked then
                ErsteSeitenzahl.UnCheck
                FirstPageNumbers_bool = false
        else
                ErsteSeitenzahl.Check
                FirstPageNumbers_bool = true
        end if
   FirstPageNumbers_current = FirstPageNumbers_bool
   TabTabelleCalc.OK

'/// check if the modify has been taken over
   FormatPageCalc
   Kontext
        active.setpage TabTabelleCalc
        Kontext "TabTabelleCalc"
        if ErsteSeitenzahl.IsChecked then
                FirstPageNumbers_bool = true
        else
                FirstPageNumbers_bool = false
        end if
        if FirstPageNumbers_current = FirstPageNumbers_bool then
                printlog "OK, the FirstPageNumbers state has been modified"
        else
                warnlog "The FirstPageNumbers state hasn't been modified"
        end if
        Kontext
        TabTabelleCalc.Cancel

'/// check if the undo-function works
        EditUndo
        if FirstPageNumbers_current = true then
                FirstPageNumbers_current = false
        else
                FirstPageNumbers_current = true
        end if
        FormatPageCalc
   Kontext
        active.setpage TabTabelleCalc
        Kontext "TabTabelleCalc"
        if ErsteSeitenzahl.IsChecked then
                FirstPageNumbers_bool = true
        else
                FirstPageNumbers_bool = false
        end if
        if FirstPageNumbers_current = FirstPageNumbers_bool then
                printlog "OK, the FirstPageNumbers state has been reset to current"
        else
                warnlog "The FirstPageNumbers state hasn't been reset to current"
        end if
        Kontext
        TabTabelleCalc.Cancel

'/// check if the redo-function works
        EditRedo
        if FirstPageNumbers_current = true then
                FirstPageNumbers_current = false
        else
                FirstPageNumbers_current = true
        end if
        FormatPageCalc
   Kontext
        active.setpage TabTabelleCalc
        Kontext "TabTabelleCalc"
        if ErsteSeitenzahl.IsChecked then
                FirstPageNumbers_bool = true
        else
                FirstPageNumbers_bool = false
        end if
        if FirstPageNumbers_current = FirstPageNumbers_bool then
                printlog "OK, redo works"
        else
                warnlog "The redo-function doesn't work"
        end if
        Kontext
        TabTabelleCalc.Cancel
        EditUndo
        '_________________________________________________________________________________________________

'/// Call menuitem 'FormatPage', goto tabpage 'Sheet' and check fit printout on number
        dim PageNumbers_current, PageNumbers_str as string
        FormatPageCalc
        Kontext
        active.setpage TabTabelleCalc
        Kontext "TabTabelleCalc"
        if NOT ErsteSeitenzahl.IsChecked then
                ErsteSeitenzahl.Check
        end if
   PageNumbers_current = NummerErsteSeite.GetText
   NummerErsteSeite.More 3
   PageNumbers_str = NummerErsteSeite.GetText
   TabTabelleCalc.OK

'/// check if the modify has been taken over
   FormatPageCalc
   Kontext
        active.setpage TabTabelleCalc
        Kontext "TabTabelleCalc"
        if NOT ErsteSeitenzahl.IsChecked then
                warnlog "The Checkbox FirstPageNumber isn't checked, it could be a bug!"
                goto finish
        else
                if NummerErsteSeite.GetText = PageNumbers_str then
                        printlog "Ok, the PageNumber modify has been taken over"
                else
                        warnlog "The PageNumber modify hasn't been taken over"
                end if
        end if
        Kontext
        TabTabelleCalc.Cancel

'/// check if the undo-function works
        EditUndo
        FormatPageCalc
   Kontext
        active.setpage TabTabelleCalc
        Kontext "TabTabelleCalc"
        if NOT ErsteSeitenzahl.IsChecked then
                warnlog "The Checkbox FirstPageNumber isn't checked, it could be a bug!"
                goto finish
        else
                if NummerErsteSeite.GetText = PageNumbers_current then
                        printlog "Ok, the PageNumber modify has been reset to current"
                else
                        warnlog "The PageNumber modify hasn't been reset to current"
                end if
        end if
        Kontext
        TabTabelleCalc.Cancel

'/// check if the redo-function works
        EditRedo
        FormatPageCalc
        Kontext
        active.setpage TabTabelleCalc
        Kontext "TabTabelleCalc"
        if NOT ErsteSeitenzahl.IsChecked then
                warnlog "The Checkbox FirstPageNumber isn't checked, it could be a bug!"
                goto finish
        else
                if NummerErsteSeite.GetText = PageNumbers_str then
                        printlog "Ok, redo works"
                else
                        warnlog "The redo-function doesn't work"
                end if
        end if
        Kontext
finish:
        TabTabelleCalc.Cancel
        EditUndo

        '_________________________________________________________________________________________________

'/// Call menuitem 'FormatPage', goto tabpage 'Sheet' and check fit printout on number
        dim Allto_current, Allto_bool as boolean
        FormatPageCalc
        Kontext
        active.setpage TabTabelleCalc
        Kontext "TabTabelleCalc"
        Allto_current = false
'       Allto_current = false
        if ScalingMode.GetSelIndex = 1 then
                ScalingMode.Select (3)
                Allto_bool = false
        else
                QAErrorLog "Unexpected entry is selected in control <scaling mode>"
                goto jumpOut
        end if
   Allto_current = Allto_bool
   TabTabelleCalc.OK

'/// check if the modify has been taken over
   FormatPageCalc
   Kontext
        active.setpage TabTabelleCalc
        Kontext "TabTabelleCalc"
        if ScalingMode.GetSelIndex = 1 then
                Allto_bool = true
        else
                Allto_bool = false
        end if
        if Allto_current = Allto_bool then
                printlog "OK, the Allto state has been modified"
        else
                warnlog "The Allto state hasn't been modified"
        end if
        Kontext
        TabTabelleCalc.Cancel

        ' check if the undo-function works
        EditUndo
        if Allto_current = true then
                Allto_current = false
        else
                Allto_current = true
        end if
        FormatPageCalc
        Kontext
        active.setpage TabTabelleCalc
        Kontext "TabTabelleCalc"
        if ScalingMode.GetSelIndex = 1 then
                Allto_bool = true
        else
                Allto_bool = false
        end if
        if Allto_current = Allto_bool then
                printlog "OK, the Allto state has been reset to current"
        else
                warnlog "The Allto state hasn't been reset to current"
        end if
        Kontext
        TabTabelleCalc.Cancel

'/// check if the redo-function works
        EditRedo
        if Allto_current = true then
                Allto_current = false
        else
                Allto_current = true
        end if
        FormatPageCalc
   Kontext
        active.setpage TabTabelleCalc
        Kontext "TabTabelleCalc"
        if ScalingMode.GetSelIndex = 1 then
                Allto_bool = true
        else
                Allto_bool = false
        end if
        if Allto_current = Allto_bool then
                printlog "OK, redo works"
        else
                warnlog "The redo-function doesn't work"
        end if
        Kontext
        TabTabelleCalc.Cancel
        EditUndo
        '_________________________________________________________________________________________________

'/// Call menuitem 'FormatPage', goto tabpage 'Sheet' and toggle reduce/enlarge printout
        dim AlltoPercent_current, AlltoPercent_str as string
        FormatPageCalc
        Kontext
        active.setpage TabTabelleCalc
        Kontext "TabTabelleCalc"
        ScalingMode.Select (1)
        TabTabelleCalc.OK

        FormatPageCalc
        Kontext
        active.setpage TabTabelleCalc
        Kontext "TabTabelleCalc"
        AlltoPercent_current = SkalierungProzent.GetText
        SkalierungProzent.More 3
        AlltoPercent_str = SkalierungProzent.GetText
        TabTabelleCalc.OK

'/// check if the modify has been taken over
        FormatPageCalc
        Kontext
        active.setpage TabTabelleCalc
        Kontext "TabTabelleCalc"
        if SkalierungProzent.GetText = AlltoPercent_str then
           printlog "Ok, the AlltoPercent modify has been taken over"
        else
           warnlog "The AlltoPercent modify hasn't been taken over"
        end if
        Kontext
        TabTabelleCalc.Cancel

'/// check if the undo-function works
        EditUndo
        FormatPageCalc
        Kontext
        active.setpage TabTabelleCalc
        Kontext "TabTabelleCalc"
        if SkalierungProzent.GetText = AlltoPercent_current then
           printlog "Ok, the AlltoPercent modify has been reset to current"
        else
           warnlog "The AlltoPercent modify hasn't been reset to current"
        end if
        Kontext
        TabTabelleCalc.Cancel

'/// check if the redo-function works
        EditRedo
        FormatPageCalc
        Kontext
        active.setpage TabTabelleCalc
        Kontext "TabTabelleCalc"
        if SkalierungProzent.GetText = AlltoPercent_str then
           printlog "Ok, redo works"
        else
           warnlog "The redo-function doesn't work"
        end if
        Kontext
fin:
        TabTabelleCalc.Cancel
        EditUndo

        '_________________________________________________________________________________________________

'/// Call menuitem 'FormatPage', goto tabpage 'Sheet' and define width/height of a printrange
        FormatPageCalc
        Kontext
        active.setpage TabTabelleCalc
        Kontext "TabTabelleCalc"
        ScalingMode.Select(2)
	ScalePageWidth.SetText "1"
        ScalePageHeight.SetText "1"
	TabTabelleCalc.OK

'/// Set new values for width/height scaling	
        FormatPageCalc
        Kontext
        active.setpage TabTabelleCalc
        Kontext "TabTabelleCalc"
	ScalePageWidth.More(2)
        ScalePageHeight.More(3)
        TabTabelleCalc.OK
	
'/// Check if new values where stored properly	
        FormatPageCalc
        Kontext
        active.setpage TabTabelleCalc
        Kontext "TabTabelleCalc"
	if ScalePageWidth.GetText = "3" then
	   printlog "Control <Width in pages> has the right value"
	else
	   warnlog "Control <Width in pages> has an unexpeted value -> CHECK!"
	endif
	
	if ScalePageHeight.GetText = "4" then
	   printlog "Control <Height in pages> has the right value"
	else
	   warnlog "Control <Height in pages> has an unexpeted value -> CHECK!"
	endif
	TabTabelleCalc.Cancel
	
'/// Undo new values and check for proper old values
        EditUndo
        FormatPageCalc
        Kontext
        active.setpage TabTabelleCalc
        Kontext "TabTabelleCalc"
	if ScalePageWidth.GetText = "1" then
	   printlog "Control <Width in pages> has the right value"
	else
	   warnlog "Control <Width in pages> has an unexpeted value -> CHECK!"
	endif
	
	if ScalePageHeight.GetText = "1" then
	   printlog "Control <Height in pages> has the right value"
	else
	   warnlog "Control <Height in pages> has an unexpeted value -> CHECK!"
	endif
	TabTabelleCalc.Cancel
	
'/// Apply redo and check new values again
	EditRedo
	FormatPageCalc
        Kontext
        active.setpage TabTabelleCalc
        Kontext "TabTabelleCalc"
	if ScalePageWidth.GetText = "3" then
	   printlog "Control <Width in pages> has the right value"
	else
	   warnlog "Control <Width in pages> has an unexpeted value -> CHECK!"
	endif
	
	if ScalePageHeight.GetText = "4" then
	   printlog "Control <Height in pages> has the right value"
	else
	   warnlog "Control <Height in pages> has an unexpeted value -> CHECK!"
	endif
	TabTabelleCalc.Cancel
	EditUndo

'/// Call menuitem 'FormatPage', goto tabpage 'Sheet' and toggle fit printout on
        dim MaxNoPages_current, MaxNoPages_str as string

        FormatPageCalc
        Kontext
        active.setpage TabTabelleCalc
        Kontext "TabTabelleCalc"
        ScalingMode.Select (3)
        AnzahlMaxSeiten.More 1
        MaxNoPages_current =AnzahlMaxSeiten.GetText
        TabTabelleCalc.OK

'/// in order to check the option "MaxNoNumbers" there must be set a second modify for this

        FormatPageCalc
        Kontext
        active.setpage TabTabelleCalc
        Kontext "TabTabelleCalc"
        if NOT ScalingMode.GetselIndex = 3 then
           warnlog "Wrong entry in listbox 'scaling mode' selected, it could be a bug!"
           goto jumpOut
        else
'        MaxNoPages_current = AnzahlMaxSeiten.GetText
        AnzahlMaxSeiten.More 2
        MaxNoPages_str =AnzahlMaxSeiten.GetText
        end if
        TabTabelleCalc.OK

'/// check if the modify has been taken over
        FormatPageCalc
        Kontext
        active.setpage TabTabelleCalc
        Kontext "TabTabelleCalc"
        if AnzahlMaxSeiten.GetText = MaxNoPages_str then
           printlog "Ok, the MaxNoPages modify has been taken over"
        else
           warnlog "The MaxNoPages modify hasn't been taken over"
        end if
        Kontext
        TabTabelleCalc.Cancel

'/// check if the undo-function works
        EditUndo
        FormatPageCalc
        Kontext
        active.setpage TabTabelleCalc
        Kontext "TabTabelleCalc"
        if AnzahlMaxSeiten.GetText = MaxNoPages_current then
           printlog "Ok, the MaxNoPages modify has been reset to current"
        else
           warnlog "The MaxNoPages modify hasn't been reset to current"
        end if
        Kontext
        TabTabelleCalc.Cancel

'/// check if the redo-function works
        EditRedo
        FormatPageCalc
   Kontext
        active.setpage TabTabelleCalc
        Kontext "TabTabelleCalc"
        if AnzahlMaxSeiten.GetText = MaxNoPages_str then
           printlog "Ok, redo works"
        else
           warnlog "The redo-function doesn't work"
        end if
        Kontext
jumpOut:
        TabTabelleCalc.Cancel
        EditUndo

        call hCloseDocument
endcase
