'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: keyboardaccessibility1.inc,v $
'*
'*  $Revision: 1.10 $
'*
'*  last change: $Author: tbo $ $Date: 2005/09/07 19:07:28 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : hercule.li@sun.com
'*
'* short description : Keyboard Accessibility -- 1
'*
'************************************************************************
'*
' #1 tDataPilot_1
' #1 tDataPilot_2
' #1 tDataPilot_3
' #1 tDataPilot_4
' #1 tDataPilot_5
' #1 tDataPilot_6
' #1 tDataPilot_7
' #1 tDataPilot_8
' #1 tDataPilot_9
' #1 tDataPilot_10
' #1 tDataPilot_11
' #1 tDataPilot_12
' #1 tDataPilot_13
' #1 tDataPilot_14
' #1 tDataPilot_15
' #1 tDataPilot_16
' #1 tDataPilot_17
' #1 tDataPilot_18
' #1 tDataPilot_19
' #1 tDataPilot_20
' #1 tDataPilot_21
' #1 tDataPilot_22
' #1 tDataPilot_23
' #1 tDataPilot_24
' #1 tDataPilot_25
' #1 tDataPilot_26
' #1 tDataPilot_27
' #1 tDataPilot_28
' #1 tDataPilot_29
' #1 tDataPilot_30
' #1 tDataPilot_31
' #1 tDataPilot_32
' #1 tDataPilot_33
'*
'\***********************************************************************

sub C_Keyboard_Accessibility_1

   printLog Chr(13) + "=== Keyboard_Accessibility 1 ==="

   printLog Chr(13) + "-- test DatePilot  -- Date/DatePilot"
      Call tDataPilot_1    'Check ALT+[Hotkey of Row/Column/Data area]
      Call tDataPilot_2    'Check Remove button
      Call tDataPilot_3    'Check Delete button
      Call tDataPilot_4    'Check Options button
      Call tDataPilot_5    'Check Tab
      Call tDataPilot_6    'Check Shift+Tab
      Call tDataPilot_7    'Check UP/DOWN/LEFT/RIGHT in the selection area
      Call tDataPilot_8    'Check UP/DOWN in the Page/Row/Column/Data area
      Call tDataPilot_9    'Check LEFT/RIGHT in the Page/Row/Column/Data area
      Call tDataPilot_10   'Check Home/End in the selected area
      Call tDataPilot_11   'Check CTRL+UP/DOWN/LEFT/RIGHT - Move field inside of the area (Modify field order)
      Call tDataPilot_12   'Check CTRL+HOME/END - Move field to top/bottom of the area
      Call tDataPilot_13   'Change position in Row and Column
      Call tDataPilot_14   'Contextmenu - Start
      Call tDataPilot_15   'Contextmenu - Refresh
      Call tDataPilot_16   'Contextmenu - Filter
      Call tDataPilot_17   'Contextmenu - Delete
      Call tDataPilot_18   'Change function in data field dialog
      Call tDataPilot_19   'More - Set result to new sheet
      Call tDataPilot_20   'More - Set result to new cell
      Call tDataPilot_21   'More - Ignore empty rows (uncheck) - Default
      Call tDataPilot_22   'More - Ignore empty rows (check)
      Call tDataPilot_23   'More - Identify categories(uncheck) - Default
      Call tDataPilot_24   'More - Identify categories(check)
      Call tDataPilot_25   'More - Total columns(Check) - default
      Call tDataPilot_26   'More - Total columns(UnCheck)
      Call tDataPilot_27   'More - Total rows(Check) - default
      Call tDataPilot_28   'More - Total rows(UnCheck)
      Call tDataPilot_29   'Current selection
      Call tDataPilot_30   'Show items without data (uncheck) - Default
      Call tDataPilot_31   'Show items without data (check)
      Call tDataPilot_32   'Hide/Show details
      Call tDataPilot_33   'Subtotals

end sub

'-------------------------------------------------------------------------

testcase tDataPilot_1

  printLog "Check ALT+[Hotkey of Row/Column/Data area] "
  '/// Check ALT+[Hotkey of Row/Column/Data area] , Move current field to the Row/Column/Data area

   call hNewDocument
     Kontext "DocumentCalc"
     '/// Input some test text in Calc document
     DocumentCalc.typeKeys "A<TAB>B<TAB>C<TAB>D"
     DocumentCalc.typeKeys "<Down><LEFT><LEFT><LEFT>"
     DocumentCalc.typeKeys "1<TAB>2<TAB>3<TAB>4"

     '/// DataPilot/Start , check current selection
     DataDataPilotStart
     Kontext "QuelleAuswaehlen"
       AktuelleSelektion.Check
     QuelleAuswaehlen.OK
     Sleep 1

     '/// Press Alt + Hotkey of Page & Row & Column & Data field
       Kontext "Datenpilot"
       Sleep 1

       Call  fDataPilotPageSelection()
       sleep 1
       Call  fDataPilotColumnSelection()
       sleep 1
       Call  fDataPilotRowSelection()
       Sleep 1
       Call  fDataPilotDataSelection()
       Sleep 1

       Datenpilot.OK
       Sleep 1

      Kontext "DocumentCalc"

      if cZellwert("A5")  <> "A" then  Warnlog "A5 should be A, but get" +cZellwert("A5")
      if cZellwert("B7")  <> "B" then  Warnlog "B7 should be B, but get" +cZellwert("B7")
      if cZellwert("A8")  <> "C" then  Warnlog "A8 should be C, but get" +cZellwert("A8")
      if cZellwert("C10") <> "4" then  Warnlog "C10 should be 4, but get" +cZellwert("C10")

   Call hCloseDocument

endcase

'-------------------------------------------------------------------------

testcase tDataPilot_2

  printLog "Check Remove button"
  '/// Check Remove button

   call hNewDocument

   '/// input some test text in a calc document
     Kontext "DocumentCalc"
     DocumentCalc.typeKeys "A<Down>1"

    '/// DataPilot/Start , check current selection
     DataDataPilotStart
     Kontext "QuelleAuswaehlen"
       AktuelleSelektion.Check
     QuelleAuswaehlen.OK

       Kontext "Datenpilot"
       Sleep 1
     '/// 1) Check Remove button should NOT be enabled when there is no any entry
       try
        Entfernen.Click
        Warnlog "Remove button should NOT be enabled when there is no any entry!"
       catch
       endcatch

     '/// 2) Check Remove button should NOT be enabled when the entry exists but the focus isn't on it
       Call  fDataPilotColumnSelection()
       sleep 1

       try
        Entfernen.Click
        Warnlog "Remove button should NOT be enabled when the entry exists but the focus isn't on it !"
       catch
       endcatch

     '/// 3) Remove button should be enabled when the entry exists and the focus is on it
       Datenpilot.typekeys "<Tab>" , 5 , TRUE
       sleep 2
       try
        Entfernen.Click
       catch
        Warnlog "Remove button should be enabled when the entry exists and the focus is on it !"
       endcatch

       Sleep 2

       Datenpilot.OK
       Sleep 1

       Kontext "Active"
       if Active.Exists then
        Active.Ok
       else
        Warnlog "The dialogue isn't opened when click OK"
       endif

     '/// 4) Check if the entry is really removed
      Kontext "DocumentCalc"
      if cZellwert("A6") = "A" then Warnlog "The entry is NOT really removed !"

   Call hCloseDocument

endcase

'-------------------------------------------------------------------------

testcase tDataPilot_3

  printLog "Check Delete button"
  '/// Check Delete button

   call hNewDocument

   '/// input some test text in a calc document
     Kontext "DocumentCalc"
     DocumentCalc.typeKeys "A<Down>1"

    '/// DataPilot/Start , check current selection
     DataDataPilotStart
     Kontext "QuelleAuswaehlen"
       AktuelleSelektion.Check
     QuelleAuswaehlen.OK

       Kontext "Datenpilot"
       Sleep 1

     '/// Press Ctrl+C to insert A into column area
       Call  fDataPilotColumnSelection()
       sleep 1

     '/// Press Delete in A in the column area
       DataPilotColumn.typekeys "<DELETE>"
       Sleep 1

       Datenpilot.OK
       Sleep 1

       Kontext "Active"
       if Active.Exists then
        Active.Ok
       else
        Warnlog "The dialogue isn't opened when click OK"
       endif

     '/// Check if the entry is really removed
      Kontext "DocumentCalc"
      if cZellwert("A6") = "A" then Warnlog "The entry is NOT really removed !"

   Call hCloseDocument

endcase

'-------------------------------------------------------------------------

testcase tDataPilot_4

  printLog "Check Options button"
  '/// Check Options button

   call hNewDocument

   '/// input some test text in a calc document
     Kontext "DocumentCalc"
     DocumentCalc.typeKeys "A<Down>1"

    '/// DataPilot/Start , check current selection
     DataDataPilotStart
     Kontext "QuelleAuswaehlen"
       AktuelleSelektion.Check
       QuelleAuswaehlen.OK

       Kontext "Datenpilot"
       Sleep 1
     '/// 1) Check Options button should NOT be enabled when there is no any entry
       try
        Optionen.Click
        Kontext "Datenfeld"
        Datenfeld.Cancel
        Warnlog "Options button should NOT be enabled when there is no any entry!"
       catch
       endcatch

     '/// 2) Check Options button should NOT be enabled when the entry exists but the focus isn't on it
       Call  fDataPilotColumnSelection()
       sleep 1

       try
        Optionen.Click
        Kontext "Datenfeld"
        Datenfeld.Cancel
        Warnlog "Options button should NOT be enabled when the entry exists but the focus isn't on it !"
       catch
       endcatch

     '/// 3) Options button should be enabled when the entry exists and the focus is on it
       Datenpilot.typekeys "<Tab>" , 5 , TRUE
       sleep 1
       try
        Optionen.Click
        Kontext "Datenfeld"
        Datenfeld.Cancel
       catch
        Warnlog "Options button should be enabled when the entry exists and the focus is on it !"
       endcatch

       Sleep 2

       Kontext "Datenpilot"
       Datenpilot.Cancel
       Sleep 1

   Call hCloseDocument

endcase

'-------------------------------------------------------------------------

testcase tDataPilot_5

  printLog "Check <Tab>"
  '/// Check <Tab>
  '/// => TAB - Next control or area (Page/Row/Column/Data/Select)

   call hNewDocument

   '/// input some test text in a calc document
     DocumentCalc.typeKeys "A<TAB>B<TAB>C<TAB>D"
     DocumentCalc.typeKeys "<Down><LEFT><LEFT><LEFT>"
     DocumentCalc.typeKeys "1<TAB>2<TAB>3<TAB>4"

    '/// DataPilot/Start , check current selection
     DataDataPilotStart
     Kontext "QuelleAuswaehlen"
       AktuelleSelektion.Check
       QuelleAuswaehlen.OK

       Kontext "Datenpilot"
       Sleep 1

     '/// Press Alt + Hotkey of Page & Row & Column & Data field
       Call  fDataPilotPageSelection()
       sleep 1
       Call  fDataPilotColumnSelection()
       sleep 1
       Call  fDataPilotRowSelection()
       Sleep 1
       Call  fDataPilotDataSelection()
       Sleep 1

     '/// Press TAB 8 times, should let the focus on D in the column area
       Datenpilot.typekeys "<Tab>" , 8 , TRUE
       sleep 1
       try
        Entfernen.Click
       catch
        Warnlog "<TAB> doesn't work fine ~~Remove button should be enabled when the entry exists and the focus is on it !"
       endcatch

       Datenpilot.OK
       Sleep 1

      Kontext "DocumentCalc"

      if cZellwert("A5")  <> "A" then  Warnlog "A5 should be A, but get" +cZellwert("A5")
      if cZellwert("B7")  <> "B" then  Warnlog "B7 should be B, but get" +cZellwert("B7")
      if cZellwert("A8")  <> "C" then  Warnlog "A8 should be C, but get" +cZellwert("A8")
      if Len(cZellwert("C10")) <> 0 then  Warnlog "C10 should be Null, but get" +cZellwert("C10")

   Call hCloseDocument

endcase

'-------------------------------------------------------------------------

testcase tDataPilot_6

  printLog "Check <Shift Tab>"
  '/// Check <Shift Tab>
  '/// => SHIFT+TAB - Previous control/area

   call hNewDocument

   '/// input some test text in a calc document
     DocumentCalc.typeKeys "A<TAB>B<TAB>C<TAB>D"
     DocumentCalc.typeKeys "<Down><LEFT><LEFT><LEFT>"
     DocumentCalc.typeKeys "1<TAB>2<TAB>3<TAB>4"

    '/// DataPilot/Start , check current selection
     DataDataPilotStart
     Kontext "QuelleAuswaehlen"
       AktuelleSelektion.Check
       QuelleAuswaehlen.OK

       Kontext "Datenpilot"
       Sleep 1

     '/// Press Alt + Hotkey of Page & Row & Column & Data field
       Call  fDataPilotPageSelection()
       sleep 1
       Call  fDataPilotColumnSelection()
       sleep 1
       Call  fDataPilotRowSelection()
       Sleep 1
       Call  fDataPilotDataSelection()
       Sleep 1

     '/// Press Shift+TAB 10 times, should let the focus on D in the column area
       Datenpilot.typekeys "<Shift Tab>" , 10 , TRUE
       sleep 1
       try
        Entfernen.Click
       catch
        Warnlog "<Shift + TAB> doesn't work fine ~~Remove button should be enabled when the entry exists and the focus is on it !"
       endcatch

       Datenpilot.OK
       Sleep 1

      Kontext "DocumentCalc"

      if cZellwert("A5")  <> "A" then  Warnlog "A5 should be A, but get" +cZellwert("A5")
      if cZellwert("B7")  <> "B" then  Warnlog "B7 should be B, but get" +cZellwert("B7")
      if cZellwert("A8")  <> "C" then  Warnlog "A8 should be C, but get" +cZellwert("A8")
      if Len(cZellwert("C10")) <> 0 then  Warnlog "C10 should be Null, but get " +cZellwert("C10")

   Call hCloseDocument

endcase

'-------------------------------------------------------------------------

testcase tDataPilot_7

  printLog "Check UP/DOWN/LEFT/RIGHT in the selection area"
  '/// Check UP/DOWN in the selection area

   call hNewDocument

   '/// input some test text in a calc document
     Kontext "DocumentCalc"
     DocumentCalc.typeKeys "A<TAB>B<TAB><Down><LEFT><LEFT><LEFT>1<TAB>2<TAB>"

    '/// DataPilot/Start , check current selection
     DataDataPilotStart
     Kontext "QuelleAuswaehlen"
       AktuelleSelektion.Check
       QuelleAuswaehlen.OK

       Kontext "Datenpilot"
       Sleep 1

      '/// Press Down in selection area , we hope the fouce is on B
       DataPilotSelection.typekeys "<Down>"
       Sleep 1
      '/// Press Ctrl+C to insert B into column area
       Call  fDataPilotColumnSelection()
       sleep 1
      '/// Press Shift+TAB once, should let the focus on the column area
       Datenpilot.typekeys "<Shift Tab>" , TRUE

      '/// click OK
       Datenpilot.OK
       Sleep 1

     '/// Check if DOWN works well
      Kontext "DocumentCalc"
      if cZellwert("A6") <> "B" then Warnlog "Down key doesn't works fine!"

   Call hCloseDocument

endcase

'-------------------------------------------------------------------------

testcase tDataPilot_8

  printLog "Check UP/DOWN in Page/Row/Column/Data area"
  '/// Check UP/DOWN in Page/Row/Column/Data area
   call hNewDocument

   '/// input some test text in a calc document
     Kontext "DocumentCalc"
     DocumentCalc.typeKeys "A<TAB>B<TAB><Down><LEFT><LEFT><LEFT>1<TAB>2<TAB>"

    '/// DataPilot/Start , check current selection
     DataDataPilotStart
     Kontext "QuelleAuswaehlen"
       AktuelleSelektion.Check
       QuelleAuswaehlen.OK

       Kontext "Datenpilot"
       Sleep 1

      '/// Press Ctrl+R to insert A into Row area
       Call  fDataPilotRowSelection()
       sleep 1
      '/// Press Ctrl+R to insert B into Row area
       Call  fDataPilotRowSelection()
       sleep 1

      '/// Press Shift+TAB once, should let the focus on the Row area
       Datenpilot.typekeys "<Shift Tab>" , TRUE

      '/// Press Up to set focus to A
       Datenpilot.typekeys "<Up>" , TRUE
       Sleep 1
       Entfernen.Click
       Sleep 1

      '/// click OK
       Datenpilot.OK
       Sleep 1

     '/// Check if DOWN works well
      Kontext "DocumentCalc"
      if cZellwert("A6") <> "B" then Warnlog "A6 should be B, but get " + cZellwert("A6")

   Call hCloseDocument

endcase

'-------------------------------------------------------------------------

testcase tDataPilot_9

  printLog "Check LEFT/RIGHT in Page/Row/Column/Data area"
  '/// Check LEFT/RIGHT in Page/Row/Column/Data area
   call hNewDocument

   '/// input some test text in a calc document
     Kontext "DocumentCalc"
     DocumentCalc.typeKeys "A<TAB>B<TAB><Down><LEFT><LEFT><LEFT>1<TAB>2<TAB>"

    '/// DataPilot/Start , check current selection
     DataDataPilotStart
     Kontext "QuelleAuswaehlen"
       AktuelleSelektion.Check
       QuelleAuswaehlen.OK

       Kontext "Datenpilot"
       Sleep 1

      '/// Press Ctrl+C to insert A into column area
       Call  fDataPilotColumnSelection()
       sleep 1
      '/// Press Ctrl+C to insert B into column area
       Call  fDataPilotColumnSelection()
       sleep 1

      '/// Press Shift+TAB once, should let the focus on the column area
       Datenpilot.typekeys "<Shift Tab>" , TRUE

      '/// Press Left , should let the focus on A
       Datenpilot.typekeys "<Left>" , TRUE

       Entfernen.Click
       Sleep 1

      '/// click OK
       Datenpilot.OK
       Sleep 1

     '/// Check if DOWN works well
      Kontext "DocumentCalc"
      if cZellwert("A6") <> "B" then Warnlog "A6 should be B, but get " + cZellwert("A6")

   Call hCloseDocument

endcase

'-------------------------------------------------------------------------

testcase tDataPilot_10

  printLog "Check Home/End in the selected area"
  '/// Check Home/End in the selected area
  '/// [Note] Test End in this case
   call hNewDocument

   '/// input some test text in a calc document
     Kontext "DocumentCalc"
     DocumentCalc.typeKeys "A<TAB>B<TAB>C<TAB><Down><LEFT><LEFT><LEFT><LEFT>1<TAB>2<TAB>3<TAB><LEFT>"

    '/// DataPilot/Start , check current selection
     DataDataPilotStart
     Kontext "QuelleAuswaehlen"
       AktuelleSelektion.Check
       QuelleAuswaehlen.OK

       Kontext "Datenpilot"
       Sleep 1

      '/// Press End to set the focus to C
       DataPilotSelection.typekeys "<End>"
       Sleep 1

      '/// Press Alt+C to insert C into column area
       Call  fDataPilotColumnSelection()
       Sleep 1

      '/// click OK
       Datenpilot.OK
       Sleep 1

      '/// Check if End works well
      Kontext "DocumentCalc"
      if cZellwert("A6") <> "C" then Warnlog "Down key doesn't works fine!"

   Call hCloseDocument

endcase

'-------------------------------------------------------------------------

testcase tDataPilot_11

  printLog "Check CTRL+UP/DOWN/LEFT/RIGHT - Move field inside of the area (Modify field order)"
  '/// Check CTRL+UP/DOWN/LEFT/RIGHT - Move field inside of the area (Modify field order)
  '/// [Note] Test Ctrl+Left in this case
   call hNewDocument

   '/// input some test text in a calc document
     Kontext "DocumentCalc"
     DocumentCalc.typeKeys "A<TAB>B<TAB>C<TAB><Down><LEFT><LEFT><LEFT><LEFT>1<TAB>2<TAB>3<TAB><LEFT>"

    '/// DataPilot/Start , check current selection
     DataDataPilotStart
     Kontext "QuelleAuswaehlen"
       AktuelleSelektion.Check
       QuelleAuswaehlen.OK

       Kontext "Datenpilot"
       Sleep 1

     '/// Press Alt + Hotkey of Column to insert A , B and C into Column area
       Kontext "Datenpilot"
       Sleep 1

       Call  fDataPilotColumnSelection()
       sleep 1
       Call  fDataPilotColumnSelection()
       Sleep 1
       Call  fDataPilotColumnSelection()
       Sleep 1

      '/// Press Shift+TAB once, should let the focus on the B in the column area
       Datenpilot.typekeys "<Shift Tab>" , TRUE

      '/// Press Ctrl+Left , let the B and C change their location .
       DataPilotColumn.typekeys "<MOD1 Left>"

      '/// click OK
       Datenpilot.OK
       Sleep 1

      '/// Check if  Ctrl+Left works well
      Kontext "DocumentCalc"
      if cZellwert("B6") <> "C" then Warnlog "Ctrl+Left doesn't works fine! B6 is NOT right."
      if cZellwert("C6") <> "B" then Warnlog "Ctrl+Left doesn't works fine! C6 is NOT right."

   Call hCloseDocument

endcase

'-------------------------------------------------------------------------

testcase tDataPilot_12

  printLog "Check CTRL+Home/End - Move field inside of the area (Modify field order)"
  '/// Check CTRL+Home/End - Move field inside of the area (Modify field order)
  '/// [Note] Test Ctrl+Home in this case
   call hNewDocument

   '/// input some test text in a calc document
     Kontext "DocumentCalc"
     DocumentCalc.typeKeys "A<TAB>B<TAB>C<TAB><Down><LEFT><LEFT><LEFT><LEFT>1<TAB>2<TAB>3<TAB><LEFT>"

    '/// DataPilot/Start , check current selection
     DataDataPilotStart
     Kontext "QuelleAuswaehlen"
       AktuelleSelektion.Check
       QuelleAuswaehlen.OK

       Kontext "Datenpilot"
       Sleep 1

     '/// Press Alt + Hotkey of Column to insert A , B and C into Column area
       Kontext "Datenpilot"
       Sleep 1

       Call  fDataPilotColumnSelection()
       sleep 1
       Call  fDataPilotColumnSelection()
       Sleep 1
       Call  fDataPilotColumnSelection()
       Sleep 1

      '/// Press Shift+TAB once, should let the focus on the B in the column area
       Datenpilot.typekeys "<Shift Tab>" , TRUE

      '/// Press Ctrl+Home , let the A and C change their location .
       DataPilotColumn.typekeys "<MOD1 Home>"

      '/// click OK
       Datenpilot.OK
       Sleep 1

     '/// Check if Ctrl+Home works well
      Kontext "DocumentCalc"
      if cZellwert("A6") <> "C" then Warnlog "Ctrl+Home doesn't works fine! A6 is NOT right."
      if cZellwert("B6") <> "A" then Warnlog "Ctrl+Home doesn't works fine! B6 is NOT right."
      if cZellwert("C6") <> "B" then Warnlog "Ctrl+Home doesn't works fine! C6 is NOT right."

   Call hCloseDocument

endcase

'-------------------------------------------------------------------------

testcase tDataPilot_13

  printLog "Change position in Row and Column"
  '/// Change position in Row and Column

   call hNewDocument

   '/// input some test text in a calc document
     Kontext "DocumentCalc"
     DocumentCalc.typeKeys "A<TAB>B<Down><Home>1<TAB>2"

    '/// DataPilot/Start , check current selection
     DataDataPilotStart
     Kontext "QuelleAuswaehlen"
       AktuelleSelektion.Check
       QuelleAuswaehlen.OK

       Kontext "Datenpilot"
       Sleep 1

     '/// Drap A to Row fields , B to Column fields
       Kontext "Datenpilot"
       Sleep 1
       Call  fDataPilotRowSelection()
       sleep 1
       Call  fDataPilotColumnSelection()
       Sleep 1

      '/// click OK
       Datenpilot.OK
       Sleep 1

     '/// Check the result
      Kontext "DocumentCalc"
      printLog "-- Before changing position :"
      if cZellwert("A7") <> "A" then Warnlog "A7 isn't correct !"
      if cZellwert("B6") <> "B" then Warnlog "B6 isn't correct !"
      if cZellwert("A8") <> "1" then Warnlog "A8 isn't correct !"
      if cZellwert("B7") <> "2" then Warnlog "B7 isn't correct !"

    '/// DataPilot/Start
     DataDataPilotStart

       Kontext "Datenpilot"
       Sleep 1

      '/// Set focus to A , and change its position to Column fields
       Call  fDataPilotColumnSelection()
       sleep 1

      '/// Set focus to B , and change its position to Row fields
       Call  fDataPilotRowSelection()
       sleep 1

      '/// click OK
       Datenpilot.OK
       Sleep 1

     '/// Check the result
      Kontext "DocumentCalc"
      printLog "-- After changing position :"
      if cZellwert("A7") <> "B" then Warnlog "A7 isn't correct !"
      if cZellwert("B6") <> "A" then Warnlog "B6 isn't correct !"
      if cZellwert("A8") <> "2" then Warnlog "A8 isn't correct !"
      if cZellwert("B7") <> "1" then Warnlog "B7 isn't correct !"

   Call hCloseDocument

endcase

'-------------------------------------------------------------------------

testcase tDataPilot_14

  printLog "Contextmenu - Start"
  '/// Contextmenu - Start

   call hNewDocument

   '/// input some test text in a calc document
     Kontext "DocumentCalc"
     DocumentCalc.typeKeys "A<Down>1"

    '/// DataPilot/Start , check current selection
     DataDataPilotStart
     Kontext "QuelleAuswaehlen"
       AktuelleSelektion.Check
       QuelleAuswaehlen.OK

     '/// Drap A to Row fields
       Kontext "Datenpilot"
       Sleep 1
       Call  fDataPilotRowSelection()
       sleep 1

      '/// click OK
       Datenpilot.OK
       Sleep 1

     Kontext "DocumentCalc"
     if cZellwert("A7") <> "1" then Warnlog "A7 isn't correct !"

    '/// Context menu - Start
     DocumentCalc.OpenContextMenu
     Call hMenuSelectNr(1)
     Sleep 1

     Kontext "Datenpilot"
     Sleep 1

     if Datenpilot.Exists then
         Datenpilot.Cancel
     else
         Warnlog "Context menu - Start doesn't work well !"
     end if

   Call hCloseDocument

endcase

'-------------------------------------------------------------------------

testcase tDataPilot_15

  printLog "Contextmenu - Refresh"
  '/// Contextmenu - Refresh

   call hNewDocument

   '/// Input some test text in a calc document
     Kontext "DocumentCalc"
     DocumentCalc.typeKeys "A<Down>1"

    '/// DataPilot/Start , check current selection
     DataDataPilotStart
     Kontext "QuelleAuswaehlen"
       AktuelleSelektion.Check
       QuelleAuswaehlen.OK

     '/// Drap A to Row fields
       Kontext "Datenpilot"
       Sleep 1
       Call  fDataPilotRowSelection()
       sleep 1

      '/// click OK
       Datenpilot.OK
       Sleep 1

    '/// Input 2 in A2
     Call cgotocell("A2")
     DocumentCalc.typeKeys "2"

     Call cgotocell("A7")

    '/// Context menu - Refresh
     DocumentCalc.OpenContextMenu
     Call hMenuSelectNr(2)
     Sleep 1

     if cZellwert("A7") <> "2" then Warnlog "A7 isn't correct !"

   Call hCloseDocument

endcase

'-------------------------------------------------------------------------

testcase tDataPilot_16

  printLog "Contextmenu - Filter"
  '/// Contextmenu - Filter

   call hNewDocument

   '/// Input some test text in a calc document
     Kontext "DocumentCalc"
     DocumentCalc.typeKeys "A<Down>1"

    '/// DataPilot/Start , check current selection
     DataDataPilotStart
     Kontext "QuelleAuswaehlen"
       AktuelleSelektion.Check
       QuelleAuswaehlen.OK

     '/// Drap A to Row fields
       Kontext "Datenpilot"
       Sleep 1
       Call  fDataPilotRowSelection()
       sleep 1

      '/// click OK
       Datenpilot.OK
       Sleep 1

     Call cgotocell("A7")

    '/// Context menu - Filter
     DocumentCalc.OpenContextMenu
     Call hMenuSelectNr(3)
     Sleep 1

     Kontext "PivotFilter"
     Sleep 1

     if PivotFilter.Exists then
         PivotFilter.Cancel
     else
         Warnlog "Context menu - Filter doesn't work well !"
     end if

   Call hCloseDocument

endcase

'-------------------------------------------------------------------------

testcase tDataPilot_17

  printLog "Contextmenu - Delete"
  '/// Contextmenu - Delete

   call hNewDocument

   '/// Input some test text in a calc document
     Kontext "DocumentCalc"
     DocumentCalc.typeKeys "A<Down>1"

    '/// DataPilot/Start , check current selection
     DataDataPilotStart
     Kontext "QuelleAuswaehlen"
       AktuelleSelektion.Check
       QuelleAuswaehlen.OK

     '/// Drap A to Row fields
       Kontext "Datenpilot"
       Sleep 1
       Call  fDataPilotRowSelection()
       sleep 1

      '/// click OK
       Datenpilot.OK
       Sleep 1

     Call cgotocell("A7")

    '/// Context menu - Delete
     DocumentCalc.OpenContextMenu
     Call hMenuSelectNr(4)
     Sleep 1

     if Len(cZellwert("A4")) <> 0 then Warnlog "A4 isn't correct !"
     if Len(cZellwert("A6")) <> 0 then Warnlog "A6 isn't correct !"
     if Len(cZellwert("A7")) <> 0 then Warnlog "A7 isn't correct !"
     if Len(cZellwert("A8")) <> 0 then Warnlog "A8 isn't correct !"

   Call hCloseDocument

endcase

'-------------------------------------------------------------------------

testcase tDataPilot_18

  printLog "Change function in data field dialog"
  '/// Change function in data field dialog

   call hNewDocument

   '/// Input some test text in a calc document
     Kontext "DocumentCalc"
     DocumentCalc.typeKeys "A<Down>10<Down>20"

    '/// DataPilot/Start , check current selection
     DataDataPilotStart
     Kontext "QuelleAuswaehlen"
       AktuelleSelektion.Check
       QuelleAuswaehlen.OK

     '/// Drap A to Data fields
       Kontext "Datenpilot"
       Sleep 1
       Call fDataPilotDataSelection()
       sleep 1
       Datenpilot.typekeys "<Tab>" , 5 , TRUE
       Sleep 1

      '/// Press Options button , should pop up Data fields function dialog
      '/// Change function to Average (default is Sum)
       Optionen.Click
       Kontext "DataFieldsFunctionDlg"
         FunctionList.Select 3
         Sleep 1
       DataFieldsFunctionDlg.OK
       Sleep 1

       Kontext "Datenpilot"
     Datenpilot.OK

     if cZellwert("A8") <> "15" then Warnlog "A8 isn't correct !"

   Call hCloseDocument

endcase

'----------------------------------------------------------------

testcase tDataPilot_19

  Dim testFile   as String
  Dim sheetName  as String

  testFile   = "datapilot.sxc"
  sheetName  = "_Sheet1_1.$A$1"

  printLog "More - Set result to new sheet"
  '/// More - Set result to new sheet

   call hNewDocument

   '/// Open test file datapilot.sxc
    Call hDateiOeffnen ( gTesttoolPath + "calc\special\input\keyboardaccessibility\" + testFile )

    '/// DataPilot/Start , check current selection
     DataDataPilotStart
     Kontext "QuelleAuswaehlen"
       AktuelleSelektion.Check
       QuelleAuswaehlen.OK

     '/// Drap Product to Column fields
       Kontext "Datenpilot"
         Sleep 1
         Call  fDataPilotColumnSelection()
         Sleep 1

      '/// Press More button , select 'new sheet'
         Zusaetze.Click
         Sleep 2
         AusgabeAb.Select 2
       Datenpilot.OK

     if cZellwert("A4") <> "Audio" then Warnlog "A4 isn't correct !"
     if cZellwert("B4") <> "DVD"   then Warnlog "B4 isn't correct !"
     if cZellwert("C4") <> "Video" then Warnlog "C4 isn't correct !"
     if Len(cZellwert("E4")) <> 0  then Warnlog "E4 isn't correct !"

     DocumentCalc.typeKeys "<MOD1 Home>"
     DataConsolidate
     Kontext "Konsolidieren"
       if Right(Ausgeben.getText , 14) <> sheetName then
           warnlog "Something wrong in the new sheet ! "
       end if
     Konsolidieren.close

   Call hCloseDocument

endcase

'----------------------------------------------------------------

testcase tDataPilot_20

  Dim i              as Integer
  Dim sResultTo , s1 as String

  printLog "More - Set result to new cell"
  '/// More - Set result to new cell

   call hNewDocument

    '/// Input some text
     Kontext "DocumentCalc"
     DocumentCalc.typeKeys "A<Down>10"

    '/// DataPilot/Start , check current selection
     DataDataPilotStart
     Kontext "QuelleAuswaehlen"
       AktuelleSelektion.Check
       QuelleAuswaehlen.OK

     '/// Drap A to Column fields
       Kontext "Datenpilot"
         Sleep 1
         Call fDataPilotColumnSelection()
         Sleep 1

      '/// Press More button , input $Sheet1.$A$10 in 'result to'
         Zusaetze.Click
         Sleep 1

         i  = instr (Bereich.GetText , ".")
         s1 = Left(Bereich.GetText , i)
         sResultTo = s1+"$A$10"
         Bereich.SetText sResultTo
       Datenpilot.OK

     if Len(cZellwert("A6")) <> 0   then Warnlog "A6 isn't correct !"
     if cZellwert("A12")     <> "A" then Warnlog "A12 isn't correct !"

   Call hCloseDocument

endcase

'----------------------------------------------------------------

testcase tDataPilot_21

  printLog "More - Ignore empty rows (UnCheck) - Default"
  '/// More - Ignore empty rows(UnCheck) - Default

   call hNewDocument

    '/// Input some text and select them
     Kontext "DocumentCalc"
     DocumentCalc.typeKeys "A<Down>10<Down><Down>20"
     DocumentCalc.typeKeys "<Shift PageUp>"

    '/// DataPilot/Start , check current selection
     DataDataPilotStart
     Kontext "QuelleAuswaehlen"
       AktuelleSelektion.Check
       QuelleAuswaehlen.OK

     '/// Drap A to Column fields
       Kontext "Datenpilot"
         Sleep 1
         Call fDataPilotColumnSelection()
         Sleep 1

      '/// Press More button , Uncheck 'Ignore empty rows'
         Zusaetze.Click
         Sleep 2
         LeerzeilenIgnorieren.UnCheck
       Datenpilot.OK

     if Left(cZellwert("C9"),1) <> "(" then Warnlog "C9 isn't correct !"
     if Len(cZellwert("D9"))    = 0    then Warnlog "D9 isn't correct !"

   Call hCloseDocument

endcase

'----------------------------------------------------------------

testcase tDataPilot_22

  printLog "More - Ignore empty rows (Check)"
  '/// More - Ignore empty rows(Check)

   call hNewDocument

    '/// Input some text and select them
     Kontext "DocumentCalc"
     DocumentCalc.typeKeys "A<Down>10<Down><Down>20"
     DocumentCalc.typeKeys "<Shift PageUp>"

    '/// DataPilot/Start , check current selection
     DataDataPilotStart
     Kontext "QuelleAuswaehlen"
       AktuelleSelektion.Check
       QuelleAuswaehlen.OK

     '/// Drap A to Column fields
       Kontext "Datenpilot"
         Sleep 1
         Call fDataPilotColumnSelection()
         Sleep 1

      '/// Press More button , check 'Ignore empty rows'
         Zusaetze.Click
         Sleep 2
         LeerzeilenIgnorieren.Check
       Datenpilot.OK

     if Left(cZellwert("C9"),1) = "(" then Warnlog "C9 isn't correct !"
     if Len(cZellwert("D9"))    <> 0  then Warnlog "D9 isn't correct !"

   Call hCloseDocument

endcase

'----------------------------------------------------------------

testcase tDataPilot_23

  Dim testFile   as String

  testFile = "iDentifyCategory.sxc"

  printLog "More - Identify categories(Uncheck) - Default"
  '/// More - Identify categories(Uncheck) - Default

   call hNewDocument

   '/// Open test file iDentifyCategory.sxc
    Call hDateiOeffnen ( gTesttoolPath + "calc\special\input\keyboardaccessibility\" + testFile )

    '/// DataPilot/Start , check current selection
     DataDataPilotStart
     Kontext "QuelleAuswaehlen"
       AktuelleSelektion.Check
       QuelleAuswaehlen.OK

     '/// Drap City to Row fields , Product to Column fields , number to data fields
       Kontext "Datenpilot"
         Sleep 1
         Call fDataPilotRowSelection()
         Sleep 1
         Call fDataPilotColumnSelection()
         Sleep 1
         Call  fDataPilotDataSelection()
         Sleep 1
       Datenpilot.OK

     if Left(cZellwert("A12"),1) <> "(" then Warnlog "A12 isn't correct !"
     if cZellwert("A13") <> "Beijing"   then Warnlog "A13 isn't correct !"
     if cZellwert("A14") <> "New York"  then Warnlog "A14 isn't correct !"
     if cZellwert("A15") <> "Shanghai"  then Warnlog "A15 isn't correct !"

   Call hCloseDocument

endcase

'----------------------------------------------------------------

testcase tDataPilot_24

  Dim testFile   as String

  testFile = "iDentifyCategory.sxc"

  printLog "More - Identify categories(check)"
  '/// More - Identify categories(check)

   call hNewDocument

   '/// Open test file iDentifyCategory.sxc
    Call hDateiOeffnen ( gTesttoolPath + "calc\special\input\keyboardaccessibility\" + testFile )

    '/// DataPilot/Start , check current selection
     DataDataPilotStart
     Kontext "QuelleAuswaehlen"
       AktuelleSelektion.Check
       QuelleAuswaehlen.OK

     '/// Drap City to Row fields , Product to Column fields , number to data fields
       Kontext "Datenpilot"
         Sleep 1
         Call fDataPilotRowSelection()
         Sleep 1
         Call fDataPilotColumnSelection()
         Sleep 1
         Call  fDataPilotDataSelection()
         Sleep 1

      '/// Press More button , check 'Identify categories'
         Zusaetze.Click
         Sleep 2
         KategorieErkennung.Check
       Datenpilot.OK

     if cZellwert("A12") <> "Beijing"   then Warnlog "A12 isn't correct !"
     if cZellwert("A13") <> "New York"  then Warnlog "A13 isn't correct !"
     if cZellwert("A14") <> "Shanghai"  then Warnlog "A14 isn't correct !"

   Call hCloseDocument

endcase

'----------------------------------------------------------------

testcase tDataPilot_25

  Dim testFile   as String

  testFile = "datapilot.sxc"

  printLog "More - Total columns(Check) - default"
  '/// More - Total columns(Check) - default

   call hNewDocument

   '/// Open test file datapilot.sxc
    Call hDateiOeffnen ( gTesttoolPath + "calc\special\input\keyboardaccessibility\" + testFile )

    '/// DataPilot/Start , check current selection
     DataDataPilotStart
     Kontext "QuelleAuswaehlen"
       AktuelleSelektion.Check
       QuelleAuswaehlen.OK

     '/// Drap Product to Column fields
       Kontext "Datenpilot"
         Sleep 1
         Call fDataPilotColumnSelection()
         Sleep 1

     '/// Drap 2000 to data fields
         Datenpilot.typekeys "<Down>" , 2 , TRUE
         Sleep 1
         Call fDataPilotDataSelection()
         Sleep 1

      '/// Press OK
       Datenpilot.OK

     if cZellwert("A25") <> "1289000" then Warnlog "A25 isn't correct !"
     if cZellwert("B25") <> "365000"  then Warnlog "B25 isn't correct !"
     if cZellwert("C25") <> "1530000" then Warnlog "C25 isn't correct !"
     if cZellwert("D25") <> "3184000" then Warnlog "D25 isn't correct !"

   Call hCloseDocument

endcase

'----------------------------------------------------------------

testcase tDataPilot_26

  Dim testFile   as String

  testFile = "datapilot.sxc"

  printLog "More - Total columns(UnCheck)"
  '/// More - Total columns(UnCheck)

   call hNewDocument

   '/// Open test file datapilot.sxc
    Call hDateiOeffnen ( gTesttoolPath + "calc\special\input\keyboardaccessibility\" + testFile )

    '/// DataPilot/Start , check current selection
     DataDataPilotStart
     Kontext "QuelleAuswaehlen"
       AktuelleSelektion.Check
       QuelleAuswaehlen.OK

     '/// Drap Product to Column fields
       Kontext "Datenpilot"
         Sleep 1
         Call fDataPilotColumnSelection()
         Sleep 1

     '/// Drap 2000 to data fields
         Datenpilot.typekeys "<Down>" , 2 , TRUE
         Sleep 1
         Call fDataPilotDataSelection()
         Sleep 1

      '/// Press More button , Uncheck 'Tatal columns'
         Zusaetze.Click
         Sleep 2
         GesamtSpalten.UnCheck

      '/// Press OK
       Datenpilot.OK

     if cZellwert("A25") <> "1289000" then Warnlog "A25 isn't correct !"
     if cZellwert("B25") <> "365000"  then Warnlog "B25 isn't correct !"
     if cZellwert("C25") <> "1530000" then Warnlog "C25 isn't correct !"
     if Len(cZellwert("D25")) <> 0    then Warnlog "D25 isn't correct !"

   Call hCloseDocument

endcase

'----------------------------------------------------------------

testcase tDataPilot_27

  Dim testFile   as String

  testFile = "datapilot.sxc"

  printLog "More - Total rows(Check) - default"
  '/// More - Total rows(Check) - default

   call hNewDocument

   '/// Open test file datapilot.sxc
    Call hDateiOeffnen ( gTesttoolPath + "calc\special\input\keyboardaccessibility\" + testFile )

    '/// DataPilot/Start , check current selection
     DataDataPilotStart
     Kontext "QuelleAuswaehlen"
       AktuelleSelektion.Check
       QuelleAuswaehlen.OK

     '/// Drap Product to Row fields
       Kontext "Datenpilot"
         Sleep 1
         Call fDataPilotRowSelection()
         Sleep 1

     '/// Drap 2000 to data fields
         Datenpilot.typekeys "<Down>" , 2 , TRUE
         Sleep 1
         Call fDataPilotDataSelection()
         Sleep 1

      '/// Press OK
       Datenpilot.OK

     if cZellwert("B24") <> "1289000" then Warnlog "B24 isn't correct !"
     if cZellwert("B25") <> "365000"  then Warnlog "B25 isn't correct !"
     if cZellwert("B26") <> "1530000" then Warnlog "B26 isn't correct !"
     if cZellwert("B27") <> "3184000" then Warnlog "B27 isn't correct !"

   Call hCloseDocument

endcase

'----------------------------------------------------------------

testcase tDataPilot_28

  Dim testFile   as String

  testFile = "datapilot.sxc"

  printLog "More - Total rows(UnCheck)"
  '/// More - Total rows(UnCheck)

   call hNewDocument

   '/// Open test file datapilot.sxc
    Call hDateiOeffnen ( gTesttoolPath + "calc\special\input\keyboardaccessibility\" + testFile )

    '/// DataPilot/Start , check current selection
     DataDataPilotStart
     Kontext "QuelleAuswaehlen"
       AktuelleSelektion.Check
       QuelleAuswaehlen.OK

     '/// Drap Product to Row fields
       Kontext "Datenpilot"
         Sleep 1
         Call fDataPilotRowSelection()
         Sleep 1

     '/// Drap 2000 to data fields
         Datenpilot.typekeys "<Down>" , 2 , TRUE
         Sleep 1
         Call fDataPilotDataSelection()
         Sleep 1

      '/// Press More button , Uncheck 'Tatal rows'
         Zusaetze.Click
         Sleep 2
         GesamtZeilen.UnCheck

      '/// Press OK
       Datenpilot.OK

     if cZellwert("B24") <> "1289000" then Warnlog "B24 isn't correct !"
     if cZellwert("B25") <> "365000"  then Warnlog "B25 isn't correct !"
     if cZellwert("B26") <> "1530000" then Warnlog "B26 isn't correct !"
     if Len(cZellwert("B27")) <> 0    then Warnlog "B27 isn't correct !"

   Call hCloseDocument

endcase

'----------------------------------------------------------------

testcase tDataPilot_29

  Dim testFile   as String

  testFile = "datapilot.sxc"

  printLog "Current selection"
  '/// Current selection

   call hNewDocument

   '/// Open test file datapilot.sxc , and select first 2 lines
    Call hDateiOeffnen ( gTesttoolPath + "calc\special\input\keyboardaccessibility\" + testFile )
     Kontext "DocumentCalc"
     DocumentCalc.typeKeys "<MOD1 Home><Shift End><Shift Down>"

    '/// DataPilot/Start , check current selection
     DataDataPilotStart
     Kontext "QuelleAuswaehlen"
       AktuelleSelektion.Check
       QuelleAuswaehlen.OK

     '/// Drap Product to Column fields
       Kontext "Datenpilot"
         Sleep 1
         Call fDataPilotColumnSelection()
         Sleep 1

     '/// Drap 2000 to data fields
         Datenpilot.typekeys "<Down>" , 2 , TRUE
         Sleep 1
         Call fDataPilotDataSelection()
         Sleep 1

     '/// Press OK
       Datenpilot.OK

       Kontext "Active"
       Sleep 2
       if Active.Exists then
           if Active.GetRT = 304 then
               Active.Yes
           else
               Warnlog Active.GetRT
               Active.No
           end if
       end if

     if cZellwert("A6") <> "Products" then Warnlog "A6 isn't correct !"
     if cZellwert("A7") <> "Audio"    then Warnlog "A7 isn't correct !"
     if cZellwert("A8") <> "200000"   then Warnlog "A8 isn't correct !"

   Call hCloseDocument

endcase

'----------------------------------------------------------------

testcase tDataPilot_30

  Dim testFile  as String

  testFile = "showItemsWithoutData.sxc"

  printLog "Show items without data (uncheck) - Default"
  '/// Show items without data (uncheck) - Default

   call hNewDocument

   '/// Open test file showItemsWithoutData.sxc
    Call hDateiOeffnen ( gTesttoolPath + "calc\special\input\keyboardaccessibility\" + testFile )

    '/// DataPilot/Start , check current selection
     DataDataPilotStart
     Kontext "QuelleAuswaehlen"
       AktuelleSelektion.Check
       QuelleAuswaehlen.OK

     '/// Drap A , B to Row fields
       Kontext "Datenpilot"
         Sleep 1
         Call fDataPilotRowSelection()
         Sleep 1
         Call fDataPilotRowSelection()
         Sleep 1

     '/// Press OK
       Datenpilot.OK

     if cZellwert("A9")  <> "2"  then Warnlog "A9 isn't correct !"
     if cZellwert("A10") <> "4"  then Warnlog "A10 isn't correct !"
     if cZellwert("B10") <> "6"  then Warnlog "B10 isn't correct !"
     if cZellwert("B11") <> "5"  then Warnlog "B11 isn't correct !"
     if Left(cZellwert("B9"),1) <> "(" then Warnlog "B9 isn't correct !"

   Call hCloseDocument

endcase

'----------------------------------------------------------------

testcase tDataPilot_31

  Dim testFile  as String

  testFile = "showItemsWithoutData.sxc"

  printLog "Show items without data (check)"
  '/// Show items without data (check)

   call hNewDocument

   '/// Open test file showItemsWithoutData.sxc
    Call hDateiOeffnen ( gTesttoolPath + "calc\special\input\keyboardaccessibility\" + testFile )

    '/// DataPilot/Start , check current selection
     DataDataPilotStart
     Kontext "QuelleAuswaehlen"
       AktuelleSelektion.Check
       QuelleAuswaehlen.OK

     '/// Drap A , B to Row fields
       Kontext "Datenpilot"
         Sleep 1
         Call fDataPilotRowSelection()
         Sleep 1
         Call fDataPilotRowSelection()
         Sleep 1

        '/// Set focus to B in Row Field
         Datenpilot.typekeys "<Tab>" , 5 , TRUE
         sleep 1

        '/// Press Options button , check Show items without data
        '/// + in Data Field dialog
        '/// Close Data Field dialog
         Optionen.Click
         Kontext "Datenfeld"
           OhneDatenAnzeigen.Check
         Datenfeld.OK

     '/// Press OK
       Kontext "Datenpilot"
       Datenpilot.OK

     if cZellwert("A9")  <> "2"    then Warnlog "A9 isn't correct !"
     if cZellwert("A12") <> "4"    then Warnlog "A12 isn't correct !"
     if Len(cZellwert("A10")) <> 0 then Warnlog "A10 isn't correct !"
     if cZellwert("B9")  <> "5"    then Warnlog "B9 isn't correct !"
     if cZellwert("B10") <> "6"    then Warnlog "B10 isn't correct !"
     if cZellwert("B12") <> "5"    then Warnlog "B12 isn't correct !"
     if cZellwert("B13") <> "6"    then Warnlog "B13 isn't correct !"
     if cZellwert("B15") <> "5"    then Warnlog "B15 isn't correct !"
     if cZellwert("B16") <> "6"    then Warnlog "B16 isn't correct !"
     if Left(cZellwert("B11"),1) <> "(" then Warnlog "B11 isn't correct !"
     if Left(cZellwert("B14"),1) <> "(" then Warnlog "B14 isn't correct !"
     if Left(cZellwert("B17"),1) <> "(" then Warnlog "B17 isn't correct !"

   Call hCloseDocument

endcase

'----------------------------------------------------------------

testcase tDataPilot_32

  Dim testFile  as String

  testFile = "datapilot.sxc"

  printLog "Hide/Show details"
  '/// Hide/Show details

   call hNewDocument

   '/// Open test file datapilot.sxc
    Call hDateiOeffnen ( gTesttoolPath + "calc\special\input\keyboardaccessibility\" + testFile )

    '/// DataPilot/Start , check current selection
     DataDataPilotStart
     Kontext "QuelleAuswaehlen"
       AktuelleSelektion.Check
       QuelleAuswaehlen.OK

     '/// Drap Area to Row fields
       Kontext "Datenpilot"
         Sleep 1
         Datenpilot.typekeys "<Down>" , TRUE
         Call fDataPilotRowSelection()
         Sleep 1

        '/// Set focus to Area in Row Fields
         Datenpilot.typekeys "<Tab>" , 5 , TRUE
         sleep 1

        '/// Press Options button to active data field dialog , then
        '/// + press Options button to active Data Field options dialog , check Bosten
         Optionen.Click
         Kontext "Datenfeld"
           Options.Click

           Kontext "DataFieldsOptionsDlg"
             HideItems.Check
           DataFieldsOptionsDlg.OK

         Kontext "Datenfeld"
         Datenfeld.OK

     '/// Press OK
       Kontext "Datenpilot"
       Datenpilot.OK

     if cZellwert("A24") <> "Chicago" then Warnlog "A24 isn't correct !"

   Call hCloseDocument

endcase

'----------------------------------------------------------------

testcase tDataPilot_33

  Dim testFile  as String

  testFile = "datapilot.sxc"

  printLog "Subtotals"
  '/// Subtotals

   call hNewDocument

   '/// Open test file datapilot.sxc
    Call hDateiOeffnen ( gTesttoolPath + "calc\special\input\keyboardaccessibility\" + testFile )

    '/// DataPilot/Start , check current selection
     DataDataPilotStart
     Kontext "QuelleAuswaehlen"
       AktuelleSelektion.Check
       QuelleAuswaehlen.OK

     '/// Drap Area , Salesman , Product to Row fields
     '/// Drap 2000 , 2001 , 2002 to Data fields
       Kontext "Datenpilot"
         Sleep 1
         Datenpilot.typekeys "<Down>" , TRUE
         Call fDataPilotRowSelection()
         Sleep 1
         Call fDataPilotRowSelection()
         Sleep 1
         Datenpilot.typekeys "<Up>"   , 3 , TRUE
         Call fDataPilotRowSelection()
         Sleep 1
         Datenpilot.typekeys "<Down>" , 2 , TRUE
         Sleep 1
         Call  fDataPilotDataSelection()
         Sleep 1
         Call  fDataPilotDataSelection()
         Sleep 1
         Call  fDataPilotDataSelection()
         Sleep 1

        '/// Set focus to Area in Row Fields
         Datenpilot.typekeys "<Tab>" , 5 , TRUE
         sleep 1
         Datenpilot.typekeys "<Up>"  , 2 , TRUE

        '/// Press Options button to active data field dialog
        '/// check User-defined , select Sum
         Optionen.Click
         Kontext "Datenfeld"
           Benutzerdefiniert.Check
           Sleep 2
           Funktionen.Select 1
         Datenfeld.OK

        '/// Set focus to Salesman in Row Fields
         Kontext "Datenpilot"
         Datenpilot.typekeys "<Down>" , TRUE

        '/// Press Options button to active data field dialog
        '/// check User-defined , select Sum
         Optionen.Click
         Kontext "Datenfeld"
           Benutzerdefiniert.Check
           Sleep 2
           Funktionen.Select 1
         Datenfeld.OK

     '/// Press OK to close Datapilot dialog
       Kontext "Datenpilot"
       Datenpilot.OK

     if cZellwert("A24") <> "Boston"    then Warnlog "A24 isn't correct !"
     if cZellwert("A39") <> "Chicago"   then Warnlog "A39 isn't correct !"
     if cZellwert("B24") <> "Robinson"  then Warnlog "B24 isn't correct !"
     if cZellwert("B39") <> "Elvis"     then Warnlog "B39 isn't correct !"

    printLog "Re-invoke datapilot"
    'Context menu - Start
     DocumentCalc.OpenContextMenu
     Call hMenuSelectNr(1)
     Sleep 1
       Kontext "Datenpilot"
       Sleep 1
        '/// Set focus to Area in Row Fields , exchange Area and Salesman's location
         Datenpilot.typekeys "<Tab>" ,   5 , TRUE
         Sleep 1
         Datenpilot.typekeys "<MOD1 Down>" , TRUE
       Datenpilot.OK

     if cZellwert("A24") <> "Brown"    then Warnlog "A24 isn't correct !"
     if cZellwert("A39") <> "Bush"     then Warnlog "A39 isn't correct !"
     if cZellwert("B24") <> "New York" then Warnlog "B24 isn't correct !"
     if cZellwert("B39") <> "Miami"    then Warnlog "B39 isn't correct !"

   Call hCloseDocument

endcase

'----------------------------------------------------------------

