'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: ch_tools_select.inc,v $
'*
'*  $Revision: 1.2 $
'*
'*  last change: $Author: tbo $ $Date: 2005/09/07 19:07:50 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : peter.junge@sun.com
'*
'* short description : selecting charts
'*
'**************************************************************************************************
'*
' #1 fSelectChartByNumber
'*
'\************************************************************************************************

function fSelectChartByNumber ( iObjectPosition as INTEGER )
    '///<b>Select any Chart in document</b>
    '///<b>INTEGER: iObjectPosition</b> - Position of object (>=1) within OLE objects
    '///+<b>NOTE:</b>You're moving within a treelistbox which is quite messy to handle.
    '///+In case 'iObjectPosition' is larger than the real number of objects in category you're end up in another categories.
    '///+<b>WITHOUT ANY WARNING!</b>
    '///<b>RETURNS:</b> BOOLEAN (success)</b>
    '///-----
    '///<ul>
    dim bNavigatorWasVisible as boolean
        bNavigatorWasVisible = FALSE
    dim iIndex
    dim iCategoryPosition as INTEGER
        iCategoryPosition = 6
    
    fSelectChartByNumber = FALSE

    '///<li>Check if Navigator is visible</li>///
    Kontext "NavigatorCalc"
    if NavigatorCalc.exists (3) then
    '///<li>Remember state of visibiliy TRUE/FALSE</li>///
        bNavigatorWasVisible = TRUE
    else
        '///<li>Invoke navigator if not visible</li>///
        EditNavigator
    end if
    
    try 
        Kontext "NavigatorCalc"
        '///<li>Go to Top in Navigator</li>///
        liste.TypeKeys "<HOME>"
        '///<li>Travel top to bottom through all categories</li>///
        for iIndex = 1 to 6
        '///<li>Make sure all elements in category are hidden, apply '-' key</li>///
             liste.TypeKeys "-<DOWN>"
        next iIndex
        '///<li>Select desired category OLE</li>///
        liste.select ( iCategoryPosition )
        '///<li>Unfold elements of selected category</li>///
        liste.TypeKeys "+"
        '///<li>Select desired position within category</li>///
        liste.select ( iCategoryPosition + iObjectPosition )
        '///<li>Hit 'RETURN' key to select element in document</li>///
        liste.TypeKeys "<RETURN>"
        '///<li>Return 'TRUE' for 'fNavigatorSelectObject'</li>///
        fSelectChartByNumber = TRUE
    catch
        warnlog "Selecting the desired object failed. Perhaps your input wasn't valid"
    endcatch
    '///<li>Close navigator if it wasn't visible before entering this function</li>///
    if bNavigatorWasVisible = TRUE then
        printlog "Leaving navigator open as initially found"
    else
        EditNavigator
        printlog "Closing navigator as initially found"
    end if
    '///</ul>
end function

