'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: f_basic_3.inc,v $
'*
'*  $Revision: 1.5 $
'*
'*  last change: $Author: tbo $ $Date: 2005/09/07 19:07:58 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : joerg.skottke@sun.com
'*
'* short description : check macro-dialogs / run scripts ( 3. part )
'*
'*******************************************************************************
'*
' #1 tCheckControlsettings              ' check settings of the dialog controls - wrn:10 does not work on status page, when the routine is called more than one times
'*
'\******************************************************************************

testcase tCheckControlsettings

   Dim i as Integer, kControls as Integer
   Dim sFile as String, sControl as String
   Dim lsPropList( 50 ) as String

   '///<h2>check if all settings are saved for any control in all applications</h2>
   '///<ul><li>open a new doc ( for all applications )</li>

   select case lcase ( gApplication )
      case "writer"  : sFile = gOfficePath + "user\work\w_basic.sxw"
      case "calc"    : sFile = gOfficePath + "user\work\c_basic.sxc"
      case "impress" : sFile = gOfficePath + "user\work\i_basic.sxi"
      case "draw"    : sFile = gOfficePath + "user\work\d_basic.sxd"
   end select

   'DEBUG: Here you can fastly test only one control if you change the 1 - 21.
   'DEBUG: for kControls = 18 to 18 would test only Currency Field.
   for kControls = 1 to 21
      ListAllDelete ( lsPropList() )

      printlog Chr(13) + "   open a new " + gApplication + "-doc"

      '///<li>create a new module for the new document ( named TTModule )</li>
      call hNewDocument
      Call CreateNewModuleForDoc

      '///<li>create a new dialog in BasicIDE</li>
      Kontext "BasicIDE"
      Tabbar.OpenContextMenu
      hMenuSelectNr(1)
      sleep(1)
      hMenuSelectNr(2)
      sleep(2)

      if not DialogWindow.Exists (2) then
         Warnlog "No dialog window is shown!"
         endif

      Kontext "BasicIDE" 'try to grab the IDE, it might have lost focus on Linux

      Kontext "MacroBar"

      '///<li>tear off controls and insert one control ( for each test only one control )</li>
      printlog "   tear off 'controls'"
'      Controls.TearOff
'      sleep(1)
'      Kontext "TB_MacroControls"
'      if TB_MacroControls.Exists <> TRUE then
'         Warnlog "Controls-window is not open!"
'      else
'         TB_MacroControls.Move ( 50 , 50 )
'      endif
'      sleep (1)

      ' skip this testsequence if the
      if( showMacroControls() <> true ) then goto skiptest

      '///<li>the controls are :</li>
      select case kControls
         case 1  :  sControl = "CommandButton"  :  CommandButton.Click
         case 2  :  sControl = "ImageControl"   :  ImageControl.Click
         case 3  :  sControl = "Checkbox"       :  Checkbox.Click
         case 4  :  sControl = "OptionButton"   :  OptionButton.Click
         case 5  :  sControl = "Label"          :  Label.Click
         case 6  :  sControl = "TextField"      :  TextField.Click
         case 7  :  sControl = "ListBox"        :  Listbox.Click
         case 8  :  sControl = "ComboBox"       :  ComboBox.Click
         case 9  :  sControl = "Scrollbar"      :  HScrollBar.Click
         case 10 :  sControl = "Scrollbar"      :  VScrollBar.Click
         case 11 :  sControl = "FrameControl"   :  FrameControl.Click
         case 12 :  sControl = "Progressbar"    :  Progressbar.Click
         case 13 :  sControl = "FixedLine"      :  HLine.Click
         case 14 :  sControl = "FixedLine"      :  VLine.Click
         case 15 :  sControl = "DateField"      :  DateField.Click
         case 16 :  sControl = "TimeField"      :  TimeField.Click
         case 17 :  sControl = "NumericField"   :  NumericField.Click
         case 18 :  sControl = "CurrencyField"  :  CurrencyField.Click
         case 19 :  sControl = "FormattedField" :  FormattedField.Click
         case 20 :  sControl = "PatternField"   :  PatternField.Click
         case 21 :  sControl = "FileControl"    :  FileControl.Click
      end select

      '///<ol><li>Command button</li>
      '///<li>Image control</li>
      '///<li>Check box</li>
      '///<li>Option button</li>
      '///<li>Label</li>
      '///<li>Text field</li>
      '///<li>List box</li>
      '///<li>Combo box</li>
      '///<li>vertical Scroll bar</li>
      '///<li>horizontal Scroll bar</li>
      '///<li>Frame control</li>
      '///<li>Progress bar</li>
      '///<li>horizontal fixed line</li>
      '///<li>vertical fixed line</li>
      '///<li>Date field</li>
      '///<li>Time field</li>
      '///<li>Numeric field</li>
      '///<li>Currency field</li>
      '///<li>Formatted field</li>
      '///<li>Pattern field</li>
      '///<li>File control</li></ol>
      sleep(1)
      printlog "now '" & sControl & "' is tested"
      Call DrawControlOnDialog (35 , 30 , 40 , 35)
      Call DrawControlOnDialog (50 , 50 , 60 , 60)
      sleep(1)
      '///<li>change all settings for this control</li>
      call hChangeControlSettings(sControl, lsPropList())
      sleep(1)
      '///<li>close Basic-IDE</li>
      call hCloseDocument
      sleep(1)
      '///<li>save the document and close it</li>
      call hSpeichernUnterKill (sFile)
      FileClose
      sleep(2)
      '///<li>open the saved document</li>
      call hDateiOeffnen (sFile)
      sleep(1)
      '///<li>open Basic-IDE for this file</li>
      call SelectTheLastModule ( TRUE , FALSE )
      Bearbeiten.Click
      Sleep (2)

      '///<li>open the dialog window</li>
      Kontext "BasicIDE"
      for i=1 to 20
         Tabbar.MouseDown ( 5*i , 50 )
         Tabbar.MouseUp ( 5*i , 50 )
         if DialogWindow.Exists(1) then i=100
      next i

      ' this prevents the test from failing if the macrocontrols are not opened
      ' in time (hopefully)
      if ( showMacroControls() = true ) then

         '///<li>activate select mode and the properties</li>
         printlog "   activate select mode"
         SelectMode.Click

         Kontext "BasicIDE"
         DialogWindow.MouseDown ( 45 , 45 )
         DialogWindow.MouseMove ( 65 , 65 )
         DialogWindow.MouseUp   ( 65 , 65 )

         '///<li>check all changed settings</li>
         call hCheckControlSettings ( sControl, lsPropList( ) )

      endif

      '///<li>close Basic IDE and the document</li></ul>
      Call hCloseDocument

      skiptest:
      Call hCloseDocument

   '///<b>next control</b>
   next kControls

endcase

'*******************************************************************************

function showMacroControls() as boolean

   Kontext "MacroBar"
   if MacroBar.Exists(2) then
      printlog "   tear off 'controls'"
      try
          Controls.TearOff
          sleep(2)
      catch
          sleep( 2 )
      endcatch
   endif

   Kontext "TB_MacroControls"
   if TB_MacroControls.Exists(1) <> TRUE then
       Warnlog "Controls-window is not open!"
       showMacroControls() = false
   else
       TB_MacroControls.Move ( 50 , 50 )
       showMacroControls() = true
   endif

   sleep( 1 )

end function
