'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: f_basic_formcontrols_common.inc,v $
'*
'*  $Revision: 1.4 $
'*
'*  last change: $Author: tbo $ $Date: 2005/09/07 19:07:59 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'*  owner : joerg.skottke@sun.com
'*
'*  short description : Common properties for all formcontrols
'*
'*******************************************************************************
'**
' #1 tCommonFormControls ' Set and verify properties common for all controls
'**
'\******************************************************************************

testcase tCommonFormControls

    '///<H1>Set and verify properties common for all controls</H1>

    const SVERSION = "680" ' major office version
    const CFN = "tCommonFormControls::"
    const CMODULE = "tcommon" 

    dim brc as boolean ' multi purpose returncode
    dim sFile as string
        sFile = hGetBasicWorkFile( SVERSION )

    dim lsControlNames( 30 ) as string

    dim iCurrentControl as integer
    dim sCurrentControl as string
    dim iCurrentProperty as integer
    
    ' file might exist, leftover by prior run
    hDeleteFile( sFile )

    gApplication = "WRITER"  ' we only look at the writer for now.

    ' get a new document (2 open then), verify
    call hNewDocument()
    hCheckDocCount( 2 , false )

    ' create a new module, create a new dialog, open macro controls float
    brc = hInitFormControls( CMODULE )
    if ( not brc ) then
        printlog( CFN & "Aborting due to previous errors." )
        call hCloseDocument()
        goto endsub
    endif

    for iCurrentControl = 1 to ICONTROLCOUNT - 1  

        sCurrentControl = hDrawControlOnDialog( iCurrentControl )
        hSelectControl( iCurrentControl )
        hOpenPropertyBrowser()
        hSetPBTabPage( 1 )
        hSetCommonProperties( iCurrentControl )
        hClosePropertyBrowser()
            

    next iCurrentControl
    
    hCloseBasicIde()
    
    hSaveFile( sFile , "" , false , false )
    
    call hCloseDocument()
    
    hLoadFile( sFile )
    hHandleSecurityWarning()
    
    hSelectTheLastModule( true )
    
    Bearbeiten.click()
    
    hFindFirstDialog()
    
    hShowMacroControls()
    
    for iCurrentControl = 1 to ICONTROLCOUNT - 1
        
        hSelectControl( iCurrentControl )
        hOpenPropertyBrowser()
        hGetCommonProperties( iCurrentControl )
        hClosePropertyBrowser()
            
    next iCurrentControl

    hCloseBasicIde()
    
    call hCloseDocument()
    
    hDeleteFile( sFile )

endcase

'******************************************************************************

function hSetCommonProperties( iIndex as integer ) as boolean

    const CFN = "hSetCommonProperties::"
    dim iBreakPos as integer
    
    kontext "TabGeneralControl"
    
    if ( ( iIndex < 1 ) or ( iIndex > ICONTROLCOUNT -1 ) ) then
        warnlog( CFN & "Invalid index passed to function, aborting" )
        hSetCommonProperties() = false
        exit function
    endif
    
    if ( not NameText.exists() ) then
        warnlog( CFN & "Unable to access properties, aborting" )
        hSetCommonProperties() = false
        exit function
    endif    
    
    try
        iBreakPos = 0
        NameText.setText( "MyControl" & iIndex )
        
        iBreakPos = 1 
        Enabled.select( 2 )
        
        iBreakPos = 2
        Printable.select( 2 )
        
        iBreakPos = 3
        HelpText.setText( "MyHelpText" & iIndex )
        
        iBreakPos = 4
        HelpUrl.setText( "http://www.sun.com" )
        
        iBreakPos = 5
        Information.setText( "My Additional Information " & iIndex )
        
    catch
        warnlog( CFN & "Failed to access a control after Pos " & iBreakPos )
        hSetCommonProperties() = false
        exit function
    endcatch
    
    printlog( CFN & "Success" )
    hSetCommonProperties() = true
    
end function
        
'*******************************************************************************

function hGetCommonProperties( iIndex as integer ) as boolean

    const CFN = "hGetCommonProperties::"
    dim iBreakPos as integer
    
    dim cPropertyValue as string
    dim iPropertyValue as integer
    dim cReferenceValue as string
    
    dim iErr as integer
        iErr = 0
    
    kontext "TabGeneralControl"
    
    if ( ( iIndex < 1 ) or ( iIndex > ICONTROLCOUNT -1 ) ) then
        warnlog( CFN & "Invalid index passed to function, aborting" )
        hGetCommonProperties() = false
        exit function
    endif
    
    if ( not NameText.exists() ) then
        warnlog( CFN & "Unable to access properties, aborting" )
        hGetCommonProperties() = false
        exit function
    endif    
    
    try
        iBreakPos = 0
        cPropertyValue = NameText.getText()
        cReferenceValue = "MyControl" & iIndex 
        if ( cPropertyValue <> cReferenceValue ) then
            warnlog( CFN & "NameText not saved" )
            iErr = 1
        endif
        
        iBreakPos = 1
        iPropertyValue = Enabled.getSelIndex()
        if ( iPropertyValue <> 2 ) then
            warnlog( CFN & "Enabled not saved" )
            iErr = 1
        endif        
        
        iBreakPos = 2
        iPropertyValue = Printable.getSelIndex()
        if ( iPropertyValue <> 2 ) then
            warnlog( CFN & "Printable not saved" )
            iErr = 1
        endif        
        
       
        iBreakPos = 3
        cPropertyValue = HelpText.getText()
        cReferenceValue = "MyHelpText" & iIndex 
        if ( cPropertyValue <> cReferenceValue ) then
            warnlog( CFN & "HelpText not saved" )
            iErr = 1
        endif        
        
        iBreakPos = 4
        cPropertyValue = HelpUrl.getText()
        cReferenceValue = "http://www.sun.com" 
        if ( cPropertyValue <> cReferenceValue ) then
            warnlog( CFN & "HelpUrl not saved" )
            iErr = 1
        endif        
        
        iBreakPos = 5
        cPropertyValue = Information.getText()
        cReferenceValue = "My Additional Information " & iIndex 
        if ( cPropertyValue <> cReferenceValue ) then
            warnlog( CFN & "Information not saved" )
            iErr = 1
        endif        
        
    catch
        warnlog( CFN & "Failed to access a control after Pos " & iBreakPos )
        hSetCommonProperties() = false
        exit function
    endcatch
    
    if ( iErr = 0 ) then
        printlog( CFN & "Success" )
    endif
    hGetCommonProperties() = true
    
end function
    
