'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: f_basic_modulenames.inc,v $
'*
'*  $Revision: 1.11 $
'*
'*  last change: $Author: jsk $ $Date: 2006/02/08 11:14:01 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'*  owner : joerg.skottke@sun.com
'*
'*  short description : Test modulenames on the tabbar
'*
'*******************************************************************************
'**
' #1 tBasicIdeModuleNames ' Test modulenames on the tabbar
' #1 tInvalidModuleNames  ' Unsupported characters in module names
' #1 tValidModuleNames    ' Basic Keywords, underscore and long module names
' #1 hBasicModuleCreateNew() Go from document to the module naming dialog
'**
'\******************************************************************************

testcase tBasicIdeModuleNames

    '///<h1>Naming conventions in BASIC-IDE module-/dialog-tabs</h1>

    dim cDefaultTabName as string
    dim rc as integer
    dim brc as boolean
    dim i as integer
    const CMODULE = "TModuleNames"

    gApplication = "Writer"
    call hNewDocument()

    ' ------ prerequisites ---------
    
    '///<ul>
    '///<li>Create a new module for the current (writer) document</li>
    brc = hInitBasicIde( CMODULE )

   
    brc = hInsertMacro( 1 )
    if ( rc <> 0 ) then
       warnlog( "Failed to insert macro" )
    endif
   
    '///<li>Verify that the name makes it to the BASIC macro organizer</li>
    cDefaultTabName = hGetTabNameFromOrganizer()

    ' ------ begin test --------    
    
    
    '///<li>Try to name the tab something containing whitespace (should fail)</li>
    rc = hRenameTab( "ttModule X" )
    if ( rc = 1 ) then
       printlog( " * Warning for invalid tab-name. Good." )
       kontext
       if active.exists(5) then
           printlog "" + i + ": '" + active.getText + "'"
           active.ok
       else
           warnlog "missing active"
       endif
       ' Code for trying to find the root cause
       ' this actives loops sometimes without ever getting control over it
       for i = 1 to 3
           kontext
           if active.exists(5) then
               warnlog "" + i + ": '" + active.getText + "'"
               active.ok()
           else
               printlog "missing active"
           endif
       next i
' Would be the workaround to escape, or put this testcase in the end of the .bas file
'       kontext
'       if active.exists(5) then
'           printlog active.getText
'           active.ok
'           warnlog "Can't get rid of active! Hard exit by killing office"
'           killApp
'           sleep 10
'           hStartTheOffice
'           'TODO: JSI Implement the exit from this testcase
'       endif
       
       kontext "basicide"
' Code for trying to find the root cause
'       if basicide.exists(5) then
'       printlog "a"
'       else
'       printlog "b"
'       endif
       tabbar.typekeys( "<ESCAPE>" , true )       
    else
       warnlog( "Warning missing for names containing spaces" )
       printlog( "rc = " & rc )
    endif
    
    
    '///<li>Try to name the tab something that contains - (minus), (should fail)</li>
    rc = hRenameTab( "tt-ModuleX" )
    if ( rc = 1 ) then
       printlog( " * Warning for invalid tab-name. Good." )
       kontext "active"
       active.ok()
       
       kontext "basicide"
       tabbar.typekeys( "<ESCAPE>" , true )
    else
       warnlog( "Warning missing for names containing - (minus)" )
       printlog( "rc = " & rc )
    endif
    
    
    '///<li>Try to name the tab to the current name (should work)</li>
    rc = hRenameTab( cDefaultTabName )
    if ( rc = 0 ) then
       printlog( " * Renaming tab succeeded" )
    else
       warnlog( "Renaming Tab failed" )
       active.ok()
       
       kontext "basicide"
       tabbar.typekeys( "<ESCAPE>" , true )       
    endif

    
    '///<li>Finally try to give the tab a valid name (should work)</li>
    rc = hRenameTab( "GoodName" )
    if ( rc = 0 ) then
       printlog( " * Renaming tab succeeded" )
    else
       warnlog( "Renaming Tab failed" )
       active.ok()
       
       kontext "basicide"
       tabbar.typekeys( "<ESCAPE>" , true )       
    endif
    
    
    '///<li>Verify that we are still in the same IDE-Window</li>
    rc = hTestMacro( 1 )
    if ( rc = 1 ) then
        printlog( " * the correct macro-module is still open. Good." )
    else
        warnlog( "The open macro-module is not the one that was expected" )
    endif
    
    '///<li>Close IDE and document</li>
    hCloseBasicIDE()
    
    call hCloseDocument()
    '///</ul>

endcase

'*******************************************************************************

testcase tInvalidModuleNames

    '///<h1>Module naming conventions: Forbidden characters in module names</h1>

    dim brc as boolean
    dim cMsg as string
    dim iCurrentName as Integer
    
    dim sSeparator as String
    
    dim cModuleName as string

    '///<ul>
    '///+<li>Open a new writer document</li>
    '///+<li>Open the BASIC Macro Organizer</li>
    '///+<li>Select the last module (Document BASIC)</li>
    '///+<li>Click the &quot;New&quot; button</li>
    hBasicModuleCreateNew()

    '///+<li>Try a couple of names including '-', '+', '!', '(' ... <br>
    '///+ -&gt; Invalid name warnings are expected for all of these names</li>
    for iCurrentName = 1 to 19 

        select case iCurrentName
        case 1  : sSeparator = "-"
        case 2  : sSeparator = "."
        case 3  : sSeparator = ","
        case 4  : sSeparator = "+"
        case 5  : sSeparator = ":"
        case 6  : sSeparator = "!"
        case 7  : sSeparator = "$"
        case 8  : sSeparator = "("
        case 9  : sSeparator = ")"
        case 10 : sSeparator = "="
        case 11 : sSeparator = "?"
        case 12 : sSeparator = "*"
        case 13 : sSeparator = " "
        case 14 : sSeparator = "&"
        case 15 : sSeparator = "\"
        case 16 : sSeparator = "/"
        case 17 : sSeparator = "§"
        case 18 : sSeparator = """"
        case 19 : sSeparator = "'"
        case 20 : sSeparator = "@"
        case 21 : sSeparator = CHR$( 387 )
        end select

        cModuleName = "tt" & sSeparator & "module"
        printlog( "" )
        printlog( "Trying module name: " & cModuleName )

        brc = hNameBasicModule( cModuleName )
        
        '///+<li>Check if the Basic-Ide is open (should not be)</li>
        if ( brc ) then
            warnlog( "Basic-Ide should not open for invalid module names" )
            
            ' try to recover and continue for other names
            brc = hCloseBasicIde()
            brc = hDestroyDocument
            brc = hBasicModuleCreateNew()
            
            ' if we cannot recover, exit the test
            if ( not brc ) then
                goto endsub
            endif
        endif

    next iCurrentName

    '///+<li>Close the naming dialog</li>
    printlog( "Close the naming dialog (cancel)" )
    kontext "neuesmodul"
    if ( NeuesModul.Exists() ) then
        NeuesModul.Cancel()
    endif

    '///+<li>Close the macro dialog</li>
    printlog( "Clsoe macro dialog (if it exists)" )
    kontext "makro"
    if ( Makro.Exists() ) then
        Makro.Close()
    endif
    
    '///+<li>Close the last document</li>
    printlog( "Close the document" )
    brc = hDestroyDocument()
    '///</ul>
    
endcase

'*******************************************************************************

testcase tValidModuleNames

    '///<h1>Module naming conventions: Basic keywords, underscores, long names</h1>

    dim brc as boolean
    dim cMsg as string
    dim iCurrentName as Integer
    
    dim sKeyword as String

    '///<ul>
    '///+<li>Open a new writer document</li>
    '///+<li>Open the BASIC Macro Organizer</li>
    '///+<li>Select the last module (Document BASIC)</li>
    '///+<li>Click the &quot;New&quot; button</li>
    hBasicModuleCreateNew()

    '///+<li>Try a couple of basic keywords as module names such as 
    '///+ open, print, select, function etc.</li>
    for iCurrentName = 1 to 9

        select case iCurrentName
        case 1  : sKeyword = "option"
        case 2  : sKeyword = "sub"
        case 3  : sKeyword = "function"
        case 4  : sKeyword = "end"
        case 5  : sKeyword = "exit"
        case 6  : sKeyword = "_underscore1"
        case 7  : sKeyword = "underscore_2"
        case 8  : sKeyWord = "ThisIsQuiteALongNameForAModuleDontYouThink"
        end select

        printlog( "" )
        printlog( "Trying module name: " & sKeyword )

        brc = hNameBasicModule( sKeyword )
        
        '///+<li>Check if the Basic-Ide is open (should not be)</li>
        if ( brc ) then
            
            ' try to recover and continue for other names
            brc = hCloseBasicIde()
            brc = hDestroyDocument
            brc = hBasicModuleCreateNew()
            
            ' if we cannot recover, exit the test
            if ( not brc ) then
                goto endsub
            endif
        endif

    next iCurrentName

    '///+<li>Close the naming dialog</li>
    printlog( "Close the naming dialog (cancel)" )
    kontext "neuesmodul"
    if ( NeuesModul.Exists() ) then
        NeuesModul.Cancel()
    endif

    '///+<li>Close the macro dialog</li>
    printlog( "Clsoe macro dialog (if it exists)" )
    kontext "makro"
    if ( Makro.Exists() ) then
        Makro.Close()
    endif
    
    '///+<li>Close the last document</li>
    printlog( "Close the document" )
    brc = hDestroyDocument()
    '///</ul>
    
endcase

'*******************************************************************************

function hBasicModuleCreateNew() as boolean

    '///<h3>Create a new doc, open Basic organizer, select last module, click New...</h3>
    '///<i>Starting point: The first doc!</i><br>
    '///<u>Input</u>:
    '///<ol>
    '///+<li>Nothing</li>
    '///</ol>
    '///<u>Returns</u>:
    '///<ol>
    '///+<li>Errorcode (boolean) </li>
    '///<ul>
    '///+<li>True if module naming dialog is open</li>
    '///+<li>False on any other condition</li>
    '///</ul>
    '///</ol>
    '///<u>Description</u>:
    '///<ul>

    dim brc as boolean
        brc = false
        
    dim iPos as integer
        
    const CFN = "hBasicModuleCreateNew::"

    '///+<li>Open a new writer document</li>
    gApplication = "Writer"
    brc = hCreateDocument()
    
    '///+<li>Open the BASIC Macro Organizer</li>
    brc = hOpenBasicOrganizerFromDoc()
    if ( not brc ) then
        warnlog( CFN & "Could not open the BASIC Macro Organizer, aborting" )
        hDestroyDocument()
    endif     
    
    '///+<li>Select the last module (Document BASIC)</li>
    if ( brc ) then
        iPos = hSelectTheLastNode( MakroAus )
        if ( not Neu.isEnabled() ) then
            warnlog( CFN & "New button is disabled for the current module, aborting" )
            kontext "Makro"
            Makro.cancel()
            brc = hDestroyDocument()
        endif
    endif 
    
    '///+<li>Click the &quot;New&quot; button</li>
    '///+<li>Verify that the renaming dialog is open</li>
    if ( brc ) then
    
        printlog( "Click 'New'" )
        Neu.Click()
        
        kontext "NeuesModul"
        if ( Neuesmodul.exists() ) then
            brc = true
            printlog( CFN & "Naming dialog is open"
        endif
    endif 
    
    hBasicModuleCreateNew() = brc
    '///</ul>
    
end function
