/* mapProjection.java
 * Copyright (C) 1996 by William Giel
 *
 * E-mail: rvdi@usa.nai.net
 * WWW: http://www.nai.net/~rvdi/home.htm
 *
 ***************************************************************************
 * Abstract
 * --------
 * An abstract base class for mapping projection data and methods.
 ***************************************************************************
 * Permission to use, copy, modify, and distribute this software and its
 * documentation without fee for NON-COMMERCIAL purposes is hereby granted.
 * 
 * THE AUTHOR MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY
 * OF THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. THE AUTHOR SHALL NOT BE LIABLE
 * FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 ***************************************************************************/

import java.awt.*;

import mappingData;


///////////////////////////////////////
// Contains geographic position
///////////////////////////////////////
class geoPos
{
    //geoPos coords are decimal degrees!

    
    public double latitude;
    public double longitude;
    
    geoPos(double phi, double lam)
    {
        latitude=phi;
        longitude=lam;
    }
}
        



abstract class MapProjection
{

    double MAP_SCALE;
    double FALSE_NORTHING;
    double FALSE_EASTING;
    double PRIME_MERIDIAN;
    
    double a;
    double e;

    int ITERATIONS=4;

    MapProjection( mappingData data)
    {
        MAP_SCALE=data.mapScale;
        FALSE_NORTHING=data.falseNorthing;
        FALSE_EASTING=data.falseEasting;
        PRIME_MERIDIAN=data.primeMeridian;
        a=data.semiMajorAxis;
        e=data.eccentricity;
    }

    abstract public Point forward(geoPos latlong);
    abstract public geoPos inverse(Point xy);

}







