'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: extras_drawing_objects.inc,v $
'*
'*  $Revision: 1.4 $
'*
'*  last change: $Author: tbo $ $Date: 2005/09/27 15:02:00 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'*  owner : joerg.skottke@sun.co
'*
'*  short description : Check the drawing objects files
'*
'*******************************************************************************
'**
' #1 tCheck_AllFormatForDrawingObjectFiles ' Check the drawing objects files
'**
'\******************************************************************************

testcase tCheck_AllFormatForDrawingObjectFiles
    Dim j as Integer, i as Integer
    Dim sDatei as String, Farbe5 as String, Farbe16 as String
    Dim lsListe(1000) as String
    Dim Fehler as Boolean
    '///<h1>This test checks all files: They are important to format drawing objects</h1>
    '///<ul>
    '///<li>line styles</li>
    '///<li>arrow styles</li>
    '///<li>area colors</li>
    '///<li>area gradients</li>
    '///<li>area hatchings</li>
    '///<li>area bitmaps</li>
    '///</ul>
    Fehler = FALSE
    printlog "The tested language is :" + gLanguage
    printlog "- Line styles"
    gApplication = "DRAW"
    '///<h3>line styles</h3>
    '///<ul>
    '///<li>open a draw document</li>
    '///<li>format / line</li>
    '///<li>open tabpage 'Line Styles'</li>
    '///</ul>
    Call hNewDocument
    FormatLine

    kontext
    Active.SetPage TabLinienStile
    '///<h3>Test procedure: </h3>
    '///<ul>
    '///<li>click on open and insert the styles files 'standard.sod' and check all entries</li>
    '///<li>click on open and insert the styles files 'styles.sod' and check all entries ( in other languages the filename is translated )</li>

    kontext "tablinienstile"

    for j=1 to 2
        Oeffnen.Click
        if j=1 then
            sDatei = "standard.sod"
        endif

        if j=2 then

            select case iSprache
            case 03   : sDatei = "estilos.sod"
            case 31   : sDatei = "stijlen.sod"
            case 33   : sDatei = "chic.sod"
            case 34   : sDatei = "stilos.sod"
            case 39   : sDatei = "stili.sod"
            case 45   : sDatei = "streger.sod"
            case 46   : sDatei = "stil.sod"
            case 49   : sDatei = "linien.sod"
            case 55   : sDatei = "Linhas.sod"
            case 81   : sDatei = "81styles.sod"
            case 82   : sDatei = "82styles.sod"
            case 86   : sDatei = "86styles.sod"
            case 88   : sDatei = "88styles.sod"
            case else : sDatei = "styles.sod"        ' for 01 and ...
            end select

        endif

        printlog "   - check " + sDatei

        if Dir ( ConvertPath ( gOfficePath + "user\config\" + sDatei ) ) <> "" then

            kontext "oeffnendlg"
            sleep( 1 )
            Dateiname.SetText sDatei
            Oeffnen.Click

            kontext

            if Active.GetRt = 304 then
                Warnlog Active.GetText
                Active.OK
                sleep( 2 )
                Fehler =  TRUE
            endif

            Sleep (2)

            kontext "tablinienstile"

            if Fehler = FALSE then
                ListAllDelete ( lsListe() )

                for i=1 to LinienStil.GetItemCount
                    ListAppend ( lsListe(), LinienStil.GetItemText (i) )
                next i

                hCompareStylesAndFormats ( lsListe(), 1, j )
            endif

        else
            Warnlog sDatei + " does not exists!"
        endif

    next j

    '///<li>load standard.sod for default settings</li>
    printlog "   - load standard.sod for default settings"
    Oeffnen.Click()
    sleep( 1 )

    kontext "oeffnendlg"
    Dateiname.SetText "standard.sod"
    Oeffnen.Click
    '///</ul>
    
    '///<h3>Arrow styles</h3>
    '///<ul>
    '///<li>open tabpage 'Arrow Styles'</li>
    Fehler = FALSE
    printlog Chr(13) + "- Arrow styles"

    kontext
    Active.SetPage TabLinienenden

    kontext "tablinienenden"
    '///<li>click on open and insert the styles files 'standard.soe' and check all entries</li>
    '///<li>click on open and insert the styles files 'arrowhd.soe' and check all entries ( in other languages the filename is translated )</li>

    for j=1 to 2
        Oeffnen.Click
        if j=1 then
            sDatei = "standard.soe"
        endif

        if j=2 then

            select case iSprache
            case 03   : sDatei = "fimlinha.soe"
            case 31   : sDatei = "einden.soe"
            case 33   : sDatei = "extrem.soe"
            case 34   : sDatei = "finlinea.soe"
            case 39   : sDatei = "estrem.soe"
            case 45   : sDatei = "pile.soe"
            case 46   : sDatei = "slut.soe"
            case 49   : sDatei = "enden.soe"
            case 55   : sDatei = "Ptseta.soe"
            case 81   : sDatei = "81arrowhd.soe"
            case 82   : sDatei = "82arrowhd.soe"
            case 86   : sDatei = "86arrowhd.soe"
            case 88   : sDatei = "88arrowhd.soe"
            case else : sDatei = "arrowhd.soe"    ' for 01 and ...
            end select

        endif

        printlog "   - check " + sDatei

        if Dir ( ConvertPath ( gOfficePath + "user\config\" + sDatei ) ) <> "" then

            kontext "oeffnendlg"
            sleep( 1 )
            Dateiname.SetText sDatei
            Oeffnen.Click

            kontext

            if Active.GetRt = 304 then
                Warnlog Active.GetText
                Active.OK
                sleep( 2 )
                Fehler =  TRUE
            endif

            Sleep (2)

            kontext "tablinienenden"

            if Fehler = FALSE then
                ListAllDelete ( lsListe() )

                for i=1 to Liste.GetItemCount
                    ListAppend ( lsListe(), Liste.GetItemText (i) )
                next i

                hCompareStylesAndFormats ( lsListe(), 2, j )
            endif

        else
            Warnlog sDatei + " does not exists!"
        endif

    next j

    '///<li>load standard.soe for default settings</li>
    '///<li>close the 'Arrow styles'-tabpage with 'cancel'</li>
    printlog "   - load standard.soe for default settings"
    Oeffnen.Click()

    kontext "oeffnendlg"
    sleep( 1 )
    Dateiname.SetText "standard.soe"
    Oeffnen.Click

    kontext "tablinienenden"
    TabLinienenden.Cancel
    sleep( 1 )
    '///</ul>
    '///<h3>Colors</h3>
    '///<ul>
    '///<li>Format / Area</li>
    '///<li>activate tabpage 'Colors'</li>
    Fehler = FALSE
    printlog Chr(13) + "- Colors"
    FormatArea

    kontext
    Active.SetPage TabFarben

    kontext "tabfarben"
    '///<li>click on open and insert the styles files 'standard.soc' and check all entries</li>
    '///<li>click on open and insert the styles files 'palette.soc' and check all entries ( in other languages the filename is translated )</li>
    '///<li>click on open and insert the styles files 'cmyk.soc' and check all entries</li>
    '///<li>click on open and insert the styles files 'web.soc' and check all entries</li>
    '///<li>click on open and insert the styles files 'html.soc' and check all entries</li>
    '///<li>click on open and insert the styles files 'gallery.soc' and check all entries</li>
    '///<li>click on open and insert the styles files 'sun-color.soc' and check all entries</li>

    for j=1 to 7
    
        printlog( "534: J = " & j )
    
        select case j
        case 1 : sDatei = "standard.soc"
        case 2 : ' language dependenet filenames

            select case iSprache
            case 03   : sDatei = "cor.soc"
            case 31   : sDatei = "palet.soc"
            case 33   : sDatei = "couleur.soc"
            case 34   : sDatei = "color.soc"
            case 39   : sDatei = "colore.soc"
            case 45   : sDatei = "farver.soc"
            case 46   : sDatei = "faerg.soc"
            case 49   : sDatei = "farben.soc"
            case 55   : sDatei = "Palheta.soc"
            case 81   : sDatei = "81palette.soc"
            case 82   : sDatei = "82palette.soc"
            case 86   : sDatei = "86palette.soc"
            case 88   : sDatei = "88palette.soc"
            case else : sDatei = "palette.soc"        ' for 01 and ...
            end select

        case 3 : sDatei = "cmyk.soc"
        case 4 : sDatei = "web.soc"
        case 5 : sDatei = "html.soc"
        case 6 : sDatei = "gallery.soc"
        case 7 : sDatei = "sun-color.soc"
        end select

        printlog "   - check " + sDatei

        if Dir ( ConvertPath ( gOfficePath + "user\config\" + sDatei ) ) <> "" then

            ' This is the open-button on the color tab-page of the object 
            ' properties dialogue. The File-Open dialog is only called if we
            ' are certain that the file exists. 
            kontext "tabfarben"
            Oeffnen.Click

            kontext "oeffnendlg"
            sleep( 1 )
            Dateiname.SetText sDatei
            Oeffnen.Click

            kontext

            if Active.GetRt = 304 then
                Warnlog Active.GetText
                Active.OK
                sleep( 2 )
                Fehler =  TRUE
            endif

            Sleep (2)

            if Fehler <> TRUE then
                ListAllDelete ( lsListe() )

                kontext "tabfarben"

                for i=1 to Farbe.GetItemCount
                    ListAppend ( lsListe(), Farbe.GetItemText (i) )
                next i

                hCompareStylesAndFormats ( lsListe(), 3, j )
            endif

        else
            Warnlog sDatei + " does not exists!"
            
            ' Need to close the dialog again
            kontext "OeffnenDlg"
            
        endif

    next j
    '///</ul>

    '///<i>load standard.soc for default settings</i>
    printlog "   - load standard.soc for default settings"
    Oeffnen.Click

    kontext "oeffnendlg"
    sleep( 1 )
    Dateiname.SetText "standard.soc"
    Oeffnen.Click
    '///<h3>Gradients</h3>
    '///<ul>
    '///<li>activate tabpage 'Gradients'</li>
    Fehler = FALSE
    printlog Chr(13) + "- Gradients"

    kontext
    Active.SetPage TabFarbverlaeufe

    kontext "tabfarbverlaeufe"
    '///<li>click on open and insert the styles files 'standard.sog' and check all entries</li>
    '///<li>click on open and insert the styles files 'classic.sog' and check all entries ( in other languages the filename is translated )</li>
    '///<li>click on open and insert the styles files 'modern.sog' and check all entries ( in other languages the filename is translated )</li>

    for j=1 to 3

        if j=1 then
            sDatei = "standard.sog"
        endif

        if j=2 then

            select case iSprache
            case 03   : sDatei = "singelo.sog"
            case 31   : sDatei = "klassiek.sog"
            case 33   : sDatei = "classique.sog"
            case 34   : sDatei = "clasico.sog"
            case 39   : sDatei = "classico.sog"
            case 45   : sDatei = "klassisk.sog"
            case 46   : sDatei = "formellt.sog"
            case 49   : sDatei = "klassik.sog"
            case 55   : sDatei = "Classico.sog"
            case 81   : sDatei = "81classic.sog"
            case 82   : sDatei = "82classic.sog"
            case 86   : sDatei = "86classic.sog"
            case 88   : sDatei = "88classic.sog"
            case else : sDatei = "classic.sog"         ' for 01 and ...
            end select

        endif


        if j=3 then

            select case iSprache
            case 03   : sDatei = "actual.sog"
            case 31   : sDatei = "modieus.sog"
            case 33   : sDatei = "moderne.sog"
            case 34   : sDatei = "nuevo.sog"
            case 39   : sDatei = "moderno.sog"
            case 45   : sDatei = "aktuel.sog"
            case 46   : sDatei = "elegant.sog"
            case 49   : sDatei = "aktuell.sog"
            case 55   : sDatei = "Vigente.sog"
            case 81   : sDatei = "81modern.sog"
            case 82   : sDatei = "82modern.sog"
            case 86   : sDatei = "86modern.sog"
            case 88   : sDatei = "88modern.sog"
            case else : sDatei = "modern.sog"          ' for 01 and ...
            end select

        endif

        printlog "   - check " + sDatei

        if Dir ( ConvertPath ( gOfficePath + "user\config\" + sDatei ) ) <> "" then
        
            kontext "TabFarbverlaeufe"
            Oeffnen.Click

            kontext "oeffnendlg"
            sleep( 1 )
            Dateiname.SetText sDatei
            Oeffnen.Click

            kontext

            if Active.GetRt = 304 then
                Warnlog Active.GetText
                Active.OK
                sleep( 2 )
                Fehler =  TRUE
            endif

            Sleep (2)

            kontext "tabfarbverlaeufe"

            if Fehler = FALSE then
                ListAllDelete ( lsListe() )

                for i=1 to Tabelle.GetItemCount
                    ListAppend ( lsListe(), Tabelle.GetItemText (i) )
                next i

                hCompareStylesAndFormats ( lsListe(), 4, j )
            endif

        else
            Warnlog sDatei + " does not exists!"
        endif

    next j
    '///</ul>

    '///<i>load standard.sog for default settings</i>
    printlog "   - load standard.sog for default settings"
    Oeffnen.Click
    sleep( 1 )

    kontext "oeffnendlg"
    Dateiname.SetText "standard.sog"
    Oeffnen.Click
    '///<h3>Hatchings</h3>
    '///<ul>
    '///<li>activate tabpage 'Gradients'</li>
    Fehler = FALSE
    printlog Chr(13) + "- Hatchings"

    kontext
    Active.SetPage TabSchraffuren

    kontext "tabschraffuren"
    '///<li>click on open and insert the styles files 'standard.soh' and check all entries</li>
    '///<li>click on open and insert the styles files 'hatching.soh' and check all entries ( in other languages the filename is translated )</li>

    for j=1 to 2

        if j=1 then
            sDatei = "standard.soh"
        endif

        if j=2 then

            select case iSprache
            case 03   : sDatei = "sombread.soh"
            case 31   : sDatei = "arcer.soh"
            case 33   : sDatei = "hachures.soh"
            case 34   : sDatei = "tramas.soh"
            case 39   : sDatei = "tratto.soh"
            case 45   : sDatei = "skraveringer.soh"
            case 46   : sDatei = "moenster.soh"
            case 49   : sDatei = "schraffu.soh"
            case 55   : sDatei = "PreenchimentoDePadrao.soh"
            case 81   : sDatei = "81hatching.soh"
            case 82   : sDatei = "82hatching.soh"
            case 86   : sDatei = "86hatching.soh"
            case 88   : sDatei = "88hatching.soh"
            case else : sDatei = "hatching.soh"      ' for 01 and ...
            end select

        endif

        printlog "   - check " + sDatei

        if Dir ( ConvertPath ( gOfficePath + "user\config\" + sDatei ) ) <> "" then
        
            kontext "TabSchraffuren"
            Oeffnen.Click

            kontext "oeffnendlg"
            sleep( 1 )
            Dateiname.SetText sDatei
            Oeffnen.Click

            kontext

            if Active.GetRt = 304 then
                Warnlog Active.GetText
                Active.OK
                sleep( 2 )
                Fehler =  TRUE
            endif

            Sleep (2)

            kontext "tabschraffuren"

            if Fehler = FALSE then
                ListAllDelete ( lsListe() )

                for i=1 to Tabelle.GetItemCount
                    ListAppend ( lsListe(), Tabelle.GetItemText (i) )
                next i

                hCompareStylesAndFormats ( lsListe(), 5, j )
            endif

        else
            Warnlog sDatei + " does not exists!"
        endif

    next j
    '///</ul>

    '///<i>load standard.soh for default settings</i>
    printlog "   - load standard.soh for default settings"
    kontext "TabSchraffuren"
    Oeffnen.Click

    kontext "oeffnendlg"
    sleep( 1 )
    Dateiname.SetText "standard.soh"
    Oeffnen.Click
    '///<h3>Bitmaps</h3>
    '///<ul>
    '///<li>activate tabpage 'Bitmaps'</li>
    Fehler = FALSE
    printlog Chr(13) + "- Bitmaps"

    kontext
    Active.SetPage TabBitmap

    kontext "tabbitmap"
    '///<li>click on open and insert the styles files 'standard.sob' and check all entries</li>

    for j=1 to 1
    
        Oeffnen.Click
        
        if j=1 then
            sDatei = "standard.sob"
        endif
        
        printlog "   - check " + sDatei

        kontext "oeffnendlg"
        sleep( 1 )
        Dateiname.SetText sDatei
        Oeffnen.Click

        kontext

        if Active.GetRt = 304 then
            Warnlog Active.GetText
            Active.OK
            sleep( 2 )
            Fehler =  TRUE
        endif

        Sleep (2)

        kontext "tabbitmap"

        if Fehler = FALSE then
            ListAllDelete ( lsListe() )

            for i=1 to Tabelle.GetItemCount
                ListAppend ( lsListe(), Tabelle.GetItemText (i) )
            next i

            hCompareStylesAndFormats ( lsListe(), 6, j )
        endif

    next j
    '///</ul>

    '///<i>load standard.sob for default settings</i>
    printlog "   - load standard.sob for default settings"
    kontext "tabbitmap"
    Oeffnen.Click

    kontext "oeffnendlg"
    sleep( 1 )
    Dateiname.SetText "standard.sob"
    Oeffnen.Click
    '///<ul>
    '///<li>close the 'bitmap'-tabpage with 'cancel'</li>

    kontext "tabbitmap"
    TabBitmap.Cancel
    '///<li>close the draw-document</li>
    '///</ul>
    Call hCloseDocument
    
    skip_test:
    
endcase
