'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: filedlg_filenames2.bas,v $
'*
'*  $Revision: 1.5 $
'*
'*  last change: $Author: jsk $ $Date: 2005/11/30 09:42:42 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
' **
' ** owner : joerg.skottke@sun.com
' **
' ** short description : check special filenames and destinations
' **
'\******************************************************************************

sub main

   use "framework\filedlg\inc\filename_tools.inc"
   use "framework\filedlg\inc\filename1.inc"
   use "framework\tools\inc\docfuncs.inc"
   use "framework\tools\inc\filetools.inc"
   use "framework\tools\inc\stringtools.inc"
   
   dim iCounter    as integer ' increment
   dim iFileCount  as integer ' Number of files in the current workdirectory
   dim cCurrentApp as string  ' the active application before start of this test

   call hStatusIn ( "framework", "filedlg_filenames2.bas", "check exotic filenames" )

   dim starttime
       starttime = now()

   cCurrentApp = gApplication()

   iFileCount = hgetFileCount() ' get the number of files in the current workdir

   ' check saving files to reserved names on Windows in the main
   ' applications. All operations here are expected to fail for Windows
   ' On UNIX those limitations don't exist, so these files are expected
   ' to be saved/loaded and deleted correctly.

   for iCounter = 2 to 2
      if ( gPlatGroup = "w95" ) then
         printlog( " " + CHR$(13) + hNumericDoctype( iCounter ) )
         call tSaveReservedNamesWin()  ' reserved names like printerports etc.
      else
         printlog( " " + CHR$(13) + hNumericDoctype( iCounter ) )
         call tSaveReservedNamesUNIX() ' should not be identified as such
      end if
   next iCounter

   ' restore old settings
   gApplication = cCurrentApp
   call ExitRestartTheOffice()

   ' Check if all workfiles have been deleted (if not this might be a bug!)
   if ( hGetFileCount() > iFileCount ) then
      qaerrorlog( "Not all workfiles have been deleted. Please check manually." )
      endif

   ' time it took the test to complete / database
   printlog Chr(13) + "End : " + WieLange ( starttime )
   call hStatusOut()

end sub

' ****************************************

sub LoadIncludeFiles

   use "global\system\inc\master.inc"
   use "global\system\inc\gvariabl.inc"
   gApplication = "WRITER"
   Call GetUseFiles

end sub
