'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: help_compare_content.inc,v $
'*
'*  $Revision: 1.4 $
'*
'*  last change: $Author: jsk $ $Date: 2005/12/15 12:31:18 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : joerg.skottke@sun.com
'*
'* short description : 
'*
'*******************************************************************************
' **
' #1 tCompareHelpContent   ' Verify the Content-Treelist on the Content page
' **
'\******************************************************************************

testcase tCompareHelpContent()

    '///<h1>Compare the help content in the Help-Viewer against a reference</h1>
    '///<h2>help_compare_content::tCompareHelpContent</h2>
    '///<ul>
    '///+<li>Open the Help-Viewer</li>
    '///+<li>Go to the Content-Page</li>
    '///+<li>Read all entries in the Content-Treelist</li>
    '///+<li>Close the Help</li>
    '///+<li>Compare the list to a reference</li>
    '///</ul>
    
    ' file related variables
    dim sFileOut as string
    dim sFilein as string
    dim sFileName as string
    
    ' the array that holds the names of the applications
    dim aTopicsFromUI( 1200 ) as string 
    
    ' some incremant variables and temporary stuff
    dim iTopicsFromUI as integer
    dim iCurrentItem as integer
    dim sCurrentItem as string
    dim irc as integer
    
    ' define input and output paths, presetting variables
    sFileName = "help_content" & iSprache & ".txt"
    sFileOut = hGetWorkFile( sFilename )
    sFileIn  = gTesttoolPath & "framework\help\input\help_content"  
    sFileIn  = hGetInputPath( sFileIn , sFileName )
    if ( sFileIn = "" ) then
        warnlog( "Invalid path created, test aborts." )
        goto endsub
    endif
    
    aTopicsFromUI( 0 ) = "0"
    
    ' get the names from the listbox
    call hOpenHelp()
    hSelectHelpTab( "content" )
    
    ' find out, how many items we have in the list
    iTopicsFromUI = hExpandAllNodes( SearchContent ) 
    printlog( "Reading " & iTopicsFromUI & " items from Content Treelist" )
    
    ' get all topics from the contents-treelist
    hGetVisibleNodeNames( SearchContent , aTopicsFromUI() )
 
    call hCloseHelp()
    
    ' Compare the list against a reference or create a new list, if the 
    ' reference does not exist
    printlog( "" )
    printlog( "Beginning comparision" )
    irc = hManageComparisionList( sFileIn, sFileOut, aTopicsFromUI() )
    if ( irc <> 0 ) then
	warnlog( "Something went wrong, please review the log." )
    endif
    
endcase


