'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: l1_ole3.inc,v $
'*
'*  $Revision: 1.11 $
'*
'*  last change: $Author: tbo $ $Date: 2005/12/14 12:56:41 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : thorsten.bosbach@sun.com
'*
'* short description : 
'*
'*******************************************************************************
' **
' #1 tDraw_as_OLE_Object
' #1 tCalc_as_OLE_Object
' #1 tChart_Math_as_OLE_Object
' **
'\******************************************************************************

testcase tDraw_as_OLE_Object
    const ICWAIT as Integer = 1
    dim sFile as String
    dim sExtension as String
    
    '///Test a Draw-OLE-Object in Writer / Calc / Draw / Masterdocument
    PrintLog "    Draw as OLE-Object"
    '///open a new document ( Writer / Calc / Draw / Masterdocument )
    Call hNewDocument
    PrintLog "    - insert"
    '///+insert / object / OLE-object
    InsertObjectOLEObject
        Kontext "OLEObjektEinfuegen"
        if OLEObjektEinfuegen.exists(5) then
            printlog( "    - select 'create new'" ) '///+select 'create new'
            NeuErstellen.Check
            '///+select the draw-OLE-object ( you can find the name for each language at [TesttoolPath]/global/input/olenames/ole_[lang-code].txt )
            printlog( "    - select objecttype" )
            ObjektTyp.Select( gOLEDraw )
            printlog( "    - click OK" )'///+click 'OK'
            OLEObjektEinfuegen.OK
            sleep( ICWAIT * 5 )
        else
            warnlog "OLEObjektEinfuegen doesn't exists"
        endif

    call OLERemoveFocus
    PrintLog "    - save"  '///+file / save -> in a local directory
    try
        FileSave
    catch
        warnlog( "Could not access Filesave. Selection is still on OLE object" )
        call sendescape(1)
        FileSave
    endcatch
    call UncheckAutoFileExtension

    call getExtension(sExtension)
    sFile = ConvertPath ( gOfficePath + "user\work\ole_impr" + sExtension )
    if (app.Dir(sFile) <> "") then 
        app.kill( sFile )
    endif

    Dateiname.SetText(sFile)
    Speichern.Click

    Kontext "Active"
    If Active.Exists(5) then
        printlog "Active: '" + active.getText + "'"
        try
            Active.Yes
            printlog "- used YES button"
        catch
            Active.Ok
            printlog "- used OK button"
        endcatch
    endif
    sleep( ICWAIT * 3 )

    printlog( "    - Close the document" )'///+Close the document
    hCloseDocument()

    PrintLog "    - open"'///+file / open => the saved file
    hDateiOeffnen(sFile)
    if isOleAvailable() then
        ' there are OLE-Objects available
        '///+disbale the navigator if it exists 
        call DisableNavigator()
        '///+set focus to OLE object
        call OLESetFocus()
        '///+remove focus from OLE object
        call SendEscape()
    else
        qaErrorLog "#i44725# OLE Object not saved in Master Document"
    endif
    sleep( ICWAIT * 5 )
    '///+Close the document
    printlog( "    - Close the document" )
    hCloseDocument()
endcase

'*******************************************************************************

testcase tCalc_as_OLE_Object
    '///Test a Calc-OLE-Object in Writer / Calc / Draw / Masterdocument
    Dim sFile as String
    Dim sExtension as String
    
    PrintLog "    Calc as OLE-Object"
    
    '///+Open a new document
    printlog( "    - Open a new document" )
    hNewDocument
    
    PrintLog "    - insert"
    '///+insert / object / OLE-object
    InsertObjectOLEObject
    Kontext "OLEObjektEinfuegen"
    if OLEObjektEinfuegen.exists(5) then
        '///+select 'create new'
        printlog( "    - check 'create new'" )
        NeuErstellen.Check()
        
        '///+select the Calc-OLE-object 
        ' ( you can find the name for each language at 
        '   [TesttoolPath]/global/input/olenames/ole_[lang-code].txt )
        printlog( "    - select Spreadsheet" )
        ObjektTyp.Select( gOLECalc )
        
        '///+click 'OK' to accept and close the dialog
        printlog( "    - press OK" )
        OLEObjektEinfuegen.OK
    else
        warnlog "tCalc_as_OLE_Object:: Dialog open failed: Insert->Object->OLEObject"
    endif
    sleep(2)
    
    call SendEscape() ' just sends the keystroke <ESC> to the document
    
    PrintLog "    - save"
    FileSave
    Kontext "SpeichernDlg"
    if SpeichernDlg.exists(5) then
        '///+file / save -> in a local directory
        call UncheckAutoFileExtension()
        sExtension = getExtension()
        sFile = ConvertPath ( gOfficePath + "user\work\ole_calc" + sExtension )
        printlog( "    - delete the file if it exists" )
        if app.Dir ( sFile ) <> "" then 
            app.kill( sFile )
        endif 
        printlog( "    - name the file" )
        Dateiname.SetText( sFile )
        printlog( "    - save the file by pressing 'save'" )
        Speichern.Click

        Kontext "Active"
        try
            If Active.Exists(5) then 
                printlog( "    - close the warning: '" + active.getText + "'")
                Active.Yes
            endif
        catch
            If Active.Exists then 
                Active.OK
            endif
        endcatch
    else
        warnlog( "l1_ole3::tCalc_as_OLE_Object SaveAs Dialog not open." )
    endif
    
    '///+Close the document
    printlog( "    - Close the document" )
    hCloseDocument
    
    '///+file / open => the saved file
    PrintLog "    - reopen it"
    hDateiOeffnen(sFile)
    sleep(2)
    
    '///+activate the OLE-Object (with doubleclick or accessibility shortcuts)
    '///+and deactivate the Editmode with 'Escape'
    PrintLog "    - activate OLE-Object"
    if isOleAvailable() then
        '///+disable the navigator if it exists
        call DisableNavigator()
        call OLESetFocus3()
    else
        qaErrorLog "#i44725# OLE Object not saved in Master Document"
    endif
    sleep(5)
    
    '///+Close the document
    printlog( "    - Close the document" )
    hCloseDocument
endcase

'*******************************************************************************

testcase tChart_Math_as_OLE_Object ( OLEApp )

   '///Test a Chart- or Math-OLE-Object in Writer / Calc / Draw / Impress / Masterdocument
   'dim sPath as String 
   dim sFile as String
   dim sExtension as String
   const ICWAIT as Integer = 2 

   PrintLog "    " + OLEApp + " as OLE-Object"

   '///+Open a new document
   printlog( "    - Open a new document" )
   hNewDocument

   If gApplication = "WRITER" then
      If OLEApp = "MATH" then
         Kontext "DocumentWriter"
         DocumentWriter.TypeKeys( "<TAB>", 3 , TRUE )
      end if
   end if

   If gApplication = "GLOBALDOC" then
      If OLEApp = "MATH" then
         Kontext "DocumentMasterDoc"
         DocumentMasterDoc.TypeKeys( "<TAB>", 3 , TRUE )
      end if
   end if

   PrintLog "    - insert"
   '///+insert / object / OLE-object
   InsertObjectOLEObject

   Kontext "OLEObjektEinfuegen"
   '///+select 'create new'
   NeuErstellen.Check()

   '///+select the Chart- or Math-OLE-object ( you can find the name for each language at [TesttoolPath]/global/input/olenames/ole_[lang-code].txt )
   select case OLEApp
      case "CHART" : ObjektTyp.Select( gOLEChart )
      case "MATH"  : ObjektTyp.Select( gOLEMath )
   end select

   '///+click 'OK'
   OLEObjektEinfuegen.OK()

   Sleep( ICWAIT )

   if gApplication = "GLOBALDOC" then
      Kontext "DocumentMasterDoc"
      DocumentMasterDoc.MouseDoubleClick ( 99 , 99 )
   else
      gMouseClick ( 99 , 99 )
   end if

   '///+file / save -> in a local directory
   PrintLog "    - save"
   FileSave

   call UncheckAutoFileExtension()
   call getExtension( sExtension ) 

   select case OLEApp
     case "CHART" : 
        sFile = ConvertPath ( gOfficePath + "user\work\ole_char" + sExtension )
     case "MATH"  : 
        sFile = ConvertPath ( gOfficePath + "user\work\ole_math" + sExtension )
   end select

   if app.Dir ( sFile ) <> "" then 
       app.kill( sFile )
   endif

   Sleep( ICWAIT )

   Dateiname.SetText( sFile )
   Speichern.Click()

   Kontext "Active"
   try
      If Active.Exists then Active.Yes()
   catch
      If Active.Exists then Active.Ok()
   endcatch

   Sleep( ICWAIT )

   '///+Close the document
   printlog( "    - Close the document" )
   hCloseDocument

   '///+file / open => the saved file
   PrintLog "    - open"
    hDateiOeffnen(sFile)

    if isOleAvailable() then
        '///+disable the navigator if it exists
        call DisableNavigator()
        call OLESetFocus2()
        call SendEscape()
    else
        qaErrorLog "#i44725# OLE Object not saved in Master Document"
    endif

   '///+Close the document
   printlog( "    - Close the document" )
   hCloseDocument
endcase

function isOleAvailable() as boolean
    dim i as integer
    dim a as integer

    isOleAvailable = FALSE
    ' check if OLE-Objects are in the document with the navigator
    kontext "NavigatorGlobaldoc"
    if NavigatorGlobaldoc.exists(1) then
        printlog "Navigator globaldoc was available"
        if NOT AuswahlListe.exists then
            Umschalten.click
        endif
        a = AuswahlListe.getItemCount
        ' somehow not all items might be displayed
        if NOT (a>2) then
            inhaltsansicht.click
            i = AuswahlListe.getItemCount
            if NOT(i>a) then
                inhaltsansicht.click
            else
                a = i
            endif
        endif
        AuswahlListe.typeKeys("<home>")
        sleep 1
        'fold everything
        for i = 1 to a
            AuswahlListe.typeKeys("-<down>")
        next i
        ' unfold everything, until there is something to unfold
        ' then we found the object we looked for: OLE
        AuswahlListe.typeKeys("<home>")
        sleep 1
        i = 0
        a = AuswahlListe.getItemCount
        ' don't run indefinite
        while ((AuswahlListe.getItemCount = a) AND (i < a))
            AuswahlListe.typeKeys("+<down>")
            inc(i)
        wend
        printlog a
        printlog i
        try
            printlog AuswahlListe.getSelText
        catch
            qaerrorlog "no item in navigator is selected"
        endcatch
        ' activate object
        AuswahlListe.typeKeys("<return>")
        i = AuswahlListe.getItemCount
        printlog i
        if (i > a) then
            isOleAvailable = TRUE
        else
            isOleAvailable = FALSE
        endif
    else
        Kontext "NavigatorWriter"
        if NOT NavigatorWriter.exists(1) then
            EditNavigator
        endif
        Kontext "NavigatorWriter"
    if NavigatorWriter.exists(5) then
        printlog "Navigator writer was available"
        if NOT AuswahlListe.exists then
            Umschalten.click
        endif
        a = AuswahlListe.getItemCount
        ' somehow not all items might be displayed
        if NOT (a>2) then
            inhaltsansicht.click
            i = AuswahlListe.getItemCount
            if NOT(i>a) then
                inhaltsansicht.click
            else
                a = i
            endif
        endif
        AuswahlListe.typeKeys("<home>")
        sleep 1
        'fold everything
        for i = 1 to a
            AuswahlListe.typeKeys("-<down>")
        next i
        ' unfold everything, until there is something to unfold
        ' then we found the object we looked for: OLE
        AuswahlListe.typeKeys("<home>")
        sleep 1
        i = 0
        a = AuswahlListe.getItemCount
        ' don't run indefinite
        while ((AuswahlListe.getItemCount = a) AND (i < a))
            AuswahlListe.typeKeys("+<down>")
            inc(i)
        wend
        try
            printlog AuswahlListe.getSelText
        catch
            qaerrorlog "no item in navigator is selected"
        endcatch
        i = AuswahlListe.getItemCount
        ' activate object
        AuswahlListe.typeKeys("<return>")
        if (i > a) then
            isOleAvailable = TRUE
        else
            isOleAvailable = FALSE
        endif
    else
    kontext "NavigatorDraw"
    if NavigatorDraw.exists(5) then
        printlog "Navigator draw was available"
    else
        EditNavigator
    endif
    kontext "NavigatorDraw"
    if NavigatorDraw.exists(5) then
        printlog "Navigator draw was available."
        if NOT Liste.exists then
            Umschalten.click
        endif
        Liste.typeKeys("<home>")
        sleep 1
        'fold everything
        a = Liste.getItemCount
        for i = 1 to a
            Liste.typeKeys("-<down>")
        next i
        ' unfold everything, until there is something to unfold
        ' then we found the object we looked for: OLE
        Liste.typeKeys("<home>")
        sleep 1
        i = 0
        a = Liste.getItemCount
        ' don't run indefinite
        while ((Liste.getItemCount = a) AND (i < a))
            Liste.typeKeys("+<down>")
            inc(i)
        wend
        try
            printlog Liste.getSelText
        catch
            qaerrorlog "no item in navigator is selected"
        endcatch
        i = Liste.getItemCount
        if (i > a) then
            isOleAvailable = TRUE
        else
            isOleAvailable = FALSE
        endif
    else
        ' no globaldoc
        ' check if something is selected
        try
            EditCopy
            printlog "Something was selected; executed Edit->Copy"
            isOleAvailable = TRUE
        catch
            qaErrorLog "Nothing is selected."
            isOleAvailable = FALSE
        endcatch
    endif
    endif
    endif
end function
