'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: opt_ooo_java.inc,v $
'*
'*  $Revision: 1.8 $
'*
'*  last change: $Author: tbo $ $Date: 2005/11/15 14:02:08 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : thorsten.bosbach@sun.com
'*
'* short description : Tools->Options: OpenOffice.org Java
'*
'*******************************************************************************
'**
' #1 tOOoJava
'**
'\******************************************************************************

testcase tOOoJava
    dim bJavaState as boolean

    '///Options test for Java settings
    '///<ul>
    ToolsOptions
    hToolsOptions( "StarOffice", "Java" )

    '///<li>Make sure Java is enabled. If it is not: Fix this</li>
    printlog( "Verify that Java is enabled and configured" )
    if ( usejava.isChecked() = false ) then
        warnlog( "Java should be enabled by default, checking and restarting" )
        bJavaState = hChangeJavaState( true )
        if ( bJavaState = false ) then
            warnlog( "Java is still not enabled, aborting test." )
            kontext "OptionenDlg"
            OptionenDlg.cancel()
            goto endsub
        endif
    else
        printlog( "   Java is enabled. Good." )
    endif
    
    ' Needs a delay, it might take some time until the listbox gets populated
    sleep( 3 )
    
    ' There should be a java-runtime installed. If not -> leave test
    '///<li>Make sure Java at least one Java runtime is installed</li>
    printlog( "Make sure at least one Java runtime is installed" )
    if ( javalist.getitemcount() = 0 ) then
        warnlog( "No java listed in listbox, the test will stop" )
        kontext "OptionenDlg"
        OptionenDlg.cancel()
        goto endsub
    else
        printlog( "   Java is installed, good." )
    endif
    
    printlog( "Quickly test that all controls are active" )
    '///<li>Verify that all controls are active</li></ul>
    if ( add.isEnabled() ) then
        printlog( "   'Add...' is enabled" )
    else
        warnlog( "The 'Add...' button is disabled" )
    endif
    
    if ( parameters.isEnabled() ) then
        printlog( "   'Parameters...' is enabled" )
    else
        warnlog( "The 'Parameters...' button is disabled" )
    endif

    if ( classpath.isEnabled() ) then
        printlog( "   'Class Path...' is enabled" )
    else
        warnlog( "The 'Class Path...' button is disabled" )
    endif
    
    if ( JavaList.isEnabled() ) then
        printlog( "   'JavaList' is enabled" )
    else
        warnlog( "The 'JavaList' button is disabled" )
    endif
    
    kontext "OptionenDlg"
    OptionenDlg.ok
endcase

'*******************************************************************************

function hChangeJavaState( bEnable as boolean ) as boolean
    ' this little fella switches Java support on and off including a restart of
    ' the office to make the change active. The state is returned

    if ( bEnable ) then
        printlog( "   Enable Java" )
        usejava.check()
    else
        printlog( "   Disable Java" )
        useJava.unCheck()
    endif
        
    ' leave tools/options
    printlog( "   Leave Tools/Options" )
    kontext "OptionenDlg"
    OptionenDlg.ok()
        
    ' restart the office to make the change take effect
    printlog( "   Restart the application" )
    call exitRestartTheOffice()
        
    ' return to java page
    printlog( "   Return to Tools/Options Java-page" )
    ToolsOptions
    hToolsOptions( "StarOffice", "Java" )
    kontext "TabJava"
    
    if ( useJava.isChecked() ) then
        hChangeJavaState() = true
    else
        hChangeJavaState() = false
    endif
end function
