'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: f_sec_incorrect_password.inc,v $
'*
'*  $Revision: 1.10 $
'*
'*  last change: $Author: tbo $ $Date: 2005/09/27 15:12:40 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'*  owner : joerg.skottke@sun.com
'*
'*  short description : Password protect files
'*
'*******************************************************************************
'**
' #1 tIncorrectPassword ' Save and load files with non-matching password
'**
'\******************************************************************************

testcase tIncorrectPassword( filetypeID as string )

    '///<H1>Save and load files with incorrect password</H1>
    '///This test saves a file from each application with a password. Then the 
    '///document is closed and reloaded. When prompted an icorrect password is
    '///entered. The document will not be loaded then, an error is displayed.
   
    dim workfile as string
        workfile = "password" & hGetSuffix( filetypeID )
        printlog( " * Name of workfile: " & workfile )

    dim workpath as string
        workpath = convertpath( gOfficePath & "user\work\" )
        printlog( " * Save file to: " & workpath )

    dim rc as integer
    dim brc as boolean
    
    '///<ul>
    '///<li>Delete the workfile (just in case it still exists from prior run)</li>
    printlog( "Delete the workfile - if it was left over by a former testrun" )
    hDeleteFile( workpath & workfile )    

    '///<li>Open a new document</li>
    printlog( "Open a new document" )
    call hNewDocument()

    '///<li>Change the document so the 'save' button becomes active</li>
    printlog( "Change the document" )
    call hChangeDoc()

    ' a small delay for impress, it takes a little longer to get the "save" button
    ' active
    if ( gApplication = "IMPRESS" ) then
        printlog( "Extra delay for impress : 2 seconds" )
        sleep( 2 )
    endif

    '///<li>Click on FileSave</li>
    printlog( "Click on FileSave" )
    FileSave

    Kontext "SpeichernDlg"
    '///<li>Check the password-checkbox, name the file and click 'Save'</li>
    printlog( "Check the password checkbox" )
    Passwort.check()
    printlog( "Disable automatic filename extension" )
    AutomatischeDateinamensErweiterung.unCheck()
    printlog( "Name the file as " & workpath & workfile )
    Dateiname.settext( workpath & workfile )
    printlog( "Click <save>" )
    Speichern.click()

    sleep( 1 )

    Kontext "Active"
    if ( active.exists() ) then
        warnlog( "Unexpected active: " & active.gettext() )
    endif   

    sleep( 1 )

    '///<li>On the password-dialog enter a password and confirm it</li>
    printlog( "On the password dialog enter " & workfile & " twice and confirm" )
    Kontext "passwordDlg"
    if ( passworddlg.exists() ) then
        password.setText( workfile )
        passwordConfirm.setText( workfile )
        passwordDlg.ok()
        rc = 0  ' all went as expected
    else
        rc = 1  ' the dialog did not show up
    endif
    


    ' continue if everything is still ok
    '///<li>Close the document</li>
    if ( rc = 0 ) then

        ' status: all dialogs are closed, we are on the workfile-document
        printlog( "Close the document" )
        call hCloseDocument()
        
        sleep( 3 )

        ' there may only be one open document (the first doc)
        brc = hCheckDocCount( 1 , true )

        ' set the errorcode if too many documents are open
        if ( not brc ) then
            rc = 1
        endif
        
    endif



    '///<li>Load the file again, when prompted enter 'blafasel' as password</li>
    if ( rc = 0 ) then

        printlog( "Load the file again" )
        hLoadFile ( workpath & workfile )
        hHandleActivesOnLoad( 0 , 2 )

        kontext "PasswordFileOpen"
        printlog( "On password dialog: Enter incorrect password (e.g. blafasel)" )
        if ( passwordFileOpen.exists() ) then
            passwortName.setText( "blafasel" )
            passwordFileOpen.ok()
        else
            warnlog( "The password-dialog is missing!" )
            rc = 1 
        endif

    endif

    ' now there must be a warning, that the incorrect password was entered
    '///<li>Confirm the warning that the password was incorrect</li>
    sleep( 1 )
    kontext "active"
    if ( active.exists() ) then
        printlog( "Warning is displayed, confirm with OK" )
        printlog( active.getText() )
        active.ok()
        rc = 0
    else
        warnlog( "There is no warning for incorrect password" )
        rc = 1
    endif


    '///<li>Verify that only one document is open</li>
    printlog( "Verify that only one document is open" )
    if ( rc = 0 ) then
        brc = hCheckDocCount( 1 , false ) 
        if ( not brc ) then
            rc = 1 
        endif
    else
        brc = hCheckDocCount( 1 , true )
        rc = 1
    endif

    '///<li>If two documents are open, this is an error</li>
    if ( rc = 1 ) then
        printlog( "Closing unexpected second document to recover" )
        call hCloseDocument()
    endif
    
    '///<li>Verify that the last open document is 'The first doc' </li>
    printlog( "Verify that the last open document is 'The first doc'" )
    hIdentifyWriterDoc( "The first doc!" , true )

    '///<li>Delete the workfile</li>
    printlog( "Delete the workfile" )
    hDeleteFile( workpath & workfile )

endcase

