'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: macro_tools.inc,v $
'*
'*  $Revision: 1.2 $
'*
'*  last change: $Author: jsk $ $Date: 2006/01/05 13:07:14 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
' **
' ** owner : joerg.skottke@sun.com
' **
' ** short description : Helper functions for Macro tests
' **
'*******************************************************************************
' **
' #1 hCreateBasicMacro  ' Creates a BASIC Macro (taken from file)
' #1 hMacroImport       ' Import a macro from a source file
' #1 hMacroPaste        ' Paste the macro into the Basic IDE
' **
'\******************************************************************************

function hCreateBasicMacro( iMacroId as integer,
                            iImportMethod as integer ) as boolean
                            
    '///<h3>Function not yet used</h3>
    '///<u>This function will replace hInsertMacro in the future</u>

    const CFN = "hCreateBasicMacro::"

    dim cMID as string
    dim cIM as string
    dim brc as boolean
        brc = false
    dim iLineCount as integer
    
    dim aRefList( 200 ) as string
    
    dim cFileIn as string
        cFileIn = gTesttoolPath() & "framework\tools\input\macros.txt"
        cFileIn = ConvertPath( cFileIn )
    
    dim cFileOut as string
        cFileOut = hGetWorkPath() & "macro.txt"
        
    select case iMacroId
    case 1 : cMID = "TTMacro1"
    case 2 : cMID = "TTMacro2"
    case 3 : cMID = "TTMacro3"
    case 4 : cMID = "MessageBoxes"
    case default
         warnlog( CFN & "Invalid MacroID: " & iMacroID )
         hCreateBasicMacro() = brc
         exit function 
    end select
    
    iLineCount = hGetDatafileSection( cFileIn, aRefList(), cMID , "" , "" )
    printlog( CFN & "Read " & iLineCount & " lines from macro source" )
    
    select case iImportMethod
    case 1 : cIM = "Import macro from file"
             brc = hMacroImport( aRefList() , cFileOut )
    case 2 : cIM = "Paste macro from ClipBoard"
             brc = hMacroPaste( aRefList() )
    case 3 : cIM = "Type macro"
             brc = hMacroType( aRefList() )
    case default
         warnlog( CFN & "Invalid Import Method: " & iImportMethod )
         hCreateBasicMacro() = brc
         exit function 
    end select
     
    hCreateBasicMacro() = brc 
    
end function

'*******************************************************************************

function hMacroImport( aMacroList() , cFileOut ) as boolean

    '///<h3>Function not yet used</h3>
    '///<u>This function will replace hInsertMacro in the future</u>

    dim brc as boolean

    hDeleteFile( cFileOut )
    call ListWrite( aMacroList() , cFileOut , "UTF8" )
    
    Kontext "BasicIDE"
    brc = hDeleteMacro()

    Kontext "MacroBar"
    InsertSourceText.click()
    
    Kontext "DateiOeffnen"
    DateiName.setText( cFileOut )
    Oeffnen.click()
    
    hDeleteFile( cFileOut )
    
end function    

'*******************************************************************************

function hMacroPaste( aMacroList() )

    '///<h3>Function not yet used</h3>
    '///<u>This function will replace hInsertMacro in the future</u>

    dim brc as boolean
    dim iThisLine as integer
    dim iLineCount as integer
        iLineCount = ListCount( aMacroList() )
    
    Kontext "BasicIDE"
    brc = hDeleteMacro()
    
    for iThisLine = 1 to iLineCount
    
        setClipBoard

end function

