'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: declare.inc,v $
'*
'*  $Revision: 1.10 $
'*
'*  last change: $Author: tbo $ $Date: 2005/09/27 15:13:45 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : thorsten.ziehm@sun.com
'*
'* short description : starting routines for declare.bas
'*
'*****************************************************************
'*
' #1 GetUseFiles
' #1 LoadDeclaration
' #1 TestEnter
' #1 TestExit
' #1 hOfficeStarten
'*
'\****************************************************************

' *****************************************************************
'  ruft alle wichtigen Startroutinen auf
'
sub GetUseFiles()
'///
   Use "global\system\inc\sysinfo.inc"
   Use "global\system\inc\inivalue.inc"
   Use "global\system\inc\iniinfo.inc"

   Use "global\tools\inc\t_xml1.inc"         ' XML-Parse-Routinen
   Use "global\tools\inc\t_tools2.inc"
   Use "global\tools\inc\t_lists.inc"        ' Listenbearbeitung

   Call LoadDeclaration                  ' Deklarationen einlesen ( master.inc )
   Call GetToolPlatform                  ' Plattform und Pfade des Testtools bestimmen ( sysinfo.inc )
   Call GetOfficePlatform                ' Plattform und Pfade des Office bestimmen ( sysinfo.inc )
   Call GetIniInformation                ' alle wichtigen Daten aus der Testtool.ini ziehen und auf glob. Variable setzen ( iniinfo.inc )
   Call GetOfficeInformation             ' set 'sAppExe' for startup
   Call hOfficeStarten                   ' try to start the office for first time ( master.inc )
   Call GetLanguageInformation           ' die Sprache des Office ermitteln und ggf. einstellen ( iniinfo.inc )

end sub

' **********************************************************
'  Einbinden der Deklarationen
'
sub LoadDeclaration
'///load all sid-files
   use "global\sid\all.sid"         ' all menu items ( german )
   use "global\sid\bars.sid"         ' all bars as slots
   use "global\sid\context.sid"      ' slots only used in context menus
   use "global\sid\e_all.sid"        ' all menu items ( english )
   use "global\sid\others.sid"       ' general slots ( german )

'///load all win-files
   use "global\win\tab_a_d.win"      ' Tabpages TabA ...TabZ
   use "global\win\tab_e_g.win"
   use "global\win\tab_h_o.win"
   use "global\win\tab_p_s.win"
   use "global\win\tab_t_z.win"

   use "global\win\dial_a_c.win"     ' Dialogs A ... Z
   use "global\win\dial_d_h.win"
   use "global\win\dial_i_o.win"
   use "global\win\dial_p_s.win"
   use "global\win\dial_t_z.win"

   use "global\win\sys_dial.win"     ' Systemdialogs
   use "global\win\dokument.win"     '
   use "global\win\mathop.win"       ' Mathoperators

   use "global\win\piloten.win"      ' Draw-Autopilot
   use "global\win\w_autop.win"      ' Writer-Autopilots

   use "global\win\bars.win"         ' bars with buttons ( englisch )

   use "global\win\e_mathop.win"
   use "global\win\edia_a_c.win"
   use "global\win\edia_d_h.win"
   use "global\win\edia_i_o.win"
   use "global\win\edia_p_s.win"
   use "global\win\edia_t_z.win"
   use "global\win\etab_a_d.win"
   use "global\win\etab_e_g.win"
   use "global\win\etab_h_o.win"
   use "global\win\etab_p_s.win"
   use "global\win\etab_t_z.win"

   use "global\win\etoolbox.win"
   
   use "global\win\spadmin.win"
   

'   use "win\sop.win"            ' all helpIDs for the SOPlayer

end sub

sub TestEnter
'///special TestEnter : without recovering at starting a testcase

   Dim sFehler as String
   Dim Unterbrechnung as Boolean

   Unterbrechnung = FALSE

   try
      sFehler = ResetApplication
      if sFehler <> "" then
         WarnLog "   **    Fehler in der TestEnter-Routine      **"

         if InStr ( 1, sFehler, "nicht schliessen", 1 ) <> 0 then
            printLog sFehler
            Unterbrechnung = TRUE
         else
            printLog sFehler
         end if
      end if
   catch
      WarnLog "   **    Fehler in der TestEnter-Routine      **"
      printLog "!!!  Konnte nicht auf Grundzustand kommen  !!!"
      Unterbrechnung = TRUE
   endcatch

   try
      AppAbort                       ' Alle noch anstehenden Befehle loeschen
   catch
   endcatch

   if Unterbrechnung = TRUE then
      if ( MsgBox ("Konnte nicht in den Grundzustand kommen." + Chr(10) + "Bitte die Applikation selbst in den Basiszustand setzten und OK druecken", 1, "TestEnter-Routine" )) = 2 then end
   else
      Kontext "Standardbar"
      if Standardbar.Exists = FALSE then
         ViewFullScreen
         if Standardbar.Exists (3) then
            Warnlog "Ansicht/Ganzerbildschirm war noch eingeschaltet"
         else
            ViewToolbarsFunctionbar
            if Standardbar.Exists (3) then Warnlog "Standardbar was turned off"
         end if
      end if
   end if

   try
      AppAbort                       ' Alle noch anstehenden Befehle loeschen
   catch
   endcatch

   Kontext
end sub


sub TestExit
'///special TestEnter : without recovering at ending a testcase
   Dim sFehler as String
   Dim Unterbrechnung as Boolean

   Unterbrechnung = FALSE

   try
      sFehler = ResetApplication
      if sFehler <> "" then
         Warnlog "   **    Fehler in der TestExit-Routine      **"

         if InStr ( 1, sFehler, "nicht schliessen", 1 ) <> 0 then
            printLog sFehler
            Unterbrechnung = TRUE
         else
            printLog sFehler
         end if
      end if
   catch
      WarnLog "   **    Fehler in der TestExit-Routine      **"
      printLog "!!!  Konnte nicht auf Grundzustand kommen, es wurde vielleicht von Hand recovert.   !!!"
      Unterbrechnung = TRUE
   endcatch

   try
      AppAbort                       ' Alle noch anstehenden Befehle loeschen
   catch
   endcatch

   if Unterbrechnung = TRUE then
      if ( MsgBox ("Konnte nicht in den Grundzustand kommen." + Chr(10) + "Bitte die Applikation selbst in den Basiszustand setzten und OK druecken", 1, "TestExit-Routine" )) = 2 then End
   else
      Kontext "Standardbar"
      if Standardbar.Exists = FALSE then
         ViewFullScreen
         if Standardbar.Exists (3) then
            Warnlog "Ansicht/Ganzerbildschirm war noch eingeschaltet"
         else
            ViewToolbarsFunctionbar
            if Standardbar.Exists (3) then Warnlog "Standardbar was turned off"
         end if
      end if
   end if

   try
      AppAbort                       ' Alle noch anstehenden Befehle loeschen
   catch
   endcatch

   Kontext
end sub


' *****************************************************************
'  startet das Office, wenn es nicht geht, wird eine Printbox ausgegeben
'
sub hOfficeStarten
    if gClient = TRUE then
       try
          start sAppExe, sAppParameter
' hiermit kann der Client nicht gestartet werden, aber wenn er schon aktiv ist, darf der Shell-befehl nicht ausgeführt werden
       catch
          shell ( sAppExe & sAppParameter, 1 )
          wait 10000
       endcatch
    end if

    try
       start sAppExe, "-enableautomation -norestore -nolockcheck "
    catch
       if gSamePC = FALSE then
          Exceptlog
          if MsgBox ("Ein Office auf einem anderen Rechner/Plattform kann nicht automatisch gestartet werden." + Chr(10) + "Bitte das Office selber starten und Test weiterlaufen lassen.", 1, "Starten des Office" ) = 2 then end
       else
          Exceptlog
          if gClient = TRUE then
             if MsgBox ( "Beim Start des Office-Client gab es Probleme. Bitte den Client von Hand starten und den Test weiterlaufen lassen!", 1, "Starten des Office" ) = 2 then end
          else
             if gNetzInst = TRUE then
                Warnlog "Beim Start des Workstation-Office gab es Probleme, es wird ein 2. Start versucht!"
             else
                Warnlog "Beim Starten des Office gab es Probleme, es wird ein 2. Start versucht!"
             end if
          end if
       end if
       wait 2000
   endcatch

   if gClient = TRUE then
      start sAppExe, sAppParameter
   else
      start sAppExe, "-enableautomation -norestore -nolockcheck "
   end if
   wait 3000
end sub


' ***************************************************************
' Input  : - sTrimmer   => the original text
'
' Return : the string without 'tab's at the beginning and the end
'
' - cut 'Tab's at the beginning and at the end of a string
'
function TrimTab ( sTrimmer as String ) as String
   Dim sInterim as String

   sInterim = sTrimmer
   sInterim = lTrimTab ( sInterim )
   TrimTab = rTrimTab ( sInterim )

end function

' ***************************************************************
' Input  : - slTrimmer   => the original text
'
' Return : the string without 'tab's at the beginning
'
' - cut 'Tab's at the beginning of a string ( left )
'
function lTrimTab ( slTrimmer as String ) as String
   Dim i, iLen as Integer
   Dim sInterim as String

   iLen = len ( slTrimmer )
   sInterim = slTrimmer

   for i=1 to iLen
      if Asc ( left ( sInterim, 1 ) ) = 9 then
         sInterim = Right ( sInterim, len ( sInterim ) - 1 )
      else
         i=iLen+1
      end if
   next i
   lTrimTab = sInterim
end function

' ***************************************************************
' Input  : - srTrimmer   => the original text
'
' Return : the string without 'tab's at the end
'
' - cut 'Tab's at the end of a string ( rigth )
'
function rTrimTab ( srTrimmer as String ) as String
   Dim i, iLen as Integer
   Dim sInterim as String

   iLen = len ( srTrimmer )
   sInterim = srTrimmer

   for i=1 to iLen
      if Asc ( right ( sInterim, 1 ) ) = 9 then
         sInterim = left ( sInterim, len ( sInterim ) - 1 )
      else
         i=iLen+1
      end if
   next i
   rTrimTab = sInterim
end function


