'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: gallery.inc,v $
'*
'*  $Revision: 1.12 $
'*
'*  last change: $Author: tbo $ $Date: 2005/09/07 19:29:16 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : fredrik.haegg@sun.com
'*
'* short description : Checking all gallery themes
'*
'*****************************************************************
'*
' #1 tLoadAllGalleryGraphicFiles 'Inserting all gallery graphics and checking the sizes
' #0 LoadGraphic
' #0 makeNumOutOfText
' #1 tSettingsToCM 'Measurement unit for textdocuments to cm
' #1 tResetSettings 'Resetting the measurement unit for textdocuments.
'*
'\****************************************************************

testcase tLoadAllGalleryGraphicFiles
'/// Inserting all gallery graphics in a Writer document and checking the sizes.
 Dim lsFiles (3000) as String
 Dim lsGraphics (3000) as String
 Dim i as Integer, iCount as Integer
 Dim corLoad as Boolean
 dim x as boolean
 
'/// Geting all installed gallery objects out of the installation in a list.
   if gNetzInst = TRUE then
      GetAllFileList ( ConvertPath ( gNetzOfficePath + "share\gallery\" ), "*.*", lsFiles () )
    else
      GetAllFileList ( ConvertPath ( gOfficePath + "share\gallery\" ), "*.*", lsFiles () )
   end if
   call GetOnlyGraphics ( lsFiles (), lsGraphics() )
   iCount = ListCount ( lsGraphics() )
   printlog "We have " + iCount + " graphics in the our gallery!"
'///+ Open a new document
   call hNewDocument

   for i=1 to iCount
      corLoad = FALSE
      try
'/// <i>Loop begin</i>
'///+ Inserting all gallery files and checking the sizes
'///+- Iinsert / graphic / from file
'///+- Check the size in 'format / graphics' on the <i>Type</i> tabpage
'///+-- The size should noz be smaler than 17*25cm / photos 21*25cm
'///+ Deleting the graphic with &lt;delete&gt; of the keyboard
'/// <i>Loop ends</i>
        x = LoadGraphic ( lsGraphics(i), corLoad )
      catch
         ExceptLog
         if corLoad = FALSE then
            ResetApplication
            warnlog "Problems with " + lsGraphics(i)
            call hNewDocument
         end if
      endcatch
      if (not x) then
          printlog "" + i
      endif
   next i

'   Kontext "Gallery"  '
'    IF Gallery.Exists(2) THEN
      ToolsGallery
      sleep (2)
'    END IF

   call hCloseDocument
'///close the document
endcase

'-------------------------------------------------------------------------

sub LoadGraphic ( sFile as String, bOK as Boolean ) as boolean
 Dim iW, iWMax, iH, iHMax
   call hGrafikEinfuegen ( sFile )
   FormatGraphics
   Kontext
    Active.SetPage TabType
   Kontext "TabType"
    OriginalSize.Click
    iW = Val ( makeNumOutOfText ( Width.GetText ) )
    iH = Val ( makeNumOutOfText ( Height.GetText )
    if instr ( sFile, "photo" ) <> 0 then
       iWMax = 22
       iHMax = 25
     else
       iWMax = 17
       iHMax = 25
    end if
    if iW > iWMax OR iH > iHMax then
       printlog sFile + " :"
       warnlog "Size is too big ( max should be '" + iWMax + "' cm* '" + iHMax + "'cm DinA4 with default borders ), but it is '" + iW + "' * '" + iH + "'"
       LoadGraphic = false
    end if
    TabType.OK
    sleep (1)
   Kontext "DocumentWriter"
    DocumentWriter.TypeKeys "<Delete>"
    sleep (1)
   bOK = TRUE
end sub

'-------------------------------------------------------------------------

sub GetOnlyGraphics ( OldList() as String, NewList() as String )
   Dim i as Integer
   Dim sExtension as String

   ListAllDelete ( NewList() )
   for i=1 to ListCount ( OldList() )
      sExtension = lcase ( Right ( OldList(i), 3 ) )
      if sExtension = "jpg" OR sExtension = "gif" OR sExtension = "wmf" OR sExtension = "png" then
         ListAppend ( NewList(), OldList(i) )
      end if
   next i
end sub

'-------------------------------------------------------------------------

function makeNumOutOfText ( sNum as String ) as String
 Dim sDummy as String
 Dim iComma as Integer

   iComma = Instr ( sNum, "," )
   if iComma <> 0 then
      sDummy = Left ( sNum, iComma-1 ) + "." + Mid ( sNum, iComma+1, len ( sNum )-2 )
    else
      sDummy = Left ( sNum, len (sNum)-2 )
   end if
   makeNumOutOfText = sDummy
end function

'-------------------------------------------------------------------------

sub tSettingsToCM
'///Setting the measurement unit for textdocuments to <i>cm</i>.
'///+Tools / options / text documents / general
   ToolsOptions
    hToolsOptions ( "Textdocument", "General" )
    iSaveSetting = Masseinheit.GetSelIndex
    Masseinheit.Select 2
   Kontext "ExtrasOptionenDlg"
    ExtrasOptionenDlg.OK
end sub

'-------------------------------------------------------------------------

sub tResetSettings
'///Resetting the measurement unit for textdocuments.
'///+Tools / options / text documents / general
   ToolsOptions
    hToolsOptions ( "Textdocument", "General" )
    Masseinheit.Select iSaveSetting
   Kontext "ExtrasOptionenDlg"
    ExtrasOptionenDlg.OK
end sub

'-------------------------------------------------------------------------
