'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: w_fields7.inc,v $
'*
'*  $Revision: 1.7 $
'*
'*  last change: $Author: tbo $ $Date: 2005/09/27 15:23:06 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : helge.delfs@sun.com
'*
'* short description : Fields - L10N test
'*
'************************************************************************
'*
' #1 tL10N_1             'L10N test - above/below
' #1 tL10N_2             'L10N test - date
' #1 tL10N_3             'L10N test - time
'*
'\***********************************************************************

testcase tL10N_1

  Dim sTestFile             as String
  Dim sAbove() , sBelow()   as String
  Dim iCountry()            as Integer
  Dim i , j                 as Integer

  sTestFile = Convertpath (gTesttoolpath + "writer\level1\input\fields\AboveBelow.sxw")

  sBelow  = Array( _
                   "below"    , _
                   "infra"    , _
                   "abajo"    , _
                   "sotto"    , _
                   "ovan"     , _
                   "unten"    , _
                   "abaixo"   , _
                   "後述"    , _
                   "아래"    , _
                   "下面"    , _
                   "下面"    , _
                  )
  sAbove  = Array( _
                   "above"    , _
                   "supra"    , _
                   "arriba"   , _
                   "sopra"    , _
                   "nedan"    , _
                   "oben"     , _
                   "acima"    , _
                   "前述"    , _
                   "위"       , _
                   "上面"    , _
                   "上面"    , _
                  )
  iCountry = Array ( 1 , 33 , 34 , 39 , 46 , 49 , _
                     55, 81 , 82 , 86 , 88 )

  printlog "L10N test - above/below"
 '/// <b> L10N test - above/below </b>

  Call hNewDocument

  '/// Open test file AboveBelow.sxw
   Call hDateiOeffnen(sTestFile)

  '/// Check if reference above/below is changed after language is changed

   j = UBound(iCountry)
   for i = 0 to j
       Call wDokSchreiben "<MOD1 Home>"
       fSetLocale(fGetLanguageName(iCountry(i)))
       if iCountry(i) < 80 then
           fSetWestern(fGetLanguageName(iCountry(i)))
           fSetAsian("Null")
       else
           fSetWestern("Null")
           fSetAsian(fGetLanguageName(iCountry(i)))
       end if

       Call wDokSchreiben "<F9>"
       Call wDokSchreiben "<Shift Right>"
       if fGetFieldContent() <> sBelow(i) then
           Warnlog "Should get " & sBelow(i) & " but get " & fGetFieldContent()
       end if
       Call wDokSchreiben "<MOD1 End>"
       Call wDokSchreiben "<Shift Left>"
       if fGetFieldContent() <> sAbove(i) then
           Warnlog i & " - Should get " & sAbove(i) & " but get " & fGetFieldContent()
       end if
   next i

  Call hCloseDocument

endcase

'-----------------------------------------------------------------

testcase tL10N_2

  Dim sTestFile    as String
  Dim sDate()      as String
  Dim iCountry()   as Integer
  Dim i , j        as Integer

  sTestFile = Convertpath (gTesttoolpath + "writer\level1\input\fields\Date.sxw")

  sDate  = Array( _
                   "Tuesday, August 3, 2004"    , _
                   "mardi 3 août 2004"    , _
                   "martes, 3 de agosto de 2004"    , _
                   "martedi 3 agosto 2004"    , _
                   "tisdag 3 augusti 2004"    , _
                   "Dienstag, 3. August 2004"    , _
                   "Terça-feira, 3 de Agosto de 2004"    , _
                   "2004年8月3日（火曜日）"    , _
                   "04-8-3 화요일"    , _
                   "2004年8月3日 星期二"    , _
                   "中華民國93年8月3日 星期二"    , _
                  )
  iCountry = Array ( 1 , 33 , 34 , 39 , 46 , 49 , _
                     55, 81 , 82 , 86 , 88 )

  printlog "L10N test - Date"
 '/// <b> L10N test - Date </b>

  Call hNewDocument

  '/// Open test file Date.sxw
   Call hDateiOeffnen(sTestFile)

  '/// Check if Date is changed after language is changed
   j = UBound(iCountry)
   for i = 0 to j
       Call wDokSchreiben "<MOD1 Home>"
       fSetLocale(fGetLanguageName(iCountry(i)))
       if iCountry(i) < 80 then
           fSetWestern(fGetLanguageName(iCountry(i)))
           fSetAsian("Null")
       else
           fSetWestern("Null")
           fSetAsian(fGetLanguageName(iCountry(i)))
       end if

       Call wDokSchreiben "<F9>"
       Call wDokSchreiben "<Shift Right>"
       if fGetFieldContent() <> sDate(i) then
           Warnlog i & " - Should get " & sDate(i) & " but get " & fGetFieldContent()
       end if
   next i

  Call hCloseDocument

endcase

'-----------------------------------------------------------------

testcase tL10N_3

  Dim sTestFile    as String
  Dim sTime()      as String
  Dim iCountry()   as Integer
  Dim i , j        as Integer

  sTestFile = Convertpath (gTesttoolpath + "writer\level1\input\fields\Time.sxw")

  sTime  = Array( _
                   "04:46:08 PM"     , _
                   "04:46:08 PM"     , _
                   "04:46:08 PM"     , _
                   "04.46.08 p."     , _
                   "04:46:08 em"     , _
                   "04:46:08 nachm." , _
                   "04:46:08 PM"     , _
                   "午後 4:46:08"  , _
                   "오후 4시 46분 8초"    , _
                   "下午 04:46:08" , _
                   "下午 04:46:08" , _
                  )
  iCountry = Array ( 1 , 33 , 34 , 39 , 46 , 49 , _
                     55, 81 , 82 , 86 , 88 )

  printlog "L10N test - time"
 '/// <b> L10N test - time </b>

  Call hNewDocument

  '/// Open test file Time.sxw
   Call hDateiOeffnen(sTestFile)

  '/// Check if time is changed after language is changed
   j = UBound(iCountry)
   for i = 0 to j
       Call wDokSchreiben "<MOD1 Home>"
       fSetLocale(fGetLanguageName(iCountry(i)))
       if iCountry(i) < 80 then
           fSetWestern(fGetLanguageName(iCountry(i)))
           fSetAsian("Null")
       else
           fSetWestern("Null")
           fSetAsian(fGetLanguageName(iCountry(i)))
       end if

       Call wDokSchreiben "<F9>"
       Call wDokSchreiben "<Shift Right>"
       if fGetFieldContent() <> sTime(i) then
           Warnlog i & " - Should get " & sTime(i) & " but get " & fGetFieldContent()
       end if
   next i

  Call hCloseDocument

endcase

'-----------------------------------------------------------------
