'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: w_102_.inc,v $
'*
'*  $Revision: 1.6 $
'*
'*  last change: $Author: tbo $ $Date: 2005/09/27 15:25:32 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : helge.delfs@sun.com
'*
'* short description : Put description here
'*
'\***********************************************************************


sub w_102_
    printLog Chr(13) + "---------   Level 1   - Menu / Edit -   ----------"

    Call tEditRepeat
    Call tEditClipboard
    Call tEditPasteSpecial
    Call tEditFindAndReplace
    'Call tEditAddressBook   ' No Adressbook at the moment

end sub

' *******************************************************************
' *******************************************************************
' *******************************************************************

testcase tEditRepeat
    '/// Edit / Repeat ///
    PrintLog "- Edit / Repeat"
    '/// New document ///
    Call hNewDocument
    Printlog "  - Insert Table"
    '/// Insert a table into document ///
    Call hTabelleEinfuegen
    Call wDokSchreiben "<Down><Down>"
    '/// Select Edit / Repeat ///
    EditRepeat
    Sleep 1
    Call wDokSchreiben "<Up>"
    '/// Check if second table has been inserted ( try Format / Table ) ///
    FormatTable
    Kontext
    Active.SetPage TabTabelle
    Kontext "TabTabelle"
    if Right ( TabellenName.GetText, 1 ) <> "2" then Warnlog "No 2nd table inserted"
    TabTabelle.Cancel
    '/// Insert a field into document ( date ) ///
    Printlog "  - Insert Field"
    Call wDokSchreiben "<Down><Down>"
    InsertFieldsDate
    Sleep 1
    '/// Select Edit / Repeat ///
    EditRepeat
    Sleep 1
    Call wDokSchreiben "<Mod1 Shift Left>"
    Call wDokSchreiben "<Delete>"
    Sleep 1
    '/// Insert a graphic into document ///
    Printlog "  - Insert Graphic"
    Call hGrafikEinfuegen ( gTesttoolPath + "writer\input\grafik\jolink.jpg" )
    Call wDocSetContext
    Call gMouseClick ( 80, 90 )
    Sleep 3
    '/// Select Edit / Repeat ///
    try
        EditRepeat
    catch
        Warnlog "Edit: Last command couldn't be executed!"
    endcatch
    Sleep 1
    '/// try to delete inserted graphic ///

    try
        EditDeleteContents
    catch
        Warnlog "No graphic inserted, because no Selection could be deleted!"
    endcatch
    Sleep 1
    '/// Close document ///
    Call hCloseDocument
endcase

'----------------------------------------------------

testcase tEditClipboard
    '/// Edit / Clipboard ///
    PrintLog "- Edit / Clipboard"
    '/// New document ///
    Call hNewDocument
    Printlog "  - Graphic in Clipboard"
    '/// Insert a graphic from file ///
    Call hGrafikEinfuegen ( gTesttoolPath + "writer\input\grafik\jolink.jpg" )
    '/// Select grahic and copy to Clipboard ///
    try
        Call hClipboarden
    catch
        Warnlog "Clipboardfunctions not working!(No Graphic?)"
    endcatch

    '/// Draw a legend and copy to clipboard  ///
    Printlog "  - Legend in Clipboard"
    Kontext "WL_SW"
    Zeichnen.TearOff
    Kontext "TB_Zeichenfunktionen"
    Legende.CLick
    Call hObjektmalen
    Sleep 1
    '/// Cut and paste Object in clipboard ///
    Call hClipboarden

    '/// Draw a rectangle and copy to clipboard ///
    Printlog "  - Rectangle in Clipboard"
    Kontext "TB_Zeichenfunktionen"
    Rechteck.Click
    Call hObjektmalen
    Sleep 1
    '/// Cut and paste Object in clipboard ///
    Call hClipboarden

    '/// Insert a textbox and copy to clipboard ///
    Printlog "  - Textbox in Clipboard"
    Kontext "TB_Zeichenfunktionen"
    Textobjekt.Click
    Call hObjektmalen
    Call wDokSchreiben "Hallo"
    Call gMouseClick 50,80   'Deselect
    Call gMouseClick 50,40   'Select
    Sleep 1
    '/// Cut and paste Object in clipboard ///
    Call hClipboarden

    Kontext "TB_Zeichenfunktionen"
    TB_Zeichenfunktionen.Close
    Sleep 1
    Call wDokSchreiben "<Return>",7
    '/// Close document ///
    Call hCloseDocument
endcase
'----------------------------------------------------
testcase tEditPasteSpecial
    '/// Edit / Paste / Special ///
    PrintLog "- Edit / Paste Special"
    '/// New document ///
    Call hNewDocument
    Printlog "  - a Graphic into Clipboard"
    '/// Insert a graphic from file ///
    Call hGrafikEinfuegen ( gTesttoolPath + "writer\input\grafik\jolink.jpg" )
    try
        '/// Copy object and Select Insert Specials with all formats ///
        Call hInhalte
    catch
        Warnlog "Insert Specials has failed (No Graphic?)!"
    endcatch

    '/// Insert a legend ///
    Printlog "  - a Legend in Clipboard"
    Kontext "WL_SW"
    Zeichnen.TearOff
    Kontext "TB_Zeichenfunktionen"
    Legende.Click
    Call hObjektmalen
    Call wDokSchreiben "<Escape>"
    Sleep 1
    Call gMouseClick ( 70, 60 )
    '/// Copy object and Select Insert Specials with all formats ///
    Call hInhalte

    '/// Insert a rectangle ///
    Printlog "  - a Rectangle in Clipboard"
    Kontext "TB_Zeichenfunktionen"
    Rechteck.Click
    Call hObjektmalen
    Call wDokSchreiben "<Escape>"
    Sleep 1
    Call gMouseClick ( 70, 60 )
    '/// Copy object and Select Insert Specials with all formats ///
    Call hInhalte

    '/// Insert a textbox ///
    Printlog "  - a Textbox in Clipboard"
    Kontext "TB_Zeichenfunktionen"
    Textobjekt.Click
    Call hObjektmalen
    Call wDokSchreiben "Hallo"
    Sleep 1
    Call wDokSchreiben "<Escape>"
    Sleep 1
    Call gMouseClick ( 70, 60 )
    '/// Copy object and Select Insert Specials with all formats ///
    Call hInhalte

    Kontext "TB_Zeichenfunktionen"
    TB_Zeichenfunktionen.Close
    Sleep 1
    '/// Close document ///
    Call hCloseDocument
endcase

'----------------------------------------------------

testcase tEditCompareDocument_1
    Dim i as Integer
    '/// Edit / Changes / Compare Documents ///
    printlog "- Edit / Changes / Compare documents - Accept all"
    '/// Open document ( st1_13a.sxw ) ///
    Call hDateiOeffnen ( gTesttoolPath + "writer\level1\input\st1_13a.sxw" )
    UseBindings
    '/// Select Edit / Compare ///
    EditCompareDocument
    Kontext "OeffnenDlg"
    '/// Open document ( st1_13b.sxw ) ///
    Dateiname.SetText ConvertPath( gTesttoolPath + "writer\level1\input\st1_13b.sxw" )
    Sleep 2
    Oeffnen.Click
    Sleep 5
    printlog "  - Accept all"
    '/// In Redlining dialog select 'Accept all' ///
    Kontext "Redlining"

    AlleAkzeptieren.Click
    Sleep 1
    '/// Close Redlining dialog ///
    Redlining.Close

    printlog "    - check"
    '/// check if all changes have been accepted ///
    Call wDokSchreiben "<Up>", 10
    for i=1 to 4
        Call wDokSchreiben "<End><Shift Mod1 Left>"
        EditCopy
        if GetClipboardText <> "Originaldokument" then Warnlog "Line " + i + " is incorrect!"
        Call wDokSchreiben "<Down>"
    next i
    Sleep 2
    '/// Close document ///
    Call hCloseDocument
endcase

'----------------------------------------------------
testcase tEditCompareDocument_2
    Dim i as Integer
    '/// Edit / Changes / Compare documents / Reject all ///
    printlog "- Edit / Changes / Compare Documents - Reject all"
    '/// Open document ( st1_13a.sxw ) ///
    Call hDateiOeffnen ( gTesttoolPath + "writer\level1\input\st1_13a.sxw" )
    UseBindings
    '/// Select Edit / Compare ///
    EditCompareDocument
    Kontext "OeffnenDlg"
    '/// Open document (st1_13b.sxw ) ///
    Dateiname.SetText ConvertPath( gTesttoolPath + "writer\level1\input\st1_13b.sxw" )
    Oeffnen.Click
    Sleep 5
    '/// In Redlining dialog select 'Reject all' ///
    printlog "  - Reject all"
    Kontext "Redlining"
    AlleAblehnen.Click
    '/// Close Redlining dialog ///
    Redlining.Close

    printlog "    - check"
    '/// Check if all changes have been rejected ///
    Call wDokSchreiben "<Up>", 10
    for i=1 to 8
        Call wDokSchreiben "<End><Shift Mod1 Left>"
        EditCopy
        if i=1 OR i=3 OR i=5 OR i=7 then if GetClipboardText <> "Originaldokument" then Warnlog "Line " + i + " is incorrect"
        if i=2 OR i=4 OR i=6 OR i=8 then if GetClipboardText <> "Dokument" then Warnlog "Line " + i + " is incorrect"
        Call wDokSchreiben "<Down>"
    next i
    Call wDokSchreiben "<Down><End><Shift Mod1 Left>"
    EditCopy
    if GetClipboardText <> "Tabelle" then Warnlog "The Haeding of the table hasn't benn inserted!"
    Call wDokSchreiben "<Down><Left><Left><Mod1 a>"
    EditCopy
    if GetClipboardText <> "Tabelle" then Warnlog "The table hasn't been inserted!"
    '/// Close document ///
    Call hCloseDocument
endcase

'----------------------------------------------------
testcase tEditFindAndReplace
    Dim WhereIsOutline as Integer
    Printlog " - Search for Attributes 'Outline'"
    '/// Open document ( st1_1.sxw ) ///
    Call hDateiOeffnen ( gTesttoolPath + "writer\input\st1_1.sxw" )
    '/// Select Edit / Find & Replace ///
    EditSearchAndReplace
    Kontext "FindAndReplace"

    if bAsianLan = False and gAsianSup = False then
        Select Case iSprache
            Case 01,1: WhereIsOutline = 19
            Case 31: WhereIsOutline = 4
            Case 33: WhereIsOutline = 6
            Case 34: WhereIsOutline = 6
            Case 39: WhereIsOutline = 7
            Case 46: WhereIsOutline = 13
            Case 49: WhereIsOutline = 11
            Case 81: WhereIsOutline = 13
            Case 82: WhereIsOutline = 18
            Case 86: WhereIsOutline = 35
            Case 88: WhereIsOutline = 33
            Case else
                Warnlog "Check Attributes 'Outline' for this language and adapt test!"
                Goto GoOn
        end select
    else
        Select Case iSprache
            Case 01,1: WhereIsOutline = 25
            Case 31: WhereIsOutline = 7
            Case 33: WhereIsOutline = 8
            Case 34: WhereIsOutline = 8
            Case 39: WhereIsOutline = 9
            Case 46: WhereIsOutline = 18
            Case 49: WhereIsOutline = 15
            Case 81: WhereIsOutline = 13
            Case 82: WhereIsOutline = 23
            Case 86: WhereIsOutline = 35
            Case 88: WhereIsOutline = 33
            Case else
                Warnlog "Check Attributes 'Outline' for this language and adapt test!"
                FindAndReplace.Close
                '/// Close document ///
                Call hCloseDocument
                goto endsub
        end select
    endif

    '/// Select Attributess ///
    Attributes.Click
    Kontext "Attributes"
    Auswahl.Select WhereIsOutline
    Auswahl.TypeKeys "<Space>"
    printlog "-  " & Auswahl.Getseltext
    Attributes.OK

    '/// Select 'Outline' and close dialog ///
    Sleep 2
    Kontext "FindAndReplace"
    if SearchFor.GetSelText <> "" then
        SearchFor.SetText ""
    end if
    '/// Click Find ///
    Search.Click
    Kontext
    if Active.Exists(1) then
        try
            Active.Yes
        catch
            Active.Ok
            Warnlog "Search key has not been found! Search for Attributess failed"
            Goto GoOn
        endcatch
    endif

    Call wDocSetContext
    EditCopy
    '/// Check if Attributes has been found ///
    if GetClipboardText <> "Format" then Warnlog "Wrong Attributes has been found"
    Kontext "FindAndReplace"

GoOn:
    Printlog "- Similarity Search"
    '/// In Find & Replace-dialog select 'Similarity Search' ///
    Kontext "FindAndReplace"
    Attributes.Click
    Kontext "Attributes"
    '/// Reopen Attributes-dialog and deselect 'Outline' ///
    Auswahl.Select WhereIsOutline
    Auswahl.TypeKeys "<Space>"
    Attributes.OK
    Sleep 2
    Kontext "FindAndReplace"
    SimilaritySearch.Check
    Sleep 2
    '/// Insert a word similar to another in document ///
    SearchFor.SetText "Seitenumbrech"
    Search.Click
    '/// Click 'Find' and check if Word has been found ///
    Kontext
    if Not Active.Exists then
        Call wDocSetContext
        EditCopy
        if GetClipboardText <> "Seitenumbruch" then Warnlog "Similarity Search has failed"
        Kontext "FindAndReplace"
        SimilaritySearch.UnCheck
        Sleep 2
    else
        try
            Active.Yes
            try
                Call wDocSetContext
                EditCopy
                if GetClipboardText <> "Seitenumbruch" then Printlog "Similarity Search has failed"
                Kontext "FindAndReplace"
                SimilaritySearch.UnCheck
                Sleep 2
            catch
                Kontext "Active"
                if Active.Exists then
                    if Active.GetRT = 304 then
                        Active.Ok
                    else
                        Warnlog "Unable to check if word has been found (Error in Edit / Copy)!"
                    endif
                endif
            endcatch
        catch
            Active.Ok   ' Search key not found
            Warnlog Active.Gettext
            Kontext "FindAndReplace"
        endcatch
    endif


    Printlog "- Search for Format"
    '/// Search for formats ///
    Kontext "FindAndReplace"
    SimilaritySearch.UnCheck
    Formats.Click
    Kontext
    '/// On Tabpage 'Font Effects' check 'outline' and close dialog ///
    active.SetPage TabFontEffects
    kontext "TabFontEffects"
    Outline.Check
    TabFontEffects.OK

    Kontext "FindAndReplace"
    if SearchFor.GetSelText <> "" then SearchFor.SetText ""
    Search.Click
    '/// Click 'Find' and check if word has been found ///
    Kontext
    if Active.Exists(1) then Active.Yes
    Call wDocSetContext
    EditCopy
    if GetClipboardText <> "Format" then printlog "Search for Formats has failed"
    Kontext "FindAndReplace"
    NoFormat.Click
    Sleep 1
    '/// Close dialog Find & Replace ///
    FindAndReplace.Close
    '/// Close document ///
    Call hCloseDocument
endcase

'---------------------------------------------------

testcase tEditAddressBook
   '/// Not available in current office ( No address book ) ///
  PrintLog "- Edit / Address Book"
   Call hNewDocument
   EditAddressbook

   Kontext "FehlermeldungDatenbank"
   if FehlermeldungDatenbank.Exists then
    Warnlog " Database Connection is faulty"
    FehlermeldungDatenbank.Cancel
   endif
   Sleep 1

   Kontext "Adressbuch"
  if Adressbuch.Exists then
   printlog "   - Insert new entry"
    Neu.Click
    Sleep 1
    Adressbuch.TypeKeys "<Mod1 1>"
    Vorname.SetText "Dieter Thomas"
    Nachname.SetText "Kuhn"
    Titel.SetText "Die singende Fhnwelle"
    Strasse.SetText "GuteLiederStr. 3"
    LandPlzOrt1.SetText "D"
    LandPlzOrt2.SetText "20000"
    LandPlzOrt3.SetText "Hamburg"
    URL.SetText ConvertPath( gTesttoolPath + "writer\level1\input\dtk.sxw" )

    Adressbuch.TypeKeys "<Mod1 2>"
    Firma.SetText "DTK GmbH"
    Abteilung.SetText "Tourdaten"
    Position.SetText "Der Musiker"

    Adressbuch.Close
  else
   Warnlog "Address Book didn't come up!"
  endif

  printlog "   - Check Entry"
   EditAddressbook
   Kontext "FehlermeldungDatenbank"
   if FehlermeldungDatenbank.Exists then
    Warnlog " Database Connection is faulty"
    FehlermeldungDatenbank.Cancel
   endif

   Sleep 2
   Kontext "Adressbuch"
  if Adressbuch.Exists then
   Kontext "Adressbuch"
   AnDasEnde.Click
   Adressbuch.TypeKeys "<Mod1 1>"
   if Vorname.GetText <> "Dieter Thomas" then Warnlog "Wrong Text in Field: First Name"
   if Nachname.GetText <> "Kuhn" then Warnlog "Wrong Text in Field: Last Name"
   if Titel.GetText <> "Die singende Fhnwelle" then Warnlog "Wrong Text in Field: Title"
   if Strasse.GetText <> "GuteLiederStr. 3" then Warnlog "Wrong Text in Field: Street"
   if LandPlzOrt1.GetText <> "D" then Warnlog "Wrong Text in Field: Country"
   if LandPlzOrt2.GetText <> "20000" then Warnlog "Wrong Text in Field: Zip"
   if LandPlzOrt3.GetText <> "Hamburg" then Warnlog "Wrong Text in Field: City"
   if URL.GetText <> ConvertPath( gTesttoolPath + "writer\level1\input\dtk.sxw" ) then Warnlog "Wrong Text in Field: URL"

   Adressbuch.TypeKeys "<Mod1 2>"
   if Firma.GetText <> "DTK GmbH" then Warnlog "Wrong Text in Field: Company"
   if Abteilung.GetText <> "Tourdaten" then Warnlog "Wrong Text in Field: Department"
   if Position.GetText <> "Der Musiker" then Warnlog "Wrong Text in Field: Position"

  printlog "   - AutoBrowse"
   AutoBrowse.Click
   Sleep 4
   Adressbuch.Close
  else
   Warnlog "Address Book isn't up!"
  endif

   Call wDocSetContext
   try
      EditCut               ' Das Bild ist normalerweise selektiert
   catch
     try
      gMouseClick ( 50, 40 )                ' wenn nicht, dann eben so
      EditCut
     catch
      Warnlog "Graphic could not selected!"
     endcatch
   endcatch

   try
      Call wDokSchreiben "<Escape>"
      Sleep 1
      hCloseDocument
   catch
      Warnlog "Wrong or no document openend with AutoBrowse!"
   endcatch

 dim i% : dim j% : dim ds%
 dim AlterWert$
  printlog "   - Count, Next, Previous, etc. Records"
   EditAddressbook
   Sleep 1
   Kontext "FehlermeldungDatenbank"
   if FehlermeldungDatenbank.Exists then
    Warnlog " Database Connection is faulty"
    FehlermeldungDatenbank.Cancel
   endif
   Sleep 1

   Kontext "Adressbuch"
 if Adressbuch.Exists then
   AnDasEnde.Click
   printlog "       There are "+ DatensatzNr.GetText + " Records"
   Sleep 2
   AnDenAnfang.Click
   Sleep 2
   for i% = 1 to 20
      if Naechster.IsEnabled then
        Naechster.Click
      else
         ds% = i%
         Printlog "       There are " + ds% + " Records in Address Book,  (switching)!"
         j% = i%
         i% = 100
      end if
   next i%

   for i% = 1 to j%-1
      Vorher.Click
   next i%
   Sleep 2
   if DatensatzNr.GetText <> "1" then Warnlog "Unable to jump with Previous-Key to Record 1, but : " +DatensatzNr.GetText

  printlog "   - Delete Record"
   AnDasEnde.Click
   Sleep 2
   Adressbuch.TypeKeys "<Mod1 2>"
   if Firma.GetText = "DTK GmbH" then
      Loeschen.Click
      Kontext "Active"
      if Active.Exists then
       Active.yes
      else
       Warnlog "No questioning if record should be deleted!"
      endif
      Kontext "Adressbuch"
      Sleep 1
      if Firma.GetText = "DTK GmbH" then Warnlog "The last record entry hasn't deleted"
   else
      Warnlog "Unable to select new record, so the entry will not be deleted"
   end if
    Adressbuch.Close
 else
   Warnlog "Address Book isn't up!"
 endif

   Call hCloseDocument
endcase
