'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: wr_o_3.inc,v $
'*
'*  $Revision: 1.10 $
'*
'*  last change: $Author: hde $ $Date: 2006/02/08 10:08:38 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : helge.delfs@sun.com
'*
'* short description : Writer options tests
'*
'\***********************************************************************

sub wr_o_3

    Call tToolsOptionsWriterCursor
    Call tToolsOptionsWriterChanges
    Call tToolsOptionsWriterInsert
    Call tToolsOptionsAutocaption   
    Call tToolsOptionsWriterCompatibility1
    Call tToolsOptionsWriterCompatibility2
   
end sub


'------------------------------------------------------------------------------
testcase tToolsOptionsWriterCursor

    Dim irgendwas(17) as boolean    ' Checkbox states
    Dim bRadioBut(4) as boolean         ' RadioButtons
    Dim bTempRadioBut(4) as boolean
    Dim iListBox(1) as integer         ' ListBox
    Dim iTempListBox(1) as integer

    Call hNewDocument
    printlog "'///- Tools/Options/Writer: View 2 ///"

    printlog ("'/// - save states ///")
    ToolsOptions
    Call hToolsOptions ("TextDocument","FORMATTINGAIDS")

    irgendwas(1) = DirektCursor.IsChecked
    irgendwas(2) = Zonen_Cursor.IsChecked

    bRadioBut(1) = Absatzausrichtung.IsChecked
    bRadioBut(2) = LinkerAbsatzrand.IsChecked
    bRadioBut(3) = Tabulator.IsChecked
    bRadioBut(4) = TabulatorUndLeerzeichen.IsChecked

    if ((bRadioBut(1) Xor bRadioBut(2) Xor bRadioBut(3) Xor bRadioBut(4)) = False) then Warnlog (" RadioButtons have NO init state: " + bRadioBut(1) +", BugID: Not Yet l.f.?")

    irgendwas(10) = Absatzenden.IsChecked
    irgendwas(11) = WeicheTrenner.IsChecked
    irgendwas(12) = Leerzeichen.IsChecked
    irgendwas(13) = GeschLeerzeichen.IsChecked
    irgendwas(14) = Tabulatoren.IsChecked
    irgendwas(15) = Umbrueche.IsChecked
    irgendwas(16) = VersteckterText.IsChecked
    irgendwas(17) = VersteckteAbsatze.IsChecked

    printlog ("'/// - all states inverting ///")

    if irgendwas(1) then DirektCursor.UnCheck Else DirektCursor.Check
    if irgendwas(2) then Zonen_Cursor.UnCheck Else Zonen_Cursor.Check

    if (Absatzausrichtung.IsChecked = True) then LinkerAbsatzrand.Check Else Absatzausrichtung.Check
    bTempRadioBut(1) = Absatzausrichtung.IsChecked
    bTempRadioBut(2) = LinkerAbsatzrand.IsChecked
    bTempRadioBut(3) = Tabulator.IsChecked
    bTempRadioBut(4) = TabulatorUndLeerzeichen.IsChecked

    if irgendwas(10) then Absatzenden.UnCheck Else Absatzenden.Check
    if irgendwas(11) then WeicheTrenner.UnCheck Else WeicheTrenner.Check
    if irgendwas(12) then Leerzeichen.UnCheck Else Leerzeichen.Check
    if irgendwas(13) then GeschLeerzeichen.UnCheck Else GeschLeerzeichen.Check
    if irgendwas(14) then Tabulatoren.UnCheck Else Tabulatoren.Check
    if irgendwas(15) then Umbrueche.UnCheck Else Umbrueche.Check
    if irgendwas(16) then VersteckterText.UnCheck Else VersteckterText.Check
    if irgendwas(17) then VersteckteAbsatze.UnCheck Else VersteckteAbsatze.Check

    Kontext "ExtrasOptionenDlg"
    ExtrasOptionenDlg.OK

    printlog ("'/// - SO quit - start ///")

    Call wOfficeRestart

    printlog ("'/// - checking states ///")
    ToolsOptions
    Call hToolsOptions ( "TextDocument" , "FORMATTINGAIDS" )

    if ( irgendwas(1) = DirektCursor.IsChecked ) then WarnLog "DirektCursor state changed BugID: 82955"
    if ( irgendwas(2) = Zonen_Cursor.IsChecked ) then WarnLog "Zonen_Cursor state changed"
    
    if ( bTempRadioBut(1) <> Absatzausrichtung.IsChecked       ) then WarnLog "Absatzausrichtung state changed"
    if ( bTempRadioBut(2) <> LinkerAbsatzrand.IsChecked        ) then WarnLog "LinkerAbsatzrand state changed"
    if ( bTempRadioBut(3) <> Tabulator.IsChecked               ) then WarnLog "Tabulator state changed"
    if ( bTempRadioBut(4) <> TabulatorUndLeerzeichen.IsChecked ) then WarnLog "TabulatorUndLeerzeichen state changed"
    
    if ( irgendwas(10) = Absatzenden.IsChecked  ) then  WarnLog "Absatzenden state changed"
    if ( irgendwas(11) = WeicheTrenner.IsChecked  ) then  WarnLog "WeicheTrenner state changed"
    if ( irgendwas(12) = Leerzeichen.IsChecked  ) then  WarnLog "Leerzeichen state changed"
    if ( irgendwas(13) = GeschLeerzeichen.IsChecked  ) then  WarnLog "GeschLeerzeichen state changed"
    if ( irgendwas(14) = Tabulatoren.IsChecked  ) then  WarnLog "Tabulatoren state changed"
    if ( irgendwas(15) = Umbrueche.IsChecked  ) then  WarnLog "Umbrueche state changed"
    if ( irgendwas(16) = VersteckterText.IsChecked  ) then  WarnLog "VersteckterText state changed"
    if ( irgendwas(17) = VersteckteAbsatze.IsChecked  ) then  WarnLog "VersteckteAbsatze state changed"
    
    Kontext "ExtrasOptionenDlg"
    ExtrasOptionenDlg.OK

    printlog ("'/// - all UnCheck -> o ///")
    ToolsOptions
    Call hToolsOptions ( "TextDocument" , "FORMATTINGAIDS" )

    DirektCursor.UnCheck
    Zonen_Cursor.UnCheck

    if (LinkerAbsatzrand.IsChecked = True) then Tabulator.Check Else LinkerAbsatzrand.Check
    bTempRadioBut(1) = Absatzausrichtung.IsChecked
    bTempRadioBut(2) = LinkerAbsatzrand.IsChecked
    bTempRadioBut(3) = Tabulator.IsChecked
    bTempRadioBut(4) = TabulatorUndLeerzeichen.IsChecked
    
    Absatzenden.UnCheck
    WeicheTrenner.UnCheck
    Leerzeichen.UnCheck
    GeschLeerzeichen.UnCheck
    Tabulatoren.UnCheck
    Umbrueche.UnCheck
    VersteckterText.UnCheck
    VersteckteAbsatze.UnCheck
    
    Kontext "ExtrasOptionenDlg"
    ExtrasOptionenDlg.OK
    
    printlog ("'/// - check if all UnChecked ///")
    ToolsOptions
    Call hToolsOptions ( "TextDocument" , "FORMATTINGAIDS" )
    
    if DirektCursor.IsChecked then WarnLog "DirektCursor x"
    if Zonen_Cursor.IsChecked then WarnLog "Zonen_Cursor x"
       
    if ( bTempRadioBut(1) <> Absatzausrichtung.IsChecked       ) then WarnLog "Absatzausrichtung state changed"
    if ( bTempRadioBut(2) <> LinkerAbsatzrand.IsChecked        ) then WarnLog "LinkerAbsatzrand state changed"
    if ( bTempRadioBut(3) <> Tabulator.IsChecked               ) then WarnLog "Tabulator state changed"
    if ( bTempRadioBut(4) <> TabulatorUndLeerzeichen.IsChecked ) then WarnLog "TabulatorUndLeerzeichen state changed"
    
    if Absatzenden.IsChecked then  WarnLog "Absatzenden x"
    if WeicheTrenner.IsChecked then  WarnLog "WeicheTrenner x"
    if Leerzeichen.IsChecked then  WarnLog "Leerzeichen x"
    if GeschLeerzeichen.IsChecked then  WarnLog "GeschLeerzeichen x"
    if Tabulatoren.IsChecked then  WarnLog "Tabulatoren x"
    if Umbrueche.IsChecked then  WarnLog "Umbrueche x"
    if VersteckterText.IsChecked then  WarnLog "VersteckterText x"
    if VersteckteAbsatze.IsChecked then  WarnLog "VersteckteAbsatze x"
    
    Printlog ("'/// - all Check -> x ///")
    
    DirektCursor.Check
    Zonen_Cursor.Check
    
    if (Tabulator.IsChecked = True) then TabulatorUndLeerzeichen.Check Else Tabulator.Check
    bTempRadioBut(1) = Absatzausrichtung.IsChecked
    bTempRadioBut(2) = LinkerAbsatzrand.IsChecked
    bTempRadioBut(3) = Tabulator.IsChecked
    bTempRadioBut(4) = TabulatorUndLeerzeichen.IsChecked
    
    Absatzenden.Check
    WeicheTrenner.Check
    Leerzeichen.Check
    GeschLeerzeichen.Check
    Tabulatoren.Check
    Umbrueche.Check
    VersteckterText.Check
    VersteckteAbsatze.Check
    
    Kontext "ExtrasOptionenDlg"
    ExtrasOptionenDlg.OK
    
    printlog ("'/// - check if all Checked ///")
    ToolsOptions
    Call hToolsOptions ( "TextDocument" , "FORMATTINGAIDS" )
    
    if not DirektCursor.IsChecked then WarnLog "DirektCursor o"
    if not Zonen_Cursor.IsChecked then WarnLog "Zonen_Cursor o"
    
    if ( bTempRadioBut(1) <> Absatzausrichtung.IsChecked       ) then WarnLog "Absatzausrichtung state changed"
    if ( bTempRadioBut(2) <> LinkerAbsatzrand.IsChecked        ) then WarnLog "LinkerAbsatzrand state changed"
    if ( bTempRadioBut(3) <> Tabulator.IsChecked               ) then WarnLog "Tabulator state changed"
    if ( bTempRadioBut(4) <> TabulatorUndLeerzeichen.IsChecked ) then WarnLog "TabulatorUndLeerzeichen state changed"
    
    if Not Absatzenden.IsChecked then  WarnLog "Absatzenden o BugID: 82942 OS"
    if Not WeicheTrenner.IsChecked then  WarnLog "WeicheTrenner o"
    if Not Leerzeichen.IsChecked then  WarnLog "Leerzeichen o"
    if Not GeschLeerzeichen.IsChecked then  WarnLog "GeschLeerzeichen o"
    if Not Tabulatoren.IsChecked then  WarnLog "Tabulatoren o"
    if Not Umbrueche.IsChecked then  WarnLog "Umbrueche o"
    if Not VersteckterText.IsChecked then  WarnLog "VersteckterText o"
    if Not VersteckteAbsatze.IsChecked then  WarnLog "VersteckteAbsatze o"
    
    printlog ("'/// - restore states ///")
    
    if ( irgendwas(1) = TRUE ) then  DirektCursor.Check Else DirektCursor.UnCheck
    if ( irgendwas(2) = TRUE ) then  Zonen_Cursor.Check Else Zonen_Cursor.UnCheck
    
    if ( bRadioBut(1) = TRUE ) then Absatzausrichtung.Check
    if ( bRadioBut(2) = TRUE ) then LinkerAbsatzrand.Check
    if ( bRadioBut(3) = TRUE ) then Tabulator.Check
    if ( bRadioBut(4) = TRUE ) then TabulatorUndLeerzeichen.Check
    
    if ( irgendwas(10) = TRUE ) then  Absatzenden.Check Else Absatzenden.UnCheck
    if ( irgendwas(11) = TRUE ) then  WeicheTrenner.Check Else WeicheTrenner.UnCheck
    if ( irgendwas(12) = TRUE ) then  Leerzeichen.Check Else Leerzeichen.UnCheck
    if ( irgendwas(13) = TRUE ) then  GeschLeerzeichen.Check Else GeschLeerzeichen.UnCheck
    if ( irgendwas(14) = TRUE ) then  Tabulatoren.Check Else Tabulatoren.UnCheck
    if ( irgendwas(15) = TRUE ) then  Umbrueche.Check Else Umbrueche.UnCheck
    if ( irgendwas(16) = TRUE ) then  VersteckterText.Check Else VersteckterText.UnCheck
    if ( irgendwas(17) = TRUE ) then  VersteckteAbsatze.Check Else VersteckteAbsatze.UnCheck
    
    Kontext "ExtrasOptionenDlg"
    ExtrasOptionenDlg.OK
    
    Call hCloseDocument
endcase

'------------------------------------------------------------------------------
testcase tToolsOptionsWriterChanges
   Dim iListBox(2) as integer         ' ListBox
   Dim iTempListBox(2) as integer
   Dim iListBox2(3,2) as integer         ' ListBox
   Dim iTempListBox2(3,2) as integer


    Call hNewDocument
    Call wBlindtextEinfuegen
    Kontext "DocumentWriter"
    DocumentWriter.TypeKeys "<Return>"
    Call hTabelleEinfuegen
    
    Call wDokSchreiben ("<Up>" , 2)
    
    printlog ("'///- Tools/Options/Writer: Changes ///")
    
    printlog ("'/// - save states ///")
    ToolsOptions
    Call hToolsOptions ("TextDocument","CHANGES")
    
    iListBox2(1,1) = EinfuegenAttribute.GetSelIndex
    iListBox2(1,2) = EinfuegenFarbe.GetSelIndex
    iListBox2(2,1) = LoeschenAttribute.GetSelIndex
    iListBox2(2,2) = LoeschenFarbe.GetSelIndex
    iListBox2(3,1) = AendernAttribute.GetSelIndex
    iListBox2(3,2) = AendernFarbe.GetSelIndex
    
    iListBox(1) = ZeilenMarkierung.GetSelIndex
    iListBox(2) = ZeilenFarbe.GetSelIndex
    
    printlog ("'///   - Change states ///")
    EinfuegenAttribute.Select 1
    EinfuegenFarbe.Select 15
    LoeschenAttribute.Select 5
    LoeschenFarbe.Select 4
    AendernAttribute.Select 8
    AendernFarbe.Select 65
    ZeilenMarkierung.Select 4
    ZeilenFarbe.Select 19
    
    Kontext "ExtrasOptionenDlg"
    ExtrasOptionenDlg.OK
    
    printlog "'///   - changes record with current formats  ///"
    UseBindings
    EditChangesRecord
    
    Call wDokSchreiben "<Return> Here are some changes"
    DocumentWriter.TypeKeys "<Up>", 8
    DocumentWriter.TypeKeys "<Backspace>", 10
    DocumentWriter.TypeKeys "<Down>", 2
    DocumentWriter.TypeKeys "<Delete>", 10
    DocumentWriter.TypeKeys "<Shift End>"
    FormatCharacter
    Kontext
    Active.SetPage TabFontEffects
    Kontext "TabFontEffects"
    Outline.Check
    Shadow.Check
    TabFontEffects.OK
    
    Kontext "DocumentWriter"
    DocumentWriter.TypeKeys "<Down>", 20
    DocumentWriter.TypeKeys "<Up>Die ﾎnderung in einer Tabelle"
    DocumentWriter.TypeKeys "<Tab>", 10
    
    printlog ("'/// - all states inverting ///")
    
    ToolsOptions
    Call hToolsOptions ("TextDocument","CHANGES")
    
    if ( EinfuegenAttribute.GetItemCount <> iListBox2(1,1) ) then EinfuegenAttribute.Select (iListBox2(1,1)+1) Else EinfuegenAttribute.Select(iListBox2(1,1)-1)
    if ( EinfuegenFarbe.GetItemCount     <> iListBox2(1,2) ) then EinfuegenFarbe.Select     (EinfuegenFarbe.GetItemCount    ) Else EinfuegenFarbe.Select    (1)
    iTempListBox2(1,1) = EinfuegenAttribute.GetSelIndex
    iTempListBox2(1,2) = EinfuegenFarbe.GetSelIndex
    if ( LoeschenAttribute.GetItemCount <> iListBox2(2,1) ) then LoeschenAttribute.Select (LoeschenAttribute.GetItemCount) Else LoeschenAttribute.Select(1)
    if ( LoeschenFarbe.GetItemCount     <> iListBox2(2,2) ) then LoeschenFarbe.Select     (LoeschenFarbe.GetItemCount    ) Else LoeschenFarbe.Select    (1)
    iTempListBox2(2,1) = LoeschenAttribute.GetSelIndex
    iTempListBox2(2,2) = LoeschenFarbe.GetSelIndex
    if ( AendernAttribute.GetItemCount <> iListBox2(3,1) ) then AendernAttribute.Select (AendernAttribute.GetItemCount) Else AendernAttribute.Select(1)
    if ( AendernFarbe.GetItemCount     <> iListBox2(3,2) ) then AendernFarbe.Select     (AendernFarbe.GetItemCount    ) Else AendernFarbe.Select    (1)
    iTempListBox2(3,1) = AendernAttribute.GetSelIndex
    iTempListBox2(3,2) = AendernFarbe.GetSelIndex    
    if ( ZeilenMarkierung.GetItemCount   <> iListBox(1) ) then ZeilenMarkierung.Select   (ZeilenMarkierung.GetItemCount  ) Else ZeilenMarkierung.Select  (1)
    if ( ZeilenFarbe.GetItemCount        <> iListBox(2) ) then ZeilenFarbe.Select        (ZeilenFarbe.GetItemCount       ) Else ZeilenFarbe.Select       (1)
    iTempListBox(1) = ZeilenMarkierung.GetSelIndex
    iTempListBox(2) = ZeilenFarbe.GetSelIndex
    
    Kontext "ExtrasOptionenDlg"
    ExtrasOptionenDlg.OK
    
    printlog ("'/// - SO quit - start ///")
    
    Call wOfficeRestart
    
    printlog ("'/// - checking states ///")
    ToolsOptions
    Call hToolsOptions ( "TextDocument" , "CHANGES" )
    
    if ( EinfuegenAttribute.GetSelIndex <> iTempListBox2(1,1) ) then WarnLog "EinfuegenAttribute state changed; is: "+EinfuegenAttribute.GetSelIndex +"; should: "+ iTempListBox2(1,1)
    if ( EinfuegenFarbe.GetSelIndex     <> iTempListBox2(1,2) ) then WarnLog "EinfuegenFarbe state changed"
    if ( LoeschenAttribute.GetSelIndex <> iTempListBox2(2,1) ) then WarnLog "LoeschenAttribute state changed"
    if ( LoeschenFarbe.GetSelIndex     <> iTempListBox2(2,2) ) then WarnLog "LoeschenFarbe state changed"
    if ( AendernAttribute.GetSelIndex <> iTempListBox2(3,1) ) then WarnLog "AendernAttribute state changed"
    if ( AendernFarbe.GetSelIndex     <> iTempListBox2(3,2) ) then WarnLog "AendernFarbe state changed"
    if ( ZeilenMarkierung.GetSelIndex   <> iTempListBox(1) ) then WarnLog "ZeilenMarkierung state changed"
    if ( ZeilenFarbe.GetSelIndex        <> iTempListBox(2) ) then WarnLog "ZeilenFarbe state changed"
    
    Kontext "ExtrasOptionenDlg"
    ExtrasOptionenDlg.OK
    
    printlog ("'/// - all UnCheck -> o ///")
    ToolsOptions
    Call hToolsOptions ( "TextDocument" , "CHANGES" )
    
    EinfuegenAttribute.Select(1)
    EinfuegenFarbe.Select    (1)
    LoeschenAttribute.Select (LoeschenAttribute.GetItemCount)
    LoeschenFarbe.Select     (LoeschenFarbe.GetItemCount    )
    AendernAttribute.Select(1)
    AendernFarbe.Select    (1)
    
    ZeilenMarkierung.Select  (1)
    ZeilenFarbe.Select       (1)
    
    Kontext "ExtrasOptionenDlg"
    ExtrasOptionenDlg.OK
    
    printlog ("'/// - check if all UnChecked ///")
    ToolsOptions
    Call hToolsOptions ( "TextDocument" , "CHANGES" )
    
    if (EinfuegenAttribute.GetSelIndex <> 1 ) then WarnLog "EinfuegenAttribute is not item 1"
    if (EinfuegenFarbe.GetSelIndex     <> 1 ) then WarnLog "EinfuegenFarbe is not item 1"
    if (LoeschenAttribute.GetSelIndex <> LoeschenAttribute.GetItemCount ) then WarnLog "LoeschenAttribute is not item (GetItemCount)"
    if (LoeschenFarbe.GetSelIndex     <> LoeschenFarbe.GetItemCount     ) then WarnLog "LoeschenFarbe is not item (GetItemCount)"
    if (AendernAttribute.GetSelIndex <> 1 ) then WarnLog "AendernAttribute is not item 1"
    if (AendernFarbe.GetSelIndex     <> 1 ) then WarnLog "AendernFarbe is not item 1"
    if (ZeilenMarkierung.GetSelIndex   <> 1 ) then WarnLog "ZeilenMarkierung is not item 1"
    if (ZeilenFarbe.GetSelIndex        <> 1 ) then WarnLog "ZeilenFarbe is not item 1"
    
    Printlog ("'/// - all Check -> x ///")
    EinfuegenAttribute.Select (EinfuegenAttribute.GetItemCount)
    EinfuegenFarbe.Select     (EinfuegenFarbe.GetItemCount    )
    LoeschenAttribute.Select(1)
    LoeschenFarbe.Select    (1)
    AendernAttribute.Select (AendernAttribute.GetItemCount)
    AendernFarbe.Select     (AendernFarbe.GetItemCount    )
    
    ZeilenMarkierung.Select   (ZeilenMarkierung.GetItemCount  )
    ZeilenFarbe.Select        (ZeilenFarbe.GetItemCount       )
    
    Kontext "ExtrasOptionenDlg"
    ExtrasOptionenDlg.OK
    
    printlog ("'/// - check if all Checked ///")
    ToolsOptions
    Call hToolsOptions ( "TextDocument" , "CHANGES" )
    
    if (EinfuegenAttribute.GetSelIndex <> EinfuegenAttribute.GetItemCount ) then WarnLog "EinfuegenAttribute is not item (GetItemCount)"
    if (EinfuegenFarbe.GetSelIndex     <> EinfuegenFarbe.GetItemCount     ) then WarnLog "EinfuegenFarbe is not item (GetItemCount)"
    if (LoeschenAttribute.GetSelIndex <> 1 ) then WarnLog "LoeschenAttribute is not item 1"
    if (LoeschenFarbe.GetSelIndex     <> 1 ) then WarnLog "LoeschenFarbe is not item 1"
    if (AendernAttribute.GetSelIndex <> AendernAttribute.GetItemCount ) then WarnLog "AendernAttribute is not item (GetItemCount)"
    if (AendernFarbe.GetSelIndex     <> AendernFarbe.GetItemCount     ) then WarnLog "AendernFarbe is not item (GetItemCount)"
    
    if (ZeilenMarkierung.GetSelIndex   <> ZeilenMarkierung.GetItemCount   ) then WarnLog "ZeilenMarkierung is not item (GetItemCount)"
    if (ZeilenFarbe.GetSelIndex        <> ZeilenFarbe.GetItemCount        ) then WarnLog "ZeilenFarbe is not item (GetItemCount)"
    
    Kontext "ExtrasOptionenDlg"
    ExtrasOptionenDlg.Cancel
    
    '--------------------------------------------------------------------------
    'new document starts with unchecked edit changes record!? (i hope always ;-))
    printlog ("'/ Function test: color-real-print / screenshot also possible///'")
    Call hNewDocument
    sleep (3)
    
    Kontext "DocumentWriter"
    DocumentWriter.TypeKeys "This is normal text"
    DocumentWriter.TypeKeys "<return>"
    DocumentWriter.TypeKeys "The quick brown fox jumps over the lazy dog"
    DocumentWriter.TypeKeys "<return>"
    
    ToolsOptions
    Call hToolsOptions ( "TextDocument" , "CHANGES" )
    EinfuegenAttribute.Select (2) 'bold
    EinfuegenFarbe.Select     (8) 'mangenta
    LoeschenAttribute.Select  (4) 'strikethrough
    LoeschenFarbe.Select      (92)  ' sun3
    AendernAttribute.Select   (8) 'smallcaps
    AendernFarbe.Select       (30)'red4
    
    ZeilenMarkierung.Select   (4) 'outer margins
    ZeilenFarbe.Select        (52)'turquise4
    Kontext "ExtrasOptionenDlg"
    ExtrasOptionenDlg.Ok
    
    Kontext "DocumentWriter"
    DocumentWriter.TypeKeys "This is inserted text"
    DocumentWriter.TypeKeys "<return>"
    EditChangesRecord
    DocumentWriter.TypeKeys "The quick brown fox jumps over the lazy dog"
    DocumentWriter.TypeKeys "<return>"
    EditChangesRecord
    DocumentWriter.TypeKeys "This is attribut-changed text"
    DocumentWriter.TypeKeys "<return>"
    DocumentWriter.TypeKeys "The quick brown fox jumps over the lazy dog"
    EditChangesRecord
    DocumentWriter.TypeKeys "<shift home>"
    DocumentWriter.TypeKeys "<mod1 i><end>"
    DocumentWriter.TypeKeys "<return>"
    EditChangesRecord
    DocumentWriter.TypeKeys "This is backspaced text"
    DocumentWriter.TypeKeys "<return>"
    DocumentWriter.TypeKeys "The quick brown fox jumps over the lazy dog"
    DocumentWriter.TypeKeys "<shift home>"
    EditChangesRecord
    DocumentWriter.TypeKeys "<backspace>"
    EditChangesRecord
    DocumentWriter.TypeKeys "<end><return>"
    DocumentWriter.TypeKeys "This is deleted text"
    DocumentWriter.TypeKeys "<return>"
    DocumentWriter.TypeKeys "The quick brown fox jumps over the lazy dog"
    EditChangesRecord
    DocumentWriter.TypeKeys "<shift home>"
    DocumentWriter.TypeKeys "<delete><end>"
    DocumentWriter.TypeKeys "<return>"
    EditChangesRecord
    Call hCloseDocument
    '--------------------------------------------------------------------------
    printlog ("'/// - restore states ///")
    ToolsOptions
    Call hToolsOptions ( "TextDocument" , "CHANGES" )
    
    try
        EinfuegenAttribute.Select (iListBox2(1,1))
    catch
        EinfuegenAttribute.Select (1)
        Warnlog ("EinfuegenAttribute has wrong initialvalue: " + iListBox2(1,1) + ", BugID: 83097")
    endcatch
    try
        EinfuegenFarbe.Select     (iListBox2(1,2))
    catch
        EinfuegenFarbe.Select (1)
        WarnLog ("EinfuegenFarbe has wrong initialvalue: " + iListBox2(1,2))
    endcatch
    
    try
        printlog       iListBox2(2,1)
        LoeschenAttribute.Select (iListBox2(2,1))
    catch
        LoeschenAttribute.Select (1)
        WarnLog ("LoeschenAttribute has wrong initialvalue: " + iListBox2(2,1) )
    endcatch
    
    try
        LoeschenFarbe.Select     (iListBox2(2,2))
    catch
        LoeschenFarbe.Select (1)
        WarnLog ("LoeschenFarbe has wrong initialvalue: " + iListBox2(2,2))
    endcatch
    
    try
        AendernAttribute.Select (iListBox2(3,1))
    catch
        AendernAttribute.Select (1)
        WarnLog ("AendernAttribute has wrong initialvalue: " + iListBox2(3,1) )
    endcatch

    try
        AendernFarbe.Select     (iListBox2(3,2))
    catch
        AendernFarbe.Select (1)
        WarnLog ("AendernFarbe has wrong initialvalue: " + iListBox2(3,2))
    endcatch
    
    try
        ZeilenMarkierung.Select   (iListBox(1))
    catch
        ZeilenMarkierung.Select (1)
        WarnLog ("ZeilenMarkierung has wrong initialvalue: " + iListBox(3))
    endcatch

    try
        ZeilenFarbe.Select        (iListBox(2))
    catch
        ZeilenFarbe.Select (1)
        WarnLog ("ZeilenFarbe has wrong initialvalue: " + iListBox(4))
    endcatch
    
    Kontext "ExtrasOptionenDlg"
    ExtrasOptionenDlg.OK
    
    Call hCloseDocument
endcase

'------------------------------------------------------------------------------
testcase tToolsOptionsWriterInsert
    Dim irgendwas(8) as boolean    ' Checkbox states

    Call hNewDocument
    printlog "'///- Tools/Options/Writer: Table ///"

    printlog ("'/// - save states ///")
    ToolsOptions
    Call hToolsOptions ("TextDocument","Table")

    irgendwas(2) = Ueberschrift.IsChecked
    irgendwas(3) = Wiederholen.IsChecked
    irgendwas(4) = NichtTrennen.IsChecked
    irgendwas(5) = Umrandung.IsChecked

    irgendwas(6) = AutomatischeZahlenerkennung.IsChecked
    irgendwas(7) = Zahlenformaterkennung.IsChecked
    irgendwas(8) = AutomatischeAusrichtung.IsChecked

    printlog ("'/// - all states inverting ///")

    Ueberschrift.Check
    if irgendwas(3) then Wiederholen.UnCheck                 Else Wiederholen.Check
    if irgendwas(4) then NichtTrennen.UnCheck                Else NichtTrennen.Check
    if irgendwas(5) then Umrandung.UnCheck                   Else Umrandung.Check
    AutomatischeZahlenerkennung.Check
    if irgendwas(7) then Zahlenformaterkennung.UnCheck       Else Zahlenformaterkennung.Check
    if irgendwas(8) then AutomatischeAusrichtung.UnCheck     Else AutomatischeAusrichtung.Check

    Kontext "ExtrasOptionenDlg"
    ExtrasOptionenDlg.OK

    printlog ("'/// - SO quit - start ///")

    Call wOfficeRestart

    printlog ("'/// - checking states ///")
    ToolsOptions
    Call hToolsOptions ( "TextDocument" , "Table" )

    if ( Ueberschrift.IsChecked                = False ) then WarnLog "Ueberschrift state changed"
    if ( irgendwas(3) = Wiederholen.IsChecked                 ) then WarnLog "Wiederholen state changed"
    if ( irgendwas(4) = NichtTrennen.IsChecked                ) then WarnLog "NichtTrennen state changed"
    if ( irgendwas(5) = Umrandung.IsChecked                   ) then WarnLog "Umrandung state changed"

    if ( AutomatischeZahlenerkennung.IsChecked = False ) then WarnLog "AutomatischeZahlenerkennung state changed"
    if ( irgendwas(7) = Zahlenformaterkennung.IsChecked       ) then WarnLog "Zahlenformaterkennung state changed"
    if ( irgendwas(8) = AutomatischeAusrichtung.IsChecked     ) then WarnLog "AutomatischeAusrichtung state changed"

    Kontext "ExtrasOptionenDlg"
    ExtrasOptionenDlg.OK

    printlog ("'/// - all UnCheck -> o ///")
    ToolsOptions
    Call hToolsOptions ( "TextDocument" , "Table" )

    Ueberschrift.UnCheck
    NichtTrennen.UnCheck
    Umrandung.UnCheck
    AutomatischeZahlenerkennung.UnCheck
    
    Kontext "ExtrasOptionenDlg"
    ExtrasOptionenDlg.OK

    Printlog "'///    - check in InsertTableWriter ///"
    Call hNewDocument
    InsertTableWriter
    Kontext "TabelleEinfuegenWriter"

    if ( Ueberschrift.IsChecked          ) then WarnLog "Ueberschrift x"
    if ( TabelleNichtTrennen.IsChecked ) then WarnLog "NichtTrennen x"
    if ( Umrandung.IsChecked           ) then WarnLog "Umrandung x"

    TabelleEinfuegenWriter.OK

    Kontext "DocumentWriter"
    DocumentWriter.TypeKeys "<Down>1<Tab><Left>"
    FormatParagraph
    Kontext
    Active.SetPage TabAusrichtungAbsatz
    Kontext "TabAusrichtungAbsatz"
    if NOT Links.IsChecked then Warnlog "Die automatische Ausrichtung der Zahl wurde trotzdem durchgefﾁhrt!"
    TabAusrichtungAbsatz.Cancel

    FormatNumberFormat
    Kontext "Zahlenformat"
    if Kategorie.GetSelIndex <> 11 then Warnlog "Das Zahlenformat ist nicht Text geblieben!"
    Zahlenformat.Cancel
    Call hCloseDocument

    printlog ("'/// - check if all UnChecked ///")
    ToolsOptions
    Call hToolsOptions ( "TextDocument" , "Table" )

    if Ueberschrift.IsChecked                then WarnLog "Ueberschrift x"
    if NichtTrennen.IsChecked                then WarnLog "NichtTrennen x"
    if Umrandung.IsChecked                   then WarnLog "Umrandung x"

    if AutomatischeZahlenerkennung.IsChecked then WarnLog "AutomatischeZahlenerkennung x"

    Printlog ("'/// - all Check -> x ///")

    Ueberschrift.Check
    Wiederholen.Check
    NichtTrennen.Check
    Umrandung.Check
    
    AutomatischeZahlenerkennung.Check
    Zahlenformaterkennung.Check
    AutomatischeAusrichtung.Check
    
    Kontext "ExtrasOptionenDlg"
    ExtrasOptionenDlg.OK

    Printlog "'///    - check in InsertTableWriter ///"
    Call hNewDocument
    InsertTableWriter
    Kontext "TabelleEinfuegenWriter"

    if ( Ueberschrift.IsChecked                = FALSE ) then WarnLog "Ueberschrift o"
    if ( UeberschriftWiederholen.IsChecked                 = FALSE ) then WarnLog "Wiederholen o"
    if ( TabelleNichtTrennen.IsChecked                = FALSE ) then WarnLog "NichtTrennen o"
    if ( Umrandung.IsChecked                   = FALSE ) then WarnLog "Umrandung o"

    TabelleEinfuegenWriter.Ok

    Kontext "DocumentWriter"
    DocumentWriter.TypeKeys "<Down>1<Tab><Left>"
    FormatParagraph
    Kontext
    Active.SetPage TabAusrichtungAbsatz
    Kontext "TabAusrichtungAbsatz"
    if NOT Rechts.IsChecked then Warnlog "Alignment of number didn't change to: right!"
    TabAusrichtungAbsatz.Cancel

    FormatNumberFormat
    Kontext "Zahlenformat"
    if Kategorie.GetSelIndex <> 3 then Warnlog "numberformat didn't get changed!"
    Zahlenformat.Cancel
    
    Call hCloseDocument

    printlog ("'/// - check if all Checked ///")
    ToolsOptions
    Call hToolsOptions ( "TextDocument" , "Table" )

    if ( Ueberschrift.IsChecked                = FALSE ) then WarnLog "Ueberschrift o"
    if ( Wiederholen.IsChecked                 = FALSE ) then WarnLog "Wiederholen o"
    if ( NichtTrennen.IsChecked                = FALSE ) then WarnLog "NichtTrennen o"
    if ( Umrandung.IsChecked                   = FALSE ) then WarnLog "Umrandung o"
    
    if ( AutomatischeZahlenerkennung.IsChecked = FALSE ) then WarnLog "AutomatischeZahlenerkennung o"
    if ( Zahlenformaterkennung.IsChecked       = FALSE ) then WarnLog "Zahlenformaterkennung o"
    if ( AutomatischeAusrichtung.IsChecked     = FALSE ) then WarnLog "AutomatischeAusrichtung o"

    printlog ("'/// - restore states ///")

    Call wOptionenUndo("Table")
    
    Call hCloseDocument
endcase

' ********************************************************************

testcase tToolsOptionsAutocaption
    Dim Auswahl(20) as String
    Dim i as Integer
    Dim ObjectTmp() as string
    printlog "'///- Tools/Options/StarOffice Writer/AutoCaption ///"
    ToolsOptions
    Call hToolsOptions("TEXTDOCUMENT","AutoCaption")
    Kontext "TabAutocaption"
    for i=1 to ObjectList.GetItemCount
        ObjectList.Select i
        ObjectList.Check
        ObjectTmp() = Split(ObjectList.GetSelText, " ")        
        Auswahl(i) = ObjectTmp(Ubound(ObjectTmp()))
        Category.SetText Auswahl(i)
    next i

    Kontext "ExtrasOptionenDlg"
    ExtrasOptionenDlg.OK

    printlog "'///   - Check table caption ///"
    Call hNewDocument
    ViewZoom
    Kontext "Massstab"
    Seitenbreite.Check
    Massstab.OK
    InsertTableWriter
    Kontext "TabelleEinfuegenWriter"
    TabelleEinfuegenWriter.OK
    Kontext "DocumentWriter"
    Call wDokSchreiben ("<Down>", 2)
    Call wDokSchreiben ("<Home>")
    Select Case iSprache
        Case 31:
            Call wDokSchreiben ("<Mod1 Shift Right>", 3)
        Case else
            Call wDokSchreiben ("<Mod1 Shift Right>")
    end select
    EditCopy
    wait 500
    if Trim$(GetClipboardText) <> Auswahl ( 1 ) then Warnlog "Table caption is wrong. Not " & Auswahl(1) & " but: " & GetClipboardtext
    EditUndo

    printlog "'///   - Check frame caption ///"
    InsertFrame
    Kontext
    Active.SetPage TabType
    Kontext "TabType"
    Width.SetText "2"
    TabType.OK
    Call wDokSchreiben ("<Return><Down>")
    Select Case iSprache
        Case 31:
            Call wDokSchreiben ("<Mod1 Shift Right>", 3)
        Case else
            Call wDokSchreiben ("<Mod1 Shift Right>")
    end select
    EditCopy
    Wait 500
    if Trim$(GetClipboardText) <> Auswahl (2) then Warnlog "Caption of a frame is wrong.  Not " & Auswahl(2) & " but: " & GetClipboardtext
    Call wDokSchreiben ("<Escape>")
    Call wDokSchreiben ("<Delete>")

    printlog "'///   - Check graphics caption ///"
    '///+ "writer\input\grafik\jolink.jpg" ///
    Call hGrafikEinfuegen ( gTesttoolPath + "writer\input\grafik\jolink.jpg" )
    Call wDokSchreiben ("<Return>")
    Select Case iSprache
        Case 31:
            Call wDokSchreiben ("<Mod1 Shift Right>", 3)
        Case else
            Call wDokSchreiben ("<Mod1 Shift Right>")
    end select
    EditCopy
    if Trim$(GetClipboardText) <> Auswahl (3) then Warnlog "Caption of a graphic is wrong. Not " & Auswahl(3) & " but: " & GetClipboardtext
    Call hCloseDocument
    
    printlog "'///   - Check caption of all other objects ///"
    for i=1 to 5        
        Call hNewDocument    
        InsertObjectOLEObject
        Kontext "OLEObjektEinfuegen"
        Objekttyp.Select i
        printlog " - " & Objekttyp.GetSelText
        OLEObjektEinfuegen.OK

        Kontext "DocumentWriter"
        Call gMouseClick ( 90, 90 )
        Sleep 2
        Call wDokSchreiben ("<Return>")
        Select Case i
            Case 1,3,4,5
                Select Case iSprache
                    Case 31
                        Call wDokSchreiben ("<Mod1 Shift Right>",3)
                    Case else
                        Call wDokSchreiben ("<Mod1 Shift Right>")
                end select
            Case else
                Call wDokSchreiben ("<Mod1 Shift Right>")
        end select
        EditCopy
        if Trim$(GetClipboardText) <> Auswahl (i+3) then Warnlog "Caption of a " & Auswahl(i+3) & " is wrong. Not " & Auswahl(i+3) & " but: " & GetClipboardtext
        Call hCloseDocument
    next i

    printlog "'///   - Set defaults ///"
    ViewZoom
    Kontext "Massstab"
    Vergroesserung100.Check
    Massstab.OK

    ToolsOptions
    Call hToolsOptions("TEXTDOCUMENT","AutoCaption")
    Kontext "TabAutocaption"
    for i=1 to ObjectList.GetItemCount
        ObjectList.Select i
        ObjectList.Uncheck
    next i

    Kontext "ExtrasOptionenDlg"
    ExtrasOptionenDlg.OK
    
endcase

'-------------------------------------------------------------------

testcase tToolsOptionsWriterCompatibility1
    
    Dim i as integer
    
    printlog "Check status change of all checkboxes in StarOffice Writer->Compatibility options" 
    '/// Test of option 'Use StarOffice 6.0/7 tabstop formatting'
    Call hNewDocument
    ToolsOptions
    Call hToolsOptions("TEXTDOCUMENT","COMPATIBILITY")
    '/// Check defaults of checkboxes. if default is wrong then set to default
    Kontext "TabCompatibility"
    For i = 1 to Options.GetItemCount
        Options.Select i
        Select case i         
            Case 2,3,7
                if Not Options.IsChecked then
                    Warnlog "Default for checkbox " & i & " is wrong (not checked)"
                    Options.Check
                endif
            Case else
                if Options.IsChecked then
                    Warnlog "Default for checkbox " & i & " is wrong (checked)"
                    Options.UnCheck
                endif
        end select
    next i
    '/// Check all checkboxes
    printlog " - check all checkboxes"
    For i = 1 to Options.GetItemCount
        Options.Select i
        Options.Check
    next i
    Default.Click
    Kontext "Active"
    if Active.Exists then
        if Active.GetRT = 304 then
            Active.Yes
        endif
    endif
    Kontext "ExtrasOptionenDlg"
    ExtrasOptionenDlg.Ok

    Call wOfficeRestart
    '/// restart the office

    '/// check state of all checkboxes and uncheck all checkboxes
    ToolsOptions
    Call hToolsOptions("TEXTDOCUMENT","COMPATIBILITY")
    Kontext "TabCompatibility"
    For i = 1 to Options.GetItemCount
        Options.Select i
        if Not Options.IsChecked then
            Warnlog "Checkbox " & i & " looses state after restart"
        else
            Options.Uncheck
        endif
    next i
    Default.Click
    Kontext "Active"
    if Active.Exists then
        if Active.GetRT = 304 then
            Active.Yes
        endif
    endif
    Kontext "ExtrasOptionenDlg"
    ExtrasOptionenDlg.Ok

    Call wOfficeRestart
    '/// restart the office

    '/// check state of all checkboxes and set defaults
    ToolsOptions
    Call hToolsOptions("TEXTDOCUMENT","COMPATIBILITY")
    Kontext "TabCompatibility"
    For i = 1 to Options.GetItemCount
        Options.Select i
        if Options.IsChecked then
            Warnlog "Checkbox " & i & " looses state after restart"
        endif
        Select Case i
            Case 2,3,7
                Options.Check
            Case else
                Options.UnCheck
        end select        
    next i
    Default.Click
    Kontext "Active"
    if Active.Exists then
        if Active.GetRT = 304 then
            Active.Yes
        endif
    endif
    Kontext "ExtrasOptionenDlg"
    ExtrasOptionenDlg.Ok

    Call hCloseDocument
    
endcase

'-------------------------------------------------------------------

testcase tToolsOptionsWriterCompatibility2
    
    Dim i as integer, DefaultFailed as boolean
    printlog "Test of option 'Use StarOffice 6.0/7 tabstop formatting'"
    
    Call hNewDocument    
    '/// open document  ./writer/leve11/input/options/compatibility1.doc
    '/// check formatting of current opened document
    Call hDateiOeffnen ( gTesttoolpath & "writer\level1\input\options\compatibility1.doc" )
    Call wDokSchreiben ("<Mod1 Home>")
    Call wDokSchreiben ("<Down>")
    Call wDokSchreiben ("<Shift Right>")
    try
        EditCopy
        if GetClipboardtext <> "A" then
            Warnlog "Seems document has been formatted wrong"
            DefaultFailed = true
        endif
    catch
        Warnlog "Seems document has been formatted wrong"
        DefaultFailed = true
    endcatch
    
    Call wDokSchreiben ("<Home>")
    Call wDokSchreiben ("<Down>" ,3)
    Call wDokSchreiben ("<Shift Right>")
    try
        EditCopy
        if GetClipboardtext <> "A" then
            Warnlog "Seems document has been formatted wrong"
            DefaultFailed = true
        endif
    catch
        Warnlog "Seems document has been formatted wrong"
        DefaultFailed = true
    endcatch
    
    if DefaultFailed = false then
        '/// in Tools->Options->StarOffice Writer->Compatitibility check option 'Use StarOffice 6.0/7 tabstop formatting'
        ToolsOptions
        Call hToolsOptions("TEXTDOCUMENT","COMPATIBILITY")
        '/// Check defaults of checkboxes. if default is wrong then set to default
        Kontext "TabCompatibility"
        Options.Select 4
        Options.Check
        Kontext "ExtrasOptionenDlg"
        ExtrasOptionenDlg.Ok
        '/// Now check if document has been reformatted
        Call wDokSchreiben ("<Mod1 Home>")
        Call wDokSchreiben ("<Down>" , 2)
        Call wDokSchreiben ("<Shift Right>")
        try
            EditCopy
            if GetClipboardtext <> "A" then
                Warnlog "Seems document has been formatted wrong"
            endif
        catch
            Warnlog "Seems document has been formatted wrong"
        endcatch
        
        Call wDokSchreiben ("<Home>")
        Call wDokSchreiben ("<Down>" , 4)
        Call wDokSchreiben ("<Shift Right>")
        try
            EditCopy
            if GetClipboardtext <> "A" then
                Warnlog "Seems document has been formatted wrong"
            endif
        catch
            Warnlog "Seems document has been formatted wrong"
        endcatch        

        '/// in Tools->Options->StarOffice Writer->Compatitibility uncheck option 'Use StarOffice 6.0/7 tabstop formatting'
        ToolsOptions
        Call hToolsOptions("TEXTDOCUMENT","COMPATIBILITY")
        '/// Check defaults of checkboxes. if default is wrong then set to default
        Kontext "TabCompatibility"
        Options.Select 4
        Options.UnCheck
        Kontext "ExtrasOptionenDlg"
        ExtrasOptionenDlg.Ok
    endif                    

    '/// Close document
    Call hCloseDocument
endcase
