'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: w_table.bas,v $
'*
'*  $Revision: 1.14 $
'*
'*  last change: $Author: hde $ $Date: 2006/02/08 10:07:56 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : helge.delfs@sun.com
'*
'* short description : Writer Table test
'*
'\***********************************************************************


global sLocaleDetail(120) as string, mUnit as string
global cDecSep as string 'Decimal Seperator init in 'sub w_204_'
global cSep as string 'Seperator for numbers formated as text init in 'sub w_204_'

sub main
    Dim StartZeit
    StartZeit = Now()

    use "writer\tools\inc\w_tools.inc"
    use "writer\tools\inc\w_tool5.inc"
    use "writer\tools\inc\w_tool6.inc"

    use "writer\level1\inc\table\w_204_.inc"
    use "writer\level1\inc\table\w_204a_.inc"
    use "writer\level1\inc\table\w_204b_.inc"

    printlog Chr(13) + "Loading of Include - Files takes: " + Wielange ( StartZeit )

    Printlog ""
    Printlog "----------------------------------------------------------"
    Printlog "|                  Writer Table Test                     |"
    Printlog "----------------------------------------------------------"
    Printlog ""
  
    if (hSetLocaleStrings (gTesttoolPath + "writer\level1\input\locale.txt",sLocaleDetail())) <> TRUE then
        warnlog "Locales doesn't exist in file : " + gTesttoolPath + "writer\level1\input\locale.txt"
        warnlog "Start 'writer\tools\w_lvl2_get_locale_strings.bas' to get the right entrys for this language!"
        exit sub
    endif
    Call wOptionenUndo("Table")
    Call hNewDocument
    mUnit = fSetMeasurementToCM()
    ToolsOptions
    Call hToolsOptions ("TextDocument","GENERAL")        
    cDecSep = GetDecimalSeperator(Tabulatorenabstand.GetText)
    Kontext "ExtrasOptionenDlg"
    ExtrasOptionenDlg.Ok

    ' Seperator to calculate with is not the same as used in UI
    ' so we can't use GetDecimalSeparator here
    Call wDokSchreiben ("1/2")
    Call wDokSchreiben ("<Shift Home>")
    ToolsCalculate
    if Instr(GetClipBoardtext, ",") > 0 then cSep = ","
    if Instr(GetClipBoardtext, ".") > 0 then cSep = "."
    Call hCloseDocument    
   
    Call hStatusIn("writer","w_table.bas","Writer Table test")
    Call w_204_
    Call w_204a_
    Call w_204b_
    Call hStatusOut

    Printlog "Duration: "+ WieLange ( StartZeit )
    Printlog "Date: " +  Date + "    Time: " + Time
end sub

sub LoadIncludeFiles
    use "global\system\inc\master.inc"
    use "global\system\inc\gvariabl.inc"
    Call GetUseFiles
    gApplication = "Writer"
end sub
