'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: xmltool2.inc,v $
'*
'*  $Revision: 1.5 $
'*
'*  last change: $Author: tbo $ $Date: 2005/09/08 08:33:29 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : joerg.sievers@sun.com
'*
'* short description : Library for Performance Test (Level 2)
'*
'***************************************************************************************
' **
' #1 hExitAndRestart
' #1 ReplaceCharacter
' **
'\**************************************************************************************
sub hExitAndRestart (sFileName as string)
'/// (Re)Starts the Office with parameters for the profiling
'///+ support inside the application.
'/// If the directory for profiling does not exist it will be created.
'/// <u>Note</u>: Not all versions of OOo have this feature enabled!    
  Dim sPath as String
  Dim specialgOfficePath as string
  
  if gPlatGroup = "w95" then
    specialgOfficePath = ReplaceCharacter( gOfficePath , "\" , "\\")
    sPath = specialgOfficePath + "user\\work\\xml\\profile\\results\\"
    printlog "Creating directory: " & ( gOfficePath + "user\work\xml\profile\results\" )
    mkdir ( gOfficePath + "user\work\xml\profile\results\" )
   else
    sPath = ConvertPath ( gOfficePath + "user\work\xml\profile\results\"  )
    printlog "Creating directory: " & sPath
    mkdir ( sPath )
  end if
  printlog "Call ExitRestartTheOffice (" & sPath & ", " & sFileName & ")"
  Call ExitRestartTheOffice (sPath, sFileName)  
end sub

'-------------------------------------------------------------------------

function ReplaceCharacter(stringToChange$, charToReplace$, replaceWith$) As String
'/// Replaces a specified character in a string with another character that you specify
    Dim ln, n As Long
    Dim NextLetter As String
    Dim FinalString As String
    Dim txt, char, rep As String
    txt = stringToChange$ 'store all arguments in
    char = charToReplace$ 'new variables
    rep = replaceWith$

    ln = Len(txt)

   For n = 1 To ln Step 1
    NextLetter = Mid(txt, n, 1)
    If NextLetter = char Then
     NextLetter = rep
    End If
    FinalString = FinalString & NextLetter
   Next n
  ReplaceCharacter = FinalString
end function

'-------------------------------------------------------------------------
