'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: oasis_graphics_update.bas,v $
'*
'*  $Revision: 1.4 $
'*
'*  last change: $Author: tbo $ $Date: 2005/09/07 19:28:18 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : joerg.sievers@sun.com
'*
'* short description : OASIS OpenDocument Fileformat Test (Presentation and Drawing)
'*
'\***********************************************************************************

Dim gPresentationFilter as string
Dim gDrawingFilter as string

sub main   
    printlog "-------------------------------------------------------------------"
    printlog "- OASIS OpenDocument file format Test (Presentation and Drawing)  -"
    printlog "-------------------------------------------------------------------"
       
    use "xml\update\inc\oasis_graphics_01.inc"
    Call sSoftwareConfiguration
       
    call hStatusIn ("XML" , "oasis_graphics_update.bas")
        call talien_attributes
        call t_all_header_footer
        call t_no_header_footer
        call t_no_header_footer_master_elements
        call t_some_header_footer              
    call hStatusOut
end sub

'-------------------------------------------------------------------------

sub LoadIncludeFiles
   use "global\system\inc\master.inc"
   use "global\system\inc\gvariabl.inc"
   use "global\tools\inc\t_xml2.inc"
   Call GetUseFiles   
end sub

'-------------------------------------------------------------------------

sub sSoftwareConfiguration
'/// Setting the software into a defined state.
    Dim sUIFilternamePresentation as string    
    Dim vExtensionPresentation(10) as string
    Dim sPresentationFilterReference as string

    Dim sUIFilternameDrawing as string    
    Dim vExtensionDrawing(10) as string
    Dim sDrawingFilterReference as string

    'Needed lib for the call to 'CreateWorkXMLExportDir'
    use "xml\tools\xmltool1.inc"    
    
    'Creating the directory for the exported files.
    call CreateWorkXMLExportDir ( "user\work\xml\graphics\update\" )
                   
    '/// Get the OASIS OpenDocument filter names for the application
    '///+ and verify it with a reference file.
    
    '-------------------------------------------------------------------------
    'Presentation
    '-------------------------------------------------------------------------

    gApplication   = "IMPRESS"    
    sUIFilternamePresentation = hGetUIFiltername("impress8")
    vExtensionPresentation() = hGetFilternameExtension("impress8")
    'gPresentationFilter has to be set GLOBALY for the WHOLE TEST SCRIPT!
    gPresentationFilter = sUIFilternamePresentation & " (." & vExtensionPresentation(0) & ")"              
    sPresentationFilterReference = hGetFilter()    
    
    if sPresentationFilterReference <> gPresentationFilter then        
        warnlog "Reference file for current OASIS filter (presentation) and real filter name in UI are not the same!"
        printlog "Reference file: " & sPresentationFilterReference
        printlog "UI Name in Office: " & gPresentationFilter
    end if

    '-------------------------------------------------------------------------    
    'Drawing
    '-------------------------------------------------------------------------

    gApplication   = "DRAW"
    sUIFilternameDrawing = hGetUIFiltername("draw8")
    vExtensionDrawing() = hGetFilternameExtension("draw8")
    'gDrawingFilter has to be set GLOBALY for the WHOLE TEST SCRIPT!
    gDrawingFilter = sUIFilternameDrawing & " (." & vExtensionDrawing(0) & ")"              
    sDrawingFilterReference = hGetFilter()    
    
    if sDrawingFilterReference <> gDrawingFilter then        
        warnlog "Reference file for current OASIS filter (Drawing) and real filter name in UI are not the same!"
        printlog "Reference file: " & sDrawingFilterReference
        printlog "UI Name in Office: " & gDrawingFilter
    end if        
end sub
