/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2002 by the OpenSG Forum                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

/*****************************************************************************\
 *****************************************************************************
 **                                                                         **
 **                  This file is automatically generated.                  **
 **                                                                         **
 **          Any changes made to this file WILL be lost when it is          **
 **           regenerated, which can become necessary at any time.          **
 **                                                                         **
 **     Do not change this file, changes should be done in the derived      **
 **     class Character!
 **                                                                         **
 *****************************************************************************
\*****************************************************************************/

#include <OSGConfig.h>

OSG_BEGIN_NAMESPACE


//! access the type of the class
inline
OSG::FieldContainerType &CharacterBase::getClassType(void)
{
    return _type; 
} 

//! access the numerical type of the class
inline
OSG::UInt32 CharacterBase::getClassTypeId(void) 
{
    return _type.getId(); 
} 

//! create a new instance of the class
inline
CharacterPtr CharacterBase::create(void) 
{
    CharacterPtr fc; 

    if(getClassType().getPrototype() != OSG::NullFC) 
    {
        fc = CharacterPtr::dcast(
            getClassType().getPrototype()-> shallowCopy()); 
    }
    
    return fc; 
}

//! create an empty new instance of the class, do not copy the prototype
inline
CharacterPtr CharacterBase::createEmpty(void) 
{ 
    CharacterPtr returnValue; 
    
    newPtr(returnValue); 

    return returnValue; 
}


/*------------------------------ get -----------------------------------*/

//! Get the Character::_sfModel field.
inline
SFCharacterModelPtr *CharacterBase::getSFModel(void)
{
    return &_sfModel;
}

//! Get the Character::_sfCurrentAnimation field.
inline
SFUInt32 *CharacterBase::getSFCurrentAnimation(void)
{
    return &_sfCurrentAnimation;
}

//! Get the Character::_sfBlendTime field.
inline
SFReal32 *CharacterBase::getSFBlendTime(void)
{
    return &_sfBlendTime;
}

//! Get the Character::_sfDelta field.
inline
SFReal32 *CharacterBase::getSFDelta(void)
{
    return &_sfDelta;
}

//! Get the Character::_sfTimeScale field.
inline
SFReal32 *CharacterBase::getSFTimeScale(void)
{
    return &_sfTimeScale;
}

//! Get the Character::_sfDrawSkeleton field.
inline
SFBool *CharacterBase::getSFDrawSkeleton(void)
{
    return &_sfDrawSkeleton;
}

//! Get the Character::_sfUseShaderForGeometry field.
inline
SFBool *CharacterBase::getSFUseShaderForGeometry(void)
{
    return &_sfUseShaderForGeometry;
}

//! Get the Character::_sfModelVolume field.
inline
SFDynamicVolume *CharacterBase::getSFModelVolume(void)
{
    return &_sfModelVolume;
}


//! Get the value of the Character::_sfModel field.
inline
CharacterModelPtr &CharacterBase::getModel(void)
{
    return _sfModel.getValue();
}

//! Get the value of the Character::_sfModel field.
inline
const CharacterModelPtr &CharacterBase::getModel(void) const
{
    return _sfModel.getValue();
}

//! Set the value of the Character::_sfModel field.
inline
void CharacterBase::setModel(const CharacterModelPtr &value)
{
    _sfModel.setValue(value);
}

//! Get the value of the Character::_sfCurrentAnimation field.
inline
UInt32 &CharacterBase::getCurrentAnimation(void)
{
    return _sfCurrentAnimation.getValue();
}

//! Get the value of the Character::_sfCurrentAnimation field.
inline
const UInt32 &CharacterBase::getCurrentAnimation(void) const
{
    return _sfCurrentAnimation.getValue();
}

//! Set the value of the Character::_sfCurrentAnimation field.
inline
void CharacterBase::setCurrentAnimation(const UInt32 &value)
{
    _sfCurrentAnimation.setValue(value);
}

//! Get the value of the Character::_sfBlendTime field.
inline
Real32 &CharacterBase::getBlendTime(void)
{
    return _sfBlendTime.getValue();
}

//! Get the value of the Character::_sfBlendTime field.
inline
const Real32 &CharacterBase::getBlendTime(void) const
{
    return _sfBlendTime.getValue();
}

//! Set the value of the Character::_sfBlendTime field.
inline
void CharacterBase::setBlendTime(const Real32 &value)
{
    _sfBlendTime.setValue(value);
}

//! Get the value of the Character::_sfDelta field.
inline
Real32 &CharacterBase::getDelta(void)
{
    return _sfDelta.getValue();
}

//! Get the value of the Character::_sfDelta field.
inline
const Real32 &CharacterBase::getDelta(void) const
{
    return _sfDelta.getValue();
}

//! Set the value of the Character::_sfDelta field.
inline
void CharacterBase::setDelta(const Real32 &value)
{
    _sfDelta.setValue(value);
}

//! Get the value of the Character::_sfTimeScale field.
inline
Real32 &CharacterBase::getTimeScale(void)
{
    return _sfTimeScale.getValue();
}

//! Get the value of the Character::_sfTimeScale field.
inline
const Real32 &CharacterBase::getTimeScale(void) const
{
    return _sfTimeScale.getValue();
}

//! Set the value of the Character::_sfTimeScale field.
inline
void CharacterBase::setTimeScale(const Real32 &value)
{
    _sfTimeScale.setValue(value);
}

//! Get the value of the Character::_sfDrawSkeleton field.
inline
bool &CharacterBase::getDrawSkeleton(void)
{
    return _sfDrawSkeleton.getValue();
}

//! Get the value of the Character::_sfDrawSkeleton field.
inline
const bool &CharacterBase::getDrawSkeleton(void) const
{
    return _sfDrawSkeleton.getValue();
}

//! Set the value of the Character::_sfDrawSkeleton field.
inline
void CharacterBase::setDrawSkeleton(const bool &value)
{
    _sfDrawSkeleton.setValue(value);
}

//! Get the value of the Character::_sfUseShaderForGeometry field.
inline
bool &CharacterBase::getUseShaderForGeometry(void)
{
    return _sfUseShaderForGeometry.getValue();
}

//! Get the value of the Character::_sfUseShaderForGeometry field.
inline
const bool &CharacterBase::getUseShaderForGeometry(void) const
{
    return _sfUseShaderForGeometry.getValue();
}

//! Set the value of the Character::_sfUseShaderForGeometry field.
inline
void CharacterBase::setUseShaderForGeometry(const bool &value)
{
    _sfUseShaderForGeometry.setValue(value);
}

//! Get the value of the Character::_sfModelVolume field.
inline
DynamicVolume &CharacterBase::getModelVolume(void)
{
    return _sfModelVolume.getValue();
}

//! Get the value of the Character::_sfModelVolume field.
inline
const DynamicVolume &CharacterBase::getModelVolume(void) const
{
    return _sfModelVolume.getValue();
}

//! Set the value of the Character::_sfModelVolume field.
inline
void CharacterBase::setModelVolume(const DynamicVolume &value)
{
    _sfModelVolume.setValue(value);
}


OSG_END_NAMESPACE

#define OSGCHARACTERBASE_INLINE_CVSID "@(#)$Id: OSGCharacterBase.inl,v 1.2 2006/02/20 17:04:12 dirk Exp $"

