/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2002 by the OpenSG Forum                 *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

/*****************************************************************************\
 *****************************************************************************
 **                                                                         **
 **                  This file is automatically generated.                  **
 **                                                                         **
 **          Any changes made to this file WILL be lost when it is          **
 **           regenerated, which can become necessary at any time.          **
 **                                                                         **
 **     Do not change this file, changes should be done in the derived      **
 **     class ShaderParameterMInt!
 **                                                                         **
 *****************************************************************************
\*****************************************************************************/


#define OSG_COMPILESHADERPARAMETERMINTINST

#include <stdlib.h>
#include <stdio.h>

#include <OSGConfig.h>

#include "OSGShaderParameterMIntBase.h"
#include "OSGShaderParameterMInt.h"


OSG_BEGIN_NAMESPACE

const OSG::BitVector  ShaderParameterMIntBase::ValueFieldMask = 
    (TypeTraits<BitVector>::One << ShaderParameterMIntBase::ValueFieldId);

const OSG::BitVector ShaderParameterMIntBase::MTInfluenceMask = 
    (Inherited::MTInfluenceMask) | 
    (static_cast<BitVector>(0x0) << Inherited::NextFieldId); 


// Field descriptions

/*! \var Int32           ShaderParameterMIntBase::_mfValue
    parameter value
*/

//! ShaderParameterMInt description

FieldDescription *ShaderParameterMIntBase::_desc[] = 
{
    new FieldDescription(MFInt32::getClassType(), 
                     "value", 
                     ValueFieldId, ValueFieldMask,
                     false,
                     (FieldAccessMethod) &ShaderParameterMIntBase::getMFValue)
};


FieldContainerType ShaderParameterMIntBase::_type(
    "ShaderParameterMInt",
    "ShaderParameter",
    NULL,
    (PrototypeCreateF) &ShaderParameterMIntBase::createEmpty,
    ShaderParameterMInt::initMethod,
    _desc,
    sizeof(_desc));

//OSG_FIELD_CONTAINER_DEF(ShaderParameterMIntBase, ShaderParameterMIntPtr)

/*------------------------------ get -----------------------------------*/

FieldContainerType &ShaderParameterMIntBase::getType(void) 
{
    return _type; 
} 

const FieldContainerType &ShaderParameterMIntBase::getType(void) const 
{
    return _type;
} 


FieldContainerPtr ShaderParameterMIntBase::shallowCopy(void) const 
{ 
    ShaderParameterMIntPtr returnValue; 

    newPtr(returnValue, dynamic_cast<const ShaderParameterMInt *>(this)); 

    return returnValue; 
}

UInt32 ShaderParameterMIntBase::getContainerSize(void) const 
{ 
    return sizeof(ShaderParameterMInt); 
}


#if !defined(OSG_FIXED_MFIELDSYNC)
void ShaderParameterMIntBase::executeSync(      FieldContainer &other,
                                    const BitVector      &whichField)
{
    this->executeSyncImpl((ShaderParameterMIntBase *) &other, whichField);
}
#else
void ShaderParameterMIntBase::executeSync(      FieldContainer &other,
                                    const BitVector      &whichField,                                    const SyncInfo       &sInfo     )
{
    this->executeSyncImpl((ShaderParameterMIntBase *) &other, whichField, sInfo);
}
void ShaderParameterMIntBase::execBeginEdit(const BitVector &whichField, 
                                            UInt32     uiAspect,
                                            UInt32     uiContainerSize) 
{
    this->execBeginEditImpl(whichField, uiAspect, uiContainerSize);
}

void ShaderParameterMIntBase::onDestroyAspect(UInt32 uiId, UInt32 uiAspect)
{
    Inherited::onDestroyAspect(uiId, uiAspect);

    _mfValue.terminateShare(uiAspect, this->getContainerSize());
}
#endif

/*------------------------- constructors ----------------------------------*/

#ifdef OSG_WIN32_ICL
#pragma warning (disable : 383)
#endif

ShaderParameterMIntBase::ShaderParameterMIntBase(void) :
    _mfValue                  (), 
    Inherited() 
{
}

#ifdef OSG_WIN32_ICL
#pragma warning (default : 383)
#endif

ShaderParameterMIntBase::ShaderParameterMIntBase(const ShaderParameterMIntBase &source) :
    _mfValue                  (source._mfValue                  ), 
    Inherited                 (source)
{
}

/*-------------------------- destructors ----------------------------------*/

ShaderParameterMIntBase::~ShaderParameterMIntBase(void)
{
}

/*------------------------------ access -----------------------------------*/

UInt32 ShaderParameterMIntBase::getBinSize(const BitVector &whichField)
{
    UInt32 returnValue = Inherited::getBinSize(whichField);

    if(FieldBits::NoField != (ValueFieldMask & whichField))
    {
        returnValue += _mfValue.getBinSize();
    }


    return returnValue;
}

void ShaderParameterMIntBase::copyToBin(      BinaryDataHandler &pMem,
                                  const BitVector         &whichField)
{
    Inherited::copyToBin(pMem, whichField);

    if(FieldBits::NoField != (ValueFieldMask & whichField))
    {
        _mfValue.copyToBin(pMem);
    }


}

void ShaderParameterMIntBase::copyFromBin(      BinaryDataHandler &pMem,
                                    const BitVector    &whichField)
{
    Inherited::copyFromBin(pMem, whichField);

    if(FieldBits::NoField != (ValueFieldMask & whichField))
    {
        _mfValue.copyFromBin(pMem);
    }


}

#if !defined(OSG_FIXED_MFIELDSYNC)
void ShaderParameterMIntBase::executeSyncImpl(      ShaderParameterMIntBase *pOther,
                                        const BitVector         &whichField)
{

    Inherited::executeSyncImpl(pOther, whichField);

    if(FieldBits::NoField != (ValueFieldMask & whichField))
        _mfValue.syncWith(pOther->_mfValue);


}
#else
void ShaderParameterMIntBase::executeSyncImpl(      ShaderParameterMIntBase *pOther,
                                        const BitVector         &whichField,
                                        const SyncInfo          &sInfo      )
{

    Inherited::executeSyncImpl(pOther, whichField, sInfo);


    if(FieldBits::NoField != (ValueFieldMask & whichField))
        _mfValue.syncWith(pOther->_mfValue, sInfo);


}

void ShaderParameterMIntBase::execBeginEditImpl (const BitVector &whichField, 
                                                 UInt32     uiAspect,
                                                 UInt32     uiContainerSize)
{
    Inherited::execBeginEditImpl(whichField, uiAspect, uiContainerSize);

    if(FieldBits::NoField != (ValueFieldMask & whichField))
        _mfValue.beginEdit(uiAspect, uiContainerSize);

}
#endif



OSG_END_NAMESPACE

#include <OSGSFieldTypeDef.inl>
#include <OSGMFieldTypeDef.inl>

OSG_BEGIN_NAMESPACE

#if !defined(OSG_DO_DOC) || defined(OSG_DOC_DEV)
DataType FieldDataTraits<ShaderParameterMIntPtr>::_type("ShaderParameterMIntPtr", "ShaderParameterPtr");
#endif

OSG_DLLEXPORT_SFIELD_DEF1(ShaderParameterMIntPtr, OSG_SYSTEMLIB_DLLTMPLMAPPING);
OSG_DLLEXPORT_MFIELD_DEF1(ShaderParameterMIntPtr, OSG_SYSTEMLIB_DLLTMPLMAPPING);


/*------------------------------------------------------------------------*/
/*                              cvs id's                                  */

#ifdef OSG_SGI_CC
#pragma set woff 1174
#endif

#ifdef OSG_LINUX_ICC
#pragma warning( disable : 177 )
#endif

namespace
{
    static Char8 cvsid_cpp       [] = "@(#)$Id: OSGShaderParameterMIntBase.cpp,v 1.1 2007/03/09 18:11:48 a-m-z Exp $";
    static Char8 cvsid_hpp       [] = OSGSHADERPARAMETERMINTBASE_HEADER_CVSID;
    static Char8 cvsid_inl       [] = OSGSHADERPARAMETERMINTBASE_INLINE_CVSID;

    static Char8 cvsid_fields_hpp[] = OSGSHADERPARAMETERMINTFIELDS_HEADER_CVSID;
}

OSG_END_NAMESPACE

