/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2002 by the OpenSG Forum                 *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

/*****************************************************************************\
 *****************************************************************************
 **                                                                         **
 **                  This file is automatically generated.                  **
 **                                                                         **
 **          Any changes made to this file WILL be lost when it is          **
 **           regenerated, which can become necessary at any time.          **
 **                                                                         **
 **     Do not change this file, changes should be done in the derived      **
 **     class DisplayFilterForeground!
 **                                                                         **
 *****************************************************************************
\*****************************************************************************/


#define OSG_COMPILEDISPLAYFILTERFOREGROUNDINST

#include <stdlib.h>
#include <stdio.h>

#include <OSGConfig.h>

#include "OSGDisplayFilterForegroundBase.h"
#include "OSGDisplayFilterForeground.h"


OSG_BEGIN_NAMESPACE

const OSG::BitVector  DisplayFilterForegroundBase::FilterFieldMask = 
    (TypeTraits<BitVector>::One << DisplayFilterForegroundBase::FilterFieldId);

const OSG::BitVector  DisplayFilterForegroundBase::ServerFieldMask = 
    (TypeTraits<BitVector>::One << DisplayFilterForegroundBase::ServerFieldId);

const OSG::BitVector DisplayFilterForegroundBase::MTInfluenceMask = 
    (Inherited::MTInfluenceMask) | 
    (static_cast<BitVector>(0x0) << Inherited::NextFieldId); 


// Field descriptions

/*! \var DisplayFilterPtr DisplayFilterForegroundBase::_mfFilter
    
*/
/*! \var std::string     DisplayFilterForegroundBase::_sfServer
    Server to be calibrated (if any)
*/

//! DisplayFilterForeground description

FieldDescription *DisplayFilterForegroundBase::_desc[] = 
{
    new FieldDescription(MFDisplayFilterPtr::getClassType(), 
                     "filter", 
                     FilterFieldId, FilterFieldMask,
                     false,
                     (FieldAccessMethod) &DisplayFilterForegroundBase::getMFFilter),
    new FieldDescription(SFString::getClassType(), 
                     "server", 
                     ServerFieldId, ServerFieldMask,
                     false,
                     (FieldAccessMethod) &DisplayFilterForegroundBase::getSFServer)
};


FieldContainerType DisplayFilterForegroundBase::_type(
    "DisplayFilterForeground",
    "Foreground",
    NULL,
    (PrototypeCreateF) &DisplayFilterForegroundBase::createEmpty,
    DisplayFilterForeground::initMethod,
    _desc,
    sizeof(_desc));

//OSG_FIELD_CONTAINER_DEF(DisplayFilterForegroundBase, DisplayFilterForegroundPtr)

/*------------------------------ get -----------------------------------*/

FieldContainerType &DisplayFilterForegroundBase::getType(void) 
{
    return _type; 
} 

const FieldContainerType &DisplayFilterForegroundBase::getType(void) const 
{
    return _type;
} 


FieldContainerPtr DisplayFilterForegroundBase::shallowCopy(void) const 
{ 
    DisplayFilterForegroundPtr returnValue; 

    newPtr(returnValue, dynamic_cast<const DisplayFilterForeground *>(this)); 

    return returnValue; 
}

UInt32 DisplayFilterForegroundBase::getContainerSize(void) const 
{ 
    return sizeof(DisplayFilterForeground); 
}


#if !defined(OSG_FIXED_MFIELDSYNC)
void DisplayFilterForegroundBase::executeSync(      FieldContainer &other,
                                    const BitVector      &whichField)
{
    this->executeSyncImpl((DisplayFilterForegroundBase *) &other, whichField);
}
#else
void DisplayFilterForegroundBase::executeSync(      FieldContainer &other,
                                    const BitVector      &whichField,                                    const SyncInfo       &sInfo     )
{
    this->executeSyncImpl((DisplayFilterForegroundBase *) &other, whichField, sInfo);
}
void DisplayFilterForegroundBase::execBeginEdit(const BitVector &whichField, 
                                            UInt32     uiAspect,
                                            UInt32     uiContainerSize) 
{
    this->execBeginEditImpl(whichField, uiAspect, uiContainerSize);
}

void DisplayFilterForegroundBase::onDestroyAspect(UInt32 uiId, UInt32 uiAspect)
{
    Inherited::onDestroyAspect(uiId, uiAspect);

    _mfFilter.terminateShare(uiAspect, this->getContainerSize());
}
#endif

/*------------------------- constructors ----------------------------------*/

#ifdef OSG_WIN32_ICL
#pragma warning (disable : 383)
#endif

DisplayFilterForegroundBase::DisplayFilterForegroundBase(void) :
    _mfFilter                 (), 
    _sfServer                 (), 
    Inherited() 
{
}

#ifdef OSG_WIN32_ICL
#pragma warning (default : 383)
#endif

DisplayFilterForegroundBase::DisplayFilterForegroundBase(const DisplayFilterForegroundBase &source) :
    _mfFilter                 (source._mfFilter                 ), 
    _sfServer                 (source._sfServer                 ), 
    Inherited                 (source)
{
}

/*-------------------------- destructors ----------------------------------*/

DisplayFilterForegroundBase::~DisplayFilterForegroundBase(void)
{
}

/*------------------------------ access -----------------------------------*/

UInt32 DisplayFilterForegroundBase::getBinSize(const BitVector &whichField)
{
    UInt32 returnValue = Inherited::getBinSize(whichField);

    if(FieldBits::NoField != (FilterFieldMask & whichField))
    {
        returnValue += _mfFilter.getBinSize();
    }

    if(FieldBits::NoField != (ServerFieldMask & whichField))
    {
        returnValue += _sfServer.getBinSize();
    }


    return returnValue;
}

void DisplayFilterForegroundBase::copyToBin(      BinaryDataHandler &pMem,
                                  const BitVector         &whichField)
{
    Inherited::copyToBin(pMem, whichField);

    if(FieldBits::NoField != (FilterFieldMask & whichField))
    {
        _mfFilter.copyToBin(pMem);
    }

    if(FieldBits::NoField != (ServerFieldMask & whichField))
    {
        _sfServer.copyToBin(pMem);
    }


}

void DisplayFilterForegroundBase::copyFromBin(      BinaryDataHandler &pMem,
                                    const BitVector    &whichField)
{
    Inherited::copyFromBin(pMem, whichField);

    if(FieldBits::NoField != (FilterFieldMask & whichField))
    {
        _mfFilter.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (ServerFieldMask & whichField))
    {
        _sfServer.copyFromBin(pMem);
    }


}

#if !defined(OSG_FIXED_MFIELDSYNC)
void DisplayFilterForegroundBase::executeSyncImpl(      DisplayFilterForegroundBase *pOther,
                                        const BitVector         &whichField)
{

    Inherited::executeSyncImpl(pOther, whichField);

    if(FieldBits::NoField != (FilterFieldMask & whichField))
        _mfFilter.syncWith(pOther->_mfFilter);

    if(FieldBits::NoField != (ServerFieldMask & whichField))
        _sfServer.syncWith(pOther->_sfServer);


}
#else
void DisplayFilterForegroundBase::executeSyncImpl(      DisplayFilterForegroundBase *pOther,
                                        const BitVector         &whichField,
                                        const SyncInfo          &sInfo      )
{

    Inherited::executeSyncImpl(pOther, whichField, sInfo);

    if(FieldBits::NoField != (ServerFieldMask & whichField))
        _sfServer.syncWith(pOther->_sfServer);


    if(FieldBits::NoField != (FilterFieldMask & whichField))
        _mfFilter.syncWith(pOther->_mfFilter, sInfo);


}

void DisplayFilterForegroundBase::execBeginEditImpl (const BitVector &whichField, 
                                                 UInt32     uiAspect,
                                                 UInt32     uiContainerSize)
{
    Inherited::execBeginEditImpl(whichField, uiAspect, uiContainerSize);

    if(FieldBits::NoField != (FilterFieldMask & whichField))
        _mfFilter.beginEdit(uiAspect, uiContainerSize);

}
#endif



OSG_END_NAMESPACE

#include <OSGSFieldTypeDef.inl>
#include <OSGMFieldTypeDef.inl>

OSG_BEGIN_NAMESPACE

#if !defined(OSG_DO_DOC) || defined(OSG_DOC_DEV)
DataType FieldDataTraits<DisplayFilterForegroundPtr>::_type("DisplayFilterForegroundPtr", "ForegroundPtr");
#endif

OSG_DLLEXPORT_SFIELD_DEF1(DisplayFilterForegroundPtr, OSG_SYSTEMLIB_DLLTMPLMAPPING);
OSG_DLLEXPORT_MFIELD_DEF1(DisplayFilterForegroundPtr, OSG_SYSTEMLIB_DLLTMPLMAPPING);


/*------------------------------------------------------------------------*/
/*                              cvs id's                                  */

#ifdef OSG_SGI_CC
#pragma set woff 1174
#endif

#ifdef OSG_LINUX_ICC
#pragma warning( disable : 177 )
#endif

namespace
{
    static Char8 cvsid_cpp       [] = "@(#)$Id: FCBaseTemplate_cpp.h,v 1.47 2006/03/17 17:03:19 pdaehne Exp $";
    static Char8 cvsid_hpp       [] = OSGDISPLAYFILTERFOREGROUNDBASE_HEADER_CVSID;
    static Char8 cvsid_inl       [] = OSGDISPLAYFILTERFOREGROUNDBASE_INLINE_CVSID;

    static Char8 cvsid_fields_hpp[] = OSGDISPLAYFILTERFOREGROUNDFIELDS_HEADER_CVSID;
}

OSG_END_NAMESPACE

