/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2002 by the OpenSG Forum                 *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

/*****************************************************************************\
 *****************************************************************************
 **                                                                         **
 **                  This file is automatically generated.                  **
 **                                                                         **
 **          Any changes made to this file WILL be lost when it is          **
 **           regenerated, which can become necessary at any time.          **
 **                                                                         **
 **     Do not change this file, changes should be done in the derived      **
 **     class GradientBackground!
 **                                                                         **
 *****************************************************************************
\*****************************************************************************/


#define OSG_COMPILEGRADIENTBACKGROUNDINST

#include <stdlib.h>
#include <stdio.h>

#include <OSGConfig.h>

#include "OSGGradientBackgroundBase.h"
#include "OSGGradientBackground.h"


OSG_BEGIN_NAMESPACE

const OSG::BitVector  GradientBackgroundBase::ColorFieldMask = 
    (TypeTraits<BitVector>::One << GradientBackgroundBase::ColorFieldId);

const OSG::BitVector  GradientBackgroundBase::PositionFieldMask = 
    (TypeTraits<BitVector>::One << GradientBackgroundBase::PositionFieldId);

const OSG::BitVector  GradientBackgroundBase::ClearStencilBitFieldMask = 
    (TypeTraits<BitVector>::One << GradientBackgroundBase::ClearStencilBitFieldId);

const OSG::BitVector GradientBackgroundBase::MTInfluenceMask = 
    (Inherited::MTInfluenceMask) | 
    (static_cast<BitVector>(0x0) << Inherited::NextFieldId); 


// Field descriptions

/*! \var Color3f         GradientBackgroundBase::_mfColor
    The colors of the gradient.
*/
/*! \var Real32          GradientBackgroundBase::_mfPosition
    The positions of the gradient.
*/
/*! \var Int32           GradientBackgroundBase::_sfClearStencilBit
    Usually 0 is used to clear all stencil bitplanes (clear is deactivated if smaller zero).
*/

//! GradientBackground description

FieldDescription *GradientBackgroundBase::_desc[] = 
{
    new FieldDescription(MFColor3f::getClassType(), 
                     "color", 
                     ColorFieldId, ColorFieldMask,
                     false,
                     (FieldAccessMethod) &GradientBackgroundBase::getMFColor),
    new FieldDescription(MFReal32::getClassType(), 
                     "position", 
                     PositionFieldId, PositionFieldMask,
                     false,
                     (FieldAccessMethod) &GradientBackgroundBase::getMFPosition),
    new FieldDescription(SFInt32::getClassType(), 
                     "clearStencilBit", 
                     ClearStencilBitFieldId, ClearStencilBitFieldMask,
                     false,
                     (FieldAccessMethod) &GradientBackgroundBase::getSFClearStencilBit)
};


FieldContainerType GradientBackgroundBase::_type(
    "GradientBackground",
    "Background",
    NULL,
    (PrototypeCreateF) &GradientBackgroundBase::createEmpty,
    GradientBackground::initMethod,
    _desc,
    sizeof(_desc));

//OSG_FIELD_CONTAINER_DEF(GradientBackgroundBase, GradientBackgroundPtr)

/*------------------------------ get -----------------------------------*/

FieldContainerType &GradientBackgroundBase::getType(void) 
{
    return _type; 
} 

const FieldContainerType &GradientBackgroundBase::getType(void) const 
{
    return _type;
} 


FieldContainerPtr GradientBackgroundBase::shallowCopy(void) const 
{ 
    GradientBackgroundPtr returnValue; 

    newPtr(returnValue, dynamic_cast<const GradientBackground *>(this)); 

    return returnValue; 
}

UInt32 GradientBackgroundBase::getContainerSize(void) const 
{ 
    return sizeof(GradientBackground); 
}


#if !defined(OSG_FIXED_MFIELDSYNC)
void GradientBackgroundBase::executeSync(      FieldContainer &other,
                                    const BitVector      &whichField)
{
    this->executeSyncImpl((GradientBackgroundBase *) &other, whichField);
}
#else
void GradientBackgroundBase::executeSync(      FieldContainer &other,
                                    const BitVector      &whichField,                                    const SyncInfo       &sInfo     )
{
    this->executeSyncImpl((GradientBackgroundBase *) &other, whichField, sInfo);
}
void GradientBackgroundBase::execBeginEdit(const BitVector &whichField, 
                                            UInt32     uiAspect,
                                            UInt32     uiContainerSize) 
{
    this->execBeginEditImpl(whichField, uiAspect, uiContainerSize);
}

void GradientBackgroundBase::onDestroyAspect(UInt32 uiId, UInt32 uiAspect)
{
    Inherited::onDestroyAspect(uiId, uiAspect);

    _mfColor.terminateShare(uiAspect, this->getContainerSize());
    _mfPosition.terminateShare(uiAspect, this->getContainerSize());
}
#endif

/*------------------------- constructors ----------------------------------*/

#ifdef OSG_WIN32_ICL
#pragma warning (disable : 383)
#endif

GradientBackgroundBase::GradientBackgroundBase(void) :
    _mfColor                  (), 
    _mfPosition               (), 
    _sfClearStencilBit        (Int32(-1)), 
    Inherited() 
{
}

#ifdef OSG_WIN32_ICL
#pragma warning (default : 383)
#endif

GradientBackgroundBase::GradientBackgroundBase(const GradientBackgroundBase &source) :
    _mfColor                  (source._mfColor                  ), 
    _mfPosition               (source._mfPosition               ), 
    _sfClearStencilBit        (source._sfClearStencilBit        ), 
    Inherited                 (source)
{
}

/*-------------------------- destructors ----------------------------------*/

GradientBackgroundBase::~GradientBackgroundBase(void)
{
}

/*------------------------------ access -----------------------------------*/

UInt32 GradientBackgroundBase::getBinSize(const BitVector &whichField)
{
    UInt32 returnValue = Inherited::getBinSize(whichField);

    if(FieldBits::NoField != (ColorFieldMask & whichField))
    {
        returnValue += _mfColor.getBinSize();
    }

    if(FieldBits::NoField != (PositionFieldMask & whichField))
    {
        returnValue += _mfPosition.getBinSize();
    }

    if(FieldBits::NoField != (ClearStencilBitFieldMask & whichField))
    {
        returnValue += _sfClearStencilBit.getBinSize();
    }


    return returnValue;
}

void GradientBackgroundBase::copyToBin(      BinaryDataHandler &pMem,
                                  const BitVector         &whichField)
{
    Inherited::copyToBin(pMem, whichField);

    if(FieldBits::NoField != (ColorFieldMask & whichField))
    {
        _mfColor.copyToBin(pMem);
    }

    if(FieldBits::NoField != (PositionFieldMask & whichField))
    {
        _mfPosition.copyToBin(pMem);
    }

    if(FieldBits::NoField != (ClearStencilBitFieldMask & whichField))
    {
        _sfClearStencilBit.copyToBin(pMem);
    }


}

void GradientBackgroundBase::copyFromBin(      BinaryDataHandler &pMem,
                                    const BitVector    &whichField)
{
    Inherited::copyFromBin(pMem, whichField);

    if(FieldBits::NoField != (ColorFieldMask & whichField))
    {
        _mfColor.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (PositionFieldMask & whichField))
    {
        _mfPosition.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (ClearStencilBitFieldMask & whichField))
    {
        _sfClearStencilBit.copyFromBin(pMem);
    }


}

#if !defined(OSG_FIXED_MFIELDSYNC)
void GradientBackgroundBase::executeSyncImpl(      GradientBackgroundBase *pOther,
                                        const BitVector         &whichField)
{

    Inherited::executeSyncImpl(pOther, whichField);

    if(FieldBits::NoField != (ColorFieldMask & whichField))
        _mfColor.syncWith(pOther->_mfColor);

    if(FieldBits::NoField != (PositionFieldMask & whichField))
        _mfPosition.syncWith(pOther->_mfPosition);

    if(FieldBits::NoField != (ClearStencilBitFieldMask & whichField))
        _sfClearStencilBit.syncWith(pOther->_sfClearStencilBit);


}
#else
void GradientBackgroundBase::executeSyncImpl(      GradientBackgroundBase *pOther,
                                        const BitVector         &whichField,
                                        const SyncInfo          &sInfo      )
{

    Inherited::executeSyncImpl(pOther, whichField, sInfo);

    if(FieldBits::NoField != (ClearStencilBitFieldMask & whichField))
        _sfClearStencilBit.syncWith(pOther->_sfClearStencilBit);


    if(FieldBits::NoField != (ColorFieldMask & whichField))
        _mfColor.syncWith(pOther->_mfColor, sInfo);

    if(FieldBits::NoField != (PositionFieldMask & whichField))
        _mfPosition.syncWith(pOther->_mfPosition, sInfo);


}

void GradientBackgroundBase::execBeginEditImpl (const BitVector &whichField, 
                                                 UInt32     uiAspect,
                                                 UInt32     uiContainerSize)
{
    Inherited::execBeginEditImpl(whichField, uiAspect, uiContainerSize);

    if(FieldBits::NoField != (ColorFieldMask & whichField))
        _mfColor.beginEdit(uiAspect, uiContainerSize);

    if(FieldBits::NoField != (PositionFieldMask & whichField))
        _mfPosition.beginEdit(uiAspect, uiContainerSize);

}
#endif



OSG_END_NAMESPACE

#include <OSGMFieldTypeDef.inl>

OSG_BEGIN_NAMESPACE

#if !defined(OSG_DO_DOC) || defined(OSG_DOC_DEV)
DataType FieldDataTraits<GradientBackgroundPtr>::_type("GradientBackgroundPtr", "BackgroundPtr");
#endif

OSG_DLLEXPORT_MFIELD_DEF1(GradientBackgroundPtr, OSG_SYSTEMLIB_DLLTMPLMAPPING);


/*------------------------------------------------------------------------*/
/*                              cvs id's                                  */

#ifdef OSG_SGI_CC
#pragma set woff 1174
#endif

#ifdef OSG_LINUX_ICC
#pragma warning( disable : 177 )
#endif

namespace
{
    static Char8 cvsid_cpp       [] = "@(#)$Id: FCBaseTemplate_cpp.h,v 1.47 2006/03/17 17:03:19 pdaehne Exp $";
    static Char8 cvsid_hpp       [] = OSGGRADIENTBACKGROUNDBASE_HEADER_CVSID;
    static Char8 cvsid_inl       [] = OSGGRADIENTBACKGROUNDBASE_INLINE_CVSID;

    static Char8 cvsid_fields_hpp[] = OSGGRADIENTBACKGROUNDFIELDS_HEADER_CVSID;
}

OSG_END_NAMESPACE

