# Changed
# ##################################
# namespace: Bubble
# coded by:  Steve Foster
# date:      16/1/1998
# requires:  tcl/tk 8.0(namespace)
# desc:      Attaches help bubbles
#            to any existing windows
#
#   Example
#     # create a window or two
#     button .b -text Button
#     label  .l -text Label
#     pack .b .l -side left
#
#     # then assign the help to it
#     # to start background bubble 
#     Bubble::initBubble .b "Hello This is a button"
#     Bubble::initBubble .l "Hello This is a label, it think?"
#
#     # to destroy background bubble
#     # ie remove its binding
#     Bubble::destroyBubble .b
# ##################################
namespace eval Bubble {
    variable win          ;# array to hold info
    variable time 1750     ;# delay before posting help (ms)
    
    # Help attributes
    ##################
    variable bcolor lemonchiffon ;# background color
    variable fcolor black        ;# text color
    variable just   "left"       ;# justify text left
    variable wrapl  2i           ;# wrap length
    variable bd	    1            ;# border thickness
    variable font   [font actual "helvetica 12"]	
    
    # Public
    #########
    # Command to setup a help bubble binding
    proc initBubble {w txt} {
	variable win

	if { ![winfo exists $w] } {
	    tk_messageBox -title "Bubble ERROR" \
		-message "ERROR: \"$w\" Dosnt exist, Cant attach Help Bubble" \
		-icon error \
		-type ok
	}
	
	bind $w <Enter> "Bubble::_startBubble $w" ;# entered window
	bind $w <Leave> "Bubble::_killBubble  $w" ;# left window
	set win($w,TXT) $txt
    }
    # Command to destroy a help bubble binding
    proc destroyBubble w {
	# delete event bindings
	bind $w <Enter> ""
	bind $w <Leave> ""
    }

    
    # Private
    ##########
    # commands used behind the scenes
    proc _startBubble w {
	variable win 
	variable time
	destroy .bubble

	# entered window so start bubble timer 
	set win($w,ID) [after $time "Bubble::_doBubble $w"]
    }
    proc _doBubble w {
	if {![winfo exists $w]} {return}
	# pop up the help window
	variable win
	variable bcolor
	variable fcolor
	variable just
	variable wrapl
	variable bd
	variable font	

	# get position for bubble window
	set posx +[winfo pointerx $w]
	set posy +[winfo pointery $w]

	# create window, remove it from view, remove frame
	toplevel .bubble
	wm withdraw .bubble
	wm overrideredirect .bubble 1
	wm geometry .bubble $posx$posy

	# set up label with attributes
	label .bubble.l -text $win($w,TXT) \
	    -bg $bcolor -fg $fcolor \
	    -bd $bd -font $font \
	    -justify $just -wraplength $wrapl \
	    -padx 6 -relief raised -borderwidth 3
	pack .bubble.l

	# make it visible
	wm deiconify .bubble
    }
    proc _killBubble w {
	# cancel timers _doBubble will kill the .bubble help
	variable win
	after cancel $win($w,ID)

    }

}
