/*

    This file is part of Ophcrack (Time-Memory-Trade-Off-crack).

    Ophcrack is a Lanmanager/NTLM hash cracker based on the faster time-memory
    trade-off using rainbow tables. 
    
    Created with the help of: Maxime Mueller, Luca Wullschleger, Claude
    Hochreutiner, Andreas Huber and Etienne Dysli.

    Copyright 2006 Philippe Oechslin, Cedric Tissieres

    Ophcrack is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Ophcrack is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Ophcrack; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

    This program is released under the GPL with the additional exemption 
    that compiling, linking, and/or using OpenSSL is allowed.
*/


/* Reduction functions to make passwords from hashes */

/* $Id: make_redux.h,v 1.0 2004/07/09 12:54:15 oechslin Exp $
 *
 * $Log: make_redux.h,v $
 * Revision 2.3.4 2007/02/19 tissieres
 * German chars support
 *
 * Revision 2.3  2006/07/21 tissieres
 * Added NTLM support
 *
 * Revision 1.0  2004/07/09 12:54:15  oechslin
 * Initial revision
 *
 *
 */

#ifndef MAKE_REDUX_H
#define MAKE_REDUX_H

#include <limits.h>

#define REDUX_LM_ALPHANUM10k 0
#define REDUX_LM_ALPHANUM5k  1
#define REDUX_LM_EXTENDED    2
#define REDUX_LM_GERMAN      3
#define REDUX_NT_EXTENDED    4


extern unsigned char* charset;

extern int perm[];

extern int n_redux;

struct special_max {
  char n;
  char k;
  unsigned int max;
};

#define setbit(x,pos) x | (1 << pos);
#define getbit(x,pos) (x & (1 << pos)) ? 1 : 0

void init_redux(int ident, int length);

void next_redux();

void set_redux(int col, int table);

void make_redux(unsigned char *in, unsigned char *out);

#endif
