<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns="http://www.w3.org/1999/xhtml">

<xsl:preserve-space elements="table_head" />

<xsl:template match="benchmark">
<xsl:call-template name = "table_head" />
<xsl:for-each select="test">
<xsl:sort select="date"/>
<xsl:call-template name = "table_columns" />
</xsl:for-each>
</xsl:template>


<xsl:template name = "table_head" >
<xsl:text>                     -</xsl:text><xsl:for-each select="test">---------------------</xsl:for-each>
<xsl:text>
</xsl:text>
<xsl:text>                     :</xsl:text><xsl:for-each select="test"><xsl:sort select="date"/><xsl:text>  </xsl:text><xsl:value-of select="date"/><xsl:text>  :</xsl:text></xsl:for-each>
<xsl:text>
</xsl:text>
<xsl:text>----------------------</xsl:text><xsl:for-each select="test"><xsl:text>---------------------</xsl:text></xsl:for-each>
<xsl:text>
</xsl:text>
</xsl:template>

<xsl:template name = "table_columns" >
<xsl:variable name="current_runtime"><xsl:value-of select="run_time"/></xsl:variable>

<xsl:text>:  </xsl:text><xsl:value-of select="date"/><xsl:text>  :</xsl:text>
<xsl:for-each select="./../test"><xsl:sort select="date"/>
<xsl:variable name="diff_percent"><xsl:value-of select="-round(((run_time - $current_runtime) * 100) div $current_runtime)"/></xsl:variable>
<xsl:choose>
<xsl:when test="$diff_percent = 'NaN' ">
<xsl:text>          X         :</xsl:text>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="wspace"><xsl:with-param name="nb_space"><xsl:value-of select="11 - string-length($diff_percent)"/></xsl:with-param></xsl:call-template>
<xsl:value-of select="$diff_percent" /><xsl:text>%        :</xsl:text>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
<xsl:text>
</xsl:text>
<xsl:text>----------------------</xsl:text><xsl:for-each select="./../test"><xsl:text>---------------------</xsl:text></xsl:for-each>
<xsl:text>
</xsl:text>
</xsl:template>

<xsl:template name = "wspace">
<xsl:param name="nb_space" />
<xsl:text> </xsl:text>
<xsl:if test="number($nb_space) &gt; 1">
<xsl:call-template name="wspace">
<xsl:with-param name="nb_space">
<xsl:value-of select="$nb_space - 1" />
</xsl:with-param>
</xsl:call-template>
</xsl:if>
</xsl:template>

</xsl:stylesheet>
