
/******************************************************************************
**
**  Copyright (C) 2006 Brian Wotring.
**
**  This program is free software; you can redistribute it and/or
**  modify it, however, you cannot sell it.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
**
**  You should have received a copy of the license attached to the
**  use of this software.  If not, view a current copy of the license
**  file here:
**
**      http://www.hostintegrity.com/osiris/LICENSE
**
******************************************************************************/

/*****************************************************************************
**
**  File:    config_brief.h
**  Date:    August 18, 2002
**
**  Author:  Brian Wotring
**
**  Purpose: structure representing a scanning config that can be transported
**           in a message.
**
******************************************************************************/

#ifndef CONFIG_BRIEF_H
#define CONFIG_BRIEF_H

/* this is a condensed config structure used for communication */
/* between the management daemon and a management application. */

typedef struct OSI_CONFIG_BRIEF
{
    osi_uint64 valid;
    
    char name[MAX_CONFIG_NAME_LENGTH];
    char id[MAX_CONFIG_ID_LENGTH];

} OSI_CONFIG_BRIEF;


void wrap_config_brief( OSI_CONFIG_BRIEF *config );
void unwrap_config_brief( OSI_CONFIG_BRIEF *config );


#endif
