#!/usr/bin/perl

use NetAddr::IP;

# default values.

$ip_start = "";
$ip_end = "";

$enabled = "yes";
$notify_enabled = "yes";
$notify_flags = "0";
$notify_email = "";
$session_key = "";
$base_db = "";
$log_to_file = "no";
$schedule_start = time;
$schedule_period = "1440";
$db_flags = "0";
$port = "2265";
$config = "";

# make a hosts directory

mkdir hosts;

print "Enter config name to use for this set of hosts: ";
$config = <STDIN>;                                              
chomp ($config);

print "Enter IP address range: ";
$ips = <STDIN>;
chomp ($ips);

print "Enable these hosts? (y/n): ";
$tmp= <STDIN>;
chomp ($tmp);
if ( $tmp ne "" )
{
    $enabled = $tmp;
}

# NOTIFY FLAGS HERE.

print "Enable email notification? (y/n): ";
$tmp = <STDIN>;
chomp ($tmp);
if ( $tmp ne "" )
{
    $notify_enabled = $tmp;
}

if ( $notify_enabled eq "y" )
{

print "Notify on scan failures? (y/n): ";
$tmp = <STDIN>;
chomp ($tmp);
if ( $tmp eq "y" )
{
    $notify_flags += 1;
}

print "Notify always? (y/n): ";
$tmp = <STDIN>;
chomp ($tmp);
if ( $tmp eq "y" )
{
    $notify_flags += 2;
}


print "Notify on rekeys? (y/n): ";
$tmp = <STDIN>;
chomp ($tmp);
if ( $tmp eq "y" )
{
    $notify_flags += 4;
}
}

print "Enable logging to files? (y/n): ";
$tmp = <STDIN>;
chomp ($tmp);
if ( $tmp ne "" )
{
    $log_to_file = $tmp;
}

print "Schedule period in minutes (1440=daily): ";
$tmp = <STDIN>;
chomp ($tmp);
if ( $tmp ne "" )
{
    $schedule_period = $tmp;
}

# DB FLAGS EHRE.

print "Archive Scan Databases? (y/n): ";
$tmp = <STDIN>;
chomp ($tmp);
if ( $tmp eq "y" )
{
    $db_flags += 1;
}

print "Auto-Accept changes? (y/n): ";
$tmp = <STDIN>;
chomp ($tmp);
if ( $tmp eq "y" )
{
    $db_flags += 2;
}

print "Purge Old Databases? (y/n): ";
$tmp = <STDIN>;
chomp ($tmp);
if ( $tmp eq "y" )
{
    $db_flags += 4;
}


print "Agent listen port (suggested 2265): ";
$tmp = <STDIN>;
chomp ($tmp);
if ( $tmp ne "" )
{
    $port = $tmp;
}


# loop through address range, create each host.

determine_ip_ranges();

print ">>> Building hosts for range ($ip_start) to ($ip_end)\n";

$start = NetAddr::IP->new($ip_start);
$end= NetAddr::IP->new($ip_end);

while( $start <= $end )
{
    $x = $start->addr();
    $start++;

    create_host($x);
}


# print helpful message.

print "\n";
print ">>> hosts archive created.\n";
print "\n";
print "To deploy these hosts, copy the contents of hosts/*\n";
print "to your osiris root directory.  This is usually /usr/local/osiris\n";
print "on UNIX and \%WindowsRoot\%\\osiris on Windows.\n";
print "\n";
print "Once copied, do the following to setup permissions correctly:\n\n";
print "    chown -R osiris hosts\n";
print "    chgrp -R osiris hosts\n";

print "\n\n";

sub create_host
{
    $ip = $_[0];
    
    mkdir "hosts/$ip";
    mkdir "hosts/$ip/configs";
    mkdir "hosts/$ip/databases";
    mkdir "hosts/$ip/logs";

    open (f, ">hosts/$ip/host.conf") || die ("unable to write file. $!");

    print f ("host = $ip\n");
    print f ("description=\n");
    print f ("type = generic\n");
    print f ("enabled = $enabled\n");
    print f ("notify_enabled = $notify_enabled\n");
    print f ("notify_flags = $notify_flags\n");
    print f ("notify_email = $notify_email\n");
    print f ("session_key = $session_key\n");
    print f ("base_db = $base_db\n");
    print f ("log_to_file = $log_to_file\n");
    print f ("schedule_start = $schedule_start\n");
    print f ("schedule_period = $schedule_period\n");
    print f ("db_flags = $db_flags\n");
    print f ("port = $port\n");
    print f ("config = $config\n");

    close(f);
    print "    >>> created $ip\n";
}

sub determine_ip_ranges
{
    $s = index $ips,"-";
    $ip_start = substr( $ips, 0, $s );
    $ip_end = substr($ips,($s+1));

    # trim whitespace.

    $ip_start =~ s/^\s+//;
    $ip_start =~ s/\s+$//;

    $ip_end =~ s/^\s+//;
    $ip_end =~ s/\s+$//;
}

