
/*
 * Copyright (C) 2002-2003 Stefan Holst
 * Copyright (C) 2004-2005 Maximilian Schwerin
 *
 * This file is part of oxine a free media player.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: disc.h 1522 2006-11-11 13:57:10Z mschwerin $
 *
 */

#ifndef HAVE_DISC_H
#define HAVE_DISC_H
#ifdef __cplusplus
extern "C" {
#endif

#include "oxine.h"
#include "types.h"

typedef enum {
    DEVICE_TYPE_NONE,
    DEVICE_TYPE_UNKNOWN,
    DEVICE_TYPE_AUDIO_CD,
    DEVICE_TYPE_VIDEO_CD,
    DEVICE_TYPE_VIDEO_DVD,
    DEVICE_TYPE_CDROM
} device_type_t;

typedef struct {
    /* These entries are defined once at the start. They do not change by
     * polling the device. */
    char *device;
    char *mountpoint;
    bool is_type_cd;

    /* These entries are changed by the polling thread and depend on the
     * current state of the device. */
    char *current_mrl;
    device_type_t current_type;
    bool is_disc_in;
} device_entry_t;

char *disc_get_title (const char *device);
device_type_t disc_get_type (const char *device);

bool disc_is_mounted (const char *device);
bool disc_is_present (const char *device);

bool disc_eject (const char *device);
bool disc_mount (const char *device);
bool disc_umount (const char *device);

void disc_autoscan_load (playlist_t * playlist, const char *mrl);
void disc_autoscan_read (filelist_t * filelist);

#ifdef HAVE_DISC_POLLING
void disc_start_polling (oxine_t * oxine);
void disc_stop_polling (oxine_t * oxine);
#endif

#ifdef __cplusplus
}
#endif
#endif
