/*
**  Pantomime.h
**
**  Copyright (c) 2001, 2002, 2003
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**  
**  This library is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
**  Lesser General Public License for more details.
**  
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

#ifndef _Pantomime_H_Pantomime
#define _Pantomime_H_Pantomime

#import <Foundation/Foundation.h>

#include <Pantomime/Charset.h>
#include <Pantomime/Constants.h>
#include <Pantomime/Container.h>
#include <Pantomime/elm_defs.h>
#include <Pantomime/elm_lib.h>
#include <Pantomime/Flags.h>
#include <Pantomime/Folder.h>
#include <Pantomime/FolderInformation.h>
#include <Pantomime/MD5.h>
#include <Pantomime/IMAPCacheManager.h>
#include <Pantomime/IMAPFolder.h>
#include <Pantomime/IMAPMessage.h>
#include <Pantomime/IMAPStore.h>
#include <Pantomime/InternetAddress.h>
#include <Pantomime/ISO8859_1.h>
#include <Pantomime/ISO8859_10.h>
#include <Pantomime/ISO8859_11.h>
#include <Pantomime/ISO8859_13.h>
#include <Pantomime/ISO8859_14.h>
#include <Pantomime/ISO8859_15.h>
#include <Pantomime/ISO8859_2.h>
#include <Pantomime/ISO8859_3.h>
#include <Pantomime/ISO8859_4.h>
#include <Pantomime/ISO8859_5.h>
#include <Pantomime/ISO8859_6.h>
#include <Pantomime/ISO8859_7.h>
#include <Pantomime/ISO8859_8.h>
#include <Pantomime/ISO8859_9.h>
#include <Pantomime/KOI8_R.h>
#include <Pantomime/KOI8_U.h>
#include <Pantomime/LocalFolder.h>
#include <Pantomime/LocalFolderCacheManager.h>
#include <Pantomime/LocalMessage.h>
#include <Pantomime/LocalStore.h>
#ifdef MACOSX
#include <Pantomime/MacOSXGlue.h>
#endif
#include <Pantomime/Message.h>
#include <Pantomime/MimeMultipart.h>
#include <Pantomime/MimeUtility.h>
#include <Pantomime/NSRegEx.h>
#include <Pantomime/NSData+Extensions.h>
#include <Pantomime/NSString+Extensions.h>
#include <Pantomime/parseaddrs.h>
#include <Pantomime/Parser.h>
#include <Pantomime/Part.h>
#include <Pantomime/POP3CacheManager.h>
#include <Pantomime/POP3CacheObject.h>
#include <Pantomime/POP3Folder.h>
#include <Pantomime/POP3Message.h>
#include <Pantomime/POP3Store.h>
#include <Pantomime/Sendmail.h>
#include <Pantomime/Service.h>
#include <Pantomime/SMTP.h>
#include <Pantomime/Store.h>
#include <Pantomime/TCPConnection.h>
#include <Pantomime/Transport.h>
#include <Pantomime/UUFile.h>
#include <Pantomime/UTF8.h>
#include <Pantomime/WINDOWS_1250.h>
#include <Pantomime/WINDOWS_1251.h>
#include <Pantomime/WINDOWS_1252.h>
#include <Pantomime/WINDOWS_1253.h>
#include <Pantomime/WINDOWS_1254.h>

#endif // _Pantomime_H_Pantomime
