#ifndef INCLUDE_ENTITY_GROUP_H
#define INCLUDE_ENTITY_GROUP_H

#include <list>
#include "Entity.h"

typedef std::list<Entity*> EntityList;

class EntityGroup : public Entity {

 public:

  EntityGroup();
  ~EntityGroup();

  void addEntity(Entity *);
  bool removeEntity(Entity *);

  bool findExecute(EntityType, char *, char *, void *, bool);

  void save(FILE *);
  bool load(FILE *, char *);
  void exportEntities(FILE *, GList *);

  void populate_tree_model(GtkTreeStore *, GtkTreeIter *);
  GtkWidget * getWidgets();

  Entity * findByID(int);

  void apply();
  void destroyWidgets();

  bool contains(Entity *);

  int count();

  void setDisabled(bool);
  bool getDisabled();

 private:

  std::list<Entity*> my_entities;

  GtkWidget * name_entry;
  GtkWidget * description_view;
  GtkWidget * disabled_toggle;
  GtkTextBuffer * description_buffer;

  bool disabled;

};

#endif // INCLUDE_ENTITY_GROUP_H

