/**
 * This file is included by plugins.  Do not include any Papaya header files here.
 * Declare classes used using 'class <classname>;'
 */

#ifndef INCLUDE_PREFERENCE_H
#define INCLUDE_PREFERENCE_H

#include <gtk/gtk.h>
#include <glade/glade.h>

class Prefs;

typedef enum {
  WidgetToggle,
  WidgetCheckbutton,
  WidgetEntry,
  WidgetSpinbutton,
  WidgetOptionmenu,
  WidgetNone
} WidgetType;

typedef enum {
  CategoryTerminal,
  CategoryTerminalOutput,
  CategoryTerminalInput,
  CategoryTerminalHistory,
  CategoryConnection,
  CategoryConnectionGeneral,
  CategoryConnectionCompression,
  CategoryProxies,
  CategoryColours,
  CategoryFonts,
  CategoryPlugins, 
  CategoryLast // Not a real category, but the last place marker in the ENUM
} Category;

class PreferenceOptions {

 public:
  PreferenceOptions(char *, char *, WidgetType);
  ~PreferenceOptions();
  
  char * getName();
  char * getWidget();
  WidgetType getType();

 private:
  char * name, * widget;
  WidgetType type;
};

class PreferenceData {
 public:

  PreferenceData();
  PreferenceData(char * name, char * value);
  PreferenceData(char * name, bool value);
  PreferenceData(char * name, int value);
  ~PreferenceData();

  void setName(char * name);
  char * getName();

  void setValue(char * value);
  void setValue(bool value);
  void setValue(int value);
  char * getValue();

 private:

  char * name;
  char * value;

};

class Preference {

 public:

  Preference();
  virtual ~Preference();

  virtual GtkWidget * getWidget();
  virtual void destroyWidget();
  
  virtual void applyPreferences(Prefs *);
  virtual void loadPreferences(Prefs *);

  virtual Category * getCategories();

 protected:

  GladeXML *  xml;
  GList * availablePreferences;
};

#endif // INCLUDE_PREFERENCE_H
