/**
 * Win32PluginAPIImplementation.h
 *
 * Do NOT #include any Papaya header files into this file.  Declare the
 * required classes using "class <classname>;"
 */

#include "papaya/system.h"

class CommandInterpreter;
class EntityHandler;
class Entity;
class Connection;
class BaseWindow;
class PluginHandler;
class Preference;
class Plugin;
class Socket;
class VT;
class MUD;
class Prefs;
class Event;
class SystemTriggerEntity;
class Message;
class Fade;


// This is the exception to the above rule.
#include "Event.h"

void register_plugin(Plugin *, char *);
void unregister_plugin(Plugin *);

void preference_add_editor(Preference *);
void preference_remove_editor(Preference *);


Socket * connection_get_socket(Connection *);
VT * connection_get_vt(Connection *);
char * connection_get_name(Connection *);
MUD * connection_get_mud(Connection *);
Connection * connection_get_next(Connection *);
Prefs * connection_query_preferences(Connection *);


int socket_write(Socket *, char *, int);
bool socket_get_telnet_option(Socket *, int);

EvType event_get_type(Event *);

char * get_prefix();

void vt_add_to_tray(VT *, GtkWidget *, GtkWidget **);
void vt_remove_from_tray(VT *, GtkWidget *, GtkWidget *);
void vt_scroll(VT *);
void vt_append(VT *, char *);

char * preferences_get_preference(Prefs *, char *);
void preferences_set_preference(Prefs *, char *, char *);
int preferences_get_preference_integer(Prefs *, char *);
void preferences_set_preference_integer(Prefs *, char *, int);
bool preferences_get_preference_boolean(Prefs *, char *);
void preferences_set_preference_boolean(Prefs *, char *, bool);

void command_interpreter_interpret(CommandInterpreter *, Connection *, char *);

Prefs * get_global_preferences();
CommandInterpreter * get_command_interpreter();
Connection * get_first_connection();
EntityHandler * get_entity_handler();
BaseWindow * get_main_window();
PluginHandler * get_plugin_handler();
Connection * get_connection_by_name(char *);

void entity_handler_add_entity(EntityHandler *, char * group, void * entity);
void entity_handler_remove_entity(EntityHandler *, void * entity);

SystemTriggerEntity * system_trigger_entity_new(char * t, Connection * c, SystemTriggerCallbackFunction func, void * d);

Connection * main_window_get_current_connection(BaseWindow *);
GtkItemFactory * main_window_get_item_factory(BaseWindow *);
GtkWidget * main_window_add_page_for_app(BaseWindow *, char *);

void plugin_handler_client_message(PluginHandler *, Connection *, char *);
void plugin_handler_add_input_filter(PluginHandler *, Plugin *);
void plugin_handler_add_output_filter(PluginHandler *, Plugin *);
void plugin_handler_add_prompt_filter(PluginHandler *, Plugin *);
void plugin_handler_add_telopt_filter(PluginHandler *, Plugin *, unsigned char);
void plugin_handler_remove_input_filter(PluginHandler *, Plugin *);
void plugin_handler_remove_output_filter(PluginHandler *, Plugin *);
void plugin_handler_remove_prompt_filter(PluginHandler *, Plugin *);
void plugin_handler_remove_telopt_filter(PluginHandler *, Plugin *, unsigned char);
void plugin_handler_remove_telopt_filters(PluginHandler *, Plugin *);


Prefs * mud_get_preferences(MUD *);
char * mud_get_password(MUD *);
char * mud_get_login_name(MUD *);
char * mud_get_login_trigger(MUD *);
char * mud_get_password_trigger(MUD *);
void mud_set_password(MUD *, char *);
void mud_set_login_name(MUD *, char *);
void mud_set_login_trigger(MUD *, char *);
void mud_set_password_trigger(MUD *, char *);

Message * message_new(char *, char *, bool);

GdkColor * fade_get_shade(Fade *, int, int);
GtkWidget * fade_get_editor(Fade *);
void fade_on_prefs_cancel(Fade *);
void fade_on_prefs_apply(Fade *);
char * fade_string_max_colour(Fade *);
char * fade_string_mid_colour(Fade *);
char * fade_string_min_colour(Fade *);
char * fade_string_use_three(Fade *);
Fade * fade_new(gboolean, char *, char *, char *);
void fade_reset(Fade *, gboolean, char *, char *, char *);
void fade_delete(Fade *);

// Turf protocol uses void * to pass classes as dl.c won't accept C++ code.
extern "C" void turf_protocol_add_command(void *, char *, void *, gpointer);
extern "C" bool turf_protocol_is_supported(void *);
