#include "PromptPreference.h"
#include "mudclient.h"

#include <gmodule.h>

extern PreferenceHandler * preferenceHandler;
static PromptPreference * promptPreference;

PromptPreference::PromptPreference() {
  xml = NULL;
  promptPreference = this;

  availablePreferences = g_list_append(availablePreferences, new PreferenceOptions("PromptOnInputLine", "prompt_area_checkbox", WidgetToggle));
  availablePreferences = g_list_append(availablePreferences, new PreferenceOptions("UsePromptTerminator", "prompt_terminator_checkbox", WidgetToggle));
  availablePreferences = g_list_append(availablePreferences, new PreferenceOptions("PromptTerminator", "prompt_terminator_entry", WidgetEntry));
  availablePreferences = g_list_append(availablePreferences, new PreferenceOptions("DoublePrompt", "prompt_window_checkbox", WidgetToggle));


}

PromptPreference::~PromptPreference() {
  promptPreference = NULL;
  if (xml)
    g_object_unref(xml);
}

GtkWidget * PromptPreference::getWidget() {
  char buf[1024];
  snprintf(buf, 1024, "%s/share/papaya/promptpreferences.glade", getPrefix());
  
  if (xml) {
    GtkWidget * vbox = glade_xml_get_widget(xml, "vbox");
    return vbox;
  }

  xml = glade_xml_new(buf, NULL, NULL);
  glade_xml_signal_autoconnect(xml);
  GtkWidget * vbox = glade_xml_get_widget(xml, "vbox");
  gtk_widget_show(vbox);
  return vbox;
}

void PromptPreference::destroyWidget() {
  if (xml)
    g_object_unref(xml);
  xml = NULL;
}

Category * PromptPreference::getCategories() {
  return (Category *)prompt_categories;
}

void PromptPreference::setTerminatorEntryState(bool enable) {
  gtk_widget_set_sensitive(glade_xml_get_widget(xml, "prompt_terminator_entry"), enable);
}


extern "C" G_MODULE_EXPORT gint on_prompt_terminator_checkbox_toggled(GtkWidget * widget, gpointer data) {
  promptPreference->setTerminatorEntryState(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
  return 1;
}
