#include "mudclient.h"
#include "PluginHandler.h"
#include "Prefs.h"
#include "Connection.h"
#include "CommandInterpreter.h"
#include "EntityHandler.h"
#include "BaseWindow.h"
#include "PreferenceHandler.h"
#include "papaya/Event.h"
#include "Message.h"
#include "Telnet.h"
#include "SystemTriggerEntity.h"
#include "Fade.h"

extern Prefs * globalPreferences;
extern PluginHandler * phandler;
extern BaseWindow * mainWindow;
extern EntityHandler * entities;
extern Connection * first_connection;
extern CommandInterpreter * commandInterpreter;
extern PreferenceHandler * preferenceHandler;


void register_plugin(Plugin * p, char * ver) {
	phandler->registerPlugin(p, ver);
}

void unregister_plugin(Plugin * p) {
	phandler->unregisterPlugin(p);
}




void preference_add_editor(Preference * p) {
  preferenceHandler->addPreferenceEditor(p);
}

void preference_remove_editor(Preference * p) {
  preferenceHandler->removePreferenceEditor(p);
}

Socket * connection_get_socket(Connection * c) {

	return c->getSocket();

}



VT * connection_get_vt(Connection * c) {

	return c->getVT();

}



char * connection_get_name(Connection * c) {

	return c->getName();

}



EvType event_get_type(Event * e) {

	return e->getType();

}



int socket_write(Socket * s, char * t, int len) {

	return s->write(t, len);

}


bool socket_get_telnet_option(Socket * s, int option) {
  return s->getTelnetOption((Telnet::option_t) option);
}



void vt_append(VT * vt, char * t) {

	vt->append(t);

}



void vt_add_to_tray(VT * vt, GtkWidget * w1, GtkWidget ** w2) {

	vt->addToTray(w1, w2);

}



void vt_remove_from_tray(VT * vt, GtkWidget * w1, GtkWidget * w2) {

	vt->removeFromTray(w1, w2);

}



char * get_prefix() {

	return getPrefix();

}



MUD * connection_get_mud(Connection * c) {

	return c->getMUD();

}



char * preferences_get_preference(Prefs * p, char * name) {

	return p->getPreference(name);

}



void preferences_set_preference(Prefs * p, char * name, char * value) {

	p->setPreference(name, value);

}


int preferences_get_preference_integer(Prefs * p, char * name) {
	return p->getPreferenceInteger(name);
}

void preferences_set_preference_integer(Prefs * p, char * name, int value) {
	p->setPreferenceInteger(name, value);
}

bool preferences_get_preference_boolean(Prefs * p, char * name) {
	return p->getPreferenceBoolean(name);
}

void preferences_set_preference_boolean(Prefs * p, char * name, bool value) {
	p->setPreferenceBoolean(name, value);
}


Prefs * get_global_preferences() {

	return globalPreferences;

}



Prefs * mud_get_preferences(MUD * m) {

	return m->getPreferences();

}




char * mud_get_password(MUD * m) {
  return m->getPassword();
}

void mud_set_password(MUD * m, char * pw) {
  m->setPassword(pw);
}

char * mud_get_login_name(MUD * m) {
  return m->getLoginName();
}

void mud_set_login_name(MUD * m, char * n) {
  m->setName(n);
}

char * mud_get_login_trigger(MUD * m) {
  return m->getLoginTrigger();
}

void mud_set_login_trigger(MUD * m, char * t) {
  m->setLoginTrigger(t);
}

char * mud_get_password_trigger(MUD * m) {
  return m->getPasswordTrigger();
}

void mud_set_password_trigger(MUD * m, char * t) {
  m->setPasswordTrigger(t);
}

Connection * connection_get_next(Connection * c) {

	return c->getNext();

}



Connection * get_first_connection() {

	return first_connection;

}



CommandInterpreter * get_command_interpreter() {

	return commandInterpreter;

}



void command_interpreter_interpret(CommandInterpreter * ci, Connection * c, char * cmd) {

	ci->interpret(c, cmd);

}



BaseWindow * get_main_window() {

	return mainWindow;

}



EntityHandler * get_entity_handler() {

	return entities;

}



PluginHandler * get_plugin_handler() {

	return phandler;

}



Connection * main_window_get_current_connection(BaseWindow * w) {

	return w->getCurrentConnection();

}



GtkItemFactory * main_window_get_item_factory(BaseWindow * w) {

	return w->getItemFactory();

}


GtkWidget * main_window_add_page_for_app(BaseWindow * w, char * string) {
  return w->addPageForApp(string);
}



void entity_handler_add_entity(EntityHandler * eh, char * group, void * e) {

	eh->addEntity(group, (Entity *)e);

}



void entity_handler_remove_entity(EntityHandler * eh, void * e) {

	eh->removeEntity((Entity *)e);

}


SystemTriggerEntity * system_trigger_entity_new(char * t, Connection * c, SystemTriggerCallbackFunction func, void * d) {
  return new SystemTriggerEntity(t, c, func, d);
}


void plugin_handler_client_message(PluginHandler * ph, Connection * c, char * msg) {

	ph->clientMessage(c, msg);

}


void plugin_handler_add_input_filter(PluginHandler * ph, Plugin * p) {
  ph->addInputFilter(p);
}

void plugin_handler_add_output_filter(PluginHandler * ph, Plugin * p) {
  ph->addOutputFilter(p);
}

void plugin_handler_add_prompt_filter(PluginHandler * ph, Plugin * p) {
  ph->addPromptFilter(p);
}

void plugin_handler_add_telopt_filter(PluginHandler * ph, Plugin * p, unsigned char option) {
  ph->addTeloptFilter(p, option);
}

void plugin_handler_remove_input_filter(PluginHandler * ph, Plugin * p) {
  ph->removeInputFilter(p);
}

void plugin_handler_remove_output_filter(PluginHandler * ph, Plugin * p) {
  ph->removeOutputFilter(p);
}

void plugin_handler_remove_prompt_filter(PluginHandler * ph, Plugin * p) {
  ph->removePromptFilter(p);
}

void plugin_handler_remove_telopt_filter(PluginHandler * ph, Plugin * p, unsigned char option) {
  ph->removeTeloptFilter(p, option);
}

void plugin_handler_remove_telopt_filters(PluginHandler * ph, Plugin * p) {
  ph->removeTeloptFilters(p);
}




void vt_scroll(VT * vt) {

	vt->scroll();

}



Connection * get_connection_by_name(char * c) {

	return findConnection(c);

}



Prefs * connection_query_preferences(Connection * c) {

	return c->queryPreferences();

}

Message * message_new(char * title, char * message, bool modal) {
  return new Message(title, message, modal);
}

GdkColor * fade_get_shade(Fade * fade, int level, int max_level) {
  return fade->getShade(level, max_level);
}

GtkWidget * fade_get_editor(Fade * fade) {
  return fade->getEditor();
}

void fade_on_prefs_cancel(Fade * fade) {
  fade->onPrefsCancel();
}

void fade_on_prefs_apply(Fade * fade) {
  fade->onPrefsApply();
}

char * fade_string_max_colour(Fade * fade) {
  return fade->stringMaxColour();
}

char * fade_string_mid_colour(Fade * fade) {
  return fade->stringMidColour();
}

char * fade_string_min_colour(Fade * fade) {
  return fade->stringMinColour();
}

char * fade_string_use_three(Fade * fade) {
  return fade->stringUseThree();
}

Fade * fade_new(gboolean three, char * min, char * mid, char * max) {
  return new Fade(three, min, mid, max);
}

void fade_reset(Fade * fade, gboolean three, char * min, char * mid, char *max) {
  fade->reset(three, min, mid, max);
}

void fade_delete(Fade *fade) {
  delete fade;
}

#ifndef WIN32
void plugin_address_table_init(void *) {
}
#endif
