#ifndef WIN32

#include <gtk/gtk.h>
#ifndef WIN32
#include <gdk/gdkx.h>
#include <unistd.h>
#endif
#include <pthread.h>
#include <stdio.h>
#include <signal.h>
#include <stdlib.h>
#include <string.h>

#include "Win32PluginAPI.cpp"
#include "Mudftp.h"

static Mudftp * mudftp;

#define MAJOR "1"
#define MINOR "1"

extern "C" char * plugin_query_name() {
  return "Mudftp";
}

extern "C" char * plugin_query_description() {
  return _("Embeds the gmudftp application into Papaya.");
}

extern "C" char * plugin_query_major() {
  return MAJOR;
}

extern "C" char * plugin_query_minor() {
  return MINOR;
}

extern "C" void plugin_init(void) {
  mudftp = new Mudftp();
}

extern "C" void plugin_cleanup(void) {
  delete mudftp;
}

Mudftp::Mudftp() {
  child_pid = 0;

  version = 1.0;
  name = strdup("mudFTP");

  register_plugin(this, VERSION);

  run();
}

Mudftp::~Mudftp() {
  // This is going to kill the main process!
  // kill();
  
  //  kill();

  unregister_plugin(this);
}

void Mudftp::run() {
  char arg[1024];

  GtkWidget * socket = main_window_add_page_for_app(get_main_window(), "mudFTP");
  if (!socket) {
    //    new Message(_("Error"), _("Cannot create page for mudFTP application."), true);
    return;
  }

  // @@ This plugin probably doesn't work any more.
  sprintf(arg, "%ld", GDK_WINDOW_XWINDOW(socket->window));

  child_pid = fork();
  if (child_pid == 0) {
    execlp("gmudftp", arg, NULL);
    abort();
  }

  return;
}

void Mudftp::kill() {
  // @@ Kill process with child pid.
  ::kill(child_pid, SIGKILL);
}

char * Mudftp::getDescription() {
  return "Embeds gmudFTP into Papaya";
}

#endif




