typedef enum {

  CmdNone = 0,

  NameChange = 1,
  RequestConnections = 2,
  ConnectionList = 3,
  TextEverybody = 4,
  TextPersonal = 5,
  TextGroup = 6,
  Message = 7,

  Version = 19,
  FileStart = 20,
  FileDeny = 21,
  FileBlockRequest = 22,
  FileBlock = 23,
  FileEnd = 24,
  FileCancel = 25,
  PingRequest = 26,
  PingResponse = 27,
  PeekConnections = 28,
  PeekList = 29,
  Snoop = 30,
  SnoopData = 31,

  Icon = 100,
  Status = 101,
  EmailAddress = 102,
  RequestPGPKey = 103,
  PGPKey = 104,
  SendCommand =105,
  Stamp = 106

} ZChatCommandType;

struct command {
  ZChatCommandType id; // Local byte order
  uint16_t len; // Local byte order
  char * data; // The data area of the command

  char * zchat; // The constructed zchat version of the command.
  char * mudmaster; // The constructed mudmaster version of the command.
};

struct command * new_command();
void delete_command(struct command *);
