/*
 * Copyright (C) 2002-2003  Jean-Charles Salzeber <jc@varspool.net>
 *
 * This file is part of penggy.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *                
 * $Id: utils.h,v 1.8 2003/02/01 13:45:28 chupa Exp $
 *               
 */

#ifndef __UTILS_H__
#define __UTILS_H__

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#ifdef HAVE_SYS_TYPES_H
# include <sys/types.h>
#endif
#ifdef HAVE_BYTESWAP_H
# include <byteswap.h>
#endif

#ifndef MAX
# define MAX(a,b) ((a)>(b) ? (a):(b))
#endif

/* Host to Little Endian */
#if WORDS_BIGENDIAN
#  define htoles(x)   bswap_16(x)
#  define htolel(x)   bswap_32(x)
#else
#  define htoles(x)   (x)
#  define htolel(x)   (x)
#endif

/* Little Endian to host*/
#if WORDS_BIGENDIAN
#  define letohs(x)   bswap_16(x)
#  define letohl(x)   bswap_32(x)
#else
#  define letohs(x)   (x)
#  define letohl(x)   (x)
#endif

void trim (char *line);
void lowerize (char *string);

#endif /* __UTILS_H__ */
