#!/bin/sh
#
# ctrlif.sh       Bring up/down networking
#
# description: Activates/Deactivates pentamedia interfaces configured to 
#              start at boot time.
# $1 : command
# $2 : interface's name 
# $3 : driver module's name

card=0

if [ ! -f /proc/$3 ]; then
	echo 
	echo "Can't read the count of $3"
	echo 
	exit 1
fi

if [ ! -d /etc/sysconfig/network-scripts ]; then
	echo 
	echo "Can't find /etc/sysconfig/network-scripts"
	echo 
	exit 2
fi

if [ ! -f /etc/modules.conf ]; then
	echo 
	echo "Can't find /etc/modules.conf"
	echo 
	exit 3
fi

count=`cat /proc/$3` 

# See how we were called.
case "$1" in
	start)
		while [ "$card" -le $(($count-1)) ]; do
			echo 
			echo "->Bringing up interface $2$card"
			echo 

			echo "alias $2$card $3" >> /etc/modules.conf
			echo "DEVICE=$2$card" >> config/netscripts
			cp -f config/netscripts /etc/sysconfig/network-scripts/ifcfg-$2$card
		        /sbin/ifup ifcfg-$2$card

			sed -e '/DEVICE='$2$card'/d' config/netscripts > tmp
			rm -f config/netscripts
			mv tmp config/netscripts
			card=$(($card+1)) 
		done
        ;;
	stop)
		while [ "$card" -le $(($count-1)) ]; do
			echo 
			echo "->Bringing down interface $2$card"
			echo 

		        /sbin/ifdown ifcfg-$2$card
			rm -f /etc/sysconfig/network-scripts/ifcfg-$2$card

			sed -e '/alias '$2$card' '$3'/d' /etc/modules.conf > tmp
			rm -f /etc/modules.conf;
			mv tmp /etc/modules.conf
			card=$(($card+1)) 
		done
        ;;

	*)
        echo $"Usage: $0 {start|stop} {inteface's name} {driver module's name}"
        exit 4
esac

exit 0
