(** Wrapper around Perl [Net::Google::Reponse] class.
  *
  * Copyright (C) 2003 Merjis Ltd.
  *
  * $Id: pl_Net_Google_Response.ml,v 1.3 2003/10/16 13:41:07 rich Exp $
  *)

open Perl

let _ = eval "use Net::Google::Response"

class net_google_response sv =

object (self)

  method documentFiltering =
    bool_of_sv (call_method sv "documentFiltering" [])
  method searchComments =
    string_of_sv (call_method sv "searchComments" [])
  method estimateTotalResultsNumber =
    int_of_sv (call_method sv "estimateTotalResultsNumber" [])
  method estimateIsExact =
    bool_of_sv (call_method sv "estimateIsExact" [])
  method searchQuery =
    string_of_sv (call_method sv "searchQuery" [])
  method startIndex =
    int_of_sv (call_method sv "startIndex" [])
  method endIndex =
    int_of_sv (call_method sv "endIndex" [])
  method searchTips =
    string_of_sv (call_method sv "searchTips" [])
  method directoryCategories =
    let sv = call_method sv "directoryCategories" [] in
    let av = deref_array sv in
    av_map (fun sv -> new net_google_response sv) av
  method searchTime =
    float_of_sv (call_method sv "searchTime" [])
  method toString =
    string_of_sv (call_method sv "toString" [])
  method title =
    string_of_sv (call_method sv "title" [])
  method url =
    string_of_sv (call_method sv "URL" [])
  method snippet =
    string_of_sv (call_method sv "snippet" [])
  method cachedSize =
    string_of_sv (call_method sv "cachedSize" [])
  method directoryTitle =
    string_of_sv (call_method sv "directoryTitle" [])
  method summary =
    string_of_sv (call_method sv "summary" [])
  method hostName =
    string_of_sv (call_method sv "hostName" [])

  (* method directoryCategory *)

end

(* let new_ = ... *)
