%{
#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include "types.h"
#include "text.tab.h"

#include "misc.h"

static int
puttext(void) {
  yylval.text.text=yytext;
  yylval.text.n=yyleng;
  return 0;
}

%}

%option nomain
%option noyywrap
%option case-insensitive
%option 8bit
%option nounput

SPACE [ ]
NL [\n]
SPEC [_^$%#]
QUOTE [\"]
NORM [^{SPEC}{QUOTE}]
ALPHA [[:alpha:]\'-]
DIGIT [:digit:]


%x arabic
%x quote

%%

%{
static int start;

if (!start) {
  yy_flex_debug=getenv("DEBUG_LEX") ? 1 : 0;
  start=1;
}

%}

<INITIAL,quote>{

  "{"{SPACE}*"\\arabic" {
    BEGIN(arabic);
    puttext();
    return STRING;
  }
  
  "&"{ALPHA}+ {
    yytext++;
    yyleng--;
    puttext();
    return LOOKUP;
  }
  
  {NL}{SPACE}*{NL}{SPACE}*"+P"{DIGIT}+{SPACE}*{NL} {
    yytext=strstr(yytext,"+P")+2;
    yylval.num=atoi(yytext);
    return PAGE_NO;
  }

  ^{SPACE}{5} {
    yylval.text.text="\n";
    yylval.text.n=1;
    return STRING;
  }

  {NORM}+ {
    puttext();
    return STRING;
  }
  
  {SPEC} {
    yylval.c=*yytext;
    return SPECIAL;
  }
  
}

<arabic>{
  
  [^\}]+ {
    puttext();
    return STRING;
  }
  
  "}" {
    BEGIN(INITIAL);
    puttext();
    return STRING;
  }
  
}

<quote>{
  
  {QUOTE} {
    BEGIN(INITIAL);
    yylval.text.text="''";
    yylval.text.n=2;
    return STRING;
  }

}

{QUOTE} {
  BEGIN(quote);
  yylval.text.text="``";
  yylval.text.n=2;
  return STRING;
}




%%

