/* $Id$ */

/* ---------------------------------------------------------------- */

%header %{
#if (PETSC_VERSION_MAJOR    == 2 && \
     PETSC_VERSION_MINOR    == 3 && \
     PETSC_VERSION_SUBMINOR == 2 && \
     PETSC_VERSION_RELEASE  == 1)
#if defined(PETSC_HAVE_MPIUNI)
#if !defined(MPI_Finalized)
static SWIGUNUSED
int MPI_Finalized(int *flag)
{
  if (flag) *flag = 0;
  return 0;
}
#endif
#endif
#endif
%}

/* ---------------------------------------------------------------- */

%header %{
#if (PETSC_VERSION_MAJOR    == 2 && \
     PETSC_VERSION_MINOR    == 3 && \
     PETSC_VERSION_SUBMINOR == 2 && \
     PETSC_VERSION_RELEASE  == 1)

#define VEC_IGNORE_NEGATIVE_INDICES 1
static SWIGUNUSED
PetscErrorCode VecSetOption_232(Vec x,VecOption op,PetscTruth flag) {
  if (op==VEC_IGNORE_OFF_PROC_ENTRIES && flag==PETSC_FALSE) 
    op = VEC_TREAT_OFF_PROC_ENTRIES;
  else 
    return 0;
  return VecSetOption(x,op);
}
#define VecSetOption(x,o,f) VecSetOption_232(x,o,f)


#define VecStrideScale(v,start,scale) VecStrideScale(v,start,&scale)

#endif
%}

%header %{
#if (PETSC_VERSION_MAJOR    == 2 && \
     PETSC_VERSION_MINOR    == 3 && \
     PETSC_VERSION_SUBMINOR == 2 && \
     PETSC_VERSION_RELEASE  == 1)
static SWIGUNUSED
PetscErrorCode ISSum_232(IS is1,IS is2,IS *is3) {
  PetscTruth     f;
  PetscErrorCode ierr;
  PetscFunctionBegin;
  PetscValidHeaderSpecific(is1,IS_COOKIE,1);
  PetscValidHeaderSpecific(is2,IS_COOKIE,2);
  PetscValidPointer(is3, 3);
  ierr = ISSorted(is1,&f); CHKERRQ(ierr);
  if (!f) SETERRQ(PETSC_ERR_ARG_INCOMP,"Arg 1 is not sorted");
  ierr = ISSorted(is2,&f); CHKERRQ(ierr);
  if (!f) SETERRQ(PETSC_ERR_ARG_INCOMP,"Arg 2 is not sorted");
  ierr = ISDuplicate(is1,is3); CHKERRQ(ierr);
  ierr = ISSum(is3,is2); CHKERRQ(ierr);
  PetscFunctionReturn(0);
}
#define ISSum(is1,is2,is3) ISSum_232(is1,is2,is3)
#endif
%}

%header %{
#if (PETSC_VERSION_MAJOR    == 2 && \
     PETSC_VERSION_MINOR    == 3 && \
     PETSC_VERSION_SUBMINOR == 2 && \
     PETSC_VERSION_RELEASE  == 1)
#define VecScatterBegin(sct,x,y,im,sm) VecScatterBegin(x,y,im,sm,sct)
#define VecScatterEnd(sct,x,y,im,sm)   VecScatterEnd(x,y,im,sm,sct)
#endif
%}

/* ---------------------------------------------------------------- */

%header %{
#if (PETSC_VERSION_MAJOR    == 2 && \
     PETSC_VERSION_MINOR    == 3 && \
     PETSC_VERSION_SUBMINOR == 2 && \
     PETSC_VERSION_RELEASE  == 1)

#define MatGetRowIJ(mat,shift,symm,bc,n,ia,ja,done) \
        MatGetRowIJ(mat,shift,symm,n,ia,ja,done)
#define MatRestoreRowIJ(mat,shift,symm,bc,n,ia,ja,done) \
        MatRestoreRowIJ(mat,shift,symm,n,ia,ja,done)
#define MatGetColumnIJ(mat,shift,symm,bc,n,ia,ja,done) \
        MatGetColumnIJ(mat,shift,symm,n,ia,ja,done)
#define MatRestoreColumnIJ(mat,shift,symm,bc,n,ia,ja,done) \
        MatRestoreColumnIJ(mat,shift,symm,n,ia,ja,done)

#define MatIsHermitian(A,tol,flg) MatIsHermitian(A,flg)

#define MAT_ROW_ORIENTED 1
#define MAT_COLUMN_ORIENTED 2
#define MAT_ROWS_SORTED 4
#define MAT_COLUMNS_SORTED 8
#define MAT_NO_NEW_NONZERO_LOCATIONS 16
#define MAT_YES_NEW_NONZERO_LOCATIONS 32
#define MAT_SYMMETRIC 64
#define MAT_STRUCTURALLY_SYMMETRIC 65
#define MAT_NO_NEW_DIAGONALS 66
#define MAT_YES_NEW_DIAGONALS 67
#define MAT_INODE_LIMIT_1 68
#define MAT_INODE_LIMIT_2 69
#define MAT_INODE_LIMIT_3 70
#define MAT_INODE_LIMIT_4 71
#define MAT_INODE_LIMIT_5 72
#define MAT_IGNORE_OFF_PROC_ENTRIES 73
#define MAT_ROWS_UNSORTED 74
#define MAT_COLUMNS_UNSORTED 75
#define MAT_NEW_NONZERO_LOCATION_ERR 76
#define MAT_NEW_NONZERO_ALLOCATION_ERR 77
#define MAT_USE_HASH_TABLE 78
#define MAT_KEEP_ZEROED_ROWS 79
#define MAT_IGNORE_ZERO_ENTRIES 80
#define MAT_USE_INODES 81
#define MAT_DO_NOT_USE_INODES 82
#define MAT_NOT_SYMMETRIC 83
#define MAT_HERMITIAN 84
#define MAT_NOT_STRUCTURALLY_SYMMETRIC 85
#define MAT_NOT_HERMITIAN 86
#define MAT_SYMMETRY_ETERNAL 87
#define MAT_NOT_SYMMETRY_ETERNAL 88
#define MAT_USE_COMPRESSEDROW 89
#define MAT_DO_NOT_USE_COMPRESSEDROW 90
#define MAT_IGNORE_LOWER_TRIANGULAR 91
#define MAT_ERROR_LOWER_TRIANGULAR 92
#define MAT_GETROW_UPPERTRIANGULAR 93

#define MAT_NEW_NONZERO_LOCATIONS MAT_YES_NEW_NONZERO_LOCATIONS
#define MAT_NEW_DIAGONALS         MAT_YES_NEW_DIAGONALS
static SWIGUNUSED
PetscErrorCode MatSetOption_232(Mat A,MatOption op,PetscTruth flag) {
#define MAT_OPTION_INVALID ((MatOption)(-1))
  MatOption o = MAT_OPTION_INVALID;
  switch (op) {

  case MAT_ROW_ORIENTED:
    o = (flag ? MAT_ROW_ORIENTED : MAT_COLUMN_ORIENTED); break;

  case MAT_NEW_NONZERO_LOCATIONS:
    o = (flag ? MAT_YES_NEW_NONZERO_LOCATIONS : MAT_NO_NEW_NONZERO_LOCATIONS); break;

  case MAT_SYMMETRIC:
    o = (flag ? MAT_SYMMETRIC : MAT_NOT_SYMMETRIC); break;

  case MAT_STRUCTURALLY_SYMMETRIC:
    o = (flag ? MAT_STRUCTURALLY_SYMMETRIC : MAT_NOT_STRUCTURALLY_SYMMETRIC); break;

  case MAT_NEW_DIAGONALS:
    o = (flag ? MAT_YES_NEW_DIAGONALS : MAT_NO_NEW_DIAGONALS); break;

  case MAT_IGNORE_OFF_PROC_ENTRIES:
    o = (flag ? MAT_IGNORE_OFF_PROC_ENTRIES : MAT_OPTION_INVALID); break;

  case MAT_NEW_NONZERO_LOCATION_ERR:
    o = (flag ? MAT_NEW_NONZERO_LOCATION_ERR : MAT_OPTION_INVALID); break;

  case MAT_NEW_NONZERO_ALLOCATION_ERR:
    o = (flag ? MAT_NEW_NONZERO_ALLOCATION_ERR : MAT_OPTION_INVALID); break;

  case MAT_USE_HASH_TABLE:
    o = (flag ? MAT_USE_HASH_TABLE : MAT_OPTION_INVALID); break;

  case MAT_KEEP_ZEROED_ROWS:
    o = (flag ? MAT_KEEP_ZEROED_ROWS : MAT_OPTION_INVALID); break;

  case MAT_IGNORE_ZERO_ENTRIES:
    o = (flag ? MAT_IGNORE_ZERO_ENTRIES : MAT_OPTION_INVALID); break;

  case MAT_USE_INODES: 
    o = (flag ? MAT_USE_INODES : MAT_DO_NOT_USE_INODES); break;
    
  case MAT_HERMITIAN:
    o = (flag ? MAT_HERMITIAN: MAT_NOT_HERMITIAN); break;

  case MAT_SYMMETRY_ETERNAL:
    o = (flag ? MAT_SYMMETRY_ETERNAL : MAT_NOT_SYMMETRY_ETERNAL); break;
    
  case MAT_USE_COMPRESSEDROW:
    o = (flag ? MAT_USE_COMPRESSEDROW : MAT_DO_NOT_USE_COMPRESSEDROW); break;

  case MAT_IGNORE_LOWER_TRIANGULAR:
    o = (flag ? MAT_IGNORE_LOWER_TRIANGULAR : MAT_OPTION_INVALID); break;
  case MAT_ERROR_LOWER_TRIANGULAR:
    o = (flag ? MAT_ERROR_LOWER_TRIANGULAR : MAT_OPTION_INVALID); break;
  case MAT_GETROW_UPPERTRIANGULAR:
    o = (flag ? MAT_GETROW_UPPERTRIANGULAR : MAT_OPTION_INVALID); break;
  
  default: 
    o = op; break;
  }
  return MatSetOption(A,o);
#undef MAT_OPTION_INVALID
} 

#define MatSetOption(A,o,f) MatSetOption_232(A,o,f)

#endif
%}

/* ---------------------------------------------------------------- */

%header %{
#if (PETSC_VERSION_MAJOR    == 2 && \
     PETSC_VERSION_MINOR    == 3 && \
     PETSC_VERSION_SUBMINOR == 2 && \
     PETSC_VERSION_RELEASE  == 1)

#define PetscOptionsMonitorSet(mfun,mctx,mdestr) PetscOptionsSetMonitor(mfun,mctx,mdestr)
#define PetscOptionsMonitorCancel() PetscOptionsClearMonitor()

#define KSPMonitorSet(ksp,mfun,mctx,mdestr) KSPSetMonitor(ksp,mfun,mctx,mdestr)
#define KSPMonitorCancel(ksp) KSPClearMonitor(ksp)
#define KSPMonitorDefault KSPDefaultMonitor
#define KSPMonitorTrueResidualNorm KSPTrueMonitor
#define KSPMonitorSolution KSPVecViewMonitor
#define KSPMonitorLG KSPLGMonitor

#define SNESMonitorSet(snes,mfun,mctx,mdestr) SNESSetMonitor(snes,mfun,mctx,mdestr)
#define SNESMonitorCancel(snes) SNESClearMonitor(snes)
#define SNESMonitorDefault SNESDefaultMonitor
#define SNESMonitorResidual SNESVecViewResidualMonitor
#define SNESMonitorSolution SNESVecViewMonitor
#define SNESMonitorSolutionUpdate SNESVecViewUpdateMonitor
#define SNESMonitorLG SNESLGMonitor

#define TSMonitorSet(snes,mfun,mctx,mdestr) TSSetMonitor(snes,mfun,mctx,mdestr)
#define TSMonitorCancel(snes) TSClearMonitor(snes)
#define TSMonitorDefault TSDefaultMonitor
#define TSMonitorSolution TSVecViewMonitor
#define TSMonitorLG TSLGMonitor

#endif
%}

/* ---------------------------------------------------------------- */

%header %{
#if (PETSC_VERSION_MAJOR    == 2 && \
     PETSC_VERSION_MINOR    == 3 && \
     PETSC_VERSION_SUBMINOR == 2 && \
     PETSC_VERSION_RELEASE  == 1)

#define KSP_NORM_NO		  KSP_NO_NORM
#define KSP_NORM_PRECONDITIONED   KSP_PRECONDITIONED_NORM
#define KSP_NORM_UNPRECONDITIONED KSP_UNPRECONDITIONED_NORM
#define KSP_NORM_NATURAL          KSP_NATURAL_NORM

#include "include/private/kspimpl.h"

static SWIGUNUSED
PetscErrorCode KSPGetNormType(KSP ksp, KSPNormType *normtype) {
  PetscFunctionBegin;
  PetscValidHeaderSpecific(ksp,KSP_COOKIE,1);
  PetscValidPointer(normtype, 2);
  *normtype = ksp->normtype;
  PetscFunctionReturn(0);
}

#endif
%}

%header %{
#if (PETSC_VERSION_MAJOR    == 2 && \
     PETSC_VERSION_MINOR    == 3 && \
     PETSC_VERSION_SUBMINOR == 2 && \
     PETSC_VERSION_RELEASE  == 1)
#define  KSP_CONVERGED_CG_NEG_CURVE   KSP_CONVERGED_STCG_NEG_CURVE
#define  KSP_CONVERGED_CG_CONSTRAINED KSP_CONVERGED_STCG_CONSTRAINED
#endif
%}

/* ---------------------------------------------------------------- */

%header %{
#if (PETSC_VERSION_MAJOR    == 2 && \
     PETSC_VERSION_MINOR    == 3 && \
     PETSC_VERSION_SUBMINOR == 2 && \
     PETSC_VERSION_RELEASE  == 1)
#include "include/private/snesimpl.h"

#define SNES_CONVERGED_ITS 5
#define SNESDefaultConverged SNESConverged_LS
#define SNESSkipConverged(snes,it,xnorm,pnorm,fnorm,reason,ctx) \
  (*reason = SNES_CONVERGED_ITERATING, 0)
#endif
%}

%header %{
#if (PETSC_VERSION_MAJOR    == 2 && \
     PETSC_VERSION_MINOR    == 3 && \
     PETSC_VERSION_SUBMINOR == 2 && \
     PETSC_VERSION_RELEASE  == 1)
#include "include/private/snesimpl.h"
#undef __FUNCT__
#define __FUNCT__ "SNESKSPSetUseEW"
static SWIGUNUSED
PetscErrorCode SNESKSPSetUseEW(SNES snes,PetscTruth flag)
{
  PetscFunctionBegin;
  PetscValidHeaderSpecific(snes,SNES_COOKIE,1);
  snes->ksp_ewconv = flag;
  PetscFunctionReturn(0);
}
#undef __FUNCT__
#define __FUNCT__ "SNESKSPGetUseEW"
static SWIGUNUSED
PetscErrorCode SNESKSPGetUseEW(SNES snes, PetscTruth *flag)
{
  PetscFunctionBegin;
  PetscValidHeaderSpecific(snes,SNES_COOKIE,1);
  PetscValidPointer(flag,2);
  *flag = snes->ksp_ewconv;
  PetscFunctionReturn(0);
}
#undef __FUNCT__
#define __FUNCT__ "SNESKSPGetParametersEW"
static SWIGUNUSED
PetscErrorCode SNESKSPGetParametersEW(SNES snes,PetscInt *version,PetscReal *rtol_0,PetscReal *rtol_max,
				      PetscReal *gamma,PetscReal *alpha,PetscReal *alpha2,PetscReal *threshold)
{
  SNES_KSP_EW_ConvCtx *kctx;
  PetscFunctionBegin;
  PetscValidHeaderSpecific(snes,SNES_COOKIE,1);
  kctx = (SNES_KSP_EW_ConvCtx*)snes->kspconvctx;
  if (!kctx) SETERRQ(PETSC_ERR_ARG_WRONGSTATE,"No Eisenstat-Walker context existing");
  if(version)   *version   = kctx->version;
  if(rtol_0)    *rtol_0    = kctx->rtol_0;
  if(rtol_max)  *rtol_max  = kctx->rtol_max;
  if(gamma)     *gamma     = kctx->gamma;
  if(alpha)     *alpha     = kctx->alpha;
  if(alpha2)    *alpha2    = kctx->alpha2;
  if(threshold) *threshold = kctx->threshold;
  PetscFunctionReturn(0);
}
#undef __FUNCT__
#define __FUNCT__ "SNESKSPSetParametersEW"
static SWIGUNUSED
PetscErrorCode SNESKSPSetParametersEW(SNES snes,PetscInt version,PetscReal rtol_0,PetscReal rtol_max,
				      PetscReal gamma,PetscReal alpha,PetscReal alpha2,PetscReal threshold)
{
  PetscErrorCode ierr;
  PetscFunctionBegin;
  PetscValidHeaderSpecific(snes,SNES_COOKIE,1);
  ierr = SNES_KSP_SetParametersEW(snes,version,rtol_0,rtol_max,gamma,alpha,alpha2,threshold);CHKERRQ(ierr);
  PetscFunctionReturn(0);

}
#endif
%}


%header %{
#if (PETSC_VERSION_MAJOR    == 2 && \
     PETSC_VERSION_MINOR    == 3 && \
     PETSC_VERSION_SUBMINOR == 2 && \
     PETSC_VERSION_RELEASE  == 1)
#define SNESGetNonlinearStepFailures	SNESGetNumberUnsuccessfulSteps
#define SNESSetMaxNonlinearStepFailures	SNESSetMaximumUnsuccessfulSteps
#define SNESGetMaxNonlinearStepFailures	SNESGetMaximumUnsuccessfulSteps
#define SNESGetLinearSolveIterations    SNESGetNumberLinearIterations
#endif
%}


%header %{
#if (PETSC_VERSION_MAJOR    == 2 && \
     PETSC_VERSION_MINOR    == 3 && \
     PETSC_VERSION_SUBMINOR == 2 && \
     PETSC_VERSION_RELEASE  == 1)
#include "include/private/snesimpl.h"
#define MatMFFD                 MatSNESMFCtx
#define MATMFFD_COOKIE          MATSNESMFCTX_COOKIE
#define MatMFFDSetFromOptions   MatSNESMFSetFromOptions
#define MatMFFDComputeJacobian  MatSNESMFComputeJacobian
#define MatCreateSNESMF(snes,J) MatCreateSNESMF((snes),(snes)->vec_func,(J))
#endif
%}

/* ---------------------------------------------------------------- */

%header %{
#if (PETSC_VERSION_MAJOR    == 2 && \
     PETSC_VERSION_MINOR    == 3 && \
     PETSC_VERSION_SUBMINOR == 2 && \
     PETSC_VERSION_RELEASE  == 1)

#include "include/private/tsimpl.h"

static
PetscErrorCode TSSolve(TS ts, Vec u)
{
  PetscInt       steps;
  PetscReal      ptime;
  PetscErrorCode ierr;
  PetscFunctionBegin;
  PetscValidHeaderSpecific(ts,TS_COOKIE,1);
  /* set solution vector if provided */
  if (u) { ierr = TSSetSolution(ts, u); CHKERRQ(ierr); }
  /* reset time step and iteration counters */
  ts->steps = 0; ts->linear_its = 0; ts->nonlinear_its = 0;
  /* steps the requested number of timesteps. */
  ierr = TSStep(ts, &steps, &ptime);CHKERRQ(ierr);
  PetscFunctionReturn(0);
}

static
PetscErrorCode TSSetTime(TS ts, PetscReal t) 
{
  PetscFunctionBegin;
  PetscValidHeaderSpecific(ts,TS_COOKIE,1);
  ts->ptime = t;
  PetscFunctionReturn(0);
}

#endif
%}

/* ---------------------------------------------------------------- */

%header %{

#if (PETSC_VERSION_MAJOR    == 2 && \
     PETSC_VERSION_MINOR    == 3 && \
     PETSC_VERSION_SUBMINOR == 2 && \
     PETSC_VERSION_RELEASE  == 1)

PETSC_EXTERN_CXX_BEGIN
EXTERN PETSC_DLLEXPORT PetscCookie CONTAINER_COOKIE;
PETSC_EXTERN_CXX_END

#define PETSC_CONTAINER_COOKIE        CONTAINER_COOKIE
#define PetscContainer                PetscObjectContainer
#define PetscContainerGetPointer      PetscObjectContainerGetPointer
#define PetscContainerSetPointer      PetscObjectContainerSetPointer
#define PetscContainerDestroy         PetscObjectContainerDestroy
#define PetscContainerCreate          PetscObjectContainerCreate
#define PetscContainerSetUserDestroy  PetscObjectContainerSetUserDestroy

#endif
%}

/* ---------------------------------------------------------------- */

%header %{

#if (PETSC_VERSION_MAJOR    == 2 && \
     PETSC_VERSION_MINOR    == 3 && \
     PETSC_VERSION_SUBMINOR == 2 && \
     PETSC_VERSION_RELEASE  == 1)

FILE *PETSC_STDERR = 0;

#endif
%}

/* ---------------------------------------------------------------- */

/*
 * Local Variables:
 * mode: C
 * End:
 */
