/*
 *  Program: pgn-extract: a Portable Game Notation (PGN) extractor.
 *  Copyright (C) 1994-2005 David Barnes
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  David Barnes may be contacted as D.J.Barnes@kent.ac.uk
 *  http://www.cs.kent.ac.uk/people/staff/djb/
 *
 */

/* Classifications for the arguments allowed in an argsfile. */
typedef enum {
    SEVEN_TAG_ROSTER_ARGUMENT = '7',
    GAMES_PER_FILE_ARGUMENT = '#',
    ALTERNATIVE_HELP_ARGUMENT = '?',
    APPEND_TO_OUTPUT_FILE_ARGUMENT = 'a',
    BOUNDS_ARGUMENT = 'b',
    CHECK_FILE_ARGUMENT = 'c',
    DUPLICATES_FILE_ARGUMENT = 'd',
    USE_ECO_FILE_ARGUMENT = 'e',
    FILE_OF_FILES_ARGUMENT = 'f',
    HELP_ARGUMENT = 'h',
    WRITE_TO_LOG_FILE_ARGUMENT = 'l',
    NON_MATCHING_GAMES_ARGUMENT = 'n',
    WRITE_TO_OUTPUT_FILE_ARGUMENT = 'o',
    CHECK_ONLY_ARGUMENT = 'r',
    KEEP_SILENT_ARGUMENT = 's',
    TAGS_ARGUMENT = 't',
    MOVES_ARGUMENT = 'v',
    LINE_WIDTH_ARGUMENT = 'w',
    POSITIONS_ARGUMENT = 'x',
    ENDINGS_ARGUMENT = 'z',
    FILE_OF_ARGUMENTS_ARGUMENT = 'A',
    DONT_KEEP_COMMENTS_ARGUMENT = 'C',
    DONT_KEEP_DUPLICATES_ARGUMENT = 'D',
    ECO_OUTPUT_LEVEL_ARGUMENT = 'E',
    OUTPUT_FEN_STRING_ARGUMENT = 'F',
    APPEND_TO_LOG_FILE_ARGUMENT = 'L',
    DONT_KEEP_NAGS_ARGUMENT = 'N',
    DONT_MATCH_PERMUTATIONS_ARGUMENT = 'P',
    TAG_ROSTER_ARGUMENT = 'R',
    USE_SOUNDEX_ARGUMENT = 'S',
    TAG_EXTRACTION_ARGUMENT = 'T',
    SUPPRESS_ORIGINALS_ARGUMENT = 'U',
    DONT_KEEP_VARIATIONS_ARGUMENT = 'V',
    OUTPUT_FORMAT_ARGUMENT = 'W',
    USE_VIRTUAL_HASH_TABLE_ARGUMENT = 'Z',
    NO_ARGUMENT_MATCH = '\0'	/* No argument match. */
} ArgType;

void read_args_file(const char *infile);
void process_argument(char arg_letter,const char *associated_value);
