/*
 *  Program: pgn-extract: a Portable Game Notation (PGN) extractor.
 *  Copyright (C) 1994-2005 David Barnes
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  David Barnes may be contacted as D.J.Barnes@kent.ac.uk
 *  http://www.cs.kent.ac.uk/people/staff/djb/
 *
 */

void init_hashtab(void);
Boolean determine_move_details(Colour colour,Move *move_details, Board *board);
HashCode HashLookup(Col col, Rank rank, Piece piece, Colour colour);
void make_move(Col from_col, Rank from_rank, Col to_col, Rank to_rank,
                Piece piece, Colour colour,Board *board);
Boolean king_is_in_check(const Board *board,Colour king_colour);
MovePair *find_pawn_moves(Col from_col, Rank from_rank, Col to_col,Rank to_rank,
                Colour colour, const Board *board);
MovePair *find_knight_moves(Col to_col,Rank to_rank, Colour colour, const Board *board);
MovePair *find_bishop_moves(Col to_col,Rank to_rank, Colour colour, const Board *board);
MovePair *find_rook_moves(Col to_col,Rank to_rank, Colour colour, const Board *board);
MovePair *find_queen_moves(Col to_col,Rank to_rank, Colour colour, const Board *board);
MovePair *find_king_moves(Col to_col,Rank to_rank, Colour colour, const Board *board);
MovePair *exclude_checks(Piece piece, Colour colour,MovePair *possibles,
                                const Board *board);
void free_move_pair_list(MovePair *move_list);
Boolean king_is_in_checkmate(Colour colour,Board *board);
