# Phatch - Photo Batch Processor
# Copyright (C) 2007-2008 www.stani.be
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see http://www.gnu.org/licenses/
#
# Phatch recommends SPE (http://pythonide.stani.be) for editing python files.

# Embedded icon is taken from www.openclipart.org (public domain)

from core import models
from core.translation import _t, new

#---PIL
def init():
    global Image, math, background, r
    import Image, math, background
    background.init()
    r = math.radians
    
    
def perspective(image,width,height,skew_x,skew_y,offset_x,offset_y,left,top,
        back_colour,opacity,resample):
    #im.transform(im.size, Image.PERSPECTIVE, 
    #       (1, -0.2, -40, -0.01, 1, -40, -0.0005, -0.0005))
    if opacity != 100 or back_colour != '#000000':
        image   = image.convert('RGBA')
    if width != 0:
        width   = 1/width
    if height != 0:
        height  = 1/height
    skew_x    = math.tan(r(skew_x))
    skew_y    = math.tan(r(skew_y))
    matrix  = (width,skew_x,offset_x,skew_y,height,offset_y,left,top)
    #print matrix
    perspectived = image.transform(image.size, Image.PERSPECTIVE, matrix, 
                    resample)
    return background.background(perspectived,back_colour,opacity)

#---Phatch
class Action(models.Action):
    label       = _t('Perspective')
    author      = 'Stani'
    email       = 'spe.stani.be@gmail.com'
    init        = staticmethod(init)
    pil         = staticmethod(perspective)
    version     = '0.1'
    tags        = [_t('transform'),_t('border')]
    __doc__     = _t('Shear 2d or 3d')
    
    def interface(self,fields):
        fields[_t('Scale')]   = self.SliderField(100,1,200)
        fields[_t('Left Shear Angle')] = self.SliderField(5,-180,180)
        fields[_t('Top Shear Angle')]   = self.SliderField(5,-180,180)
        fields[_t('Bottom Shear Factor')] = self.FloatField(40)
        fields[_t('Right Shear Factor')]  = self.FloatField(40)
        fields[_t('Horizontal Offset')] = self.PixelField('15%')
        fields[_t('Vertical Offset')]   = self.PixelField('5%')
        fields[_t('Background Colour')]  = self.ColourField('#000000')
        fields[_t('Background Opacity')]  = self.SliderField(0,0,100)
        fields[_t('Resample Image')] = self.ImageFilterField('bicubic')
        
    def values(self,info):
        #get info
        dpi         = info[new('dpi')]
        x, y        = info[new('Pil','Size')]
        #get field values
        scale       = self.get_field('Scale',info)/100.0
        return {
            'width'   : scale,
            'height'  : scale,
            'skew_x'  : -self.get_field('Left Shear Angle',info),
            'skew_y'  : -self.get_field('Top Shear Angle',info),
            'left'    : -self.get_field('Bottom Shear Factor',info)/float(x*100),
            'top'     : -self.get_field('Right Shear Factor',info)/float(y*100),
            'offset_x': -self.get_field_size('Horizontal Offset',info,x,dpi),
            'offset_y': -self.get_field_size('Vertical Offset',info,y,dpi),
            'back_colour': self.get_field('Background Colour',info),
            'opacity' : self.get_field('Background Opacity',info),
            'resample': getattr(Image,self.get_field('Resample Image',info)),
        }
    
    icon = \
'x\xda\x01\xb3\tL\xf6\x89PNG\r\n\x1a\n\x00\x00\x00\rIHDR\x00\x00\x000\x00\
\x00\x000\x08\x06\x00\x00\x00W\x02\xf9\x87\x00\x00\x00\x04sBIT\x08\x08\x08\
\x08|\x08d\x88\x00\x00\tjIDATh\x81\xed\x99k\x8c]U\x15\xc7\x7f{\xefs\xe7=\xd3\
\xce\xf4A\x1fB\xa1H(\x18\xab\x11S(TQ\x10\x02\xc1H\xc1\xf8\x88\x04\x11\x8c\
\x021A#\x1a\x14\r\xe5\x11\xe1\x8b\xd1O&\xad~\x81\xc4\xc4\x07\x1aD\x90\x87\
\x81\xf8 R\x1e~\x18RA\xa0\xd0\x96\x96\xbe\xa6\xed\xdc\xb9\xcfs\xce=g\xef\xe5\
\x87s\xee\xdcso\xcf\xbd3\xa5\xf5\x03IW\xb2\xb2\xe7\xee\xb3\xce\xdd\xff\xff\
\xfa\xaf\xbd\xce\xbes\xe0\xa4\x9d\xb4\x93\xf6\xbe65\x8f\x98\x8d\xc0#\x1f\\\
\xb2x\xc7`\x7f!\x88\xad\r\x07\xfa\n~\x14\xc5\xf5>\xcf\xab\xd7\xa3\xa8\xd2oTm\
\xa6\x11\x95\xb4\xb8\xf2\xc1\xb2?]\x0f\xc32\x10\x02>\x10\xa4\xee\xa7su\xa0\
\x01\xd4\x80\x18\xa8\x1c\x0f\x01o\xae\x80qO\x9fs\xed\x86\xcb\xf6o\xba\xed\
\xeb\xab\x838&\xb41\rg\xf1\xa3\x88\xc8Yj\x8d\x90\xd8\t\xb5  \x16G\xb5\xee\
\xe3\x80r\xb9\xec\x9c\xb3\x14Ke\x01+\xc5RE\xc4Y\x99)W\xb0\xce\xbar\xa5\xa6\
\xac\xb3\xae43#a\xbd\x14\xee9T\x1dj8\xf9\x92\xb5<zB\tX\xaf\xffk\xe6\xd3\xdf\
\x1d\x1b\x93iY0\xd8\xa7\x947\x08F\xa3\n\x06\xa55x\x06\xe5\x19\x94\xd1`\x92Q\
\x19\x03F\xebdL\xe3\x9a\xa36\xa0\x15\xd1\xf6g\xf1_\xdc\x82;\xf4.\xaa\xc0\xd0\
~\x1f.\xdd\xccO\xa6\xaa\'\x96\xc0\xd9\x8b\xc7\x17\r\x06K\xcf\x1a\x9ey\xf7\
\x91}\x0b\x96-Z\xa1<\x8d\xf2\x0c\x12\xa5`=\x83\xa4\xa3\xf2\x0c\x18\x8d\xa4D\
\x9a#)\x11\xd1\x1a\xf1g\xa8=u\x0f\xf1\xbb\xcf\xa3\n\xa0<@\xc3\x8a\x85\xb0n\
\x15K\x1e\x7f\x95O\x02\xff<!\x04V\x16\xb8\xed\xa3\xeb\xae\x8a\x01\xb6\x86K\
\xfc\xcb\xeb\xe5\x04t\xc1\x80\xd7\x02\xad\x8c\x86BJ\xc4\x986R\xe8\x16\x11W;D\
\xe5O\xdfG\xea\xfbP\x1e(\r\xca\xa4\xae\xe1\xc7W\xb2\xf4\xa5\xdd\xdc?Ua\xc3\
\x89 \xa0"\xc5\xc6\x91\x8bnY\xa8\x14<;~\xd1\xaaK\xfd\x87\x03m\xf4\x80\x8a3\
\xa0\x9bDb\x83\xf2\x92\x92"n\x8e\x89"x\x06[\xdeO\xed/w#\x8d#I\xe6\r\xa0[\xae\
\x0c\xacY\x0e\xab\x97p\xe6T\x85s\x81\xd7\xe6C@\xf7`\xb6~\xcd\xd8H\xdc7<2\xa4\
\x80P\xf5y\xfb+\xb2\xdb\xf9U\x9c_\xc5\x05\xc9(~\x15\t\xaaHPA\x82\xd6\xb5\xd9\
\xb9\xb0\x8a\x9d\xdeM\xf5\xb1M\xb8\xe0\x08\xa4\xc0;\xb3\x8fJ\xe67]\xcd\xd2\
\xa5\xa3\xdc?_\x05\xba\x12X\xeeq\xfb\xfa\x8f\\XRJ\xa1T\xd2m\x9fYp\xfe\xa0\
\xf8U\xa4^\xc9\x00\xcf\x90\t\xaaH\x98\x80n\xba\xad\x1e\xa2\xf6\xd7\x9f"\xfet\
\x02Zg\xb2\xafZ\xc0\x9bD.:\x0b=1\xc2\xf9\xc0\xa9\xc7C\xa0\xe0\xe0\x13\xe6\
\x82\x9b\xfbgg\x14L\x0e\xaf9\xd5Z7\xe5\x82$\xf3\xce\xaf\xb4\xb2\x1dV\xdb\xfe\
\x96\xb0\x82\xab\x17\xa9\xff}3\xae\xbc/\xc9|\x06\xf8Q\nhfc6}\x9e\xc5\x8bF\
\xb8\xf3=\x13\x184|\xf6\x92Q\n\x87\x97\x9c\xbb\x9aL\xa2\xac\x83\xd7\xfaN=(~\
\x15\x17\xb6\x14\x10\xbf\x92\x01\x9e\x92\xa9\x17\xa9?\xff\x10\xb6\xb8\xab\
\x95y\xd5\xa1@\xa6\xfegc4\\u\x1e\xde\xf0\x00\x1b\x81\x85s\x110y\x93\xcb\r\
\xbf\xba\xe1\xacU\x8d\x83\xebnX&Z!Z\xe3\xb4F\x8c\xe6\xc0\xd8*o\xfd\x9e\'\xfb\
q\x91F"\x90\x98\xd9\xd1%\xa3\x84e\xc2\xc9\xc7q\x95\xbdI\xb7\xf12\xd9\xf6@7\
\xe7\xbc\xd6\\\xd3\xb5I\xae\x0f\xf6c\xb6nG\x82\x06\x7f;V\x05\xc6<8\xa7\xf0\
\xf1/\xd6\x9a\x99\x874{\xc0~obQu`\xe1\x9b.\xa8\xe0\xc2T\x89f\xd6\x83\x12\xd1\
\xeeI\xfc\x97\xff\x80\xad\x1ehm\xd8\x8e\x92\xe9\x95\xfd\xe6\xfcW/ap\xa8\x8f\
\x9b\x80\xc1cR`\\s\xd3\x97\x87\xb9\xa6x\xc5]:\x1a\x99\x18sJ%\xd9O\x15pZS)\
\x1ey\xfb\xec\xd7\xfe\xf8\x01\x822\xe2\x17\xb1\xa5\x03\xd8C;\x88\xf6\xbc\x82\
\x94\xf7\xa2\x94m\xcbx6\xd3\xbd\xb2\xafL\xa2\x80\xf2\xc0\xeb\x83z\x8cz\xf9u\
\x0eG\x8e\x7fw#p\xd4an\xa5f\xdb\x83\xcb\xbde\x7f\xbec\xdb"\xf1<\x15kEl\x0c\
\xd6\xf3\x88=\xc3\x8c3\xd4\xac\xaboypE]\x1bY\xac\x0b$}\xbd\x90\x01\x92\x99\
\xd3\x1d\x9f\xb3\xd7u\x97{\x9a\x9f\xcb\rX{+\xef\x1c\x9ca5\xe0\xe6SB+&\x14+&V\
\x9c\xb1\xd3\xd3Z)@)\xd5\xc6\xb2\xe8["S\x18\xda\xb1r\xddd[9t\xb4\xc3\xd9\x92\
\xc8\xc4t\xeb\xfd\xcd\xee\xa3:b\x16\x8e\xc2\xc6\r\x8c\x1a\xc3\xb5\xdd\x14h#\
\xb0\x0cn\xfeB?\xe3\xef\xf8\xa1\x16\xb1\xa8\x0e}\x1a\xb1`\xd3<<\xbc\xfe\xbeq\
\xd5\t\xac\xa3\x1dv\x02z/d\x7ft=\x13\x8b\xc7\xb8g^\x04\x0e\xc0][\x02\xa6\xaf\
\xfd\xcf\xee\xf3\xde\x9a|\x1a\xd2\xb5\x9a\x0f3+\xad\xd8\xb7\x96_\xf0\xb1\xb8\
\xd0\xffjv\xe3\xcd\t\xa8\xc3\xe7Cv\xf9b\xd8\xb0\x96\xc5\xc0\xa7\xe6"0\x0e\
\xdc\xb9\xd7q\xee\xe8\xc4\xe9\xbf,\xf4\x0f%\n\xa8L\'j\xbfW\xbd\xb0\xe6+\xbb\
\xbb=\x8c\xda\x00eH6c\x8e\x85\xec\xdd\xdf`\xe9)\x13\xf9\xc7\x8b,\x81"\xf0\
\x000\xa5\xb4\xd4:A+\xc0\xeb\xd81\x8f\x9c\xbf\xe9\x1c4\x8d\x9e\xd9o\x96KG\
\xcc\xb1\x90\xfd\xd0\x99p\xf6\xe9\x9c\x01|\xb8\x17\x81\xf6\xf4f\xce@\xa8\xa4\
\x97{\xa6]\x83\xf2\xf0\xb2\xd3K\xa3\xcb_\xe8\x04\x94w\\\x98W\xf6{\x90}\xe0[\
\x9c\xb2t\x9c\xfb\xe6M\xc0\xda(%\xc2\xecQ\xc2t\xeej\xe0\xd7\xcb\xbeS\x98],%\
\xday\\\xe8\x95}:\xee\xe9F\xf6\xc2\xb5\xa8\xa5\x13\\\x00\x9c6\'\x81(\x8al\
\xdc\x08R\xe0j\xb6\x1b\xe5\xe0\xe7\x99\xbe+\x1b\xd3j\xfc(\x05\xe6\xcc~\x13xV\
\xb5ndS\xbb\xef\x16\x16-\x99\xe0\xae9\t(\xa48\x9b\xfd\x0cx\x91\xa3c#\xeb\xc9\
\xd3ry\xfb\xc6\xeb\x05(\xdb\xfb;\xee\xe9F\xb6iW_\x8c72\xc0U$\r\x07\xe8\xf2\
\x8bL9\x1b)\xc5,\xe2f\xe2#\x97\xc3@\x1cO\x84Wp\xdd\xf0\xefzg?\x0b,K\xb4\x83l\
\xcd\x8c#\xda\xe0\xeb1b\xfai\xb8!J\xe1 \xdf\xbc\xf5\xc5\xea\x82\x81\xa8\xb4s\
\x1f+\x81;\x80\x1ft%0KD\xa9T\x85\x84B\xbd\xe1\xe8\x14M\x04\xde\x8eN\xe3\xa1\
\xf0z\xc6\xa5L\xcd\x8da\xa5@\xe8\x86\x89\xdd\x00\r;Dh\x87q\x85~j\xb2\x10\xe5\
\n\xd4\xedB\xac\xf4\x13\xc9(\x91\x0cce\x88@\x16 \xf4\xa3\x95\x87V\x06\xad\r\
\xd8d\x8d\xb8Vb\xdb;g\xec\x8d\xaa\xc5\xcb\x80*\xc9\xff\x99\xba+\x00\xd0\x08j\
m5\xaf\x80b\xdd\x81\xa7\xdbK\xc9\nb\x85\xcd\x95\x9b\xd0\x05\x83\xee3\xedc\
\xc1\xa0\xfb<\xb43h1\xadQ\x99\x16\xd8\xd4\x8d\x15\xc4:\x92#\xbcJ~w\x03q\xad\
\x8c*\xf4M\x03{:q\xe6\x12\xf0\x1bQ\x1d\xa4\xed(]\xf6-\xb5\x86\xe0u\xdc!Vp\
\xd6\x81U(\xa3\x10\xab\x11\x9d\x90\x12-\x88\xc9\x80\xb2\t01:\xb9\x9e\x01\x8b\
I\xaf7c2\x04D\x04\xa5t\x9c\x875w\x13\xbb\xb8<\x93\x05\x1f[a\xe7\xe1F^(N\x1cb\
\xdd\xac\x12b]\xcb\x9dk\xffl\x1d\xe2$w\xce\xd9vo\xc65My^\x90\xb7~~\tY;\xbb{E\
\xe0\xf5}\x01\xa1\xd3x\xfdy\xb1\x92\x02HT@\'\xae\xacn\xa9\xd0\xf4\x8e\xacK\
\xdcT#3g3jdT\xe8f]\xf7\x80\x8d\x1b \xf0\xca\xae\x1aG"\x857\xd4\x97\x1f\xa8Dw\
\x96\x08MP\x99r\x90\xb6\x12\xd1G\x97\xd7,\x01\x8d\xb3\x02:\xf5\xd8\x81\xb3H\
\x1c\xe5\x96PW\x02\xd3\x87\xf7\xf3\xdc\xab%J\xb6\x07x\x00t_\x02"\xcd\xb8I\
\xd5\xd0\n\xe2T\r\x93Q\xc3\n\xa2]\x8bP\x9c%y4q\x8c"\xf6\xab\xc9F\xc8[\xbd\
\x0b\xaa\x7fl\xdb\xfa\xd8\xce]\x93OE=\x90\x03\xa4u\x9eS\xd7\xa9\x93[\xf3\xcd\
{2\xdeso8\xd0:w\x0ft#\xb0\xb7Q?\xb4\xf6\xf0\x8b?\x7fn\xea\xb9\x9fUDr\x7f\xcd\
%\xd6\\\xb8\x0b(\x17;\x9cm\xb9\xe4m\xf6<\xcf\x10\xc2\nJ{\xf3\xefB\xa9Uc\xff\
\xf0gJ\xdb\x9f\xfc\xc5\xce\xdf\xdcX\xb4A\xb9\x0b\xfef\xf6\xe6\xee@\xf9j\xc8\
\xd1\xc4s\xbe\xab\xcbO\xe2\x9e\x04\x00$\xae\x1d\xf9ap\xf0\xcd\x1b\xdf\xd8|\
\xcd!\xff\xe0\xf6\x1c\x06\xcc\x0fT\xda\xa9\xda\xd4\xe8Z^Y\x17l\x18\xe2\xc20\
\xb7\x8f\xcfE\x00\x00\xdb\xa8<\x1a\x16\xf7lxc\xcbu\xbb\xa6\'\x9fh\x972g\xc1\
\xde\xe5\x91\x10\xcaU\xa3\xad\xc4ZJ\xd8\xa0\x8e\xe4\x1e%\xe7I \xb57\xa3\xf2\
\xd4\xda\x1d\xbf\xbds\xeb\xce\x87\xef\xad6\xf7E[\xb6\xe7U"\xc9|\xa7\x1a=\x15\
q\x826\xa6v\xbc\x04\x00*Qy\xea\xe2\xa9\x7f\xfd~\xcb+\xf7~\xae\x18\xd7J\x88#]\
|\xbeO\xdd\xbc,K\xfa$\xcf\'\x8f\x13@\xe7n\x829\xdf\x91\xe5\x98D3\x07\xbeW\t\
\x83\xe7_\xfa\xf6\x85[\xc6\xd7\xde>"\x8d\x02V\x1c.\xb2\xc9\xe1\xad!\xa0\x1bh\
O\'/=\\\x1dU\xd0h\xcf \xceO\x8e\xd2\x9e\x06i\x80\xc4\x82q\xbe\x12\x8bX_\xa1\
\t\xc0\x89kT5Z"Dl\xf9\xad\x97F]#\x18\xc8\x033\x9f\xd7\xac\xbdl\r\xf0_\xe5-x\
\x19U\xf0\x01A\xe2H\x9bB\xd2\xb2$\x8e\xd0\xaa\x02\xda\x8a4"Dj\xa0\x02\\l]\\\
\xaf\x92\xbcj\x85\xa4\xc5\x942\xdf[\xa2\xd5vj$\xafe\x0f\x00{\x8f\x13o\xae-\
\xf8\x7f|\xe9I{\xbf\xd8\xff\x00\xa8\xf4\xd1\x93\xd6\x0e9\xf9\x00\x00\x00\x00\
IEND\xaeB`\x82p\xe4\xd1"'
